/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.FlurstueckFinder;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class FlurstueckSelectionDialoge
extends JDialog
implements ConnectionContextProvider {
    static final Logger log = Logger.getLogger(FlurstueckSelectionDialoge.class);
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{"Wird geladen..."});
    private static final DefaultComboBoxModel NO_SELECTION_MODEL = new DefaultComboBoxModel<Object>(new Object[0]);
    private static final String CB_EDITED_ACTION_COMMAND = "comboBoxEdited";
    private List<CidsBean> currentListToAdd;
    private final boolean createEnabled;
    private final ConnectionContext connectionContext;
    private JButton btnFlurstueckAddMenCancel;
    private JButton btnFlurstueckAddMenOk;
    private JComboBox cboFlur;
    private JComboBox cboFlurstck;
    private JComboBox cboGemarkung;
    private JSeparator jSeparator1;
    private JLabel lblFlur;
    private JLabel lblFlurstueck;
    private JLabel lblGemarkung;
    private JLabel lblGemarkungsname;
    private JPanel panAddLandParcel1;
    private JPanel panMenButtons2;

    public FlurstueckSelectionDialoge(ConnectionContext connectionContext) {
        this(true, connectionContext);
    }

    public FlurstueckSelectionDialoge(boolean createEnabled, ConnectionContext connectionContext) {
        this.createEnabled = createEnabled;
        this.connectionContext = connectionContext;
        this.setTitle("Bitte Flurst\u00fcck ausw\u00e4hlen");
        this.initComponents();
        this.setSize(419, 144);
        ListCellRenderer lcr = new ListCellRenderer(){
            DefaultListCellRenderer dlcr = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel ret = (JLabel)this.dlcr.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof LightweightMetaObject) {
                    LightweightMetaObject mo = (LightweightMetaObject)value;
                    ret.setText(String.valueOf(mo.getLWAttribute("gemarkung")) + " - " + String.valueOf(mo.getLWAttribute("name")));
                }
                return ret;
            }
        };
        this.cboGemarkung.setRenderer(lcr);
        CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboGemarkung, true){

            @Override
            protected ComboBoxModel doInBackground() throws Exception {
                return new DefaultComboBoxModel<MetaObject>(FlurstueckFinder.getLWGemarkungen(FlurstueckSelectionDialoge.this.getConnectionContext()));
            }

            @Override
            protected void done() {
                super.done();
                FlurstueckSelectionDialoge.this.cboGemarkung.setSelectedIndex(0);
                FlurstueckSelectionDialoge.this.cboGemarkung.requestFocusInWindow();
                ObjectRendererUtils.selectAllTextInEditableCombobox(FlurstueckSelectionDialoge.this.cboGemarkung);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        this.checkOkEnableState();
        super.setVisible(b);
    }

    public void setCurrentListToAdd(List<CidsBean> currentListToAdd) {
        this.currentListToAdd = currentListToAdd;
    }

    public List<CidsBean> getCurrentListToAdd() {
        return this.currentListToAdd;
    }

    private void initComponents() {
        this.panAddLandParcel1 = new JPanel();
        this.cboGemarkung = new JComboBox();
        this.panMenButtons2 = new JPanel();
        this.btnFlurstueckAddMenCancel = new JButton();
        this.btnFlurstueckAddMenOk = new JButton();
        this.cboFlur = new JComboBox(NO_SELECTION_MODEL);
        this.cboFlurstck = new JComboBox(NO_SELECTION_MODEL);
        this.lblGemarkung = new JLabel();
        this.lblFlur = new JLabel();
        this.lblFlurstueck = new JLabel();
        this.lblGemarkungsname = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setMinimumSize(new Dimension(419, 154));
        this.panAddLandParcel1.setMaximumSize(new Dimension(250, 180));
        this.panAddLandParcel1.setMinimumSize(new Dimension(250, 180));
        this.panAddLandParcel1.setPreferredSize(new Dimension(250, 180));
        this.panAddLandParcel1.setLayout(new GridBagLayout());
        this.cboGemarkung.setEditable(true);
        this.cboGemarkung.setMaximumSize(new Dimension(100, 18));
        this.cboGemarkung.setMinimumSize(new Dimension(100, 18));
        this.cboGemarkung.setPreferredSize(new Dimension(100, 18));
        this.cboGemarkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckSelectionDialoge.this.cboGemarkungActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.cboGemarkung, gridBagConstraints);
        this.panMenButtons2.setLayout(new GridBagLayout());
        this.btnFlurstueckAddMenCancel.setText("Abbrechen");
        this.btnFlurstueckAddMenCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckSelectionDialoge.this.btnFlurstueckAddMenCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtons2.add((Component)this.btnFlurstueckAddMenCancel, gridBagConstraints);
        this.btnFlurstueckAddMenOk.setText("Ok");
        this.btnFlurstueckAddMenOk.setMaximumSize(new Dimension(85, 23));
        this.btnFlurstueckAddMenOk.setMinimumSize(new Dimension(85, 23));
        this.btnFlurstueckAddMenOk.setPreferredSize(new Dimension(85, 23));
        this.btnFlurstueckAddMenOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckSelectionDialoge.this.btnFlurstueckAddMenOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtons2.add((Component)this.btnFlurstueckAddMenOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.panMenButtons2, gridBagConstraints);
        this.cboFlur.setEditable(true);
        this.cboFlur.setEnabled(false);
        this.cboFlur.setMaximumSize(new Dimension(100, 18));
        this.cboFlur.setMinimumSize(new Dimension(100, 18));
        this.cboFlur.setPreferredSize(new Dimension(100, 18));
        this.cboFlur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckSelectionDialoge.this.cboFlurActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panAddLandParcel1.add((Component)this.cboFlur, gridBagConstraints);
        this.cboFlurstck.setEditable(true);
        this.cboFlurstck.setEnabled(false);
        this.cboFlurstck.setMaximumSize(new Dimension(100, 18));
        this.cboFlurstck.setMinimumSize(new Dimension(100, 18));
        this.cboFlurstck.setPreferredSize(new Dimension(100, 18));
        this.cboFlurstck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckSelectionDialoge.this.cboFlurstckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.cboFlurstck, gridBagConstraints);
        this.lblGemarkung.setText("Gemarkung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblFlur.setText("Flur");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.lblFlur, gridBagConstraints);
        this.lblFlurstueck.setText("Flurst\u00fcck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.lblFlurstueck, gridBagConstraints);
        this.lblGemarkungsname.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAddLandParcel1.add((Component)this.lblGemarkungsname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panAddLandParcel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.panAddLandParcel1, "Center");
    }

    private void cboGemarkungActionPerformed(ActionEvent evt) {
        Object selection = this.cboGemarkung.getSelectedItem();
        this.cboFlurstck.setEnabled(false);
        this.btnFlurstueckAddMenOk.setEnabled(false);
        if (selection instanceof LightweightMetaObject) {
            LightweightMetaObject lwmo = (LightweightMetaObject)selection;
            final String selGemarkungsNr = String.valueOf(selection);
            CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboFlur, CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())){

                @Override
                protected ComboBoxModel doInBackground() throws Exception {
                    return new DefaultComboBoxModel<MetaObject>(FlurstueckFinder.getLWFlure(selGemarkungsNr, FlurstueckSelectionDialoge.this.getConnectionContext()));
                }
            });
            String gemarkungsname = String.valueOf(lwmo.getLWAttribute("name"));
            this.lblGemarkungsname.setText("(" + gemarkungsname + ")");
            this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.WHITE);
        } else {
            int foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboGemarkung, String.valueOf(selection));
            if (foundBeanIndex < 0) {
                if (this.createEnabled) {
                    this.cboFlur.setModel(new DefaultComboBoxModel());
                    try {
                        Integer.parseInt(String.valueOf(selection));
                        this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                        this.cboFlur.setEnabled(true);
                        if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
                            this.cboFlur.requestFocusInWindow();
                        }
                    }
                    catch (Exception notANumberEx) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(selection + " is not a number!"), (Throwable)notANumberEx);
                        }
                        this.cboFlur.setEnabled(false);
                        this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.RED);
                        this.lblGemarkungsname.setText("(Ist keine Zahl)");
                    }
                    this.lblGemarkungsname.setText(" ");
                } else {
                    this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.RED);
                    this.cboFlur.setEnabled(false);
                }
            } else {
                this.cboGemarkung.setSelectedIndex(foundBeanIndex);
                this.cboFlur.getEditor().getEditorComponent().setBackground(Color.WHITE);
                this.cboFlurstck.getEditor().getEditorComponent().setBackground(Color.WHITE);
            }
        }
        this.checkOkEnableState();
    }

    private void btnFlurstueckAddMenCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancelHook();
    }

    private void btnFlurstueckAddMenOkActionPerformed(ActionEvent evt) {
        int position;
        CidsBean beanToAdd;
        int result;
        Object selection = this.cboFlurstck.getSelectedItem();
        if (selection instanceof LightweightMetaObject) {
            int position2;
            CidsBean selectedBean = ((LightweightMetaObject)selection).getBean();
            if (this.currentListToAdd != null && (position2 = Collections.binarySearch(this.currentListToAdd, selectedBean, AlphanumComparator.getInstance())) < 0) {
                this.currentListToAdd.add(-position2 - 1, selectedBean);
            }
        } else if (selection instanceof String && this.createEnabled && (result = JOptionPane.showConfirmDialog(this, "Das Flurst\u00fcck befindet sich nicht im Datenbestand der aktuellen Flurst\u00fccke. Soll es als historisch angelegt werden?", "Historisches Flurst\u00fcck anlegen", 0)) == 0 && (beanToAdd = this.landParcelBeanFromComboBoxes(selection.toString())) != null && (position = Collections.binarySearch(this.currentListToAdd, beanToAdd, AlphanumComparator.getInstance())) < 0) {
            try {
                if (1 == beanToAdd.getMetaObject().getStatus()) {
                    beanToAdd = beanToAdd.persist(this.getConnectionContext());
                }
                this.currentListToAdd.add(-position - 1, beanToAdd);
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
        this.setVisible(false);
        this.okHook();
    }

    public void okHook() {
    }

    public void cancelHook() {
    }

    private void checkOkEnableState() {
        this.btnFlurstueckAddMenOk.setEnabled(this.cboFlurstck.getSelectedItem() instanceof MetaObject);
    }

    private void cboFlurActionPerformed(ActionEvent evt) {
        Object selection = this.cboFlur.getSelectedItem();
        if (selection instanceof MetaObject) {
            final String selGem = String.valueOf(this.cboGemarkung.getSelectedItem());
            final StringBuffer selFlurNr = new StringBuffer(String.valueOf(this.cboFlur.getSelectedItem()));
            while (selFlurNr.length() < 3) {
                selFlurNr.insert(0, 0);
            }
            this.btnFlurstueckAddMenOk.setEnabled(false);
            this.cboFlur.getEditor().getEditorComponent().setBackground(Color.WHITE);
            CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboFlurstck, CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())){

                @Override
                protected ComboBoxModel doInBackground() throws Exception {
                    return new DefaultComboBoxModel<MetaObject>(FlurstueckFinder.getLWFurstuecksZaehlerNenner(selGem, selFlurNr.toString(), FlurstueckSelectionDialoge.this.getConnectionContext()));
                }
            });
        } else {
            String selString = String.valueOf(selection);
            while (selString.length() < 3) {
                selString = "0" + selString;
            }
            int foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboFlur, selString);
            if (foundBeanIndex < 0) {
                if (this.createEnabled) {
                    this.cboFlur.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                    this.cboFlurstck.setModel(new DefaultComboBoxModel());
                    this.cboFlurstck.setEnabled(true);
                    if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
                        this.cboFlurstck.requestFocusInWindow();
                        this.cboFlurstck.setSelectedIndex(0);
                    }
                } else {
                    this.cboFlur.getEditor().getEditorComponent().setBackground(Color.RED);
                    this.cboFlurstck.setModel(new DefaultComboBoxModel());
                    this.cboFlurstck.setEnabled(false);
                }
            } else {
                this.cboFlur.setSelectedIndex(foundBeanIndex);
                this.cboFlurstck.getEditor().getEditorComponent().setBackground(Color.WHITE);
            }
        }
        this.checkOkEnableState();
    }

    private void cboFlurstckActionPerformed(ActionEvent evt) {
        this.btnFlurstueckAddMenOk.setEnabled(this.checkFlurstueckSelectionComplete());
        if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
            this.btnFlurstueckAddMenOk.requestFocusInWindow();
        }
        Component editor = this.cboFlurstck.getEditor().getEditorComponent();
        if (this.cboFlurstck.getSelectedItem() instanceof MetaObject) {
            editor.setBackground(Color.WHITE);
        } else {
            int foundBeanIndex;
            String parcelNo = String.valueOf(this.cboFlurstck.getSelectedItem());
            if (!parcelNo.contains("/")) {
                parcelNo = parcelNo + "/0";
                if (editor instanceof JTextField) {
                    JTextField textEditor = (JTextField)editor;
                    textEditor.setText(parcelNo);
                }
            }
            if ((foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboFlurstck, parcelNo)) < 0) {
                if (this.createEnabled) {
                    this.cboFlurstck.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                } else {
                    this.cboFlurstck.getEditor().getEditorComponent().setBackground(Color.RED);
                }
            } else {
                this.cboFlurstck.setSelectedIndex(foundBeanIndex);
            }
        }
    }

    private boolean checkFlurstueckSelectionComplete() {
        if (this.cboFlur.isEnabled() && this.cboFlurstck.isEnabled()) {
            Object sel2 = this.cboFlur.getSelectedItem();
            Object sel3 = this.cboFlurstck.getSelectedItem();
            if (sel2 != null && sel3 != null && (this.createEnabled || sel3 instanceof MetaObject) && sel2.toString().length() > 0 && sel3.toString().length() > 0) {
                return true;
            }
        }
        return false;
    }

    private CidsBean landParcelBeanFromComboBoxes(String zaehlerNenner) {
        int result = 0;
        try {
            HashMap newLandParcelProperties = TypeSafeCollections.newHashMap();
            String gemarkung = String.valueOf(this.cboGemarkung.getSelectedItem());
            String flur = String.valueOf(this.cboFlur.getSelectedItem());
            if (flur.length() != 3) {
                result = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Das neue Flurst\u00fcck entspricht nicht der Namenskonvention: Flur sollte dreistellig sein (mit f\u00fchrenden Nullen, z.B. 007). Datensatz trotzdem abspeichern?", "Warnung: Format", 0, 2);
            }
            if (result == 0) {
                String[] zaehlerNennerTiles = zaehlerNenner.split("/");
                String zaehler = zaehlerNennerTiles[0];
                newLandParcelProperties.put("gemarkung", Integer.valueOf(gemarkung));
                newLandParcelProperties.put("flur", flur);
                newLandParcelProperties.put("zaehler", zaehler);
                String nenner = "0";
                if (zaehlerNennerTiles.length == 2) {
                    nenner = zaehlerNennerTiles[1];
                }
                newLandParcelProperties.put("nenner", nenner);
                MetaObject[] searchResult = FlurstueckFinder.getLWLandparcel(gemarkung, flur, zaehler, nenner, this.getConnectionContext());
                if (searchResult != null && searchResult.length > 0) {
                    return searchResult[0].getBean();
                }
                CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("alb_flurstueck_kicker", newLandParcelProperties, this.getConnectionContext());
                return newBean;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        return null;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    abstract class AbstractFlurstueckComboModelWorker
    extends SwingWorker<ComboBoxModel, Void> {
        private final JComboBox box;
        private final boolean switchToBox;

        public AbstractFlurstueckComboModelWorker(JComboBox box, boolean switchToBox) {
            this.box = box;
            this.switchToBox = switchToBox;
            box.setVisible(true);
            box.setEnabled(false);
            box.setModel(WAIT_MODEL);
        }

        @Override
        protected void done() {
            try {
                this.box.setModel((ComboBoxModel)this.get());
                if (this.switchToBox) {
                    this.box.requestFocus();
                }
            }
            catch (InterruptedException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)ex, (Throwable)ex);
                }
            }
            catch (ExecutionException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            finally {
                this.box.setEnabled(true);
                this.box.setSelectedIndex(0);
                ObjectRendererUtils.selectAllTextInEditableCombobox(this.box);
                FlurstueckSelectionDialoge.this.checkOkEnableState();
            }
        }
    }
}

