/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.MissingResourceException;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class TwWinterruheEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(TwWinterruheEditor.class);
    public static final String FIELD__START = "datum_start";
    public static final String FIELD__ENDE = "datum_ende";
    public static final String FIELD__ID = "id";
    public static final String TABLE_NAME = "tw_winterruhe";
    public static final String BUNDLE_NOSTART = "TwWinterruheEditor.isOkForSaving().noStart";
    public static final String BUNDLE_NOENDE = "TwWinterruheEditor.isOkForSaving().noEnde";
    public static final String BUNDLE_NOBEFORE = "TwWinterruheEditor.isOkForSaving().noBefore";
    public static final String BUNDLE_PANE_PREFIX = "TwWinterruheEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "TwWinterruheEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "TwWinterruheEditor.isOkForSaving().JOptionPane.title";
    public static final String TITLE = "Winterruhe";
    private final boolean editor;
    DefaultBindableDateChooser dcEnde;
    DefaultBindableDateChooser dcStart;
    private JLabel lblEnde;
    private JLabel lblStart;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panName;
    private BindingGroup bindingGroup;

    public TwWinterruheEditor() {
        this(true);
    }

    public TwWinterruheEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public boolean isOkForSaving() {
        StringBuilder errorMessage;
        boolean save;
        block9: {
            save = true;
            errorMessage = new StringBuilder();
            try {
                if (this.getCidsBean().getProperty(FIELD__START) == null) {
                    LOG.warn((Object)"No beginn specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_NOSTART));
                    save = false;
                    break block9;
                }
                try {
                    if (this.getCidsBean().getProperty(FIELD__ENDE) == null) {
                        LOG.warn((Object)"No ende specified. Skip persisting.");
                        errorMessage.append(NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_NOENDE));
                        save = false;
                    } else {
                        LocalDate ldEnde;
                        LocalDate ldStart = this.dcStart.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        if (!ldStart.isBefore(ldEnde = this.dcEnde.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
                            LOG.warn((Object)"Start not before Ende. Skip persisting.");
                            errorMessage.append(NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_NOBEFORE));
                            save = false;
                        }
                    }
                }
                catch (MissingResourceException ex) {
                    LOG.warn((Object)"End not given.", (Throwable)ex);
                    save = false;
                }
            }
            catch (MissingResourceException ex) {
                LOG.warn((Object)"Beginn not given.", (Throwable)ex);
                save = false;
            }
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(TwWinterruheEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panName = new JPanel();
        this.lblStart = new JLabel();
        this.dcStart = new DefaultBindableDateChooser();
        this.lblEnde = new JLabel();
        this.dcEnde = new DefaultBindableDateChooser();
        this.panFillerUnten1 = new JPanel();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblStart.setFont(new Font("Tahoma", 1, 11));
        this.lblStart.setText("Start:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblStart, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.datum_start}"), (Object)this.dcStart, (Property)BeanProperty.create((String)"date"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        binding.setConverter(this.dcStart.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.dcStart, gridBagConstraints);
        this.lblEnde.setFont(new Font("Tahoma", 1, 11));
        this.lblEnde.setText("Ende:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblEnde, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.datum_ende}"), (Object)this.dcEnde, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcEnde.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.dcEnde, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (cb != null) {
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            }
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error setCidsBean.", (Throwable)ex);
        }
    }

    private boolean isEditor() {
        return this.editor;
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly((JComponent)this.dcStart);
            RendererTools.makeReadOnly((JComponent)this.dcEnde);
        }
    }

    public String getTitle() {
        return TITLE;
    }

    public void setTitle(String string) {
    }
}

