/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.ImageUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;

public class UaEinsatzPicturePanel
extends JPanel
implements CidsBeanStore,
ConnectionContextStore,
Disposable {
    private static final Logger LOG = Logger.getLogger(UaEinsatzPicturePanel.class);
    public static final String FIELD__NAME = "dateiname";
    public static final String KEINE_VORSCHAU = "F\u00fcr diesen Datentyp ist keine Vorschau verf\u00fcgbar";
    public static final String KEIN_LADEN = "Vorschau kann nicht geladen werden";
    public static final String LADEN = "wird geladen";
    public final String[] FOTO_TYP;
    private CidsBean cidsBean;
    private ConnectionContext cc;
    private final boolean editor;
    private WebDavTunnelHelper webDavHelper;
    private SwingWorker worker_foto;
    JButton btnRotate;
    private JLabel lblBeschreibung;
    private JLabel lblPreview;
    private JLabel lblVorschau;
    private JPanel panPreview;
    private JScrollPane scBeschreibung;
    private JTextArea taBeschreibung;
    private BindingGroup bindingGroup;

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panPreview = new JPanel();
        this.lblBeschreibung = new JLabel();
        this.lblPreview = new JLabel();
        this.btnRotate = new JButton();
        this.scBeschreibung = new JScrollPane();
        this.taBeschreibung = new JTextArea();
        this.lblVorschau = new JLabel();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panPreview.setBorder(BorderFactory.createTitledBorder("Foto"));
        this.panPreview.setName("panPreview");
        this.panPreview.setOpaque(false);
        this.panPreview.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblBeschreibung, (String)"Beschreibung:");
        this.lblBeschreibung.setName("lblBeschreibung");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.lblBeschreibung, gridBagConstraints);
        this.lblPreview.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblPreview, (String)"nicht verf\u00fcgbar");
        this.lblPreview.setName("lblPreview");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.panPreview.add((Component)this.lblPreview, gridBagConstraints);
        this.btnRotate.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/virtualcitymap/turn.png")));
        this.btnRotate.setBorderPainted(false);
        this.btnRotate.setContentAreaFilled(false);
        this.btnRotate.setFocusPainted(false);
        this.btnRotate.setName("btnRotate");
        this.btnRotate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panPreview.add((Component)this.btnRotate, gridBagConstraints);
        this.scBeschreibung.setName("scBeschreibung");
        this.taBeschreibung.setEditable(false);
        this.taBeschreibung.setColumns(20);
        this.taBeschreibung.setRows(5);
        this.taBeschreibung.setName("taBeschreibung");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.beschreibung}"), (Object)this.taBeschreibung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scBeschreibung.setViewportView(this.taBeschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.panPreview.add((Component)this.scBeschreibung, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblVorschau, (String)"Vorschau:");
        this.lblVorschau.setName("lblVorschau");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.lblVorschau, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panPreview, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public UaEinsatzPicturePanel() {
        this(false, new String[]{"jpg", "png"});
    }

    public UaEinsatzPicturePanel(boolean editable, String[] typen) {
        this.editor = editable;
        this.FOTO_TYP = typen;
        this.initComponents();
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.taBeschreibung);
            this.btnRotate.setEnabled(false);
        }
    }

    public boolean isEditor() {
        return this.editor;
    }

    public void setWebDavHelper(WebDavTunnelHelper webDavHelper) {
        this.webDavHelper = webDavHelper;
    }

    private void btnRotateActionPerformed(ActionEvent evt) {
        this.showImage(90.0);
    }

    public static BufferedImage rotate(BufferedImage bimg, Double angle) {
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int w = bimg.getWidth();
        int h = bimg.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage rotated = new BufferedImage(neww, newh, bimg.getType());
        Graphics2D graphic = rotated.createGraphics();
        graphic.translate((neww - w) / 2, (newh - h) / 2);
        graphic.rotate(Math.toRadians(angle), w / 2, h / 2);
        graphic.drawRenderedImage(bimg, null);
        graphic.dispose();
        return rotated;
    }

    public void setCidsBean(CidsBean cidsBean) {
        try {
            this.bindingGroup.unbind();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            this.cidsBean = cidsBean;
            this.bindingGroup.bind();
            this.showImage(0.0);
            this.taBeschreibung.setEditable(true);
        } else {
            this.taBeschreibung.setEditable(false);
            this.taBeschreibung.setText("");
            this.lblPreview.setIcon(null);
            this.panPreview.setBorder(BorderFactory.createTitledBorder("Foto"));
        }
    }

    public WebDavTunnelHelper getWebdavHelper() {
        return this.webDavHelper;
    }

    public void showImage(final Double arc) {
        if (this.cidsBean.getProperty(FIELD__NAME) instanceof String && this.getWebdavHelper() != null) {
            String filename = (String)this.cidsBean.getProperty(FIELD__NAME);
            this.panPreview.setBorder(BorderFactory.createTitledBorder(filename));
            this.lblPreview.setPreferredSize(this.lblPreview.getPreferredSize());
            this.lblPreview.setIcon(null);
            this.lblPreview.setText(LADEN);
            final String[] datei = filename.split("\\.");
            boolean test = Arrays.stream(this.FOTO_TYP).anyMatch(new Predicate<String>(){

                @Override
                public boolean test(String t) {
                    return datei[1].equals(t);
                }
            });
            if (test) {
                SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>(){

                    @Override
                    protected ImageIcon doInBackground() throws Exception {
                        String filename = (String)UaEinsatzPicturePanel.this.cidsBean.getProperty(UaEinsatzPicturePanel.FIELD__NAME);
                        String fileEnding = filename.toLowerCase().substring(filename.toLowerCase().lastIndexOf(".") + 1);
                        InputStream is = UaEinsatzPicturePanel.this.getWebdavHelper().getFileFromWebDAV(filename, UaEinsatzPicturePanel.this.getConnectionContext());
                        BufferedImage image = ImageIO.read(is);
                        if (this.isCancelled()) {
                            return null;
                        }
                        BufferedImage rotatedImage = UaEinsatzPicturePanel.rotate(image, arc);
                        if (arc != 0.0) {
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)rotatedImage, fileEnding, os);
                            ByteArrayInputStream inputs = new ByteArrayInputStream(os.toByteArray());
                            UaEinsatzPicturePanel.this.getWebdavHelper().deleteFileFromWebDAV(filename, UaEinsatzPicturePanel.this.getConnectionContext());
                            UaEinsatzPicturePanel.this.getWebdavHelper().uploadFileToWebDAV(filename, (InputStream)inputs, (Component)UaEinsatzPicturePanel.this, UaEinsatzPicturePanel.this.getConnectionContext());
                        }
                        ImageIcon icon = UaEinsatzPicturePanel.this.lblPreview.getWidth() > 40 && UaEinsatzPicturePanel.this.lblPreview.getHeight() > 40 ? new ImageIcon(ImageUtil.adjustScale((BufferedImage)rotatedImage, (int)UaEinsatzPicturePanel.this.lblPreview.getWidth(), (int)(UaEinsatzPicturePanel.this.lblPreview.getHeight() - 10), (int)0, (int)20)) : new ImageIcon(rotatedImage);
                        if (this.isCancelled()) {
                            return null;
                        }
                        return icon;
                    }

                    @Override
                    protected void done() {
                        try {
                            ImageIcon icon;
                            if (!this.isCancelled() && (icon = (ImageIcon)this.get()) != null) {
                                UaEinsatzPicturePanel.this.lblPreview.setIcon(null);
                                UaEinsatzPicturePanel.this.lblPreview.setText("");
                                ImageIcon ii = icon;
                                UaEinsatzPicturePanel.this.lblPreview.setIcon(ii);
                            }
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LOG.error((Object)ex);
                        }
                    }
                };
                if (this.worker_foto != null) {
                    this.worker_foto.cancel(true);
                }
                this.worker_foto = worker;
                this.worker_foto.execute();
            } else {
                this.lblPreview.setIcon(null);
                this.lblPreview.setText(KEINE_VORSCHAU);
            }
        } else {
            this.lblPreview.setIcon(null);
            this.lblPreview.setText(KEIN_LADEN);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.cc = cc;
    }

    public ConnectionContext getConnectionContext() {
        return this.cc;
    }

    public void dispose() {
        this.setCidsBean(null);
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == UaEinsatzPicturePanel.this.btnRotate) {
                UaEinsatzPicturePanel.this.btnRotateActionPerformed(evt);
            }
        }
    }
}

