/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.custom.objecteditors.wunda_blau.AbstractVermessungEditor;
import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class VermessungBuchwerkEditor
extends AbstractVermessungEditor {
    private JComboBox cmbFormat;
    private JComboBox cmbGemarkung;
    private JComboBox cmbGeometrie;
    private JComboBox cmbGeometrieStatus;
    private Box.Filler gluGeneralInformationGap;
    private JLabel lblFormat;
    private JLabel lblGemarkung;
    private JLabel lblGeometrie;
    private JLabel lblGeometrieStatus;
    private JPanel pnlInformation;
    private BindingGroup bindingGroup;

    public VermessungBuchwerkEditor() {
        this(false);
    }

    public VermessungBuchwerkEditor(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.initComponents();
        super.initWithConnectionContext(connectionContext);
        if (this.isReadOnly()) {
            this.lblGemarkung.setVisible(false);
            this.cmbGemarkung.setVisible(false);
            this.cmbFormat.setEditable(false);
            this.cmbFormat.setEnabled(false);
            this.cmbGeometrieStatus.setEditable(false);
            this.cmbGeometrieStatus.setEnabled(false);
            this.lblGeometrie.setVisible(false);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pnlInformation = new JPanel();
        this.cmbFormat = new DefaultBindableReferenceCombo();
        if (!this.isReadOnly()) {
            this.cmbGeometrie = new DefaultCismapGeometryComboBoxEditor();
        }
        this.cmbGeometrieStatus = new DefaultBindableReferenceCombo();
        this.lblGeometrieStatus = new JLabel();
        this.gluGeneralInformationGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblGemarkung = new JLabel();
        this.lblFormat = new JLabel();
        this.cmbGemarkung = new DefaultBindableReferenceCombo();
        this.lblGeometrie = new JLabel();
        this.pnlInformation.setOpaque(false);
        this.pnlInformation.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.format}"), (Object)this.cmbFormat, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 7);
        this.pnlInformation.add((Component)this.cmbFormat, gridBagConstraints);
        if (!this.isReadOnly()) {
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geometrie}"), (Object)this.cmbGeometrie, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (!this.isReadOnly()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.pnlInformation.add((Component)this.cmbGeometrie, gridBagConstraints);
        }
        this.cmbGeometrieStatus.setRenderer(new AbstractVermessungEditor.GeometrieStatusRenderer(this.cmbGeometrieStatus.getRenderer()));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geometrie_status}"), (Object)this.cmbGeometrieStatus, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cmbGeometrieStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungBuchwerkEditor.this.cmbGeometrieStatusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 7);
        this.pnlInformation.add((Component)this.cmbGeometrieStatus, gridBagConstraints);
        this.lblGeometrieStatus.setText(NbBundle.getMessage(VermessungBuchwerkEditor.class, (String)"VermessungBuchwerkEditor.lblGeometrieStatus.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInformation.add((Component)this.lblGeometrieStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlInformation.add((Component)this.gluGeneralInformationGap, gridBagConstraints);
        this.lblGemarkung.setLabelFor(this.cmbGemarkung);
        this.lblGemarkung.setText(NbBundle.getMessage(VermessungBuchwerkEditor.class, (String)"VermessungBuchwerkEditor.lblGemarkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInformation.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblFormat.setText(NbBundle.getMessage(VermessungBuchwerkEditor.class, (String)"VermessungBuchwerkEditor.lblFormat.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInformation.add((Component)this.lblFormat, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gemarkung}"), (Object)this.cmbGemarkung, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.pnlInformation.add((Component)this.cmbGemarkung, gridBagConstraints);
        this.lblGeometrie.setText(NbBundle.getMessage(VermessungBuchwerkEditor.class, (String)"VermessungBuchwerkEditor.lblGeometrie.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInformation.add((Component)this.lblGeometrie, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void cmbGeometrieStatusActionPerformed(ActionEvent evt) {
        CidsBean geometrieStatus;
        if (this.cmbGeometrieStatus.getSelectedItem() instanceof CidsBean && (geometrieStatus = (CidsBean)this.cmbGeometrieStatus.getSelectedItem()).getProperty("id") instanceof Integer) {
            this.cmbGeometrieStatus.setBackground((Color)COLORS_GEOMETRIE_STATUS.get((Integer)geometrieStatus.getProperty("id")));
        }
    }

    @Override
    protected String getVermessungName() {
        return "Buchwerk";
    }

    @Override
    protected JPanel getInformationPanel() {
        return this.pnlInformation;
    }

    @Override
    protected String getDocumentFilename() {
        CidsBean cidsBean = this.getCidsBean();
        Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        String schluessel = (String)cidsBean.getProperty("schluessel");
        Integer steuerbezirk = (Integer)cidsBean.getProperty("steuerbezirk");
        String bezeichner = (String)cidsBean.getProperty("bezeichner");
        boolean historisch = Boolean.TRUE.equals(cidsBean.getProperty("historisch"));
        return VermessungPictureFinderClientUtils.getBuchwerkPictureFilename(schluessel, gemarkung, steuerbezirk, bezeichner, historisch);
    }

    @Override
    protected String findPicture() {
        CidsBean cidsBean = this.getCidsBean();
        Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        String schluessel = (String)cidsBean.getProperty("schluessel");
        Integer steuerbezirk = (Integer)cidsBean.getProperty("steuerbezirk");
        String bezeichner = (String)cidsBean.getProperty("bezeichner");
        boolean historisch = Boolean.TRUE.equals(cidsBean.getProperty("historisch"));
        return VermessungPictureFinderClientUtils.findBuchwerkPicture(schluessel, gemarkung, steuerbezirk, bezeichner, historisch);
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        super.setCidsBean(cidsBean);
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            this.bindingGroup.bind();
            if (cidsBean.getProperty("geometrie_status") instanceof CidsBean && cidsBean.getProperty("geometrie_status.id") instanceof Integer) {
                this.cmbGeometrieStatus.setBackground((Color)COLORS_GEOMETRIE_STATUS.get((Integer)cidsBean.getProperty("geometrie_status.id")));
            }
        }
    }

    @Override
    protected String generateTitle() {
        CidsBean cidsBean = this.getCidsBean();
        String schluessel = (String)cidsBean.getProperty("schluessel");
        Integer steuerbezirk = (Integer)cidsBean.getProperty("steuerbezirk");
        String bezeichner = (String)cidsBean.getProperty("bezeichner");
        String gemarkung = (String)cidsBean.getProperty("gemarkung.name");
        return "Schl\u00fcssel " + (schluessel != null && schluessel.trim().length() > 0 ? schluessel : "unbekannt") + " - " + "Gemarkung " + (gemarkung != null && gemarkung.trim().length() > 0 ? gemarkung : "unbekannt") + " - " + "Steuerbezirk " + (steuerbezirk != null ? steuerbezirk : "unbekannt") + " - " + "Bezeichner " + (bezeichner != null && bezeichner.trim().length() > 0 ? bezeichner : "unbekannt");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.bindingGroup.unbind();
        if (!this.isReadOnly()) {
            ((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).dispose();
        }
    }
}

