/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.custom.clientutils.AlkisClientUtils;
import de.cismet.cids.custom.clientutils.BaulastBescheinigungDialog;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.alkis.StichtagChooserDialog;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.DownloadInfoFactory;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.NbBundle;

public class AlkisBuchungsblattAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisBuchungsblattAggregationRenderer.class);
    private static final Color[] COLORS = new Color[]{new Color(247, 150, 70, 192), new Color(155, 187, 89, 192), new Color(128, 100, 162, 192), new Color(75, 172, 198, 192), new Color(192, 80, 77, 192)};
    private static volatile boolean initialisedMap = false;
    private List<CidsBeanWrapper> cidsBeanWrappers;
    private BuchungsblattTableModel tableModel;
    private MappingComponent map;
    private CidsBeanWrapper selectedCidsBeanWrapper;
    private Thread mapThread;
    private Map<CidsBean, Collection<CidsBean>> selectedFlurstueckeMap;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JXHyperlink hlBestandsnachweisStichtagNRW;
    private JXHyperlink jxlBaulastBescheinigung;
    private JXHyperlink jxlBestandsnachweisKommunal;
    private JXHyperlink jxlBestandsnachweisKommunalIntern;
    private JXHyperlink jxlBestandsnachweisNRW;
    private JLabel lblHeaderBuchungsblaetter;
    private JLabel lblHeaderButtons;
    private JPanel pnlBuchungsblaetter;
    private JPanel pnlButtons;
    private JPanel pnlMap;
    private JScrollPane scpBuchungsblaetter;
    private SemiRoundedPanel srpHeaderBuchungsblaetter;
    private SemiRoundedPanel srpHeaderButtons;
    private JTable tblBuchungsblaetter;

    public AlkisBuchungsblattAggregationRenderer() {
        this.tableModel = new BuchungsblattTableModel();
    }

    private void initComponents() {
        this.pnlButtons = new RoundedPanel();
        this.srpHeaderButtons = new SemiRoundedPanel();
        this.lblHeaderButtons = new JLabel();
        this.jxlBestandsnachweisNRW = new JXHyperlink();
        this.jxlBestandsnachweisKommunal = new JXHyperlink();
        this.jxlBestandsnachweisKommunalIntern = new JXHyperlink();
        this.hlBestandsnachweisStichtagNRW = new JXHyperlink();
        this.jxlBaulastBescheinigung = new JXHyperlink();
        this.pnlBuchungsblaetter = new RoundedPanel();
        this.srpHeaderBuchungsblaetter = new SemiRoundedPanel();
        this.lblHeaderBuchungsblaetter = new JLabel();
        this.scpBuchungsblaetter = new JScrollPane();
        this.tblBuchungsblaetter = new JTable();
        this.pnlMap = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlButtons.setOpaque(false);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.srpHeaderButtons.setBackground(Color.darkGray);
        this.srpHeaderButtons.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderButtons.setForeground(Color.white);
        this.lblHeaderButtons.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.lblHeaderButtons.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeaderButtons.add((Component)this.lblHeaderButtons, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlButtons.add((Component)this.srpHeaderButtons, gridBagConstraints);
        this.jxlBestandsnachweisNRW.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlBestandsnachweisNRW.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.jxlBestandsnachweisNRW.text"));
        this.jxlBestandsnachweisNRW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.jxlBestandsnachweisNRWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlBestandsnachweisNRW, gridBagConstraints);
        this.jxlBestandsnachweisKommunal.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlBestandsnachweisKommunal.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.jxlBestandsnachweisKommunal.text"));
        this.jxlBestandsnachweisKommunal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.jxlBestandsnachweisKommunalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlBestandsnachweisKommunal, gridBagConstraints);
        this.jxlBestandsnachweisKommunalIntern.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlBestandsnachweisKommunalIntern.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.jxlBestandsnachweisKommunalIntern.text"));
        this.jxlBestandsnachweisKommunalIntern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.jxlBestandsnachweisKommunalInternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlBestandsnachweisKommunalIntern, gridBagConstraints);
        this.hlBestandsnachweisStichtagNRW.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlBestandsnachweisStichtagNRW.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.hlBestandsnachweisStichtagNRW.text"));
        this.hlBestandsnachweisStichtagNRW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.hlBestandsnachweisStichtagNRWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.hlBestandsnachweisStichtagNRW, gridBagConstraints);
        this.jxlBaulastBescheinigung.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlBaulastBescheinigung.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.jxlBaulastBescheinigung.text"));
        this.jxlBaulastBescheinigung.setEnabled(false);
        this.jxlBaulastBescheinigung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.jxlBaulastBescheinigungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlBaulastBescheinigung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.pnlButtons, gridBagConstraints);
        this.pnlBuchungsblaetter.setMinimumSize(new Dimension(228, 132));
        this.pnlBuchungsblaetter.setOpaque(false);
        this.pnlBuchungsblaetter.setLayout(new GridBagLayout());
        this.srpHeaderBuchungsblaetter.setBackground(Color.darkGray);
        this.srpHeaderBuchungsblaetter.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderBuchungsblaetter.setForeground(Color.white);
        this.lblHeaderBuchungsblaetter.setText(NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.lblHeaderBuchungsblaetter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeaderBuchungsblaetter.add((Component)this.lblHeaderBuchungsblaetter, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.pnlBuchungsblaetter.add((Component)this.srpHeaderBuchungsblaetter, gridBagConstraints);
        this.scpBuchungsblaetter.setPreferredSize(new Dimension(250, 402));
        this.tblBuchungsblaetter.setModel(this.tableModel);
        this.tblBuchungsblaetter.setSelectionMode(0);
        this.tblBuchungsblaetter.setShowVerticalLines(false);
        this.tblBuchungsblaetter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AlkisBuchungsblattAggregationRenderer.this.tblBuchungsblaetterFocusLost(evt);
            }
        });
        this.scpBuchungsblaetter.setViewportView(this.tblBuchungsblaetter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.35;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlBuchungsblaetter.add((Component)this.scpBuchungsblaetter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.pnlBuchungsblaetter, gridBagConstraints);
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.pnlMap, gridBagConstraints);
    }

    private void jxlBestandsnachweisNRWActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_NRW_PDF), true);
    }

    private void jxlBestandsnachweisKommunalActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_KOMMUNAL_PDF), true);
    }

    private void jxlBestandsnachweisKommunalInternActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF), true);
    }

    private void tblBuchungsblaetterFocusLost(FocusEvent evt) {
        this.map.gotoInitialBoundingBox();
        this.tblBuchungsblaetter.clearSelection();
    }

    private void hlBestandsnachweisStichtagNRWActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisStichtagProduct(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadEinzelnachweisStichtagProduct(boolean berechtigungspruefung) {
        String product = ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF);
        if (!ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(product), this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        ArrayList<String> buchungsblattCodes = new ArrayList<String>(this.cidsBeanWrappers.size());
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            buchungsblattCodes.add(this.getCompleteBuchungsblattCode(cidsBeanWrapper.getCidsBean()));
        }
        int stueck = 0;
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            ++stueck;
        }
        StichtagChooserDialog stichtagChooserDialog = new StichtagChooserDialog((Frame)ComponentRegistry.getRegistry().getMainWindow(), this.getConnectionContext());
        StaticSwingTools.showDialog((JDialog)stichtagChooserDialog);
        Date stichtag = stichtagChooserDialog.getDate();
        try {
            if (stichtag == null) return;
            BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo = DownloadInfoFactory.createAlkisBuchungsblattnachweisDownloadInfo((String)product, (Date)stichtag, buchungsblattCodes);
            AlkisProductDownloadHelper.downloadBuchungsblattnachweisStichtagProduct(downloadInfo, this.getConnectionContext());
            String billingKey = ClientAlkisProducts.getInstance().getBillingKey(product);
            if (billingKey != null && !BillingPopup.doBilling(billingKey, "no.yet", (Geometry)null, (BerechtigungspruefungBillingDownloadInfo)(berechtigungspruefung && AlkisProductDownloadHelper.checkBerechtigungspruefung(downloadInfo.getProduktTyp(), this.getConnectionContext()) ? downloadInfo : null), this.getConnectionContext(), new BillingProductGroupAmount("ea", stueck))) return;
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void jxlBaulastBescheinigungActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> selectedFlurstuecke = new ArrayList<CidsBean>();
        for (CidsBeanWrapper wrapper : this.cidsBeanWrappers) {
            if (!wrapper.isSelected()) continue;
            selectedFlurstuecke.addAll(this.selectedFlurstueckeMap.get(wrapper.getCidsBean()));
        }
        BaulastBescheinigungDialog.getInstance().show(selectedFlurstuecke, this, this.getConnectionContext());
    }

    public Collection<CidsBean> getCidsBeans() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            result.add(cidsBeanWrapper.getCidsBean());
        }
        return result;
    }

    public void setCidsBeans(final Collection<CidsBean> cidsBeans) {
        if (cidsBeans != null) {
            int colorIndex = 0;
            this.cidsBeanWrappers = new LinkedList<CidsBeanWrapper>();
            for (CidsBean cidsBean : cidsBeans) {
                this.cidsBeanWrappers.add(new CidsBeanWrapper(cidsBean, true));
            }
            boolean billingAllowedBlab_be = BillingPopup.isBillingAllowed("blab_be", this.getConnectionContext());
            if (billingAllowedBlab_be) {
                new SwingWorker<Map<CidsBean, Collection<CidsBean>>, Void>(){

                    @Override
                    protected Map<CidsBean, Collection<CidsBean>> doInBackground() throws Exception {
                        HashMap<CidsBean, Collection<CidsBean>> selectedFlurstueckeMap = new HashMap<CidsBean, Collection<CidsBean>>();
                        HashSet<String> landparcelCodes = new HashSet<String>();
                        for (CidsBean cidsBean : cidsBeans) {
                            ArrayList<CidsBean> selectedFlurstuecke = new ArrayList<CidsBean>();
                            for (CidsBean landparcelBean : cidsBean.getBeanCollectionProperty("landparcels")) {
                                String landparcelcode = (String)landparcelBean.getProperty("landparcelcode");
                                if (!landparcelCodes.contains(landparcelcode)) {
                                    landparcelCodes.add(landparcelcode);
                                    CidsAlkisSearchStatement search = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, landparcelcode, null);
                                    Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, AlkisBuchungsblattAggregationRenderer.this.getConnectionContext());
                                    if (!mons.isEmpty()) {
                                        MetaObjectNode mon = (MetaObjectNode)mons.iterator().next();
                                        CidsBean flurstueck = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", AlkisBuchungsblattAggregationRenderer.this.getConnectionContext()).getBean();
                                        selectedFlurstuecke.add(flurstueck);
                                    }
                                }
                                selectedFlurstueckeMap.put(cidsBean, selectedFlurstuecke);
                            }
                        }
                        return selectedFlurstueckeMap;
                    }

                    @Override
                    protected void done() {
                        try {
                            AlkisBuchungsblattAggregationRenderer.this.selectedFlurstueckeMap = (Map)this.get();
                            AlkisBuchungsblattAggregationRenderer.this.jxlBaulastBescheinigung.setText("Baulastbescheinigung");
                            if (AlkisBuchungsblattAggregationRenderer.this.selectedFlurstueckeMap != null && !AlkisBuchungsblattAggregationRenderer.this.selectedFlurstueckeMap.isEmpty()) {
                                AlkisBuchungsblattAggregationRenderer.this.jxlBaulastBescheinigung.setEnabled(true);
                            }
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                    }
                }.execute();
            }
            Collections.sort(this.cidsBeanWrappers);
            for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
                cidsBeanWrapper.setColor(COLORS[colorIndex]);
                colorIndex = (colorIndex + 1) % COLORS.length;
            }
            this.tableModel.setCidsBeans(this.cidsBeanWrappers);
            this.initMap();
            if (this.tblBuchungsblaetter != null && this.tblBuchungsblaetter.getColumnModel() != null) {
                TableColumn tableColumn;
                TableColumn tableColumn2 = this.tblBuchungsblaetter.getColumnModel().getColumn(0);
                if (tableColumn2 != null) {
                    tableColumn2.setPreferredWidth(20);
                }
                if ((tableColumn = this.tblBuchungsblaetter.getColumnModel().getColumn(3)) != null) {
                    tableColumn.setPreferredWidth(15);
                }
            }
            this.changeButtonAvailability(this.cidsBeanWrappers.size() > 0);
        }
    }

    public void dispose() {
        this.map.dispose();
    }

    public String getTitle() {
        return NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)"AlkisBuchungsblattAggregationRenderer.title", (Object)(this.cidsBeanWrappers != null ? Integer.valueOf(this.cidsBeanWrappers.size()) : "0"));
    }

    public void setTitle(String title) {
    }

    private void initMap() {
        this.mapThread = new Thread(new InitialiseMapRunnable());
        if (EventQueue.isDispatchThread()) {
            this.mapThread.start();
        } else {
            EventQueue.invokeLater(this.mapThread);
        }
        this.revalidate();
        this.repaint();
    }

    private void changeMap() {
        if (this.mapThread != null && this.mapThread.isAlive()) {
            if (initialisedMap) {
                this.mapThread.interrupt();
            } else {
                return;
            }
        }
        this.mapThread = new Thread(new ChangeMapRunnable());
        if (EventQueue.isDispatchThread()) {
            this.mapThread.start();
        } else {
            EventQueue.invokeLater(this.mapThread);
        }
        this.revalidate();
        this.repaint();
    }

    private void changeButtonAvailability(boolean enable) {
        boolean billingAllowedNw = BillingPopup.isBillingAllowed("bestnw", this.getConnectionContext());
        boolean billingAllowedKom = BillingPopup.isBillingAllowed("bekom", this.getConnectionContext());
        boolean billingAllowedBlab_be = BillingPopup.isBillingAllowed("blab_be", this.getConnectionContext());
        this.jxlBestandsnachweisNRW.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_nrw@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedNw);
        this.jxlBestandsnachweisKommunal.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_kom@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedKom);
        this.jxlBestandsnachweisKommunalIntern.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_kom_intern@WUNDA_BLAU", this.getConnectionContext()));
        this.jxlBaulastBescheinigung.setEnabled(enable && ObjectRendererUtils.checkActionTag("baulast.report.bescheinigung_enabled@WUNDA_BLAU", this.getConnectionContext()) && !ObjectRendererUtils.checkActionTag("baulast.report.bescheinigung_disabled@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedBlab_be && this.selectedFlurstueckeMap != null && !this.selectedFlurstueckeMap.isEmpty());
    }

    private void downloadEinzelnachweisProduct(String product, boolean berechtigungspruefung) {
        if (!ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(product), this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        int stueck = 0;
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            ++stueck;
        }
        try {
            ArrayList<String> buchungsblattCodes = new ArrayList<String>(this.cidsBeanWrappers.size());
            for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
                if (!cidsBeanWrapper.isSelected()) continue;
                buchungsblattCodes.add(this.getCompleteBuchungsblattCode(cidsBeanWrapper.getCidsBean()));
            }
            BerechtigungspruefungAlkisEinzelnachweisDownloadInfo berechtigungspruefungAlkisEinzelnachweisDownloadInfo = DownloadInfoFactory.createAlkisBuchungsblattachweisDownloadInfo((String)product, buchungsblattCodes);
            String billingKey = ClientAlkisProducts.getInstance().getBillingKey(product);
            if (billingKey == null || BillingPopup.doBilling(billingKey, "no.yet", (Geometry)null, (BerechtigungspruefungBillingDownloadInfo)(berechtigungspruefung && AlkisProductDownloadHelper.checkBerechtigungspruefung(berechtigungspruefungAlkisEinzelnachweisDownloadInfo.getProduktTyp(), this.getConnectionContext()) ? berechtigungspruefungAlkisEinzelnachweisDownloadInfo : null), this.getConnectionContext(), new BillingProductGroupAmount("ea", stueck))) {
                AlkisProductDownloadHelper.downloadBuchungsblattnachweisProduct(berechtigungspruefungAlkisEinzelnachweisDownloadInfo, this.getConnectionContext());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private String getCompleteBuchungsblattCode(CidsBean cidsBean) {
        Object buchungsblattcode;
        String result = "";
        if (cidsBean != null && (buchungsblattcode = cidsBean.getProperty("buchungsblattcode")) != null) {
            result = AlkisClientUtils.fixBuchungslattCode(buchungsblattcode.toString());
        }
        return result;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.map = new MappingComponent();
        this.pnlMap.add((Component)this.map, "Center");
        this.tblBuchungsblaetter.setDefaultRenderer(Color.class, new ColorRenderer());
        this.tblBuchungsblaetter.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    AlkisBuchungsblattAggregationRenderer.this.selectedCidsBeanWrapper = null;
                } else {
                    AlkisBuchungsblattAggregationRenderer.this.selectedCidsBeanWrapper = AlkisBuchungsblattAggregationRenderer.this.tableModel.get(lsm.getLeadSelectionIndex());
                }
                AlkisBuchungsblattAggregationRenderer.this.changeMap();
            }
        });
        boolean billingAllowedNw = BillingPopup.isBillingAllowed("bestnw", this.getConnectionContext());
        boolean billingAllowedKom = BillingPopup.isBillingAllowed("bekom", this.getConnectionContext());
        this.jxlBestandsnachweisNRW.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_nrw@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedNw);
        this.jxlBestandsnachweisKommunal.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_kom@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedKom);
        this.jxlBestandsnachweisKommunalIntern.setEnabled(ObjectRendererUtils.checkActionTag("custom.alkis.product.bestandsnachweis_kom_intern@WUNDA_BLAU", this.getConnectionContext()));
        boolean billingAllowedBlab_be = BillingPopup.isBillingAllowed("blab_be", this.getConnectionContext());
        if (!billingAllowedBlab_be) {
            this.jxlBaulastBescheinigung.setText("Baulastbescheinigung");
        }
    }

    private class CidsBeanWrapper
    implements Comparable<CidsBeanWrapper> {
        private CidsBean cidsBean;
        private boolean selected;
        private Color color;
        private String blattart;
        private String buchungsblattcode;
        private Collection<Geometry> geometries;
        private Collection<StyledFeature> features;

        public CidsBeanWrapper(CidsBean cidsBean, boolean selected) {
            this.cidsBean = cidsBean;
            this.selected = selected;
            this.blattart = cidsBean.getProperty("blattart").toString();
            this.buchungsblattcode = cidsBean.getProperty("buchungsblattcode").toString();
            this.geometries = new LinkedList<Geometry>();
            this.features = new LinkedList<StyledFeature>();
            for (CidsBean landparcel : this.cidsBean.getBeanCollectionProperty("landparcels")) {
                Object geometry = landparcel.getProperty("geometrie");
                if (!(geometry instanceof Geometry)) continue;
                Geometry transformedGeometry = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)geometry), (String)ClientAlkisConf.getInstance().getSrsService());
                DefaultStyledFeature dsf = new DefaultStyledFeature();
                dsf.setGeometry(transformedGeometry);
                this.geometries.add(transformedGeometry);
                this.features.add((StyledFeature)dsf);
            }
        }

        public CidsBean getCidsBean() {
            return this.cidsBean;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            for (StyledFeature feature : this.features) {
                feature.setFillingPaint((Paint)this.color);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getBlattart() {
            return this.blattart;
        }

        public String getBuchungsblattcode() {
            return this.buchungsblattcode;
        }

        public Collection<Geometry> getGeometries() {
            return this.geometries;
        }

        public Collection<StyledFeature> getFeatures() {
            return this.features;
        }

        @Override
        public int compareTo(CidsBeanWrapper o) {
            CidsBean cidsBean1 = this.cidsBean;
            CidsBean cidsBean2 = o.cidsBean;
            if (cidsBean1 == null && cidsBean2 == null) {
                return 0;
            }
            if (cidsBean1 == null) {
                return -1;
            }
            if (cidsBean2 == null) {
                return 1;
            }
            int districtComparison = cidsBean1.getProperty("blattart").toString().compareTo(cidsBean2.getProperty("blattart").toString());
            if (districtComparison != 0) {
                return districtComparison;
            }
            return cidsBean1.getProperty("buchungsblattcode").toString().compareTo(cidsBean2.getProperty("buchungsblattcode").toString());
        }
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            return this;
        }
    }

    private class ChangeMapRunnable
    implements Runnable {
        private ChangeMapRunnable() {
        }

        @Override
        public void run() {
            GeometryCollection geoCollection = new GeometryCollection(AlkisBuchungsblattAggregationRenderer.this.selectedCidsBeanWrapper.getGeometries().toArray(new Geometry[AlkisBuchungsblattAggregationRenderer.this.selectedCidsBeanWrapper.getGeometries().size()]), new GeometryFactory());
            XBoundingBox boxToGoto = new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
            boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
            boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
            boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
            boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
            AlkisBuchungsblattAggregationRenderer.this.map.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
        }
    }

    private class InitialiseMapRunnable
    implements Runnable {
        private InitialiseMapRunnable() {
        }

        @Override
        public void run() {
            initialisedMap = false;
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            mappingModel.addHome(this.getBoundingBox());
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
            swms.setName("Buchungsblatt");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            AlkisBuchungsblattAggregationRenderer.this.map.setMappingModel((MappingModel)mappingModel);
            int duration = AlkisBuchungsblattAggregationRenderer.this.map.getAnimationDuration();
            AlkisBuchungsblattAggregationRenderer.this.map.setAnimationDuration(0);
            AlkisBuchungsblattAggregationRenderer.this.map.gotoInitialBoundingBox();
            AlkisBuchungsblattAggregationRenderer.this.map.setInteractionMode("ZOOM");
            AlkisBuchungsblattAggregationRenderer.this.map.unlock();
            AlkisBuchungsblattAggregationRenderer.this.map.setInteractionMode("MUTE");
            for (CidsBeanWrapper cidsBeanWrapper : AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers) {
                AlkisBuchungsblattAggregationRenderer.this.map.getFeatureCollection().addFeatures(cidsBeanWrapper.getFeatures());
            }
            AlkisBuchungsblattAggregationRenderer.this.map.setAnimationDuration(duration);
            initialisedMap = true;
        }

        private XBoundingBox getBoundingBox() {
            XBoundingBox result = null;
            for (CidsBeanWrapper cidsBeanWrapper : AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers) {
                for (Geometry geometry : cidsBeanWrapper.getGeometries()) {
                    if (result == null) {
                        result = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                        result.setSrs(ClientAlkisConf.getInstance().getSrsService());
                        result.setMetric(true);
                        continue;
                    }
                    XBoundingBox temp = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                    temp.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    temp.setMetric(true);
                    if (temp.getX1() < result.getX1()) {
                        result.setX1(temp.getX1());
                    }
                    if (temp.getY1() < result.getY1()) {
                        result.setY1(temp.getY1());
                    }
                    if (temp.getX2() > result.getX2()) {
                        result.setX2(temp.getX2());
                    }
                    if (!(temp.getY2() > result.getY2())) continue;
                    result.setY2(temp.getY2());
                }
            }
            return result;
        }
    }

    private class BuchungsblattTableModel
    extends AbstractTableModel {
        private int selectedCidsBeans = 0;

        private BuchungsblattTableModel() {
        }

        @Override
        public int getRowCount() {
            if (AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers.size();
        }

        @Override
        public int getColumnCount() {
            if (AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(AlkisBuchungsblattAggregationRenderer.class, (String)("AlkisBuchungsblattAggregationRenderer.BuchungsblattTableModel.getColumnName(" + column + ")"));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers == null) {
                return null;
            }
            CidsBeanWrapper cidsBeanWrapper = (CidsBeanWrapper)AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers.get(rowIndex);
            if (columnIndex == 0) {
                return cidsBeanWrapper.isSelected();
            }
            if (columnIndex == 1) {
                return cidsBeanWrapper.getBlattart();
            }
            if (columnIndex == 2) {
                return cidsBeanWrapper.getBuchungsblattcode();
            }
            return cidsBeanWrapper.getColor();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void setCidsBeans(List<CidsBeanWrapper> cidsBeans) {
            if (cidsBeans != null) {
                this.selectedCidsBeans = AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers.size();
                this.fireTableStructureChanged();
            }
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CidsBeanWrapper cidsBeanWrapper;
            if (column != 0) {
                return;
            }
            cidsBeanWrapper.setSelected(!(cidsBeanWrapper = (CidsBeanWrapper)AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers.get(row)).isSelected());
            this.selectedCidsBeans = cidsBeanWrapper.isSelected() ? ++this.selectedCidsBeans : --this.selectedCidsBeans;
            this.fireTableRowsUpdated(row, row);
            AlkisBuchungsblattAggregationRenderer.this.changeMap();
            AlkisBuchungsblattAggregationRenderer.this.changeButtonAvailability(this.selectedCidsBeans > 0);
        }

        public CidsBeanWrapper get(int index) {
            return (CidsBeanWrapper)AlkisBuchungsblattAggregationRenderer.this.cidsBeanWrappers.get(index);
        }
    }
}

