/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objectrenderer.utils.BillingCalculations;
import de.cismet.cids.custom.objectrenderer.utils.BillingRestrictedReportJButton;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.billing.TimeFilterPanel;
import de.cismet.cids.custom.objectrenderer.utils.billing.VerwendungszweckPanel;
import de.cismet.cids.custom.reports.wunda_blau.PrintBillingReportForCustomer;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBillingSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BillingKundeRenderer
extends JPanel
implements RequestsFullSizeComponent,
CidsBeanRenderer,
TitleComponentProvider,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BillingKundeRenderer.class);
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Gesch\u00e4ftsbuchnummer", "Projektbezeichnung", "Verwendung", "Produkt", "Preis (netto)", "MwSt-Satz", "Datum", "Benutzer"};
    private static final String[] AGR_PROPERTY_NAMES = new String[]{"geschaeftsbuchnummer", "projektbezeichnung", "verwendungskey", "produktbezeichnung", "netto_summe", "mwst_satz", "ts", "angelegt_durch.name"};
    private SwingWorker<List<CidsBean>, Integer> worker;
    private BillingTableModel tableModel;
    private CidsBean cidsBean;
    private String title;
    private List<CidsBean> filteredBuchungen;
    private Date[] fromDate_tillDate;
    private BigDecimal totalSum;
    private boolean itsMe = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JXBusyLabel blblBusy;
    private JButton btnBuchungsbeleg;
    private JButton btnRechnungsanlage;
    private JButton btnShowResults;
    private JCheckBox cboAbgerechnet;
    private JComboBox cboBenutzer;
    private JCheckBox cboHideFreeDownloadsBuchungsbeleg;
    private JCheckBox cboHideFreeDownloadsRechnungsanlage;
    private JCheckBox cboKostenfrei;
    private JCheckBox cboKostenpflichtig;
    private JCheckBox cboNichtAbgerechnet;
    private Box.Filler filler5;
    private JButton jButton1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JLabel lblFilterResult;
    private JLabel lblResultHeader;
    private JLabel lblTitle;
    private JPanel panTitle;
    private JPanel pnlBusyLable;
    private JPanel pnlFilterResults;
    private JPanel pnlFilters;
    private JPanel pnlTable;
    private TimeFilterPanel pnlTimeFilters;
    private VerwendungszweckPanel pnlVerwendungszweck;
    private SemiRoundedPanel smiplFilter;
    private SemiRoundedPanel smiplTable;
    private JTable tblBillings;
    private JTextField txtGeschaeftsbuchnummer;
    private JTextField txtProjekt;

    public BillingKundeRenderer() {
        this(true);
    }

    public BillingKundeRenderer(boolean editable) {
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.tableModel = new BillingTableModel((Object[][])new Object[0][], AGR_COMLUMN_NAMES);
        this.tblBillings.setModel(this.tableModel);
        this.setFilterActionInExternalPanels();
        if (!ObjectRendererUtils.checkActionTag("custom.billing.reports@WUNDA_BLAU", this.getConnectionContext())) {
            this.btnRechnungsanlage.setEnabled(false);
            this.cboHideFreeDownloadsRechnungsanlage.setEnabled(false);
        }
        this.tblBillings.getRowSorter().toggleSortOrder(6);
    }

    private void doDownload(String request) {
        if (request != null) {
            if (request.startsWith("http://")) {
                DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this);
                try {
                    URL url = new URL(request);
                    String filename = "alkis_druck";
                    try {
                        Map<String, String> urlQuery = BillingKundeRenderer.splitQuery(url);
                        filename = urlQuery.get("product") + "." + urlQuery.get("landparcel").replace("/", "--");
                    }
                    catch (UnsupportedEncodingException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    HttpDownload download = new HttpDownload(url, "", DownloadManagerDialog.getInstance().getJobName(), "ALKIS-Druck", filename, ".pdf");
                    DownloadManager.instance().add((Download)download);
                }
                catch (MalformedURLException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            } else {
                try {
                    String produktTyp = ((BerechtigungspruefungBillingDownloadInfo)MAPPER.readValue(request, BerechtigungspruefungBillingDownloadInfo.class)).getProduktTyp();
                    BerechtigungspruefungBescheinigungDownloadInfo downloadInfo = BerechtigungspruefungBescheinigungDownloadInfo.PRODUKT_TYP.equals(produktTyp) ? (BerechtigungspruefungBescheinigungDownloadInfo)MAPPER.readValue(request, BerechtigungspruefungBescheinigungDownloadInfo.class) : null;
                    if (downloadInfo instanceof BerechtigungspruefungBescheinigungDownloadInfo) {
                        AlkisProductDownloadHelper.downloadBaulastbescheinigung(downloadInfo, "", this.getConnectionContext());
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            if (idx == -1) continue;
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }

    private void initComponents() {
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.pnlFilters = new JPanel();
        this.jPanel5 = new JPanel();
        this.pnlTimeFilters = new TimeFilterPanel();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtGeschaeftsbuchnummer = new JTextField();
        this.txtProjekt = new JTextField();
        this.jLabel4 = new JLabel();
        this.cboBenutzer = new JComboBox();
        this.filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlVerwendungszweck = new VerwendungszweckPanel();
        this.btnShowResults = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.cboAbgerechnet = new JCheckBox();
        this.cboNichtAbgerechnet = new JCheckBox();
        this.cboKostenpflichtig = new JCheckBox();
        this.cboKostenfrei = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.cboHideFreeDownloadsRechnungsanlage = new JCheckBox();
        this.cboHideFreeDownloadsBuchungsbeleg = new JCheckBox();
        this.btnRechnungsanlage = new BillingRestrictedReportJButton(this.getConnectionContext());
        this.btnBuchungsbeleg = new JButton();
        this.smiplFilter = new SemiRoundedPanel();
        this.jLabel2 = new JLabel();
        this.smiplTable = new SemiRoundedPanel();
        this.lblResultHeader = new JLabel();
        this.pnlTable = new JPanel();
        this.pnlFilterResults = new JPanel();
        this.lblFilterResult = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblBillings = new JTable();
        this.pnlBusyLable = new JPanel();
        this.blblBusy = new JXBusyLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButton1 = new JButton();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("DejaVu Sans", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.setLayout(new GridBagLayout());
        this.pnlFilters.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.jPanel5.add((Component)this.pnlTimeFilters, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderFactory.createTitledBorder("")));
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 8, 3, 6);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 8, 3, 6);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.txtGeschaeftsbuchnummer.setText(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.txtGeschaeftsbuchnummer.text"));
        this.txtGeschaeftsbuchnummer.setToolTipText(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.txtGeschaeftsbuchnummer.toolTipText"));
        this.txtGeschaeftsbuchnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.txtGeschaeftsbuchnummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 12);
        this.jPanel3.add((Component)this.txtGeschaeftsbuchnummer, gridBagConstraints);
        this.txtGeschaeftsbuchnummer.getDocument().addDocumentListener(new FilterBuchungenDocumentListener());
        this.txtProjekt.setText(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.txtProjekt.text"));
        this.txtProjekt.setToolTipText(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.txtProjekt.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 12);
        this.jPanel3.add((Component)this.txtProjekt, gridBagConstraints);
        this.txtProjekt.getDocument().addDocumentListener(new FilterBuchungenDocumentListener());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 8, 0, 6);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.cboBenutzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.cboBenutzerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 12);
        this.jPanel3.add((Component)this.cboBenutzer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel5.add((Component)this.filler5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel5.add((Component)this.pnlVerwendungszweck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowResults, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.btnShowResults.text"));
        this.btnShowResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.btnShowResultsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 2);
        this.jPanel5.add((Component)this.btnShowResults, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jPanel6.border.title")));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridLayout(2, 2));
        this.cboAbgerechnet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboAbgerechnet, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboAbgerechnet.text"));
        this.cboAbgerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.cboAbgerechnetActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.cboAbgerechnet);
        this.cboNichtAbgerechnet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboNichtAbgerechnet, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboNichtAbgerechnet.text"));
        this.cboNichtAbgerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.cboNichtAbgerechnetActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.cboNichtAbgerechnet);
        this.cboKostenpflichtig.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboKostenpflichtig, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboKostenpflichtig.text"));
        this.cboKostenpflichtig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.cboKostenpflichtigActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.cboKostenpflichtig);
        this.cboKostenfrei.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboKostenfrei, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboKostenfrei.text"));
        this.cboKostenfrei.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.cboKostenfreiActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.cboKostenfrei);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 0, 2);
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilters.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.pnlFilters, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridLayout(2, 3, 20, 0));
        this.cboHideFreeDownloadsRechnungsanlage.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboHideFreeDownloadsRechnungsanlage, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboHideFreeDownloadsRechnungsanlage.text"));
        this.jPanel4.add(this.cboHideFreeDownloadsRechnungsanlage);
        this.cboHideFreeDownloadsBuchungsbeleg.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboHideFreeDownloadsBuchungsbeleg, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.cboHideFreeDownloadsBuchungsbeleg.text"));
        this.jPanel4.add(this.cboHideFreeDownloadsBuchungsbeleg);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRechnungsanlage, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.btnRechnungsanlage.text"));
        this.btnRechnungsanlage.setEnabled(false);
        this.btnRechnungsanlage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.btnRechnungsanlageActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnRechnungsanlage);
        Mnemonics.setLocalizedText((AbstractButton)this.btnBuchungsbeleg, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.btnBuchungsbeleg.text"));
        this.btnBuchungsbeleg.setEnabled(false);
        this.btnBuchungsbeleg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.btnBuchungsbelegActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnBuchungsbeleg);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.smiplFilter.setBackground(new Color(51, 51, 51));
        this.smiplFilter.setLayout((LayoutManager)new FlowLayout());
        this.jLabel2.setBackground(new Color(255, 255, 255));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jLabel2.text"));
        this.smiplFilter.add((Component)this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.smiplFilter, gridBagConstraints);
        this.smiplTable.setBackground(new Color(51, 51, 51));
        this.smiplTable.setLayout((LayoutManager)new FlowLayout());
        this.lblResultHeader.setBackground(new Color(51, 51, 51));
        this.lblResultHeader.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblResultHeader.text"));
        this.smiplTable.add((Component)this.lblResultHeader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.smiplTable, gridBagConstraints);
        this.pnlTable.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pnlTable.setLayout(new CardLayout());
        this.pnlFilterResults.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblFilterResult, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblFilterResult.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pnlFilterResults.add((Component)this.lblFilterResult, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(453, 275));
        this.tblBillings.setAutoCreateRowSorter(true);
        this.tblBillings.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblBillings.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BillingKundeRenderer.this.tblBillingsMouseMoved(evt);
            }
        });
        this.tblBillings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BillingKundeRenderer.this.tblBillingsMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BillingKundeRenderer.this.tblBillingsMouseExited(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblBillings);
        if (this.tblBillings.getColumnModel().getColumnCount() > 0) {
            this.tblBillings.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.tblBillings.columnModel.title0"));
            this.tblBillings.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.tblBillings.columnModel.title1"));
            this.tblBillings.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.tblBillings.columnModel.title2"));
            this.tblBillings.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.tblBillings.columnModel.title3"));
        }
        this.tblBillings.setDefaultRenderer(BillingUsage.class, new UsageRenderer());
        this.tblBillings.setDefaultRenderer(DateRequestTuple.class, new DateRequestTupleRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.pnlFilterResults.add((Component)this.jScrollPane1, gridBagConstraints);
        this.pnlTable.add((Component)this.pnlFilterResults, "table");
        this.pnlBusyLable.setLayout(new GridBagLayout());
        this.blblBusy.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.blblBusy, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.blblBusy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlBusyLable.add((Component)this.blblBusy, gridBagConstraints);
        this.jProgressBar1.setString(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jProgressBar1.string"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlBusyLable.add((Component)this.jProgressBar1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeRenderer.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pnlBusyLable.add((Component)this.jButton1, gridBagConstraints);
        this.pnlTable.add((Component)this.pnlBusyLable, "busy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        this.add((Component)this.pnlTable, gridBagConstraints);
    }

    private void txtGeschaeftsbuchnummerActionPerformed(ActionEvent evt) {
    }

    private void cboBenutzerActionPerformed(ActionEvent evt) {
        this.filterSettingsChanged();
    }

    private void tblBillingsMouseClicked(MouseEvent evt) {
        DateRequestTuple bt;
        int row = this.tblBillings.convertRowIndexToModel(this.tblBillings.getSelectedRow());
        int column = this.tblBillings.convertColumnIndexToModel(this.tblBillings.getSelectedColumn());
        if (column == 6 && (bt = (DateRequestTuple)this.tblBillings.getModel().getValueAt(row, column)).isRequestValid()) {
            this.doDownload(bt.getRequest());
        }
    }

    private void tblBillingsMouseMoved(MouseEvent evt) {
        int row = this.tblBillings.convertRowIndexToModel(this.tblBillings.rowAtPoint(evt.getPoint()));
        int column = this.tblBillings.convertColumnIndexToModel(this.tblBillings.columnAtPoint(evt.getPoint()));
        if (column == 6) {
            DateRequestTuple bt = (DateRequestTuple)this.tblBillings.getModel().getValueAt(row, column);
            if (bt.isRequestValid()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void tblBillingsMouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void btnShowResultsActionPerformed(ActionEvent evt) {
        this.btnBuchungsbeleg.setEnabled(true);
        this.btnRechnungsanlage.setEnabled(true);
        this.filterBuchungen();
    }

    private List<CidsBean> getSortedBillingBeans(final List<CidsBean> billingBeans) {
        ArrayList<CidsBean> sortedFilteredBuchungen = new ArrayList<CidsBean>(billingBeans);
        Collections.sort(sortedFilteredBuchungen, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                int i1 = BillingKundeRenderer.this.tblBillings.convertRowIndexToView(billingBeans.indexOf(o1));
                int i2 = BillingKundeRenderer.this.tblBillings.convertRowIndexToView(billingBeans.indexOf(o2));
                return Integer.compare(i1, i2);
            }
        });
        return sortedFilteredBuchungen;
    }

    private void btnRechnungsanlageActionPerformed(ActionEvent evt) {
        PrintBillingReportForCustomer printBillingReportForCustomer = new PrintBillingReportForCustomer(this.cidsBean, this.getSortedBillingBeans(this.filteredBuchungen), this.fromDate_tillDate, true, this, this.retrieveShowBillingInReport(evt), new PrintBillingReportForCustomer.BillingDoneListener(){

            @Override
            public void billingDone(boolean isDone) {
                BillingKundeRenderer.this.filterBuchungen();
            }
        }, this.getConnectionContext());
        printBillingReportForCustomer.print();
    }

    private void btnBuchungsbelegActionPerformed(ActionEvent evt) {
        new PrintBillingReportForCustomer(this.cidsBean, this.getSortedBillingBeans(this.filteredBuchungen), this.fromDate_tillDate, false, this, this.retrieveShowBillingInReport(evt), null, this.getConnectionContext()).print();
    }

    private void cboAbgerechnetActionPerformed(ActionEvent evt) {
        if (!this.cboAbgerechnet.isSelected() && !this.cboNichtAbgerechnet.isSelected()) {
            this.cboAbgerechnet.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboNichtAbgerechnetActionPerformed(ActionEvent evt) {
        if (!this.cboAbgerechnet.isSelected() && !this.cboNichtAbgerechnet.isSelected()) {
            this.cboAbgerechnet.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboKostenpflichtigActionPerformed(ActionEvent evt) {
        if (!this.cboKostenfrei.isSelected() && !this.cboKostenpflichtig.isSelected()) {
            this.cboKostenpflichtig.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboKostenfreiActionPerformed(ActionEvent evt) {
        if (!this.cboKostenfrei.isSelected() && !this.cboKostenpflichtig.isSelected()) {
            this.cboKostenpflichtig.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    private boolean retrieveShowBillingInReport(ActionEvent evt) {
        JButton source = (JButton)evt.getSource();
        if (source.equals(this.btnBuchungsbeleg)) {
            return !this.cboHideFreeDownloadsBuchungsbeleg.isSelected();
        }
        if (source.equals(this.btnRechnungsanlage)) {
            return !this.cboHideFreeDownloadsRechnungsanlage.isSelected();
        }
        return false;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean kundeBean) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        if (kundeBean != null) {
            this.cidsBean = kundeBean;
            this.cboBenutzer.setModel(new DefaultComboBoxModel());
            this.cboBenutzer.addItem("");
            for (CidsBean benutzerBean : this.cidsBean.getBeanCollectionProperty("benutzer_n")) {
                this.cboBenutzer.addItem(benutzerBean);
            }
            this.title = NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblTitle.prefix") + " " + kundeBean.toString();
            this.lblTitle.setText(this.title);
            try {
                this.itsMe = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "custom.billing.tree." + (String)kundeBean.getProperty("name_intern"), this.getConnectionContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pnlVerwendungszweck.initVerwendungszweckCheckBoxes(this.itsMe);
        }
    }

    public void dispose() {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "<Error>";
        }
        this.title = NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblTitle.prefix") + title;
        this.lblTitle.setText(this.title);
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createRendererInFrameFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif", (String)"billing_kunde", (int)15, (String)"Foo", (int)1280, (int)1024);
    }

    private void fillBillingTable(Collection<CidsBean> billingBeans) {
        ArrayList<Object[]> tableData = new ArrayList<Object[]>();
        for (CidsBean punktBean : billingBeans) {
            tableData.add(this.cidsBean2Row(punktBean));
        }
        this.tableModel = new BillingTableModel((Object[][])tableData.toArray((T[])new Object[tableData.size()][]), AGR_COMLUMN_NAMES);
        this.tblBillings.setModel(this.tableModel);
        this.tblBillings.getColumnModel().getColumn(4).setCellRenderer(new EuroFormatterRenderer());
        this.tblBillings.getColumnModel().getColumn(5).setCellRenderer(new PercentFormatterRenderer());
        if (!tableData.isEmpty()) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tblBillings.getModel());
            this.tblBillings.setRowSorter(sorter);
        } else {
            this.tblBillings.setRowSorter(null);
        }
    }

    private Object[] cidsBean2Row(CidsBean billingBean) {
        if (billingBean != null) {
            Object[] result = new Object[AGR_COMLUMN_NAMES.length];
            for (int i = 0; i < AGR_PROPERTY_NAMES.length; ++i) {
                Object property = billingBean.getProperty(AGR_PROPERTY_NAMES[i]);
                if (AGR_PROPERTY_NAMES[i].equals("verwendungskey")) {
                    result[i] = VerwendungszweckPanel.getUsages().get((String)property);
                    continue;
                }
                if (AGR_PROPERTY_NAMES[i].equals("ts")) {
                    String request = (String)billingBean.getProperty("request");
                    DateRequestTuple dateRequestTuple = new DateRequestTuple((Date)property, request);
                    result[i] = dateRequestTuple;
                    continue;
                }
                if (AGR_PROPERTY_NAMES[i].equals("netto_summe")) {
                    result[i] = property;
                    continue;
                }
                if (AGR_PROPERTY_NAMES[i].equals("mwst_satz")) {
                    result[i] = property;
                    continue;
                }
                String propertyString = ObjectRendererUtils.propertyPrettyPrint(property);
                result[i] = propertyString;
            }
            return result;
        }
        return new Object[0];
    }

    private String generateFilterResultText(Collection<CidsBean> billingBeans) {
        StringBuilder text = new StringBuilder();
        if (billingBeans.isEmpty()) {
            this.totalSum = new BigDecimal("0");
            text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().noBillings"));
        } else {
            int amountBillings = billingBeans.size();
            this.fromDate_tillDate = this.pnlTimeFilters.chooseDates();
            Date from = this.fromDate_tillDate[0];
            Date till = this.fromDate_tillDate[1];
            this.totalSum = BillingCalculations.calculateBruttoSumFromBillings(billingBeans);
            NumberFormat euroFormatter = NumberFormat.getCurrencyInstance(Locale.GERMANY);
            text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings1"));
            text.append(euroFormatter.format(this.totalSum));
            text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings2"));
            if (amountBillings == 1) {
                text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings3.oneBilling"));
            } else {
                text.append(amountBillings);
                text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings3.moreBillings"));
            }
            if (from == null) {
                text.append(".");
            } else if (till == null || from.equals(till)) {
                text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings4.oneDate"));
                text.append(DATE_FORMAT.format(from));
                text.append(".");
            } else {
                text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings4.twoDates1"));
                text.append(DATE_FORMAT.format(from));
                text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().billings4.twoDates2"));
                text.append(DATE_FORMAT.format(till));
                text.append(".");
            }
        }
        text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().suffix"));
        return text.toString();
    }

    private void filterSettingsChanged() {
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblResultHeader.text.filterSettingsChanged"));
    }

    private void filterBuchungen() {
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.lblResultHeader.text.updated"));
        final CidsBillingSearchStatement cidsBillingSearchStatement = new CidsBillingSearchStatement(this.cidsBean.getMetaObject());
        cidsBillingSearchStatement.setGeschaeftsbuchnummer(this.txtGeschaeftsbuchnummer.getText());
        cidsBillingSearchStatement.setProjekt(this.txtProjekt.getText());
        Object user = this.cboBenutzer.getSelectedItem();
        String userID = "";
        if (user instanceof CidsBean) {
            userID = ((CidsBean)user).getProperty("id").toString();
        }
        cidsBillingSearchStatement.setUserID(userID);
        cidsBillingSearchStatement.setVerwendungszweckKeys(this.pnlVerwendungszweck.createSelectedVerwendungszweckKeysStringArray());
        if (this.cboKostenfrei.isSelected() && this.cboKostenpflichtig.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.IGNORIEREN);
        } else if (this.cboKostenfrei.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENFREI);
        } else if (this.cboKostenpflichtig.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENPFLICHTIG);
        } else {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.IGNORIEREN);
        }
        if (this.cboAbgerechnet.isSelected() && this.cboNichtAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(null);
        } else if (this.cboAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(Boolean.valueOf(true));
        } else if (this.cboNichtAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(Boolean.valueOf(false));
        } else {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(null);
        }
        this.fromDate_tillDate = this.pnlTimeFilters.chooseDates();
        cidsBillingSearchStatement.setFrom(this.fromDate_tillDate[0]);
        cidsBillingSearchStatement.setTill(this.fromDate_tillDate[1]);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query to get the billings: " + cidsBillingSearchStatement.generateQuery()));
        }
        this.blblBusy.setBusy(true);
        ((CardLayout)this.pnlTable.getLayout()).show(this.pnlTable, "busy");
        this.btnBuchungsbeleg.setEnabled(false);
        this.btnRechnungsanlage.setEnabled(false);
        this.btnShowResults.setEnabled(false);
        this.jProgressBar1.setString(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.jProgressBar1.string"));
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setStringPainted(true);
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<List<CidsBean>, Integer>(){

            @Override
            protected List<CidsBean> doInBackground() throws Exception {
                ArrayList<CidsBean> beans;
                Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)cidsBillingSearchStatement, BillingKundeRenderer.this.getConnectionContext());
                this.publish(mons.size());
                if (mons != null) {
                    beans = new ArrayList<CidsBean>(mons.size());
                    for (MetaObjectNode mon : mons) {
                        if (!this.isCancelled()) {
                            if (mon == null) continue;
                            this.publish(beans.size() + 1);
                            MetaObject mo = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain(), BillingKundeRenderer.this.getConnectionContext());
                            CidsBean bean = mo != null ? mo.getBean() : null;
                            beans.add(bean);
                            continue;
                        }
                        break;
                    }
                } else {
                    beans = null;
                }
                return beans;
            }

            @Override
            protected void process(List<Integer> chunks) {
                for (Integer chunk : chunks) {
                    if (BillingKundeRenderer.this.jProgressBar1.isIndeterminate()) {
                        BillingKundeRenderer.this.jProgressBar1.setIndeterminate(false);
                        BillingKundeRenderer.this.jProgressBar1.setMaximum(chunk);
                        BillingKundeRenderer.this.jProgressBar1.setValue(0);
                        continue;
                    }
                    String string = "Lade Buchung " + chunk + " von " + BillingKundeRenderer.this.jProgressBar1.getMaximum();
                    BillingKundeRenderer.this.jProgressBar1.setValue(chunk);
                    BillingKundeRenderer.this.jProgressBar1.setString(string);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        List billingBeans = (List)this.get();
                        if (billingBeans == null) {
                            LOG.error((Object)"Billing metaobjects was null.");
                        } else if (billingBeans.isEmpty()) {
                            LOG.info((Object)"No Billing metaobjects found.");
                            BillingKundeRenderer.this.filteredBuchungen = new ArrayList();
                            BillingKundeRenderer.this.fillBillingTable(BillingKundeRenderer.this.filteredBuchungen);
                            BillingKundeRenderer.this.lblFilterResult.setText(BillingKundeRenderer.this.generateFilterResultText(new ArrayList()));
                        } else {
                            BillingKundeRenderer.this.filteredBuchungen = billingBeans;
                            BillingKundeRenderer.this.fillBillingTable(billingBeans);
                            BillingKundeRenderer.this.lblFilterResult.setText(BillingKundeRenderer.this.generateFilterResultText(billingBeans));
                            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                            RowSorter.SortKey sortKey = new RowSorter.SortKey(6, SortOrder.ASCENDING);
                            keys.add(sortKey);
                            BillingKundeRenderer.this.tblBillings.getRowSorter().setSortKeys(keys);
                            ((TableRowSorter)BillingKundeRenderer.this.tblBillings.getRowSorter()).sort();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Error while filtering the billings.", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Error while filtering the billings.", (Throwable)ex);
                }
                finally {
                    ((CardLayout)BillingKundeRenderer.this.pnlTable.getLayout()).show(BillingKundeRenderer.this.pnlTable, "table");
                    BillingKundeRenderer.this.btnBuchungsbeleg.setEnabled(true);
                    BillingKundeRenderer.this.btnRechnungsanlage.setEnabled(true);
                    BillingKundeRenderer.this.btnShowResults.setEnabled(true);
                    BillingKundeRenderer.this.blblBusy.setBusy(false);
                    BillingKundeRenderer.this.jProgressBar1.setMaximum(0);
                    BillingKundeRenderer.this.jProgressBar1.setValue(0);
                    BillingKundeRenderer.this.jProgressBar1.setStringPainted(false);
                    BillingKundeRenderer.this.jProgressBar1.setIndeterminate(false);
                }
            }
        };
        this.worker.execute();
    }

    private void setFilterActionInExternalPanels() {
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillingKundeRenderer.this.filterSettingsChanged();
            }
        };
        this.pnlTimeFilters.setFilterSettingChangedAction(filterAction);
        this.pnlVerwendungszweck.setFilterSettingChangedAction(filterAction);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private class DateRequestTupleRenderer
    extends DefaultTableCellRenderer {
        private DateRequestTupleRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText(ObjectRendererUtils.propertyPrettyPrint(value));
            } else {
                DateRequestTuple dateRequestTuple = (DateRequestTuple)value;
                String formattedDate = DATE_FORMAT.format(dateRequestTuple.getDate());
                String text = ObjectRendererUtils.propertyPrettyPrint(formattedDate);
                if (dateRequestTuple.isRequestValid()) {
                    this.setText("<html><a href=\"http://www.cismet.de\">" + text + "</a></html>");
                } else {
                    this.setText(text);
                }
            }
        }
    }

    private class UsageRenderer
    extends DefaultTableCellRenderer {
        private UsageRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                this.setText(ObjectRendererUtils.propertyPrettyPrint(value));
            } else {
                BillingUsage usage = (BillingUsage)value;
                this.setText(ObjectRendererUtils.propertyPrettyPrint(usage.getKey()));
                this.setToolTipText(usage.getName());
            }
        }
    }

    private class EuroFormatterRenderer
    extends DefaultTableCellRenderer {
        private NumberFormat euroFormatter = NumberFormat.getCurrencyInstance(Locale.GERMANY);

        public EuroFormatterRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null || !(value instanceof Number)) {
                this.setText(ObjectRendererUtils.propertyPrettyPrint(value));
            } else {
                this.setText(this.euroFormatter.format(value));
            }
        }
    }

    private class PercentFormatterRenderer
    extends DefaultTableCellRenderer {
        private NumberFormat percentFormatter = new DecimalFormat("#0.0");

        public PercentFormatterRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null || !(value instanceof Number)) {
                this.setText(ObjectRendererUtils.propertyPrettyPrint(value));
            } else {
                this.setText(this.percentFormatter.format(value) + " %");
            }
        }
    }

    private class FilterBuchungenDocumentListener
    implements DocumentListener {
        private FilterBuchungenDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BillingKundeRenderer.this.filterSettingsChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BillingKundeRenderer.this.filterSettingsChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BillingKundeRenderer.this.filterSettingsChanged();
        }
    }

    static final class BillingTableModel
    extends DefaultTableModel {
        public BillingTableModel(Object[][] data, String[] labels) {
            super(data, labels);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int column) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object o = this.getValueAt(row, column);
                if (o == null) continue;
                return o.getClass();
            }
            return Object.class;
        }
    }

    private class DateRequestTuple
    implements Comparable<DateRequestTuple> {
        Date date;
        String request;

        public DateRequestTuple(Date date, String request) {
            this.date = date;
            this.request = request;
        }

        private String getRequest() {
            return this.request;
        }

        public Date getDate() {
            return this.date;
        }

        @Override
        public int compareTo(DateRequestTuple o) {
            return this.date.compareTo(o.getDate());
        }

        public boolean isRequestValid() {
            if (this.isToday() && this.request != null) {
                try {
                    return BerechtigungspruefungBescheinigungDownloadInfo.PRODUKT_TYP.equals(((BerechtigungspruefungBillingDownloadInfo)MAPPER.readValue(this.request, BerechtigungspruefungBillingDownloadInfo.class)).getProduktTyp());
                }
                catch (Exception exception) {
                    return this.request.startsWith("http://");
                }
            }
            return false;
        }

        private boolean isToday() {
            if (this.date == null) {
                return false;
            }
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c2.setTime(this.date);
            return c1.get(1) == c2.get(1) && c1.get(6) == c2.get(6);
        }
    }
}

