/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.annotations.AggregationRenderer;
import de.cismet.cids.annotations.CidsAttribute;
import de.cismet.cids.annotations.CidsAttributeVector;
import de.cismet.cids.custom.deprecated.JBreakLabel;
import de.cismet.cids.custom.deprecated.JLoadDots;
import de.cismet.cids.custom.objectrenderer.utils.PrintingWaitDialog;
import de.cismet.cids.tools.metaobjectrenderer.BlurredMapObjectRenderer;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRViewer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.graphics.ShadowRenderer;

@AggregationRenderer
public class LuftbildschraegaufnahmenRenderer
extends BlurredMapObjectRenderer {
    private static final String ERROR_STR = "/de/cismet/cids/tools/metaobjectrenderer/examples/error.png";
    private static final String TITLE = "Luftbildschr\u00e4gaufnahme";
    private static final String TITLE_AGR = "Luftbildschr\u00e4gaufnahmen";
    @CidsAttribute(value="NAME")
    public String name = "";
    @CidsAttribute(value="BILDNUMMER")
    public String nummer = "";
    @CidsAttribute(value="Strasse/Lage")
    public String lage = "";
    @CidsAttribute(value="Hinweise")
    public String hinweise = "";
    @CidsAttribute(value="Aufnahmedatum")
    public Timestamp aufnahme = null;
    @CidsAttribute(value="Erfassungsdatum")
    public Timestamp erfassung = null;
    @CidsAttribute(value="Datum der Aktualisierung")
    public Timestamp aktualisierung = null;
    @CidsAttribute(value="Auftraggeber")
    public String auftraggeber = "";
    @CidsAttribute(value="Fotograf")
    public String fotograf = "";
    @CidsAttribute(value="Filmart")
    public String filmart = "";
    @CidsAttribute(value="Bild im Original vorr\u00e4tig")
    public String bildOriginal = "";
    @CidsAttribute(value="Dateiname")
    public String dateiname = "";
    @CidsAttribute(value="Organisationskennzeichen")
    public String orgaKennzeichen = "";
    public URL link = null;
    @CidsAttribute(value="Georeferenz.GEO_STRING")
    public Geometry geometry = null;
    @CidsAttributeVector(value="Strasse/Lage")
    public Vector<String> agrLage = new Vector();
    @CidsAttributeVector(value="Hinweise")
    public Vector<String> agrHinweis = new Vector();
    @CidsAttributeVector(value="Dateiname")
    public Vector<String> agrDatei = new Vector();
    @CidsAttributeVector(value="BILDNUMMER")
    public Vector<String> agrNummer = new Vector();
    @CidsAttributeVector(value="Georeferenz.GEO_STRING")
    public Vector<Geometry> geoAgr = new Vector();
    PrintingWaitDialog printingWaitDialog = new PrintingWaitDialog((Frame)ComponentRegistry.getRegistry().getMainWindow(), true);
    Properties properties = new Properties();
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ImageIcon error = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/error.png"));
    private Geometry allGeom;
    private JXHyperlink[] jxhImages;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JXHyperlink jxhAgrPrint;
    private JXHyperlink jxhPicture;
    private JXHyperlink jxhPrint;
    private JLabel lblAgrTitle;
    private JLabel lblAktdat;
    private JLabel lblAufnahmedat;
    private JLabel lblAuftraggeber;
    private JLabel lblBildOrig;
    private JLabel lblDateiname;
    private JLabel lblErfassungsdat;
    private JLabel lblFilmart;
    private JLabel lblFotograf;
    private JLabel lblHinweise;
    private JLabel lblLage;
    private JLabel lblLink;
    private JLabel lblOrganisation;
    private JLabel lblTitle;
    private JPanel panAggregation;
    private JPanel panAgrContent;
    private JPanel panAgrTitle;
    private JPanel panContent;
    private JPanel panInter;
    private JPanel panMap;
    private JPanel panPicture;
    private JPanel panSpinner;
    private JPanel panTitle;

    public LuftbildschraegaufnahmenRenderer() {
        this.initComponents();
        this.setPanContent(this.panContent);
        this.setPanInter(null);
        this.setPanMap(this.panMap);
        this.setPanTitle(this.panTitle);
        this.setSpinner(this.panSpinner);
        this.extraAggregationRendererComponent = this.panAggregation;
        try {
            this.properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/renderer.properties"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Fehler beim Laden der Properties", (Throwable)e);
        }
        this.allGeom = null;
    }

    public void assignAggregation() {
        if (this.agrDatei.size() % 3 == 0) {
            ((GridLayout)this.panAgrContent.getLayout()).setRows(this.agrDatei.size() / 3);
        } else if (this.agrDatei.size() % 3 == 1) {
            ((GridLayout)this.panAgrContent.getLayout()).setRows((this.agrDatei.size() + 2) / 3);
        } else {
            ((GridLayout)this.panAgrContent.getLayout()).setRows((this.agrDatei.size() + 1) / 3);
        }
        this.lblAgrTitle.setText(this.agrDatei.size() + " " + TITLE_AGR);
        this.jxhImages = new JXHyperlink[this.agrDatei.size()];
        int i = 0;
        while (i < this.agrDatei.size()) {
            if (this.allGeom != null && this.geoAgr.get(i) != null) {
                this.allGeom = this.allGeom.union(this.geoAgr.get(i));
            } else if (this.allGeom == null && this.geoAgr.get(i) != null) {
                this.allGeom = this.geoAgr.get(i);
            }
            RoundedPanel rnd = new RoundedPanel();
            rnd.setLayout((LayoutManager)new BorderLayout());
            JLabel lblAgrLage = new JLabel(this.agrLage.get(i));
            lblAgrLage.setFont(new Font("Tahoma", 1, 11));
            JBreakLabel lblAgrHinweis = new JBreakLabel(this.agrHinweis.get(i), 50, true);
            JPanel panLabels = new JPanel(new BorderLayout());
            panLabels.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panLabels.setOpaque(false);
            JPanel panArr = new JPanel(new FlowLayout(1));
            panArr.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panArr.setOpaque(false);
            this.jxhImages[i] = new JXHyperlink();
            this.jxhImages[i].setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/load.png")));
            this.jxhImages[i].setFocusPainted(false);
            panArr.add((Component)this.jxhImages[i]);
            panLabels.add((Component)lblAgrLage, "North");
            panLabels.add((Component)lblAgrHinweis, "Center");
            rnd.add((Component)panLabels, (Object)"North");
            rnd.add((Component)panArr, (Object)"South");
            this.panAgrContent.add((Component)rnd);
            final int index = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImageIcon ii;
                        String url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicesmall");
                        if (url == null) {
                            LuftbildschraegaufnahmenRenderer.this.log.fatal((Object)("Aggregation Wupp " + EventQueue.isDispatchThread()));
                            ii = new ImageIcon(new URL("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.agrNummer.get(index) + "&scale=0.075&format=JPG"));
                        } else {
                            LuftbildschraegaufnahmenRenderer.this.log.fatal((Object)("Aggregation Kif " + EventQueue.isDispatchThread()));
                            String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.agrNummer.get(index));
                            ii = new ImageIcon(new URL(newUrl));
                        }
                        if (ii == null) {
                            throw new Exception("Luftbildaufnahme konnte nicht geladen werden.");
                        }
                        ShadowRenderer renderer = new ShadowRenderer(LuftbildschraegaufnahmenRenderer.this.shadowLength, LuftbildschraegaufnahmenRenderer.this.shadowIntensity, LuftbildschraegaufnahmenRenderer.this.shadowColor);
                        BufferedImage temp = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 6);
                        Graphics2D tg = temp.createGraphics();
                        tg.drawImage(ii.getImage(), 0, 0, null);
                        tg.dispose();
                        BufferedImage shadow = renderer.createShadow(temp);
                        BufferedImage result = new BufferedImage(ii.getIconWidth() + 6, ii.getIconHeight() + 6, 2);
                        Graphics2D rg = result.createGraphics();
                        rg.drawImage((Image)shadow, 0, 0, null);
                        rg.drawImage((Image)temp, 0, 0, null);
                        rg.setColor(new Color(0, 0, 0, 120));
                        rg.drawRect(0, 0, ii.getIconWidth(), ii.getIconHeight());
                        rg.dispose();
                        shadow.flush();
                        BufferedImage resGray = null;
                        ColorSpace cs = ColorSpace.getInstance(1003);
                        ColorConvertOp op = new ColorConvertOp(cs, null);
                        resGray = op.filter(result, null);
                        final ImageIcon icon_orig = new ImageIcon(result);
                        final ImageIcon icon_gray = new ImageIcon(resGray);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.jxhImages[index].setIcon((Icon)icon_orig);
                                LuftbildschraegaufnahmenRenderer.this.jxhImages[index].setRolloverEnabled(true);
                                LuftbildschraegaufnahmenRenderer.this.jxhImages[index].setRolloverIcon((Icon)icon_gray);
                                LuftbildschraegaufnahmenRenderer.this.jxhImages[index].addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        String url = "";
                                        try {
                                            url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicefull");
                                            if (url == null) {
                                                BrowserLauncher.openURL((String)("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.agrNummer.get(index) + "&scale=1&format=JPG"));
                                            } else {
                                                String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.agrNummer.get(index));
                                                BrowserLauncher.openURL((String)newUrl);
                                            }
                                        }
                                        catch (Exception ex) {
                                            LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Fehler beim OEffnen der URL \"" + url + "\""), (Throwable)ex);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Konnte Bild aus URL \"http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.agrNummer.get(index) + "&scale=0.15&format=JPG\" nicht erzeugen."));
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.jxhImages[index].setIcon((Icon)LuftbildschraegaufnahmenRenderer.this.error);
                            }
                        });
                    }
                }
            });
            t.start();
        }
        ((BlurredMapObjectRenderer)this.panAggregation).setGeometry(this.allGeom);
    }

    public void assignSingle() {
        if (!this.name.equals("")) {
            this.lblTitle.setText("Luftbildschr\u00e4gaufnahme - " + this.name);
        } else {
            this.lblTitle.setText(TITLE);
        }
        if (!this.lage.equals("")) {
            this.lblLage.setText(this.lage);
        } else {
            this.lblLage.setVisible(false);
            this.jLabel1.setVisible(false);
        }
        if (!this.hinweise.equals("")) {
            this.lblHinweise.setText(this.hinweise.trim());
        } else {
            this.lblHinweise.setVisible(false);
            this.jLabel2.setVisible(false);
        }
        if (this.aufnahme != null) {
            this.lblAufnahmedat.setText(DateFormat.getDateInstance(3, Locale.GERMANY).format(this.aufnahme));
        } else {
            this.lblAufnahmedat.setVisible(false);
            this.jLabel3.setVisible(false);
        }
        if (this.erfassung != null) {
            this.lblErfassungsdat.setText(DateFormat.getDateInstance(3, Locale.GERMANY).format(this.erfassung));
        } else {
            this.lblErfassungsdat.setVisible(false);
            this.jLabel4.setVisible(false);
        }
        if (this.aktualisierung != null) {
            this.lblAktdat.setText(DateFormat.getDateInstance(3, Locale.GERMANY).format(this.aktualisierung));
        } else {
            this.lblAktdat.setVisible(false);
            this.jLabel5.setVisible(false);
        }
        if (!this.auftraggeber.equals("")) {
            this.lblAuftraggeber.setText(this.auftraggeber);
        } else {
            this.lblAuftraggeber.setVisible(false);
            this.jLabel6.setVisible(false);
        }
        if (!this.fotograf.equals("")) {
            this.lblFotograf.setText(this.fotograf);
        } else {
            this.lblFotograf.setVisible(false);
            this.jLabel7.setVisible(false);
        }
        if (!this.filmart.equals("")) {
            this.lblFilmart.setText(this.filmart);
        } else {
            this.lblFilmart.setVisible(false);
            this.jLabel8.setVisible(false);
        }
        if (!this.bildOriginal.equals("")) {
            if (this.bildOriginal.equals("1")) {
                this.lblBildOrig.setText("ja");
            } else {
                this.lblBildOrig.setText("nein");
            }
        } else {
            this.lblBildOrig.setVisible(false);
            this.jLabel9.setVisible(false);
        }
        if (!this.dateiname.equals("")) {
            this.lblDateiname.setText(this.dateiname);
        } else {
            this.lblDateiname.setVisible(false);
            this.jLabel10.setVisible(false);
        }
        if (!this.orgaKennzeichen.equals("")) {
            this.lblOrganisation.setText(this.orgaKennzeichen);
        } else {
            this.lblOrganisation.setVisible(false);
            this.jLabel11.setVisible(false);
        }
        if (this.link != null) {
            this.lblLink.setText(this.link.toString());
        } else {
            this.lblLink.setVisible(false);
            this.jLabel12.setVisible(false);
        }
        if (this.geometry != null) {
            super.setGeometry(this.geometry);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageIcon i;
                    String url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicesmall");
                    if (url == null) {
                        LuftbildschraegaufnahmenRenderer.this.log.fatal((Object)("Single Wupp " + EventQueue.isDispatchThread()));
                        i = new ImageIcon(new URL("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=0.075&format=JPG"));
                    } else {
                        LuftbildschraegaufnahmenRenderer.this.log.fatal((Object)("Single Kif " + EventQueue.isDispatchThread()));
                        String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.nummer);
                        i = new ImageIcon(new URL(newUrl));
                    }
                    if (i == null) {
                        throw new Exception("Luftbildaufnahme konnte nicht geladen werden.");
                    }
                    ShadowRenderer renderer = new ShadowRenderer(3, 0.5f, Color.BLACK);
                    BufferedImage temp = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 6);
                    Graphics2D tg = temp.createGraphics();
                    tg.drawImage(i.getImage(), 0, 0, null);
                    tg.dispose();
                    BufferedImage shadow = renderer.createShadow(temp);
                    BufferedImage result = new BufferedImage(i.getIconWidth() + 6, i.getIconHeight() + 6, 6);
                    Graphics2D rg = result.createGraphics();
                    rg.drawImage((Image)shadow, 0, 0, null);
                    rg.drawImage((Image)temp, 0, 0, null);
                    rg.setColor(new Color(0, 0, 0, 120));
                    rg.drawRect(0, 0, i.getIconWidth(), i.getIconHeight());
                    rg.dispose();
                    shadow.flush();
                    final ImageIcon icon = new ImageIcon(result);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenRenderer.this.jxhPicture.setIcon((Icon)icon);
                            LuftbildschraegaufnahmenRenderer.this.jxhPicture.setToolTipText("Klicken, um Bild im Browser zu ?ffnen");
                            LuftbildschraegaufnahmenRenderer.this.jxhPicture.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String url = "";
                                    try {
                                        url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicefull");
                                        if (url == null) {
                                            BrowserLauncher.openURL((String)("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=1&format=JPG"));
                                        } else {
                                            String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.nummer);
                                            BrowserLauncher.openURL((String)newUrl);
                                        }
                                    }
                                    catch (Exception ex) {
                                        LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Fehler beim ?ffnen der URL \"" + url + "\""), (Throwable)ex);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Konnte Bild aus URL \"http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=0.15&format=JPG\" nicht erzeugen."));
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenRenderer.this.jxhPicture.setIcon((Icon)LuftbildschraegaufnahmenRenderer.this.error);
                        }
                    });
                }
            }
        });
        t.start();
    }

    public double getWidthRatio() {
        return 1.0;
    }

    private void initComponents() {
        this.panAggregation = new BlurredMapObjectRenderer();
        this.panAgrTitle = new JPanel();
        this.jxhAgrPrint = new JXHyperlink();
        this.lblAgrTitle = new JLabel();
        this.panAgrContent = new JPanel();
        this.panTitle = new JPanel();
        this.jxhPrint = new JXHyperlink();
        this.lblTitle = new JLabel();
        this.panInter = new JPanel();
        this.panMap = new JPanel();
        this.panSpinner = new JLoadDots();
        this.panContent = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblLage = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblHinweise = new JBreakLabel(50, true);
        this.jLabel3 = new JLabel();
        this.lblAufnahmedat = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblErfassungsdat = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblAktdat = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblAuftraggeber = new JLabel();
        this.jLabel7 = new JLabel();
        this.lblFotograf = new JLabel();
        this.jLabel8 = new JLabel();
        this.lblFilmart = new JLabel();
        this.jLabel9 = new JLabel();
        this.lblBildOrig = new JLabel();
        this.jLabel10 = new JLabel();
        this.lblDateiname = new JLabel();
        this.jLabel11 = new JLabel();
        this.lblOrganisation = new JLabel();
        this.jLabel12 = new JLabel();
        this.lblLink = new JLabel();
        this.panPicture = new JPanel();
        this.jxhPicture = new JXHyperlink();
        this.panAggregation.setLayout(new BorderLayout());
        this.panAgrTitle.setOpaque(false);
        this.jxhAgrPrint.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/printer.png")));
        this.jxhAgrPrint.setFocusPainted(false);
        this.jxhAgrPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuftbildschraegaufnahmenRenderer.this.AgrPrintActionPerformed(evt);
            }
        });
        this.lblAgrTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblAgrTitle.setText("2 Luftbildaufnahmen");
        GroupLayout panAgrTitleLayout = new GroupLayout(this.panAgrTitle);
        this.panAgrTitle.setLayout(panAgrTitleLayout);
        panAgrTitleLayout.setHorizontalGroup(panAgrTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panAgrTitleLayout.createSequentialGroup().addContainerGap().addComponent(this.lblAgrTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE).addComponent((Component)this.jxhAgrPrint, -2, -1, -2).addContainerGap()));
        panAgrTitleLayout.setVerticalGroup(panAgrTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panAgrTitleLayout.createSequentialGroup().addContainerGap().addGroup(panAgrTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAgrTitle).addComponent((Component)this.jxhAgrPrint, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.panAggregation.add((Component)this.panAgrTitle, "North");
        this.panAgrContent.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
        this.panAgrContent.setOpaque(false);
        this.panAgrContent.setLayout(new GridLayout(1, 2, 10, 10));
        this.panAggregation.add((Component)this.panAgrContent, "Center");
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panTitle.setOpaque(false);
        this.jxhPrint.setForeground(new Color(255, 255, 255));
        this.jxhPrint.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/printer.png")));
        this.jxhPrint.setText("");
        this.jxhPrint.setToolTipText("Drucken");
        this.jxhPrint.setClickedColor(new Color(204, 204, 204));
        this.jxhPrint.setFocusPainted(false);
        this.jxhPrint.setHorizontalTextPosition(2);
        this.jxhPrint.setUnclickedColor(new Color(255, 255, 255));
        this.jxhPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuftbildschraegaufnahmenRenderer.this.printActionPerformed(evt);
            }
        });
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText("Luftbildschr\u00e4gaufnahme - 571203");
        GroupLayout panTitleLayout = new GroupLayout(this.panTitle);
        this.panTitle.setLayout(panTitleLayout);
        panTitleLayout.setHorizontalGroup(panTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panTitleLayout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 252, Short.MAX_VALUE).addComponent((Component)this.jxhPrint, -2, -1, -2).addContainerGap()));
        panTitleLayout.setVerticalGroup(panTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panTitleLayout.createSequentialGroup().addContainerGap().addGroup(panTitleLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.jxhPrint, -2, -1, -2).addComponent(this.lblTitle)).addContainerGap(13, Short.MAX_VALUE)));
        this.add(this.panTitle, "North");
        this.panInter.setOpaque(false);
        GroupLayout panInterLayout = new GroupLayout(this.panInter);
        this.panInter.setLayout(panInterLayout);
        panInterLayout.setHorizontalGroup(panInterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE));
        panInterLayout.setVerticalGroup(panInterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 14, Short.MAX_VALUE));
        this.add(this.panInter, "South");
        this.panMap.setOpaque(false);
        this.panMap.setLayout(new GridBagLayout());
        this.panSpinner.setMaximumSize(new Dimension(100, 100));
        this.panSpinner.setMinimumSize(new Dimension(100, 100));
        this.panSpinner.setOpaque(false);
        GroupLayout panSpinnerLayout = new GroupLayout(this.panSpinner);
        this.panSpinner.setLayout(panSpinnerLayout);
        panSpinnerLayout.setHorizontalGroup(panSpinnerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        panSpinnerLayout.setVerticalGroup(panSpinnerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.panMap.add((Component)this.panSpinner, new GridBagConstraints());
        this.add(this.panMap, "Center");
        this.panContent.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 20));
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Strasse / Lage:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel1, gridBagConstraints);
        this.lblLage.setText("Am Schaffstal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblLage, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Hinweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel2, gridBagConstraints);
        this.lblHinweise.setText("Baustelle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblHinweise, gridBagConstraints);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Aufnahmedatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel3, gridBagConstraints);
        this.lblAufnahmedat.setText("2004-08-02");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblAufnahmedat, gridBagConstraints);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Erfassungsdatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel4, gridBagConstraints);
        this.lblErfassungsdat.setText("2004-08-30");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblErfassungsdat, gridBagConstraints);
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Aktualisierungsdatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel5, gridBagConstraints);
        this.lblAktdat.setText("2005-03-11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblAktdat, gridBagConstraints);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Auftraggeber:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel6, gridBagConstraints);
        this.lblAuftraggeber.setText("Sadowski");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblAuftraggeber, gridBagConstraints);
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Fotograf:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel7, gridBagConstraints);
        this.lblFotograf.setText("Meiswinkel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblFotograf, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("Filmart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel8, gridBagConstraints);
        this.lblFilmart.setText("4,5x6 Color-Neg");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblFilmart, gridBagConstraints);
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Bild im Original vorr\u00e4tig:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel9, gridBagConstraints);
        this.lblBildOrig.setText("ja");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblBildOrig, gridBagConstraints);
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Dateiname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel10, gridBagConstraints);
        this.lblDateiname.setText("571283.tiff");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblDateiname, gridBagConstraints);
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setText("Organisationskennzeichen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel11, gridBagConstraints);
        this.lblOrganisation.setText("105 25");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblOrganisation, gridBagConstraints);
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setText("Link:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.panContent.add((Component)this.jLabel12, gridBagConstraints);
        this.lblLink.setText("http://s10220:8098/luft/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblLink, gridBagConstraints);
        this.panPicture.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        this.panPicture.setOpaque(false);
        this.panPicture.setLayout(new BorderLayout());
        this.jxhPicture.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/load.png")));
        this.jxhPicture.setFocusPainted(false);
        this.panPicture.add((Component)this.jxhPicture, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.anchor = 15;
        this.panContent.add((Component)this.panPicture, gridBagConstraints);
        this.add(this.panContent, "West");
    }

    private void AgrPrintActionPerformed(ActionEvent evt) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StaticSwingTools.showDialog((JDialog)LuftbildschraegaufnahmenRenderer.this.printingWaitDialog);
                        }
                    });
                    String url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicefull");
                    JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)this.getClass().getResourceAsStream("/de/cismet/cids/objectrenderer/LuftbildschraegaufnahmenA4H.jasper"));
                    JasperPrint jasperPrint = null;
                    try {
                        for (int j = 0; j < LuftbildschraegaufnahmenRenderer.this.agrNummer.size(); ++j) {
                            int h;
                            ImageIcon i;
                            if (url == null) {
                                i = new ImageIcon(new URL("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=1&format=JPG"));
                            } else {
                                String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.agrNummer.get(j));
                                if (LuftbildschraegaufnahmenRenderer.this.log.isDebugEnabled()) {
                                    LuftbildschraegaufnahmenRenderer.this.log.debug((Object)("Url der LSA:" + newUrl));
                                }
                                i = new ImageIcon(new URL(newUrl));
                            }
                            if (i == null) {
                                throw new Exception("Luftbildaufnahme konnte nicht geladen werden.");
                            }
                            ImageIcon icon = i;
                            int w = icon.getIconWidth();
                            if (w > (h = icon.getIconHeight())) {
                                try {
                                    BufferedImage src = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
                                    int iSizeDiff = src.getWidth() - src.getHeight();
                                    Graphics2D o2d = src.createGraphics();
                                    o2d.drawImage(icon.getImage(), 0, 0, null);
                                    o2d.dispose();
                                    AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(90.0), src.getWidth() / 2, src.getHeight() / 2);
                                    BufferedImage rotatedImage = new BufferedImage(src.getHeight(), src.getWidth(), src.getType());
                                    Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
                                    g.setTransform(affineTransform);
                                    g.drawImage((Image)src, iSizeDiff / 2, iSizeDiff / 2, null);
                                    icon = new ImageIcon(rotatedImage);
                                }
                                catch (Exception ex) {
                                    LuftbildschraegaufnahmenRenderer.this.log.error((Object)"Drehen des Images fehlgeschlagen.", (Throwable)ex);
                                }
                            }
                            if (LuftbildschraegaufnahmenRenderer.this.log.isDebugEnabled()) {
                                LuftbildschraegaufnahmenRenderer.this.log.debug((Object)"LSA hinzugef\u00fcgt");
                            }
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("Ueberschrift", LuftbildschraegaufnahmenRenderer.this.lage + " (" + LuftbildschraegaufnahmenRenderer.TITLE + ")");
                            params.put("Unterschrift", LuftbildschraegaufnahmenRenderer.this.hinweise);
                            params.put("image", icon.getImage());
                            if (LuftbildschraegaufnahmenRenderer.this.log.isDebugEnabled()) {
                                LuftbildschraegaufnahmenRenderer.this.log.debug(params);
                            }
                            if (jasperPrint == null) {
                                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params);
                                continue;
                            }
                            jasperPrint.addPage((JRPrintPage)JasperFillManager.fillReport((JasperReport)jasperReport, params).getPages().get(0));
                        }
                        final JasperPrint jasperPrintCopy = jasperPrint;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                                JRViewer aViewer = new JRViewer(jasperPrintCopy);
                                aViewer.setZoomRatio(0.35f);
                                JFrame aFrame = new JFrame("Druckvorschau");
                                aFrame.getContentPane().add((Component)aViewer);
                                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                                aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                                Insets insets = aFrame.getInsets();
                                aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                                aFrame.setLocation((screenSize.width - aFrame.getWidth()) / 2, (screenSize.height - aFrame.getHeight()) / 2);
                                aFrame.setVisible(true);
                            }
                        });
                    }
                    catch (Throwable e) {
                        LuftbildschraegaufnahmenRenderer.this.log.error((Object)"Fehler beim Jaspern", e);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Fehler beim laden des Bildes mit URL \"http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=1&format=JPG\""), (Throwable)e);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                        }
                    });
                }
            }
        });
        t.start();
    }

    private void printActionPerformed(ActionEvent evt) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int h;
                    ImageIcon i;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StaticSwingTools.showDialog((JDialog)LuftbildschraegaufnahmenRenderer.this.printingWaitDialog);
                        }
                    });
                    String url = LuftbildschraegaufnahmenRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicefull");
                    if (url == null) {
                        i = new ImageIcon(new URL("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=1&format=JPG"));
                    } else {
                        String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenRenderer.this.nummer);
                        i = new ImageIcon(new URL(newUrl));
                    }
                    if (i == null) {
                        throw new Exception("Luftbildaufnahme konnte nicht geladen werden.");
                    }
                    ImageIcon icon = i;
                    int w = icon.getIconWidth();
                    if (w > (h = icon.getIconHeight())) {
                        try {
                            BufferedImage src = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
                            int iSizeDiff = src.getWidth() - src.getHeight();
                            Graphics2D o2d = src.createGraphics();
                            o2d.drawImage(icon.getImage(), 0, 0, null);
                            o2d.dispose();
                            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(90.0), src.getWidth() / 2, src.getHeight() / 2);
                            BufferedImage rotatedImage = new BufferedImage(src.getHeight(), src.getWidth(), src.getType());
                            Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
                            g.setTransform(affineTransform);
                            g.drawImage((Image)src, iSizeDiff / 2, iSizeDiff / 2, null);
                            icon = new ImageIcon(rotatedImage);
                        }
                        catch (Exception ex) {
                            LuftbildschraegaufnahmenRenderer.this.log.error((Object)"Drehen des Images fehlgeschlagen.", (Throwable)ex);
                        }
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("Ueberschrift", LuftbildschraegaufnahmenRenderer.this.lage + " (" + LuftbildschraegaufnahmenRenderer.TITLE + ")");
                    params.put("Unterschrift", LuftbildschraegaufnahmenRenderer.this.hinweise);
                    params.put("image", icon.getImage());
                    try {
                        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)this.getClass().getResourceAsStream("/de/cismet/cids/objectrenderer/LuftbildschraegaufnahmenA4H.jasper"));
                        final JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                                JRViewer aViewer = new JRViewer(jasperPrint);
                                JFrame aFrame = new JFrame("Druckvorschau");
                                aFrame.getContentPane().add((Component)aViewer);
                                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                                aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                                Insets insets = aFrame.getInsets();
                                aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                                aFrame.setLocation((screenSize.width - aFrame.getWidth()) / 2, (screenSize.height - aFrame.getHeight()) / 2);
                                aFrame.setVisible(true);
                            }
                        });
                    }
                    catch (Throwable e) {
                        LuftbildschraegaufnahmenRenderer.this.log.error((Object)"Fehler beim Jaspern", e);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LuftbildschraegaufnahmenRenderer.this.log.error((Object)("Fehler beim laden des Bildes mit URL \"http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenRenderer.this.nummer + "&scale=1&format=JPG\""), (Throwable)e);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenRenderer.this.printingWaitDialog.setVisible(false);
                        }
                    });
                }
            }
        });
        t.start();
    }
}

