/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.wunda_blau.search.server.ObjectsPermissionsSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ObjectsPermissionsProviderPanel
extends JPanel
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(ObjectsPermissionsProviderPanel.class);
    private static final String TABLE_PERMISSIONS = "CS_OBJECTPERMISSIONS";
    private static final String TABLE_COLLECTOR = "CS_OBJECTPERMISSIONS_COLLECTOR";
    private static final String PROPERTY_CLASS_NAME = "_class_name";
    private static final String PROPERTY_OBJECT_NAME = "_object_name";
    private static final String PROPERTY_GROUP_NAME = "group_name";
    private static final String PROPERTY_USER_NAME = "user_name";
    private static final String PROPERTY_CLASS_ID = "class_id";
    private static final String PROPERTY_OBJECT_ID = "object_id";
    private static final String PROPERTY_READ = "read";
    private static final String PROPERTY_WRITE = "write";
    private static final String PROPERTY_TS_START = "ts_start";
    private static final String PROPERTY_TS_END = "ts_end";
    private static final String PROPERTY_ARR_ENTRIES = "arr_entries";
    private final List<String> columnProperties = new ArrayList<String>();
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Class> columnClasses = new ArrayList<Class>();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final Map<Integer, MetaClass> classesMap = new HashMap<Integer, MetaClass>();
    private final Map<String, CidsBean> objectsMap = new HashMap<String, CidsBean>();
    private final Collection<CidsBean> permissionBeansToDelete = new ArrayList<CidsBean>();
    private final Collection<String> groupNames = new ArrayList<String>();
    private final boolean enableClassSelection;
    private final boolean enableEdit;
    private final boolean enableGroupPermission;
    private final boolean enableUserPermission;
    private final boolean enableAllFromClass;
    private final boolean enableReadPermission;
    private final boolean enableWritePermission;
    private final boolean enableTimestamps;
    private final boolean enableAllGroups;
    private JButton btnCreatePermission;
    private JButton btnDeletePermission;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox<MetaClass> cbClasses;
    private JCheckBox chkRead;
    private JCheckBox chkTsEnd;
    private JCheckBox chkTsStart;
    private JCheckBox chkWrite;
    private JXDatePicker dpTsEnd;
    private JXDatePicker dpTsStart;
    private Box.Filler filler1;
    private JComboBox<String> jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblGroupName;
    private JLabel lblUserName;
    private JList<CidsBean> lstObjects;
    private JRadioButton optAllClassObjects;
    private JRadioButton optAllListObjects;
    private JRadioButton optByGroupName;
    private JRadioButton optByUserName;
    private JRadioButton optOnlySelectedObjects;
    private JXTable tblPermissions;
    private JTextField txtGroupName;
    private JTextField txtUserName;
    private BindingGroup bindingGroup;

    public ObjectsPermissionsProviderPanel() {
        this((Option[])null);
    }

    public ObjectsPermissionsProviderPanel(Option ... options) {
        boolean enableAllGroups = true;
        boolean enableEdit = true;
        boolean enableClassSelection = true;
        boolean enableGroupPermission = true;
        boolean enableUserPermission = true;
        boolean enableAllFromClass = true;
        boolean enableReadPermission = true;
        boolean enableWritePermission = true;
        boolean enableTimestamps = true;
        if (options != null) {
            block10: for (Option option : options) {
                switch (option) {
                    case READ_ONLY: {
                        enableEdit = false;
                        continue block10;
                    }
                    case DISABLE_GROUP_PERMISSIONS: {
                        enableGroupPermission = false;
                        continue block10;
                    }
                    case DISABLE_USER_PERMISSIONS: {
                        enableUserPermission = false;
                        continue block10;
                    }
                    case DISABLE_ALL_FROM_CLASS: {
                        enableAllFromClass = false;
                        continue block10;
                    }
                    case DISABLE_READ: {
                        enableReadPermission = false;
                        continue block10;
                    }
                    case DISABLE_WRITE: {
                        enableWritePermission = false;
                        continue block10;
                    }
                    case DISABLE_CLASS_SELECTION: {
                        enableClassSelection = false;
                        continue block10;
                    }
                    case ONLY_CONFATTR_GROUPS: {
                        enableAllGroups = false;
                    }
                }
            }
        }
        this.enableEdit = enableEdit;
        this.enableGroupPermission = enableGroupPermission;
        this.enableUserPermission = enableUserPermission;
        this.enableAllFromClass = enableAllFromClass;
        this.enableReadPermission = enableReadPermission;
        this.enableWritePermission = enableWritePermission;
        this.enableTimestamps = true;
        this.enableClassSelection = enableClassSelection;
        if (enableClassSelection) {
            this.columnProperties.add(PROPERTY_CLASS_NAME);
            this.columnNames.add("Klasse");
            this.columnClasses.add(String.class);
        }
        this.columnProperties.add(PROPERTY_OBJECT_NAME);
        this.columnNames.add("Objekt-Bezeichnung");
        this.columnClasses.add(CidsBean.class);
        if (enableGroupPermission) {
            this.columnProperties.add(PROPERTY_GROUP_NAME);
            this.columnNames.add("Gruppe");
            this.columnClasses.add(String.class);
        }
        if (enableUserPermission) {
            this.columnProperties.add(PROPERTY_USER_NAME);
            this.columnNames.add("Benutzer");
            this.columnClasses.add(String.class);
        }
        if (this.enableReadPermission) {
            this.columnProperties.add(PROPERTY_READ);
            this.columnNames.add("Lesen");
            this.columnClasses.add(Boolean.class);
        }
        if (this.enableWritePermission) {
            this.columnProperties.add(PROPERTY_WRITE);
            this.columnNames.add("Schreiben");
            this.columnClasses.add(Boolean.class);
        }
        if (this.enableTimestamps) {
            this.columnProperties.add(PROPERTY_TS_START);
            this.columnNames.add("G\u00fcltig ab");
            this.columnClasses.add(Timestamp.class);
            this.columnProperties.add(PROPERTY_TS_END);
            this.columnNames.add("G\u00fcltig bis");
            this.columnClasses.add(Timestamp.class);
        }
        this.enableAllGroups = enableAllGroups;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel9 = new JPanel();
        this.optOnlySelectedObjects = new JRadioButton();
        this.optAllListObjects = new JRadioButton();
        this.optAllClassObjects = new JRadioButton();
        this.cbClasses = new JComboBox();
        this.jPanel10 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstObjects = new DropAwareJList();
        this.jPanel6 = new JPanel();
        this.lblGroupName = new JLabel();
        this.optByGroupName = new JRadioButton();
        this.lblUserName = new JLabel();
        this.optByUserName = new JRadioButton();
        this.txtGroupName = new JTextField();
        this.jComboBox1 = new JComboBox();
        this.txtUserName = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.jPanel11 = new JPanel();
        this.dpTsStart = new JXDatePicker();
        this.dpTsEnd = new JXDatePicker();
        this.chkTsStart = new JCheckBox();
        this.chkTsEnd = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jPanel5 = new JPanel();
        this.chkRead = new JCheckBox();
        this.chkWrite = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.btnCreatePermission = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPermissions = new JXTable();
        this.btnDeletePermission = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel9.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.optOnlySelectedObjects);
        Mnemonics.setLocalizedText((AbstractButton)this.optOnlySelectedObjects, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.optOnlySelectedObjects.text"));
        this.optOnlySelectedObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.optOnlySelectedObjectsActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.optOnlySelectedObjects, gridBagConstraints);
        this.buttonGroup1.add(this.optAllListObjects);
        this.optAllListObjects.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.optAllListObjects, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.optAllListObjects.text"));
        this.optAllListObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.optAllListObjectsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.optAllListObjects, gridBagConstraints);
        this.buttonGroup1.add(this.optAllClassObjects);
        Mnemonics.setLocalizedText((AbstractButton)this.optAllClassObjects, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.optAllClassObjects.text"));
        this.optAllClassObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.optAllClassObjectsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.optAllClassObjects, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.optAllClassObjects, (Property)ELProperty.create((String)"${selected}"), this.cbClasses, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbClasses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.cbClassesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add(this.cbClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(200, 100));
        this.jScrollPane3.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane3.setRequestFocusEnabled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.optOnlySelectedObjects, (Property)ELProperty.create((String)"${selected}"), this.lstObjects, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.lstObjects.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ObjectsPermissionsProviderPanel.this.lstObjectsValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.jPanel6.border.title")));
        this.jPanel6.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblGroupName, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.lblGroupName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.lblGroupName, gridBagConstraints);
        this.buttonGroup2.add(this.optByGroupName);
        this.optByGroupName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.optByGroupName, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.optByGroupName.text"));
        this.optByGroupName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.optByGroupNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.optByGroupName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblUserName, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.lblUserName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.lblUserName, gridBagConstraints);
        this.buttonGroup2.add(this.optByUserName);
        Mnemonics.setLocalizedText((AbstractButton)this.optByUserName, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.optByUserName.text"));
        this.optByUserName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.optByUserNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.optByUserName, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.optByGroupName, (Property)ELProperty.create((String)"${selected}"), (Object)this.txtGroupName, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtGroupName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObjectsPermissionsProviderPanel.this.txtGroupNamePropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.txtGroupName, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.groupNames.toArray(new String[0])));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add(this.jComboBox1, gridBagConstraints);
        this.txtUserName.setText(NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.txtUserName.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.optByUserName, (Property)ELProperty.create((String)"${selected}"), (Object)this.txtUserName, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtUserName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObjectsPermissionsProviderPanel.this.txtUserNamePropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.txtUserName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkTsStart, (Property)ELProperty.create((String)"${selected}"), (Object)this.dpTsStart, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.dpTsStart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkTsEnd, (Property)ELProperty.create((String)"${selected}"), (Object)this.dpTsEnd, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.dpTsEnd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkTsStart, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.chkTsStart.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.chkTsStart, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkTsEnd, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.chkTsEnd.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.chkTsEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jPanel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkRead, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.chkRead.text"));
        this.chkRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.chkReadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 12);
        this.jPanel5.add((Component)this.chkRead, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWrite, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.chkWrite.text"));
        this.chkWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.chkWriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 12);
        this.jPanel5.add((Component)this.chkWrite, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreatePermission, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.btnCreatePermission.text"));
        this.btnCreatePermission.setEnabled(false);
        this.btnCreatePermission.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.btnCreatePermissionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.btnCreatePermission, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.jPanel3.border.title")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.tblPermissions.setModel((TableModel)new ObjectsPermissionsTableModel());
        this.tblPermissions.setEditable(false);
        this.jScrollPane1.setViewportView((Component)this.tblPermissions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeletePermission, (String)NbBundle.getMessage(ObjectsPermissionsProviderPanel.class, (String)"ObjectsPermissionsProviderPanel.btnDeletePermission.text"));
        this.btnDeletePermission.setEnabled(false);
        this.btnDeletePermission.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectsPermissionsProviderPanel.this.btnDeletePermissionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.btnDeletePermission, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public void setGroupConfAttr(String confAttr) {
        this.groupNames.clear();
        try {
            String groupsString = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), confAttr, this.getConnectionContext());
            if (groupsString != null) {
                for (String groupString : groupsString.split("\n")) {
                    this.groupNames.add(groupString.trim());
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private Collection<CidsBean> getPermissionBeansToDelete() {
        return this.permissionBeansToDelete;
    }

    public void persistPermissions() {
        boolean bl;
        Collection<CidsBean> permissionBeans;
        ArrayList<CidsBean> allPermissionBeansToPersist = new ArrayList<CidsBean>();
        allPermissionBeansToPersist.addAll(this.getPermissionsTableModel().getCidsBeans());
        allPermissionBeansToPersist.addAll(this.getPermissionBeansToDelete());
        HashMap permissionBeansPerDomain = new HashMap();
        for (CidsBean cidsBean : allPermissionBeansToPersist) {
            MetaObject permissionMo;
            if (cidsBean == null || 0 == cidsBean.getMetaObject().getStatus() || (permissionMo = cidsBean.getMetaObject()) == null) continue;
            String domain = permissionMo.getDomain();
            if (permissionBeansPerDomain.containsKey(domain)) {
                permissionBeans = (Collection)permissionBeansPerDomain.get(domain);
            } else {
                permissionBeans = new ArrayList();
                permissionBeansPerDomain.put(domain, permissionBeans);
            }
            permissionBeans.add(cidsBean);
        }
        ArrayList<CidsBean> collectorBeans = new ArrayList<CidsBean>(permissionBeansPerDomain.size());
        for (String domain : permissionBeansPerDomain.keySet()) {
            try {
                CidsBean collectorBean = CidsBean.createNewCidsBeanFromTableName((String)domain, (String)TABLE_COLLECTOR, (ConnectionContext)this.getConnectionContext());
                permissionBeans = (Collection)permissionBeansPerDomain.get(domain);
                if (permissionBeans == null) continue;
                collectorBean.getBeanCollectionProperty(PROPERTY_ARR_ENTRIES).addAll(permissionBeans);
                collectorBeans.add(collectorBean);
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                break;
            }
        }
        boolean bl2 = bl = collectorBeans.size() == permissionBeansPerDomain.size();
        if (bl) {
            for (CidsBean collectorBean : collectorBeans) {
                try {
                    collectorBean.persist(this.getConnectionContext());
                }
                catch (Exception ex) {
                    this.error("error while persisting collector", ex);
                }
                try {
                    collectorBean.delete();
                }
                catch (Exception ex) {
                    this.error("error while deleting collector", ex);
                }
            }
        }
    }

    private void btnDeletePermissionActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> collectedBeans = new ArrayList<CidsBean>();
        for (int row : this.tblPermissions.getSelectedRows()) {
            CidsBean selectedPermissionBean = this.getPermissionsTableModel().getCidsBean(this.tblPermissions.getRowSorter().convertRowIndexToModel(row));
            if (selectedPermissionBean == null) continue;
            collectedBeans.add(selectedPermissionBean);
        }
        this.permissionBeansToDelete.addAll(collectedBeans);
        Object object = collectedBeans.iterator();
        while (object.hasNext()) {
            CidsBean collectedBean = (CidsBean)object.next();
            MetaObject permissionMo = collectedBean.getMetaObject();
            if (permissionMo == null) continue;
            permissionMo.setStatus(3);
            permissionMo.setChanged(true);
            this.getPermissionsTableModel().remove(collectedBean);
        }
    }

    private void btnCreatePermissionActionPerformed(ActionEvent evt) {
        block13: {
            MetaClass selectedMetaClass;
            block12: {
                if (!this.optOnlySelectedObjects.isSelected() && !this.optAllListObjects.isSelected()) break block12;
                ArrayList<CidsBean> allSelectedObjectBeans = new ArrayList<CidsBean>();
                if (this.optOnlySelectedObjects.isSelected()) {
                    allSelectedObjectBeans.addAll(this.lstObjects.getSelectedValuesList());
                } else if (this.optAllListObjects.isSelected()) {
                    allSelectedObjectBeans.addAll(this.objectsMap.values());
                }
                HashMap objectBeansPerDomain = new HashMap();
                for (CidsBean objectBean : allSelectedObjectBeans) {
                    Collection<CidsBean> objectBeans;
                    MetaObject objectMo;
                    if (objectBean == null || (objectMo = objectBean.getMetaObject()) == null) continue;
                    String domain = objectMo.getDomain();
                    if (objectBeansPerDomain.containsKey(domain)) {
                        objectBeans = (Collection)objectBeansPerDomain.get(domain);
                    } else {
                        objectBeans = new ArrayList();
                        objectBeansPerDomain.put(domain, objectBeans);
                    }
                    objectBeans.add(objectBean);
                }
                for (String domain : objectBeansPerDomain.keySet()) {
                    if (domain == null) continue;
                    Collection objectBeans = (Collection)objectBeansPerDomain.get(domain);
                    for (CidsBean objectBean : objectBeans) {
                        MetaObject objectMo;
                        if (objectBean == null || (objectMo = objectBean.getMetaObject()) == null) continue;
                        try {
                            CidsBean permissionBean = this.createPermissionBean(domain, objectMo.getClassID(), objectMo.getID());
                            this.getPermissionsTableModel().add(permissionBean);
                        }
                        catch (Exception ex) {
                            this.error("error while creating permission bean", ex);
                        }
                    }
                }
                break block13;
            }
            if (!this.optAllClassObjects.isSelected() || (selectedMetaClass = (MetaClass)this.cbClasses.getSelectedItem()) == null) break block13;
            try {
                String domain = selectedMetaClass.getDomain();
                CidsBean permissionBean = this.createPermissionBean(domain, selectedMetaClass.getID(), null);
                this.getPermissionsTableModel().add(permissionBean);
            }
            catch (Exception ex) {
                this.error("error while creating permission bean", ex);
            }
        }
    }

    private CidsBean createPermissionBean(String domain, Integer classId, Integer objectId) throws Exception {
        CidsBean permissionBean = CidsBean.createNewCidsBeanFromTableName((String)domain, (String)TABLE_PERMISSIONS, (ConnectionContext)this.getConnectionContext());
        permissionBean.setProperty(PROPERTY_OBJECT_ID, (Object)objectId);
        permissionBean.setProperty(PROPERTY_CLASS_ID, (Object)classId);
        permissionBean.setProperty(PROPERTY_GROUP_NAME, this.optByGroupName.isSelected() ? (this.enableAllGroups ? this.txtGroupName.getText() : this.jComboBox1.getSelectedItem()) : null);
        permissionBean.setProperty(PROPERTY_USER_NAME, this.optByUserName.isSelected() ? this.txtUserName.getText() : null);
        permissionBean.setProperty(PROPERTY_READ, (Object)this.chkRead.isSelected());
        permissionBean.setProperty(PROPERTY_WRITE, (Object)this.chkWrite.isSelected());
        permissionBean.setProperty(PROPERTY_TS_START, this.chkTsStart.isSelected() && this.dpTsStart.getDate() != null ? new Timestamp(this.dpTsStart.getDate().getTime()) : null);
        permissionBean.setProperty(PROPERTY_TS_END, this.chkTsEnd.isSelected() && this.dpTsEnd.getDate() != null ? new Timestamp(this.dpTsEnd.getDate().getTime()) : null);
        return permissionBean;
    }

    private void optOnlySelectedObjectsActionPerformed(ActionEvent evt) {
        this.cbClasses.setSelectedItem(null);
        this.refreshAddButton();
    }

    private void optAllClassObjectsActionPerformed(ActionEvent evt) {
        this.lstObjects.setSelectedIndices(new int[0]);
        this.cbClasses.setSelectedIndex(0);
        this.refreshAddButton();
    }

    private void chkReadActionPerformed(ActionEvent evt) {
        this.refreshAddButton();
    }

    private void chkWriteActionPerformed(ActionEvent evt) {
        this.refreshAddButton();
    }

    private void lstObjectsValueChanged(ListSelectionEvent evt) {
        this.refreshAddButton();
    }

    private void optByGroupNameActionPerformed(ActionEvent evt) {
        this.txtUserName.setText(null);
        this.refreshAddButton();
    }

    private void optByUserNameActionPerformed(ActionEvent evt) {
        this.txtGroupName.setText(null);
        this.refreshAddButton();
    }

    private void txtGroupNamePropertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName())) {
            this.refreshAddButton();
        }
    }

    private void txtUserNamePropertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName())) {
            this.refreshAddButton();
        }
    }

    private void cbClassesActionPerformed(ActionEvent evt) {
        this.refreshAddButton();
    }

    private void optAllListObjectsActionPerformed(ActionEvent evt) {
        this.cbClasses.setSelectedItem(null);
        this.refreshAddButton();
    }

    private void refreshAddButton() {
        boolean objectsSelected;
        boolean bl = objectsSelected = this.optOnlySelectedObjects.isSelected() && !this.lstObjects.getSelectedValuesList().isEmpty() || this.enableAllFromClass && this.optAllClassObjects.isSelected() && this.cbClasses.getSelectedItem() != null || this.optAllListObjects.isSelected() && this.lstObjects.getModel().getSize() > 0;
        boolean groupSelected = this.enableGroupPermission && this.optByGroupName.isSelected() && this.enableAllGroups ? this.txtGroupName.getText() != null && !this.txtGroupName.getText().trim().isEmpty() : this.jComboBox1.getSelectedItem() != null;
        boolean userSelected = this.enableUserPermission && this.optByUserName.isSelected() && this.txtUserName.getText() != null && !this.txtUserName.getText().trim().isEmpty();
        boolean targetSelected = groupSelected || userSelected;
        boolean permissionTypeSelected = this.enableReadPermission && this.chkRead.isSelected() || this.enableWritePermission && this.chkWrite.isSelected();
        this.btnCreatePermission.setEnabled(objectsSelected && targetSelected && permissionTypeSelected);
    }

    private ObjectsPermissionsTableModel getPermissionsTableModel() {
        return (ObjectsPermissionsTableModel)this.tblPermissions.getModel();
    }

    private void error(String message, Exception ex) {
        LOG.fatal((Object)message, (Throwable)ex);
    }

    public boolean isEnableEdit() {
        return this.enableEdit;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        new CidsBeanDropTarget((Component)((DropAwareJList)this.lstObjects));
        this.optAllClassObjects.setVisible(this.enableAllFromClass);
        this.cbClasses.setVisible(this.enableAllFromClass);
        this.lblGroupName.setVisible(this.enableGroupPermission);
        this.optByGroupName.setVisible(this.enableGroupPermission);
        this.txtGroupName.setVisible(this.enableGroupPermission && this.enableAllGroups);
        this.jComboBox1.setVisible(this.enableGroupPermission && !this.enableAllGroups);
        this.lblUserName.setVisible(this.enableUserPermission);
        this.optByUserName.setVisible(this.enableUserPermission);
        this.txtUserName.setVisible(this.enableUserPermission);
        this.chkRead.setVisible(this.enableReadPermission);
        this.chkRead.setEnabled(this.enableWritePermission);
        this.chkWrite.setVisible(this.enableWritePermission);
        this.chkWrite.setEnabled(this.enableReadPermission);
        this.jPanel4.setVisible(this.enableEdit);
        this.btnDeletePermission.setVisible(this.enableEdit);
        this.chkWrite.setSelected(!this.enableReadPermission);
        this.chkRead.setSelected(!this.enableWritePermission);
        this.jPanel11.setVisible(this.enableTimestamps);
        this.jSeparator2.setVisible(this.enableTimestamps);
        this.optByGroupName.setVisible(this.enableUserPermission && this.enableGroupPermission);
        this.optByUserName.setVisible(this.enableUserPermission && this.enableGroupPermission);
        this.optOnlySelectedObjects.setVisible(this.enableAllFromClass);
        this.optAllClassObjects.setVisible(this.enableAllFromClass);
        this.optAllClassObjects.setSelected(false);
        this.optOnlySelectedObjects.setSelected(true);
        this.optByUserName.setSelected(!this.enableGroupPermission);
        this.optByGroupName.setSelected(!this.enableUserPermission);
        this.cbClasses.setVisible(this.enableClassSelection);
        this.tblPermissions.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObjectsPermissionsProviderPanel.this.refreshRemoveButton();
            }
        });
    }

    public void reloadPermissions() {
        final DefaultMetaTreeNode[] nodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodesArray();
        new SwingWorker<List<CidsBean>, Void>(){

            @Override
            protected List<CidsBean> doInBackground() throws Exception {
                ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                for (DefaultMetaTreeNode node : nodes) {
                    if (!(node instanceof ObjectTreeNode)) continue;
                    ObjectTreeNode otn = (ObjectTreeNode)node;
                    if (!ObjectsPermissionsProviderPanel.this.classesMap.containsKey(otn.getClassID())) continue;
                    beans.add(otn.getMetaObject().getBean());
                }
                return beans;
            }

            @Override
            protected void done() {
                try {
                    List beans = (List)this.get();
                    ObjectsPermissionsProviderPanel.this.setCidsBeans(beans);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }.execute();
        new SwingWorker<List<CidsBean>, Void>(){

            @Override
            protected List<CidsBean> doInBackground() throws Exception {
                ObjectsPermissionsSearch permSearch = new ObjectsPermissionsSearch(new MetaObjectNode[]{new MetaObjectNode("WUNDA_BLAU", -1, CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"MAUER", (ConnectionContext)ObjectsPermissionsProviderPanel.this.getConnectionContext()).getId())});
                Collection permissionMons = SessionManager.getProxy().customServerSearch((CidsServerSearch)permSearch, ObjectsPermissionsProviderPanel.this.getConnectionContext());
                ArrayList<CidsBean> permissionBeans = new ArrayList<CidsBean>();
                for (MetaObjectNode permissionMon : permissionMons) {
                    MetaObject permissionMo = SessionManager.getConnection().getMetaObject(SessionManager.getSession().getUser(), permissionMon.getObjectId(), permissionMon.getClassId(), permissionMon.getDomain(), ObjectsPermissionsProviderPanel.this.getConnectionContext());
                    if (permissionMo == null) continue;
                    permissionBeans.add(permissionMo.getBean());
                }
                return permissionBeans;
            }

            @Override
            protected void done() {
                try {
                    List permissionBeans = (List)this.get();
                    ObjectsPermissionsProviderPanel.this.getPermissionsTableModel().setCidsBeans(permissionBeans);
                    ObjectsPermissionsProviderPanel.this.reloadObjects(permissionBeans);
                }
                catch (Exception ex) {
                    ObjectsPermissionsProviderPanel.this.error("error while searching permission beans", ex);
                }
            }
        }.execute();
    }

    private void reloadObjects(final List<CidsBean> permissionBeans) {
        new SwingWorker<Collection<MetaObject>, Void>(){

            @Override
            protected Collection<MetaObject> doInBackground() throws Exception {
                ArrayList<MetaObject> mos = new ArrayList<MetaObject>();
                for (CidsBean permissionBean : permissionBeans) {
                    Integer classId = (Integer)permissionBean.getProperty(ObjectsPermissionsProviderPanel.PROPERTY_CLASS_ID);
                    Integer objectId = (Integer)permissionBean.getProperty(ObjectsPermissionsProviderPanel.PROPERTY_OBJECT_ID);
                    if (objectId == null) continue;
                    MetaObject mo = SessionManager.getProxy().getMetaObject(objectId.intValue(), classId.intValue(), SessionManager.getSession().getConnectionInfo().getUserDomain(), ObjectsPermissionsProviderPanel.this.getConnectionContext());
                    mos.add(mo);
                }
                return mos;
            }

            @Override
            protected void done() {
                try {
                    Collection mos = (Collection)this.get();
                    for (MetaObject mo : mos) {
                        ObjectsPermissionsProviderPanel.this.objectsMap.put(ObjectsPermissionsProviderPanel.createObjectKey(mo.getId(), mo.getClassID()), mo.getBean());
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                ObjectsPermissionsProviderPanel.this.getPermissionsTableModel().fireTableDataChanged();
            }
        }.execute();
    }

    public void cleanup() {
        this.objectsMap.clear();
        this.permissionBeansToDelete.clear();
    }

    private void refreshRemoveButton() {
        this.btnDeletePermission.setEnabled(this.tblPermissions.getSelectedRowCount() > 0);
    }

    public void setMetaClasses(Collection<MetaClass> metaClasses) {
        DefaultComboBoxModel<MetaClass> classesCbModel = new DefaultComboBoxModel<MetaClass>();
        for (MetaClass metaClass : metaClasses) {
            this.classesMap.put(metaClass.getID(), metaClass);
            if (classesCbModel.getIndexOf(metaClass) >= 0) continue;
            classesCbModel.addElement(metaClass);
        }
        this.cbClasses.setModel(classesCbModel);
        if (classesCbModel.getSize() > 0) {
            this.cbClasses.setSelectedIndex(0);
        }
    }

    public void setCidsBeans(Collection<CidsBean> cidsBeans) {
        DefaultListModel<CidsBean> objectsListModel = new DefaultListModel<CidsBean>();
        if (cidsBeans != null) {
            for (CidsBean cidsBean : cidsBeans) {
                MetaClass metaClass;
                if (cidsBean == null || !this.classesMap.containsKey((metaClass = cidsBean.getMetaObject().getMetaClass()).getID())) continue;
                MetaObjectNode objectMon = new MetaObjectNode(cidsBean);
                this.objectsMap.put(ObjectsPermissionsProviderPanel.createObjectKey(objectMon.getObjectId(), objectMon.getClassId()), cidsBean);
                objectsListModel.addElement(cidsBean);
            }
        }
        this.lstObjects.setModel(objectsListModel);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static String createObjectKey(Integer objectId, Integer classId) {
        return String.format("%d@%d", objectId, classId);
    }

    private class DropAwareJList
    extends JList
    implements CidsBeanDropListener {
        public DropAwareJList() {
        }

        public DropAwareJList(ListModel dataModel) {
            super(dataModel);
        }

        public DropAwareJList(Object[] listData) {
            super(listData);
        }

        public DropAwareJList(Vector listData) {
            super(listData);
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            try {
                for (CidsBean dropped : beans) {
                    if (dropped == null || !ObjectsPermissionsProviderPanel.this.classesMap.containsKey(dropped.getMetaObject().getClassID()) || ((DefaultListModel)ObjectsPermissionsProviderPanel.this.lstObjects.getModel()).contains(dropped)) continue;
                    ((DefaultListModel)ObjectsPermissionsProviderPanel.this.lstObjects.getModel()).addElement(dropped);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Problem when adding the DroppedBeans", (Throwable)ex);
            }
        }
    }

    private class ObjectsPermissionsTableModel
    extends CidsBeansTableModel {
        public ObjectsPermissionsTableModel() {
            super(ObjectsPermissionsProviderPanel.this.columnProperties.toArray(new String[0]), ObjectsPermissionsProviderPanel.this.columnNames.toArray(new String[0]), ObjectsPermissionsProviderPanel.this.columnClasses.toArray(new Class[0]), false, false);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CidsBean cidsBean = this.getCidsBean(rowIndex);
            String columnProperty = (String)ObjectsPermissionsProviderPanel.this.columnProperties.get(columnIndex);
            if (ObjectsPermissionsProviderPanel.PROPERTY_CLASS_NAME.equals(columnProperty) || ObjectsPermissionsProviderPanel.PROPERTY_OBJECT_NAME.equals(columnProperty)) {
                Integer classId = (Integer)cidsBean.getProperty(ObjectsPermissionsProviderPanel.PROPERTY_CLASS_ID);
                Integer objectId = (Integer)cidsBean.getProperty(ObjectsPermissionsProviderPanel.PROPERTY_OBJECT_ID);
                CidsBean objecBean = objectId != null ? (CidsBean)ObjectsPermissionsProviderPanel.this.objectsMap.get(ObjectsPermissionsProviderPanel.createObjectKey(objectId, classId)) : null;
                switch (columnProperty) {
                    case "_class_name": {
                        MetaClass metaClass = objecBean == null ? (MetaClass)ObjectsPermissionsProviderPanel.this.classesMap.get(classId) : (objecBean.getMetaObject() != null ? objecBean.getMetaObject().getMetaClass() : null);
                        return metaClass != null ? metaClass.getName() : null;
                    }
                    case "_object_name": {
                        return objectId != null ? (objecBean != null ? objecBean : "<html><i>wird geladen...") : "<html><i>Alle";
                    }
                }
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    public static enum Option {
        READ_ONLY,
        DISABLE_GROUP_PERMISSIONS,
        DISABLE_USER_PERMISSIONS,
        DISABLE_ALL_FROM_CLASS,
        DISABLE_READ,
        DISABLE_WRITE,
        DISABLE_TIMESTAMPS,
        DISABLE_CLASS_SELECTION,
        ONLY_CONFATTR_GROUPS;

    }
}

