/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_AbstractPictureGridObject;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultListModel;

public class Sb_SingleStadtbildGridObject
extends Sb_AbstractPictureGridObject {
    private static final ExecutorService highResAvailableThreadPool = CismetExecutors.newFixedThreadPool((int)20);
    private final CidsBean stadtbild;
    private final Sb_stadtbildserieGridObject locationOfStadtbild;
    private AtomicBoolean imageAvailableInHighRes;
    private DefaultListModel gridModel;

    public Sb_SingleStadtbildGridObject(CidsBean stadtbild, Sb_stadtbildserieGridObject locationOfStadtbild, DefaultListModel gridModel, ConnectionContext connectionContext) {
        super(connectionContext);
        this.stadtbild = stadtbild;
        this.locationOfStadtbild = locationOfStadtbild;
        this.imageAvailableInHighRes = new AtomicBoolean(true);
        this.gridModel = gridModel;
    }

    void startThreadToDetermineIfHighResImageAvailable() {
        highResAvailableThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                CidsBean stadtbildSerie = Sb_SingleStadtbildGridObject.this.locationOfStadtbild.getStadtbildserie();
                StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(stadtbildSerie, Sb_SingleStadtbildGridObject.this.stadtbild);
                Sb_SingleStadtbildGridObject.this.imageAvailableInHighRes.set(StadtbilderUtils.getFormatOfHighResPicture(stadtbildInfo) != null);
                Sb_SingleStadtbildGridObject.this.notifyModel();
            }
        });
    }

    public boolean isHighResAvailable() {
        return this.imageAvailableInHighRes.get();
    }

    @Override
    protected StadtbilderUtils.StadtbildInfo getStadtbildInfo() {
        StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(this.locationOfStadtbild.getStadtbildserie(), this.stadtbild);
        return stadtbildInfo;
    }

    @Override
    protected int getDownloadPrority() {
        return 0;
    }

    @Override
    protected void notifyModel() {
        int position = this.gridModel.indexOf(this);
        if (position >= 0 && position < this.gridModel.getSize()) {
            this.gridModel.setElementAt(this, position);
        }
    }

    @Override
    public Image getImage(int cellDimension, boolean invert) {
        Image image = super.getImage(cellDimension, invert);
        if (this.imageAvailableInHighRes.get() || image == StadtbilderUtils.PLACEHOLDER_IMAGE) {
            this.setPreview(false);
            return image;
        }
        if (image == null) {
            BufferedImage imageToShow = new BufferedImage(cellDimension, cellDimension, 2);
            Graphics2D g = (Graphics2D)imageToShow.getGraphics();
            Image scaledErrorImage = StadtbilderUtils.scaleImage(StadtbilderUtils.ERROR_IMAGE, cellDimension, invert);
            g.drawImage(scaledErrorImage, 0, cellDimension / 12, null);
            this.setPreview(false);
            return imageToShow;
        }
        this.setPreview(true);
        return image;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.stadtbild != null ? this.stadtbild.hashCode() : 0);
        hash = 11 * hash + (this.locationOfStadtbild != null ? this.locationOfStadtbild.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sb_SingleStadtbildGridObject other = (Sb_SingleStadtbildGridObject)obj;
        if (!(this.stadtbild == other.stadtbild || this.stadtbild != null && this.stadtbild.equals((Object)other.stadtbild))) {
            return false;
        }
        return this.locationOfStadtbild == other.locationOfStadtbild || this.locationOfStadtbild != null && this.locationOfStadtbild.equals(other.locationOfStadtbild);
    }

    @Override
    protected boolean isPreviewAllowed() {
        CidsBean stadtbildserie = this.locationOfStadtbild.getCidsBean();
        return Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, this.getConnectionContext()).isPreviewAllowed();
    }

    @Override
    protected CidsBean getStadtbildserie() {
        return this.locationOfStadtbild.getStadtbildserie();
    }

    public Sb_stadtbildserieGridObject getLocationOfStadtbild() {
        return this.locationOfStadtbild;
    }

    public CidsBean getStadtbild() {
        return this.stadtbild;
    }
}

