/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.tools.LinkedProperties;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ThemaAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
TitleComponentProvider {
    public static final List<Integer> COLUMN_SIZES = new CopyOnWriteArrayList<Integer>();
    public static final Color COLOR_TXT_BACK = new Color(230, 230, 230);
    public static final Color COLOR_TBL_SECOND = new Color(210, 210, 210);
    private JScrollPane jScrollPane1;
    private JLabel lblAgrTitle;
    private JPanel panAgrContent;
    private JTable tblAggregation;
    private LinkedProperties aggregationColumns = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private Collection<CidsBean> cidsBeans = null;
    private BindingGroup bindingGroup = new BindingGroup();

    public ThemaAggregationRenderer() {
        if (this.aggregationColumns == null) {
            this.aggregationColumns = new LinkedProperties();
            InputStream is = null;
            try {
                is = ThemaAggregationRenderer.class.getResourceAsStream("/de/cismet/navigator/objectrenderer/thema/aggregation_renderer.properties");
                this.aggregationColumns.load(is);
            }
            catch (IOException ex) {
                this.log.warn((Object)"Could not load properties for aggregation renderer: thema", (Throwable)ex);
                this.aggregationColumns.put((Object)"bezeichnung", (Object)"Bezeichnung");
                this.aggregationColumns.put((Object)"organisationseinheit", (Object)"Organisationseinheit");
                this.aggregationColumns.put((Object)"nutzerzahl", (Object)"Anzahl Nutzer");
                this.aggregationColumns.put((Object)"wms_wms.wms_name", (Object)"WMS");
                this.aggregationColumns.put((Object)"gaz_dienst.dienstname", (Object)"Gazetteer");
                this.aggregationColumns.put((Object)"akt_kategorie.kategoriebezeichnung", (Object)"Akt. Umsetzung");
                this.aggregationColumns.put((Object)"zuk_kategorie.kategoriebezeichnung", (Object)"Zuk. Umsetzung");
                this.aggregationColumns.put((Object)"akt_realisierungsstand.status", (Object)"Akt. Status");
                this.aggregationColumns.put((Object)"zuk_realisierungsstand.status", (Object)"Zuk. Status");
                this.aggregationColumns.put((Object)"fachthema", (Object)"Fachthema");
                this.aggregationColumns.put((Object)"fachverfahren", (Object)"Fachverfahren");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        this.log.warn((Object)ex, (Throwable)ex);
                    }
                }
            }
        }
        this.initComponents();
        Highlighter alternateRowHighlighter = HighlighterFactory.createAlternateStriping((Color)COLOR_TXT_BACK, (Color)COLOR_TBL_SECOND);
        ((JXTable)this.tblAggregation).setHighlighters(new Highlighter[]{alternateRowHighlighter});
        this.tblAggregation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor")) {
                    ThemaAggregationRenderer.this.savePreferredColumnWidths();
                }
            }
        });
    }

    private void initComponents() {
        this.lblAgrTitle = new JLabel();
        this.panAgrContent = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblAggregation = new JXTable();
        this.lblAgrTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblAgrTitle.setForeground(new Color(255, 255, 255));
        this.lblAgrTitle.setText("error ...");
        this.setLayout(new BorderLayout());
        this.panAgrContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.panAgrContent.setOpaque(false);
        this.panAgrContent.setLayout(new BorderLayout());
        this.tblAggregation.setOpaque(false);
        this.jScrollPane1.setViewportView(this.tblAggregation);
        this.panAgrContent.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.panAgrContent, "Center");
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(Collection<CidsBean> cidsBeans) {
        this.cidsBeans = cidsBeans;
        ELProperty eLProperty = ELProperty.create((String)"${cidsBeans}");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JTable)this.tblAggregation);
        JTableBinding.ColumnBinding columnBinding = null;
        for (Object key : this.aggregationColumns.keySet()) {
            String beanProperty = (String)key;
            String bezeichnung = this.aggregationColumns.getProperty(beanProperty);
            columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)("${" + beanProperty + "}")));
            columnBinding.setEditable(false);
            columnBinding.setColumnName(bezeichnung);
            CidsBean first = (CidsBean)cidsBeans.toArray()[0];
            Object example = first.getProperty(beanProperty);
            if (beanProperty == null || !beanProperty.equalsIgnoreCase("fachthema") && !beanProperty.equalsIgnoreCase("fachverfahren")) continue;
            columnBinding.setColumnClass(Boolean.class);
        }
        this.bindingGroup.addBinding((Binding)jTableBinding);
        jTableBinding.bind();
    }

    public String getTitle() {
        return this.lblAgrTitle.getText();
    }

    public void setTitle(String title) {
        this.lblAgrTitle.setText("Themenkatalog");
    }

    private void savePreferredColumnWidths() {
    }

    private void restorePreferredColumnWidths() {
    }

    public JComponent getTitleComponent() {
        return this.lblAgrTitle;
    }

    public void dispose() {
    }
}

