/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.utils.ClientAlboProperties;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class AlboReportFlaecheParametersGenerator
implements JasperReportDownload.JasperReportParametersGenerator,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(AlboReportFlaecheParametersGenerator.class);
    private static final String GEO_FIELD__PROPERTY = "fk_geom.geo_field";
    private static final ClientAlboProperties PROPERTIES = ClientAlboProperties.getInstance();
    private final CidsBean flaecheBean;
    private final ConnectionContext connectionContext;

    public AlboReportFlaecheParametersGenerator(CidsBean flaecheBean, ConnectionContext connectionContext) {
        this.flaecheBean = flaecheBean;
        this.connectionContext = connectionContext;
    }

    public CidsBean getCidsBean() {
        return this.flaecheBean;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Map generateParamters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        SimpleWMS s = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlboProperties.getInstance().getFlaecheMapUrl()));
        Geometry geometry = (Geometry)this.flaecheBean.getProperty(GEO_FIELD__PROPERTY);
        if (geometry == null) {
            parameters.put(ParametersKeys.MAP_ERROR.toString(), true);
            LOG.info((Object)"Geometry is null. Can not create a map for the albo flaeche report");
        } else {
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(geometry);
            dsf.setLineWidth(5);
            dsf.setLinePaint((Paint)Color.RED);
            dsf.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.5f));
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.addLayer((RetrievalServiceLayer)s);
            mapProvider.addFeature((Feature)dsf);
            mapProvider.setMinimumScaleDenomimator(750.0);
            mapProvider.setRoundScaleTo(HeadlessMapProvider.RoundingPrecision.HUNDRETH);
            mapProvider.setCenterMapOnResize(true);
            XBoundingBox boundingBox = new XBoundingBox(geometry);
            mapProvider.setBoundingBox(boundingBox);
            try {
                Future f = mapProvider.getImage(72, PROPERTIES.getFlaecheMapDpi().intValue(), (double)PROPERTIES.getFlaecheMapWidth().intValue(), (double)PROPERTIES.getFlaecheMapHeight().intValue());
                Image img = (Image)f.get();
                parameters.put(ParametersKeys.MAP_MASSSTAB.toString(), "1:" + NumberFormat.getIntegerInstance().format(mapProvider.getImageScaleDenominator()));
                parameters.put(ParametersKeys.MAP_IMAGE.toString(), img);
            }
            catch (Exception ex) {
                parameters.put(ParametersKeys.MAP_ERROR.toString(), true);
            }
        }
        return parameters;
    }

    public static enum ParametersKeys {
        MAP_MASSSTAB,
        MAP_IMAGE,
        MAP_ERROR;

    }
}

