/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.reports.wunda_blau.ReportBeanWithMap;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.JFreeChart;

public class GrundwassermessstellenReportBean
extends ReportBeanWithMap {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("de/cismet/cids/custom/reports/wunda_blau/GwmsReport");
    private final JFreeChart chart;
    private final CidsBean kategorieBean;
    private final List<CidsBean> messungBeans = new ArrayList<CidsBean>();
    private final List<LegendeBean> legendeLeft = new ArrayList<LegendeBean>();
    private final List<LegendeBean> legendeRight = new ArrayList<LegendeBean>();
    private final Image chartImage;

    public GrundwassermessstellenReportBean(CidsBean messstelleBean, CidsBean kategorieBean, List<CidsBean> messungBeans, List<LegendeBean> legendeLeft, List<LegendeBean> legendeRight, JFreeChart chart, ConnectionContext connectionContext) {
        super(messstelleBean, RESOURCE_BUNDLE.getString("map_url"), connectionContext);
        this.kategorieBean = kategorieBean;
        this.messungBeans.addAll(messungBeans);
        this.legendeLeft.addAll(legendeLeft);
        this.legendeRight.addAll(legendeRight);
        this.chart = chart;
        int dpi = Integer.parseInt(RESOURCE_BUNDLE.getString("chart_dpi"));
        int width = (int)((double)Integer.parseInt(RESOURCE_BUNDLE.getString("chart_width")) * ((double)dpi / 72.0));
        int height = (int)((double)Integer.parseInt(RESOURCE_BUNDLE.getString("chart_height")) * ((double)dpi / 72.0));
        this.chartImage = chart.createBufferedImage(width, height);
    }

    @Override
    protected Geometry getGeometry() {
        return this.getCidsBean() != null ? (Geometry)this.getCidsBean().getProperty("geometrie.geo_field") : null;
    }

    public CidsBean getGwms() {
        return this.getCidsBean();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public CidsBean getKategorieBean() {
        return this.kategorieBean;
    }

    public List<CidsBean> getMessungBeans() {
        return this.messungBeans;
    }

    public List<LegendeBean> getLegendeLeft() {
        return this.legendeLeft;
    }

    public List<LegendeBean> getLegendeRight() {
        return this.legendeRight;
    }

    public Image getChartImage() {
        return this.chartImage;
    }

    public static class LegendeBean {
        private final CidsBean stoffBean;
        private final Image shapeImage;

        public CidsBean getStoffBean() {
            return this.stoffBean;
        }

        public Image getShapeImage() {
            return this.shapeImage;
        }

        public LegendeBean(CidsBean stoffBean, Image shapeImage) {
            this.stoffBean = stoffBean;
            this.shapeImage = shapeImage;
        }
    }
}

