/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.custom.reports.wunda_blau.BillingBillDialog;
import de.cismet.cids.custom.reports.wunda_blau.BillingBuchungsbelegReport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class PrintBillingReportForCustomer
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(PrintBillingReportForCustomer.class);
    private final CidsBean kundeBean;
    private final Date[] fromDate_tillDate;
    private final Collection<CidsBean> billingsBeans;
    private final boolean isRechnungsanlage;
    private int amountTotalDownloads = 0;
    private int amountWithCosts = 0;
    private int amountWithoutCosts = 0;
    private int amountVUamtlicherLageplan = 0;
    private int amountVUhoheitlicheVermessung = 0;
    private int amountVUsonstige = 0;
    private int amountEigenerGebrauch = 0;
    private int amountWiederverkauf = 0;
    private int amountEigenerGebrauchGeb\u00fchrenbefreit = 0;
    private final HashSet amountVUamtlicherLageplanGB = new HashSet();
    private final HashSet amountVUhoheitlicheVermessungGB = new HashSet();
    private final HashSet amountVUsonstigeGB = new HashSet();
    private final HashSet amountEigenerGebrauchGB = new HashSet();
    private final HashSet amountWiederverkaufGB = new HashSet();
    private final HashSet amountEigenerGebrauchGeb\u00fchrenbefreitGB = new HashSet();
    private final JPanel panel;
    private final boolean showBillingWithoutCostInReport;
    private DownloadFinishedObserver downloadFinishedObserver = new DownloadFinishedObserver();
    private final BillingDoneListener billingDoneListener;
    private final ConnectionContext connectionContext;

    public PrintBillingReportForCustomer(CidsBean kundeBean, Collection<CidsBean> billingsBeans, Date[] fromDate_tillDate, boolean isRechnungsanlage, JPanel panel, boolean showBillingWithoutCostInReport, BillingDoneListener billingDoneListener, ConnectionContext connectionContext) {
        this.kundeBean = kundeBean;
        this.fromDate_tillDate = fromDate_tillDate;
        this.isRechnungsanlage = isRechnungsanlage;
        this.billingsBeans = billingsBeans;
        this.panel = panel;
        this.showBillingWithoutCostInReport = showBillingWithoutCostInReport;
        this.billingDoneListener = billingDoneListener;
        this.connectionContext = connectionContext;
    }

    public void print() {
        boolean noData;
        BigDecimal bruttoGesamt = new BigDecimal(0.0);
        BigDecimal nettoGesamt = new BigDecimal(0.0);
        BigDecimal katasterNetto = new BigDecimal(0.0);
        BigDecimal katasterBrutto = new BigDecimal(0.0);
        BigDecimal baulastenNetto = new BigDecimal(0.0);
        BigDecimal baulastenBrutto = new BigDecimal(0.0);
        BigDecimal nettoMitMwst = new BigDecimal(0.0);
        BigDecimal bruttoMitMwst = new BigDecimal(0.0);
        BigDecimal nettoOhneMwst = new BigDecimal(0.0);
        BigDecimal bruttoOhneMwst = new BigDecimal(0.0);
        ArrayList<CidsBean> unfilteredBillings = new ArrayList<CidsBean>();
        ArrayList<CidsBean> filteredBillingsOhneMwst = new ArrayList<CidsBean>();
        ArrayList<CidsBean> filteredBillingsKatasterOhneMwst = new ArrayList<CidsBean>();
        ArrayList<CidsBean> filteredBillingsBaulastenOhneMwst = new ArrayList<CidsBean>();
        ArrayList<CidsBean> filteredBillingsMitMwst = new ArrayList<CidsBean>();
        unfilteredBillings.addAll(this.billingsBeans);
        for (CidsBean billing : unfilteredBillings) {
            Double nettoSumme = (Double)billing.getProperty("netto_summe");
            Double bruttoSumme = (Double)billing.getProperty("brutto_summe");
            Double mwstSatz = (Double)billing.getProperty("mwst_satz");
            if (this.showBillingWithoutCostInReport || nettoSumme > 0.0) {
                boolean mitMwst;
                nettoGesamt = nettoSumme != null ? nettoGesamt.add(new BigDecimal(nettoSumme)) : nettoOhneMwst;
                bruttoGesamt = bruttoSumme != null ? bruttoGesamt.add(new BigDecimal(bruttoSumme)) : bruttoOhneMwst;
                boolean bl = mitMwst = mwstSatz != null && !mwstSatz.equals(new Double(0.0));
                if (mitMwst) {
                    filteredBillingsMitMwst.add(billing);
                    nettoMitMwst = nettoSumme != null ? nettoMitMwst.add(new BigDecimal(nettoSumme)) : nettoMitMwst;
                    bruttoMitMwst = bruttoSumme != null ? bruttoMitMwst.add(new BigDecimal(bruttoSumme)) : bruttoMitMwst;
                } else {
                    filteredBillingsOhneMwst.add(billing);
                    nettoOhneMwst = nettoSumme != null ? nettoOhneMwst.add(new BigDecimal(nettoSumme)) : nettoOhneMwst;
                    bruttoOhneMwst = bruttoSumme != null ? bruttoOhneMwst.add(new BigDecimal(bruttoSumme)) : bruttoOhneMwst;
                }
            }
            this.setCountersDependingOnVerwendungszweck(billing);
        }
        for (CidsBean billing : filteredBillingsOhneMwst) {
            boolean istBaulast;
            boolean bl = istBaulast = "bla".equals(billing.getProperty("produktkey")) || "blab_be".equals(billing.getProperty("produktkey"));
            if (istBaulast) {
                filteredBillingsBaulastenOhneMwst.add(billing);
                baulastenNetto = baulastenNetto.add(new BigDecimal((Double)billing.getProperty("netto_summe")));
                baulastenBrutto = baulastenBrutto.add(new BigDecimal((Double)billing.getProperty("brutto_summe")));
                continue;
            }
            filteredBillingsKatasterOhneMwst.add(billing);
            katasterNetto = katasterNetto.add(new BigDecimal((Double)billing.getProperty("netto_summe")));
            katasterBrutto = katasterBrutto.add(new BigDecimal((Double)billing.getProperty("brutto_summe")));
        }
        boolean bl = noData = filteredBillingsOhneMwst.isEmpty() && filteredBillingsKatasterOhneMwst.isEmpty() && filteredBillingsBaulastenOhneMwst.isEmpty() && filteredBillingsMitMwst.isEmpty();
        if (noData && !this.isRechnungsanlage) {
            JOptionPane.showMessageDialog(this.panel, NbBundle.getMessage(PrintBillingReportForCustomer.class, (String)"PrintBillingReportForCustomer.print().dialog.message"), NbBundle.getMessage(PrintBillingReportForCustomer.class, (String)"PrintBillingReportForCustomer.print().dialog.title"), 0);
        } else {
            BillingBuchungsbelegReport report = new BillingBuchungsbelegReport(this.kundeBean, filteredBillingsOhneMwst, nettoOhneMwst, bruttoOhneMwst, filteredBillingsKatasterOhneMwst, katasterNetto, katasterBrutto, filteredBillingsBaulastenOhneMwst, baulastenNetto, baulastenBrutto, filteredBillingsMitMwst, nettoMitMwst, bruttoMitMwst, nettoGesamt, bruttoGesamt, this.fromDate_tillDate[0], this.fromDate_tillDate[1], this.isRechnungsanlage, this.amountTotalDownloads, this.amountWithCosts, this.amountWithoutCosts, this.amountVUamtlicherLageplan, this.amountVUhoheitlicheVermessung, this.amountVUsonstige, this.amountEigenerGebrauch, this.amountWiederverkauf, this.amountEigenerGebrauchGeb\u00fchrenbefreit, this.amountVUamtlicherLageplanGB.size(), this.amountVUhoheitlicheVermessungGB.size(), this.amountVUsonstigeGB.size(), this.amountEigenerGebrauchGB.size(), this.amountWiederverkaufGB.size(), this.amountEigenerGebrauchGeb\u00fchrenbefreitGB.size());
            report.setDownloadObserver(this.downloadFinishedObserver);
            report.generateReport();
        }
    }

    private void setCountersDependingOnVerwendungszweck(CidsBean billing) {
        String verwendungsKey = (String)billing.getProperty("verwendungskey");
        ++this.amountTotalDownloads;
        Double nettoSum = (Double)billing.getProperty("netto_summe");
        if (nettoSum > 0.0) {
            ++this.amountWithCosts;
        } else {
            ++this.amountWithoutCosts;
        }
        String geschaeftsbuchnummer = (String)billing.getProperty("geschaeftsbuchnummer");
        boolean geschaeftsbuchnummerIsValid = false;
        if (!geschaeftsbuchnummer.trim().equals("")) {
            geschaeftsbuchnummerIsValid = true;
        }
        if (verwendungsKey.equals("VU aL")) {
            ++this.amountVUamtlicherLageplan;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUamtlicherLageplanGB.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("VU hV")) {
            ++this.amountVUhoheitlicheVermessung;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUhoheitlicheVermessungGB.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("VU s")) {
            ++this.amountVUsonstige;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUsonstigeGB.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("eigG")) {
            ++this.amountEigenerGebrauch;
            if (geschaeftsbuchnummerIsValid) {
                this.amountEigenerGebrauchGB.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("WV ein")) {
            ++this.amountWiederverkauf;
            if (geschaeftsbuchnummerIsValid) {
                this.amountWiederverkaufGB.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("eigG frei")) {
            ++this.amountEigenerGebrauchGeb\u00fchrenbefreit;
            if (geschaeftsbuchnummerIsValid) {
                this.amountEigenerGebrauchGeb\u00fchrenbefreitGB.add(geschaeftsbuchnummer);
            }
        }
    }

    private void markBillings() {
        if (this.isRechnungsanlage) {
            BillingBillDialog diag = new BillingBillDialog((Frame)ComponentRegistry.getRegistry().getNavigator());
            StaticSwingTools.showDialog((JDialog)diag);
            if (Boolean.TRUE.equals(diag.isBilling())) {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        for (CidsBean billing : PrintBillingReportForCustomer.this.billingsBeans) {
                            try {
                                billing.setProperty("abrechnungsdatum", (Object)new Timestamp(new Date().getTime()));
                                billing.setProperty("abgerechnet", (Object)Boolean.TRUE);
                                billing.persist(PrintBillingReportForCustomer.this.getConnectionContext());
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while setting value or persisting of billing.", (Throwable)ex);
                                final ErrorInfo ei = new ErrorInfo("Fehler beim Abrechnen", "Buchung konnte nicht auf abgerechnet gesetzt werden.", ex.getMessage(), null, (Throwable)ex, Level.ALL, null);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)CismapBroker.getInstance().getMappingComponent()), (ErrorInfo)ei);
                                    }
                                });
                            }
                        }
                        PrintBillingReportForCustomer.this.billingDoneListener.billingDone(true);
                        return null;
                    }
                }.execute();
            } else {
                this.billingDoneListener.billingDone(false);
            }
        }
    }

    public void setDownloadFinishedObserver(DownloadFinishedObserver downloadFinishedObserver) {
        this.downloadFinishedObserver = downloadFinishedObserver;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public class DownloadFinishedObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            JasperReportDownload download;
            if (o instanceof JasperReportDownload && (download = (JasperReportDownload)o).getStatus().equals((Object)Download.State.COMPLETED)) {
                PrintBillingReportForCustomer.this.markBillings();
                this.additionalFunctionalityIfDownloadCompleted();
            }
        }

        public void additionalFunctionalityIfDownloadCompleted() {
        }
    }

    public static interface BillingDoneListener {
        public void billingDone(boolean var1);
    }
}

