/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ReportBeanWithMap
implements ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(ReportBeanWithMap.class);
    private static final int MAP_DPI = 300;
    Image mapImage = null;
    private boolean mapError = false;
    private String masstab = "";
    private final CidsBean cidsBean;
    private final ConnectionContext connectionContext;

    public ReportBeanWithMap(CidsBean cidsBean, String mapUrl, ConnectionContext connectionContext) {
        this.cidsBean = cidsBean;
        this.connectionContext = connectionContext;
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            this.mapError = true;
            LOG.info((Object)"Geometry is null. Can not create a map for the mauer katasterblatt report");
        } else {
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(geometry);
            dsf.setLineWidth(5);
            dsf.setLinePaint((Paint)Color.RED);
            dsf.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.5f));
            SimpleWMS s = new SimpleWMS(new SimpleWmsGetMapUrl(mapUrl));
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.addLayer((RetrievalServiceLayer)s);
            mapProvider.addFeature((Feature)dsf);
            mapProvider.setMinimumScaleDenomimator(750.0);
            mapProvider.setRoundScaleTo(HeadlessMapProvider.RoundingPrecision.HUNDRETH);
            mapProvider.setCenterMapOnResize(true);
            int height = Integer.parseInt(NbBundle.getMessage(ReportBeanWithMap.class, (String)"MauernReportBeanWithMapAndImages.mapHeight"));
            int width = Integer.parseInt(NbBundle.getMessage(ReportBeanWithMap.class, (String)"MauernReportBeanWithMapAndImages.mapWidth"));
            XBoundingBox boundingBox = new XBoundingBox(geometry);
            mapProvider.setBoundingBox(boundingBox);
            Future f = mapProvider.getImage(72, 300, (double)width, (double)height);
            try {
                Image img = (Image)f.get();
                this.masstab = "1:" + NumberFormat.getIntegerInstance().format(mapProvider.getImageScaleDenominator());
                this.mapImage = img;
            }
            catch (Exception ex) {
                this.mapError = true;
            }
        }
    }

    protected abstract Geometry getGeometry();

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public Image getMapImage() {
        return this.mapImage;
    }

    public void setMapImage(Image mapImage) {
        this.mapImage = mapImage;
    }

    public String getMasstab() {
        return this.masstab;
    }

    public void setMasstab(String masstab) {
        this.masstab = masstab;
    }

    public boolean isReadyToProceed() {
        return this.cidsBean != null && (this.mapImage != null || this.mapError);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

