/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.templateinscriber;

import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class A4HSPersistent
extends AbstractPrintingInscriber
implements FilenamePrintingInscriber {
    public static final String KEY_HIGHLIGHT = "Ueberschrift";
    public static final String KEY_SIGNATURE = "Unterschrift";
    public static final String KEY_E_NR = "ENr";
    public static final String KEY_LOC_DESC = "Lagebezeichnung";
    public static final String KEY_DATA = "Datenart";
    public static final String KEY_DATASOURCES = "Datenquellen";
    private static final String CBO_DATA_PROPERTIES = "CboData.properties";
    private static final Logger LOG = Logger.getLogger(A4HSPersistent.class);
    String cacheFile = "";
    Properties cache = new Properties();
    private final ArrayList<JCheckBox> chkDataSourcesList;
    private List<FilenamePrintingInscriberListener> listeners = new ArrayList<FilenamePrintingInscriberListener>();
    private String oldText = "";
    private JComboBox cboData;
    private JScrollPane jScrollPane2;
    private JLabel lblData;
    private JLabel lblDataSources;
    private JLabel lblENr;
    private JLabel lblHighlight;
    private JLabel lblLocationDescription;
    private JLabel lblSignature;
    private JPanel pnlDataSources;
    private JTextField txtENr;
    private JTextField txtHighlight;
    private JTextField txtLocationDescription;
    private JTextField txtSignature;

    public A4HSPersistent() {
        this.initComponents();
        this.cacheFile = CismapBroker.getInstance().getCismapFolderPath() + System.getProperty("file.separator") + "inscriberCache";
        this.readInscriberCache();
        this.chkDataSourcesList = new ArrayList();
        this.setUpDataSourceChks();
        this.setUpDataCbo();
        this.oldText = this.txtHighlight.getText();
        this.txtHighlight.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            private void onChange(DocumentEvent e) {
                FileNameChangedEvent event = new FileNameChangedEvent(A4HSPersistent.this.oldText, A4HSPersistent.this.txtHighlight.getText());
                for (FilenamePrintingInscriberListener listener : A4HSPersistent.this.listeners) {
                    listener.fileNameChanged(event);
                }
                A4HSPersistent.this.oldText = A4HSPersistent.this.txtHighlight.getText();
            }
        });
    }

    private void setUpDataSourceChks() {
        CismapBroker broker = CismapBroker.getInstance();
        MappingComponent mapComp = broker.getMappingComponent();
        MappingModel mapModel = mapComp.getMappingModel();
        TreeMap rasterServices = mapModel.getRasterServices();
        for (Object v : rasterServices.values()) {
            boolean retrievalServiceLayerCheck;
            boolean serviceLayerCheck = v instanceof ServiceLayer && ((ServiceLayer)v).isEnabled() && ((ServiceLayer)v).getTranslucency() > 0.0f || !(v instanceof ServiceLayer);
            boolean bl = retrievalServiceLayerCheck = v instanceof RetrievalServiceLayer && ((RetrievalServiceLayer)v).getPNode().getVisible() || !(v instanceof MapService);
            if (!serviceLayerCheck || !retrievalServiceLayerCheck) continue;
            JCheckBox chkDataSource = new JCheckBox(v.toString());
            chkDataSource.setSelected(true);
            this.pnlDataSources.add((Component)chkDataSource, 0);
            this.chkDataSourcesList.add(chkDataSource);
        }
        Collections.reverse(this.chkDataSourcesList);
    }

    private void setUpDataCbo() {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(CBO_DATA_PROPERTIES);
        if (in == null) {
            LOG.error((Object)"Can not configuration file 'CboData.properties' in classpath. -> data combo box is empty");
        } else {
            Properties prop = new Properties();
            try {
                prop.load(in);
                TreeMap<Object, Object> propTreeMap = new TreeMap<Object, Object>(prop);
                Iterator<Object> it = propTreeMap.values().iterator();
                while (it.hasNext()) {
                    this.cboData.addItem(it.next());
                }
                this.cboData.setSelectedIndex(0);
            }
            catch (Exception ex) {
                LOG.error((Object)"An error occurred while reading configuration file 'CboData.properties' -> data combo box is empty", (Throwable)ex);
            }
        }
    }

    private String getSelectedDataSourcesString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstIter = true;
        for (JCheckBox chk : this.chkDataSourcesList) {
            if (!chk.isSelected()) continue;
            if (isFirstIter) {
                isFirstIter = false;
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append("- ").append(chk.getText());
        }
        return stringBuilder.toString();
    }

    public HashMap<String, String> getValues() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(KEY_HIGHLIGHT, this.txtHighlight.getText());
        hm.put(KEY_SIGNATURE, this.txtSignature.getText());
        hm.put(KEY_E_NR, this.txtENr.getText());
        hm.put(KEY_LOC_DESC, this.txtLocationDescription.getText());
        hm.put(KEY_DATA, String.valueOf(this.cboData.getSelectedItem()));
        hm.put(KEY_DATASOURCES, this.getSelectedDataSourcesString());
        this.cache.setProperty(KEY_HIGHLIGHT, this.txtHighlight.getText());
        this.cache.setProperty(KEY_SIGNATURE, this.txtSignature.getText());
        this.cache.setProperty(KEY_E_NR, this.txtENr.getText());
        this.cache.setProperty(KEY_LOC_DESC, this.txtLocationDescription.getText());
        this.writeInscriberCache();
        return hm;
    }

    private void initComponents() {
        this.lblHighlight = new JLabel();
        this.txtHighlight = new JTextField();
        this.lblSignature = new JLabel();
        this.txtSignature = new JTextField();
        this.lblENr = new JLabel();
        this.txtENr = new JTextField();
        this.lblLocationDescription = new JLabel();
        this.txtLocationDescription = new JTextField();
        this.lblData = new JLabel();
        this.cboData = new JComboBox();
        this.lblDataSources = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.pnlDataSources = new JPanel();
        this.setPreferredSize(new Dimension(312, 245));
        this.lblHighlight.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblHighlight.text"));
        this.txtHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HSPersistent.this.txtHighlightActionPerformed(evt);
            }
        });
        this.lblSignature.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblSignature.text"));
        this.lblENr.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblENr.text"));
        this.lblLocationDescription.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblLocationDescription.text"));
        this.lblData.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblData.text"));
        this.lblDataSources.setText(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblDataSources.text"));
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setMinimumSize(new Dimension(125, 56));
        this.jScrollPane2.setOpaque(false);
        this.pnlDataSources.setFocusTraversalPolicyProvider(true);
        this.pnlDataSources.setMinimumSize(new Dimension(123, 20));
        this.pnlDataSources.setLayout(new BoxLayout(this.pnlDataSources, 1));
        this.jScrollPane2.setViewportView(this.pnlDataSources);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblData).add((Component)this.lblSignature).add((Component)this.lblHighlight).add((Component)this.lblENr).add((Component)this.lblLocationDescription).add((Component)this.lblDataSources)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtLocationDescription).add((Component)this.txtSignature).add((Component)this.txtENr).add((Component)this.cboData, 0, 198, Short.MAX_VALUE).add((Component)this.txtHighlight))).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jScrollPane2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblENr).add((Component)this.txtENr, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblLocationDescription).add((Component)this.txtLocationDescription, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblSignature).add((Component)this.txtSignature, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblHighlight).add((Component)this.txtHighlight, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cboData, -2, -1, -2).add((Component)this.lblData, -2, 27, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblDataSources).add(0, 106, Short.MAX_VALUE)).add((Component)this.jScrollPane2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.lblHighlight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblHighlight.AccessibleContext.accessibleName"));
        this.lblSignature.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblSignature.AccessibleContext.accessibleName"));
        this.lblENr.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblENr.AccessibleContext.accessibleName"));
        this.lblLocationDescription.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblLocationDescription.AccessibleContext.accessibleName"));
        this.lblData.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblData.AccessibleContext.accessibleName"));
        this.lblDataSources.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HSPersistent.class, (String)"A4HSPersistent.lblDataSources.AccessibleContext.accessibleName"));
    }

    private void txtHighlightActionPerformed(ActionEvent evt) {
    }

    private void readInscriberCache() {
        try {
            this.cache.load(new FileInputStream(this.cacheFile));
            String h = this.cache.getProperty(KEY_HIGHLIGHT);
            String s = this.cache.getProperty(KEY_SIGNATURE);
            String l = this.cache.getProperty(KEY_LOC_DESC);
            String e = this.cache.getProperty(KEY_E_NR);
            this.txtHighlight.setText(h);
            this.txtSignature.setText(s);
            this.txtENr.setText(e);
            this.txtLocationDescription.setText(l);
        }
        catch (Throwable t) {
            LOG.warn((Object)"Error while reading the InscriberCache", t);
        }
    }

    private void writeInscriberCache() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    A4HSPersistent.this.cache.store(new FileOutputStream(A4HSPersistent.this.cacheFile), "Saved: " + System.currentTimeMillis());
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Error while writing the InscriberCache", t);
                }
            }
        };
        CismetThreadPool.execute((Runnable)r);
    }

    public void addFilenameChangeListener(FilenamePrintingInscriberListener listener) {
        this.listeners.add(listener);
    }

    public String getFileName() {
        return this.txtHighlight.getText();
    }
}

