/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.treeicons.wunda_blau;

import Sirius.navigator.types.treenode.ClassTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.CidsTreeObjectIconFactory;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.navigator.ui.tree.SearchResultsTree;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.tools.Static2DTools;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class VzkatSchildIconFactory
implements CidsTreeObjectIconFactory {
    private static final Logger LOG = Logger.getLogger(VzkatSchildIconFactory.class);
    private static final Map<String, ImageIcon> ICONS = new WeakHashMap<String, ImageIcon>();
    private static final ImageIcon LOADING_ICON = new ImageIcon(VzkatSchildIconFactory.class.getResource("/res/vzkat/loading_16.png"));
    private static final ImageIcon ERROR_ICON = new ImageIcon(VzkatSchildIconFactory.class.getResource("/res/vzkat/error_16.png"));
    private static final String ICON_PATH_TEMPLATE = "/de/cismet/cids/custom/wunda_blau/res/vzkat-bilder/16x16/%s.png";
    private static final ExecutorService EXECUTOR = CismetExecutors.newFixedThreadPool((int)4);
    volatile SwingWorker<Void, Void> objectRetrievingWorker = null;
    final WeakHashMap<ObjectTreeNode, ExecutorService> listOfRetrievingObjectWorkers = new WeakHashMap();
    private final ExecutorService objectRetrievalExecutor = Executors.newFixedThreadPool(15);

    public Icon getClosedPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getLeafPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIcon(otn);
    }

    public Icon getClosedObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIcon(otn);
    }

    public Icon getLeafObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIcon(otn);
    }

    public Icon getClassNodeIcon(ClassTreeNode dmtn) {
        return null;
    }

    public ImageIcon loadZeichenIcon(String key) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(String.format(ICON_PATH_TEMPLATE, key));
        return is != null ? new ImageIcon(ImageIO.read(is)) : null;
    }

    public static Icon overlayIcon(ImageIcon icon, Overlay overlay) {
        if (overlay != null) {
            switch (overlay) {
                case ERROR: {
                    ImageIcon overlayedIcon = Static2DTools.createOverlayIcon((ImageIcon)icon, (int)icon.getIconWidth(), (int)icon.getIconHeight());
                    return Static2DTools.mergeIcons((Icon)icon, (Icon)overlayedIcon);
                }
            }
            return icon;
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNode(final ObjectTreeNode node) {
        if (!this.listOfRetrievingObjectWorkers.containsKey(node) && !this.listOfRetrievingObjectWorkers.containsKey(node)) {
            this.listOfRetrievingObjectWorkers.put(node, this.objectRetrievalExecutor);
            WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = this.listOfRetrievingObjectWorkers;
            synchronized (weakHashMap) {
                final SearchResultsTree tree = ComponentRegistry.getRegistry().getSearchResultsTree();
                final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                final Object root = tree.getModel().getRoot();
                if (node != null) {
                    this.objectRetrievalExecutor.execute(new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (node.getPath()[0].equals(root)) {
                                if (tree.containsNode(node.getNode())) {
                                    node.getMetaObject(true);
                                }
                            } else {
                                node.getMetaObject(true);
                            }
                            VzkatSchildIconFactory.this.generateIcon(node);
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            try {
                                this.get();
                                treeModel.reload((TreeNode)node);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Fehler beim Laden des MetaObjects", (Throwable)ex);
                            }
                            finally {
                                WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = VzkatSchildIconFactory.this.listOfRetrievingObjectWorkers;
                                synchronized (weakHashMap) {
                                    VzkatSchildIconFactory.this.listOfRetrievingObjectWorkers.remove(node);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private Icon generateIcon(final ObjectTreeNode node) {
        if (node != null) {
            MetaObject mo = node.getMetaObject(false);
            if (mo != null) {
                CidsBean schildBean = mo.getBean();
                final String key = String.format("%s_%s", (String)schildBean.getProperty("fk_zeichen.fk_stvo.schluessel"), (String)schildBean.getProperty("fk_zeichen.schluessel"));
                if (ICONS.containsKey(key)) {
                    ImageIcon icon = ICONS.get(key) != null ? ICONS.get(key) : ERROR_ICON;
                    Overlay overlay = VzkatSchildIconFactory.getOverlay(schildBean);
                    return VzkatSchildIconFactory.overlayIcon(icon, overlay);
                }
                EXECUTOR.execute(new SwingWorker<ImageIcon, Void>(){

                    @Override
                    protected ImageIcon doInBackground() throws Exception {
                        return VzkatSchildIconFactory.this.loadZeichenIcon(key);
                    }

                    @Override
                    protected void done() {
                        try {
                            ImageIcon icon = (ImageIcon)this.get();
                            ICONS.put(key, icon);
                        }
                        catch (Exception ex) {
                            LOG.info((Object)ex, (Throwable)ex);
                            ICONS.put(key, ERROR_ICON);
                        }
                        SearchResultsTree SearchTree = ComponentRegistry.getRegistry().getSearchResultsTree();
                        DefaultTreeModel searchModel = (DefaultTreeModel)SearchTree.getModel();
                        searchModel.reload((TreeNode)node);
                        MetaCatalogueTree tree = ComponentRegistry.getRegistry().getCatalogueTree();
                        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                        treeModel.reload((TreeNode)node);
                    }
                });
            } else {
                this.loadNode(node);
            }
            return LOADING_ICON;
        }
        return null;
    }

    public static Overlay getOverlay(CidsBean schild) {
        return null;
    }

    public static enum Overlay {
        ERROR;

    }
}

