/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.wunda_blau.FlurstueckSelectionDialoge;
import de.cismet.cids.custom.wunda_blau.search.BaulastCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.BaulastSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.BaulastSearchInfo;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBaulastSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.FlurstueckInfo;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class BaulastWindowSearch
extends JPanel
implements CidsWindowSearch,
CidsBeanDropListener,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    static final Logger log = Logger.getLogger(BaulastWindowSearch.class);
    private MetaClass mc = null;
    private ImageIcon icon = null;
    private FlurstueckSelectionDialoge fsSelectionDialoge = null;
    private DefaultListModel flurstuecksFilterModel = null;
    private SearchControlPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnAddFS;
    private JButton btnFromMapFS;
    private JButton btnRemoveFS;
    private ButtonGroup buttonGroup1;
    private JComboBox cbArt;
    private JCheckBox chkBeguenstigt;
    private JCheckBox chkBelastet;
    private JCheckBox chkGeloescht;
    private JCheckBox chkGueltig;
    private JCheckBox chkKartenausschnitt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JList lstFlurstueck;
    private JPanel panCommand;
    private JPanel panSearch;
    private JPanel pnlAttributeFilter;
    private JPanel pnlFlurstuecksfilter;
    private JPanel pnlSearchFor;
    private JRadioButton rbBaulastBlaetter;
    private JRadioButton rbBaulasten;
    private JTextField txtBlattnummer;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALB_BAULAST", (ConnectionContext)this.getConnectionContext());
            this.icon = new ImageIcon(this.mc.getIconData());
            this.fsSelectionDialoge = new FlurstueckSelectionDialoge(false, this.getConnectionContext()){

                @Override
                public void okHook() {
                    List<CidsBean> result = this.getCurrentListToAdd();
                    if (result.size() > 0) {
                        BaulastWindowSearch.this.flurstuecksFilterModel.addElement(result.get(0));
                    }
                }
            };
            this.initComponents();
            MetaClass artMC = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALB_BAULAST_ART", (ConnectionContext)this.getConnectionContext());
            try {
                DefaultComboBoxModel cbArtModel = DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)artMC, (boolean)true, (ConnectionContext)this.getConnectionContext());
                this.cbArt.setModel(cbArtModel);
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            this.flurstuecksFilterModel = new DefaultListModel(){

                public void addElement(Object element) {
                    if (!this.contains(element)) {
                        super.addElement(element);
                    }
                }
            };
            this.lstFlurstueck.setModel(this.flurstuecksFilterModel);
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cbArt);
            new CidsBeanDropTarget((Component)this);
            this.fsSelectionDialoge.pack();
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.panCommand.add((Component)this.pnlSearchCancel);
            this.panCommand.add(Box.createHorizontalStrut(5));
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
            if (this.geoSearchEnabled) {
                BaulastCreateSearchGeometryListener baulastSearchGeometryListener = new BaulastCreateSearchGeometryListener(this.mappingComponent, new BaulastSearchTooltip(this.icon));
                baulastSearchGeometryListener.addPropertyChangeListener(this);
                this.btnGeoSearch = new GeoSearchButton("BAULAST_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null, NbBundle.getMessage(BaulastWindowSearch.class, (String)"BaulastWindowSearch.btnGeoSearch.toolTipText"));
                this.panCommand.add((Component)this.btnGeoSearch);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"Error in Constructor of BaulastWindowSearch", (Throwable)exception);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panSearch = new JPanel();
        this.panCommand = new JPanel();
        this.pnlAttributeFilter = new JPanel();
        this.chkGeloescht = new JCheckBox();
        this.chkGueltig = new JCheckBox();
        this.cbArt = new JComboBox();
        this.txtBlattnummer = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pnlFlurstuecksfilter = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstFlurstueck = new JList();
        this.btnAddFS = new JButton();
        this.btnRemoveFS = new JButton();
        this.btnFromMapFS = new JButton();
        this.chkBeguenstigt = new JCheckBox();
        this.chkBelastet = new JCheckBox();
        this.pnlSearchFor = new JPanel();
        this.rbBaulastBlaetter = new JRadioButton();
        this.rbBaulasten = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.chkKartenausschnitt = new JCheckBox();
        this.setMaximumSize(new Dimension(325, 460));
        this.setMinimumSize(new Dimension(325, 460));
        this.setPreferredSize(new Dimension(325, 460));
        this.setLayout(new BorderLayout());
        this.panSearch.setMaximumSize(new Dimension(400, 150));
        this.panSearch.setMinimumSize(new Dimension(400, 150));
        this.panSearch.setPreferredSize(new Dimension(400, 150));
        this.panSearch.setLayout(new GridBagLayout());
        this.panCommand.setLayout(new BoxLayout(this.panCommand, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panCommand, gridBagConstraints);
        this.pnlAttributeFilter.setBorder(BorderFactory.createTitledBorder("Attributfilter"));
        this.pnlAttributeFilter.setLayout(new GridBagLayout());
        this.chkGeloescht.setSelected(true);
        this.chkGeloescht.setText("gel\u00f6scht / geschlossen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.chkGeloescht, gridBagConstraints);
        this.chkGueltig.setSelected(true);
        this.chkGueltig.setText("g\u00fcltig");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.chkGueltig, gridBagConstraints);
        this.cbArt.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.cbArt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.txtBlattnummer, gridBagConstraints);
        this.jLabel1.setText("Blattnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Art der Baulast:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAttributeFilter.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.pnlAttributeFilter, gridBagConstraints);
        this.pnlFlurstuecksfilter.setBorder(BorderFactory.createTitledBorder("Flurst\u00fccksfilter"));
        this.pnlFlurstuecksfilter.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(new Dimension(200, 100));
        this.jScrollPane1.setMinimumSize(new Dimension(200, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane1.setViewportView(this.lstFlurstueck);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnAddFS.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-add.png")));
        this.btnAddFS.setToolTipText("Flurst\u00fcck hinzuf\u00fcgen");
        this.btnAddFS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastWindowSearch.this.btnAddFSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.btnAddFS, gridBagConstraints);
        this.btnRemoveFS.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-delete.png")));
        this.btnRemoveFS.setToolTipText("Ausgew\u00e4hlte Flurst\u00fccke entfernen");
        this.btnRemoveFS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastWindowSearch.this.btnRemoveFSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.btnRemoveFS, gridBagConstraints);
        this.btnFromMapFS.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/bookmark-new.png")));
        this.btnFromMapFS.setToolTipText("Selektierte Flurst\u00fccke aus Karte hinzuf\u00fcgen");
        this.btnFromMapFS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastWindowSearch.this.btnFromMapFSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.btnFromMapFS, gridBagConstraints);
        this.chkBeguenstigt.setSelected(true);
        this.chkBeguenstigt.setText("beg\u00fcnstigt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.chkBeguenstigt, gridBagConstraints);
        this.chkBelastet.setSelected(true);
        this.chkBelastet.setText("belastet");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFlurstuecksfilter.add((Component)this.chkBelastet, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.pnlFlurstuecksfilter, gridBagConstraints);
        this.pnlSearchFor.setBorder(BorderFactory.createTitledBorder("Suche nach"));
        this.pnlSearchFor.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.rbBaulastBlaetter);
        this.rbBaulastBlaetter.setSelected(true);
        this.rbBaulastBlaetter.setText("Baulastbl\u00e4tter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSearchFor.add((Component)this.rbBaulastBlaetter, gridBagConstraints);
        this.buttonGroup1.add(this.rbBaulasten);
        this.rbBaulasten.setText("Baulasten");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSearchFor.add((Component)this.rbBaulasten, gridBagConstraints);
        this.jPanel5.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.pnlSearchFor.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.pnlSearchFor, gridBagConstraints);
        this.chkKartenausschnitt.setText("<html>nur im aktuellen Kartenausschnitt suchen</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panSearch.add((Component)this.chkKartenausschnitt, gridBagConstraints);
        this.add((Component)this.panSearch, "Center");
    }

    private void btnAddFSActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> result = new ArrayList<CidsBean>(1);
        this.fsSelectionDialoge.setCurrentListToAdd(result);
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)this.fsSelectionDialoge, (boolean)true);
    }

    private void btnRemoveFSActionPerformed(ActionEvent evt) {
        Object[] selection;
        for (Object o : selection = this.lstFlurstueck.getSelectedValues()) {
            this.flurstuecksFilterModel.removeElement(o);
        }
    }

    private void btnFromMapFSActionPerformed(ActionEvent evt) {
        Collection selFeatures = CismapBroker.getInstance().getMappingComponent().getFeatureCollection().getSelectedFeatures();
        for (Feature feature : selFeatures) {
            CidsFeature cf;
            MetaObject mo;
            String tableName;
            if (!(feature instanceof CidsFeature) || !"FLURSTUECK".equalsIgnoreCase(tableName = (mo = (cf = (CidsFeature)feature).getMetaObject()).getMetaClass().getTableName()) && !"ALB_FLURSTUECK_KICKER".equalsIgnoreCase(tableName)) continue;
            this.flurstuecksFilterModel.addElement(mo.getBean());
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return "Baulast-Suche";
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    private BaulastSearchInfo getBaulastInfoFromGUI() {
        BaulastSearchInfo bsi = new BaulastSearchInfo();
        bsi.setResult(this.rbBaulastBlaetter.isSelected() ? CidsBaulastSearchStatement.Result.BAULASTBLATT : CidsBaulastSearchStatement.Result.BAULAST);
        if (this.chkKartenausschnitt.isSelected()) {
            XBoundingBox bb = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox();
            bsi.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)bb.getGeometry()));
        }
        bsi.setBelastet(this.chkBelastet.isSelected());
        bsi.setBeguenstigt(this.chkBeguenstigt.isSelected());
        bsi.setUngueltig(this.chkGeloescht.isSelected());
        bsi.setGueltig(this.chkGueltig.isSelected());
        bsi.setBlattnummer(this.txtBlattnummer.getText());
        Object art = this.cbArt.getSelectedItem();
        if (art != null) {
            bsi.setArt(art.toString());
        }
        return bsi;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        BaulastSearchInfo bsi = this.getBaulastInfoFromGUI();
        if (geometry != null) {
            bsi.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)geometry));
        }
        for (int i = 0; i < this.flurstuecksFilterModel.size(); ++i) {
            CidsBean fsBean = (CidsBean)this.flurstuecksFilterModel.getElementAt(i);
            try {
                if ("ALB_FLURSTUECK_KICKER".equalsIgnoreCase(fsBean.getMetaObject().getMetaClass().getTableName())) {
                    FlurstueckInfo fi = new FlurstueckInfo(((Integer)fsBean.getProperty("gemarkung")).intValue(), (String)fsBean.getProperty("flur"), (String)fsBean.getProperty("zaehler"), (String)fsBean.getProperty("nenner"));
                    bsi.getFlurstuecke().add(fi);
                    continue;
                }
                if (!"FLURSTUECK".equalsIgnoreCase(fsBean.getMetaObject().getMetaClass().getTableName())) continue;
                CidsBean gemarkung = (CidsBean)fsBean.getProperty("gemarkungs_nr");
                FlurstueckInfo fi = new FlurstueckInfo(((Integer)gemarkung.getProperty("gemarkungsnummer")).intValue(), (String)fsBean.getProperty("flur"), String.valueOf(fsBean.getProperty("fstnr_z")), String.valueOf(fsBean.getProperty("fstnr_n")));
                bsi.getFlurstuecke().add(fi);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Can not parse information from Flurstueck bean: " + fsBean), (Throwable)ex);
            }
        }
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALB_BAULAST", (ConnectionContext)this.getConnectionContext());
        int baulastClassID = mc.getID();
        mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALB_BAULASTBLATT", (ConnectionContext)this.getConnectionContext());
        int baulastblattClassID = mc.getID();
        return new CidsBaulastSearchStatement(bsi, baulastClassID, baulastblattClassID);
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        for (CidsBean bean : beans) {
            if ("FLURSTUECK".equalsIgnoreCase(bean.getMetaObject().getMetaClass().getTableName())) {
                this.flurstuecksFilterModel.addElement(bean);
            }
            this.lstFlurstueck.repaint();
        }
    }

    public boolean checkActionTag() {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "navigator.baulasten.search@WUNDA_BLAU", this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            log.error((Object)"Can not validate ActionTag for Baulasten Suche!", (Throwable)ex);
            return false;
        }
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        boolean keinKartenausschnitt;
        MetaObjectNodeServerSearch result = null;
        BaulastSearchInfo bsi = this.getBaulastInfoFromGUI();
        boolean keineBlattNummer = bsi.getBlattnummer() == null || bsi.getBlattnummer().trim().length() == 0;
        boolean keineArt = bsi.getArt() == null || bsi.getArt().trim().length() == 0;
        boolean keinFlurstueck = this.lstFlurstueck.getModel().getSize() == 0;
        boolean bl = keinKartenausschnitt = !this.chkKartenausschnitt.isSelected();
        if (keineBlattNummer && keinKartenausschnitt && keineArt && keinFlurstueck) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Ihre Suchanfrage ist nicht plausibel. Bitte pr\u00e4zisieren Sie die\nSuchanfrage durch weitere Angaben im Attribut- und Flurst\u00fccksfilter.", "Plausibilit\u00e4tskontrolle", 2);
        } else {
            result = this.getServerSearch();
        }
        return result;
    }

    public void searchStarted() {
    }

    public void searchDone(int results) {
        if (results > 0) {
            this.txtBlattnummer.setText("");
            this.cbArt.setSelectedItem("");
            this.chkKartenausschnitt.setSelected(false);
        }
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

