/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.MauernCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.MauernSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.MauernWindowSearchPanel;
import de.cismet.cids.custom.wunda_blau.search.abfrage.AbstractAbfrageWindowSearch;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMauernSearchStatement;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class MauernWindowSearch
extends AbstractAbfrageWindowSearch<MauernWindowSearchPanel, CidsMauernSearchStatement.Configuration>
implements PropertyChangeListener,
SearchControlListener {
    private static final String ACTION_TAG = "custom.mauern.search@WUNDA_BLAU";
    private static final Logger LOG = Logger.getLogger(MauernWindowSearch.class);
    private ImageIcon icon;

    public MauernWindowSearch() {
        super(new MauernWindowSearchPanel());
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    @Override
    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void searchDone(int numberOfResults) {
    }

    @Override
    public void searchCanceled() {
    }

    @Override
    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }

    @Override
    public GeoSearchButton createGeoSearchButton() {
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        MauernCreateSearchGeometryListener geometryListener = new MauernCreateSearchGeometryListener(mappingComponent, new MauernSearchTooltip(this.getIcon()));
        geometryListener.addPropertyChangeListener(this);
        return new GeoSearchButton("MAUERN_CREATE_SEARCH_GEOMETRY", mappingComponent, null, "Geo-Suche nach St\u00fctzmauern");
    }

    @Override
    public String getArtificialId() {
        return "mauer.abfragen";
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        ((MauernWindowSearchPanel)this.getSearchPanel()).initWithConnectionContext(connectionContext);
        MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"mauer", (ConnectionContext)this.getConnectionContext());
        byte[] iconDataFromMetaclass = new byte[]{};
        if (metaClass != null) {
            iconDataFromMetaclass = metaClass.getIconData();
        }
        if (iconDataFromMetaclass.length > 0) {
            LOG.info((Object)"Using icon from metaclass.");
            this.icon = new ImageIcon(metaClass.getIconData());
        } else {
            LOG.warn((Object)"Metaclass icon is not set. Trying to load default icon.");
            URL urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/search/search.png");
            this.icon = urlToIcon != null ? new ImageIcon(urlToIcon) : new ImageIcon(new byte[0]);
        }
    }

    @Override
    public MetaObjectNodeServerSearch createServerSearch(Geometry geometry) {
        return new CidsMauernSearchStatement(((MauernWindowSearchPanel)this.getSearchPanel()).createConfiguration(), geometry);
    }

    @Override
    public String getName() {
        return "Mauern-Suche";
    }
}

