/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.toolbaritem;

import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.navigator.utils.CidsClientToolbarItem;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.menu.CidsUiAction;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class WfAkukToolbarWidget
extends AbstractAction
implements CidsClientToolbarItem,
CidsUiAction,
ConnectionContextStore {
    private static final String PROPERTIES_FILE = "/de/cismet/cids/custom/wunda_blau/toolbaritem/wfAkuk.properties";
    private static final Logger LOG = Logger.getLogger(WfAkukToolbarWidget.class);
    private String akukClassKey;
    private String exchangeFile;
    private String exchangeDirectory;
    private String triggerExe;
    private String fs;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WfAkukToolbarWidget() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(PROPERTIES_FILE);
            props.load(is);
            this.fs = "";
            this.akukClassKey = props.getProperty("akukClassKey");
            this.exchangeFile = props.getProperty("exchangeFile");
            this.exchangeDirectory = props.getProperty("exchangeDirectory");
            this.triggerExe = props.getProperty("exchangeTriggerExe");
            this.fs = System.getProperty("file.separator");
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while reading WfAkuk properties file.", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"Error while closing WfAkuk properties file.", (Throwable)ex);
            }
        }
        this.putValue("ShortDescription", NbBundle.getMessage(WfAkukToolbarWidget.class, (String)"WfAkukToolbarWidget.WfAkukToolbarWidget().tooltip"));
        URL icon = this.getClass().getResource("/res/akuk.png");
        this.putValue("Name", NbBundle.getMessage(WfAkukToolbarWidget.class, (String)"WfAkukToolbarWidget.WfAkukToolbarWidget().name"));
        this.putValue("SwingLargeIconKey", new ImageIcon(icon));
    }

    public String getSorterString() {
        return "ZZZ";
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public Object getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "WfAkuk";
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block16: {
            Collection selectedNodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodes();
            Iterator it = selectedNodes.iterator();
            ArrayList<MetaObject> mos = new ArrayList<MetaObject>();
            try {
                while (it.hasNext()) {
                    DefaultMetaTreeNode node;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"selected node");
                    }
                    if ((node = (DefaultMetaTreeNode)it.next()) instanceof ObjectTreeNode) {
                        MetaObject mo = ((ObjectTreeNode)node).getMetaObject();
                        if (mo.getClassKey().equalsIgnoreCase(this.akukClassKey)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Metaobject hinzugefuegt");
                            }
                            mos.add(mo);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("falscher ClassKey:" + mo.getClassKey() + "=?=" + this.akukClassKey));
                        continue;
                    }
                    LOG.warn((Object)("Node ist kein ObjectTreeNode, sondern:" + node.getClass()));
                }
                if (mos.size() <= 0) break block16;
                String outString = "";
                for (MetaObject mo : mos) {
                    outString = outString + mo.getID() + "\r\n";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("outstring" + outString));
                }
                try {
                    String dir = this.exchangeDirectory;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Anlegen von:" + dir));
                    }
                    File dirFile = new File(dir);
                    dirFile.mkdirs();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("existiert=" + dirFile.exists()));
                    }
                    String outS = this.exchangeDirectory + this.fs + this.exchangeFile;
                    File outFile = new File(outS);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("existiert " + outS + " schon? =" + outFile.exists()));
                    }
                    BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
                    out.write(outString);
                    out.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Fehler beim Schreiben des WF-AKUK Exchange Files", e);
                }
                try {
                    ProcessBuilder pb = new ProcessBuilder(this.triggerExe);
                    pb.directory(new File(this.exchangeDirectory));
                    pb.start();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Fehler beim Aufruf der WF-AKUK triggerExe", t);
                }
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Unerwarteter Fehler im WF-AKUK-Plugin", t);
            }
        }
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.connectionContext = cc;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

