/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wupp.client.alkis;

import de.cismet.cids.custom.wupp.client.alkis.AbstractInputField;
import de.cismet.cids.custom.wupp.client.alkis.ParcelInputFieldConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ParcelInputField
extends AbstractInputField {
    public static final String PROP_CURRENT_PARCEL = "currentParcel";
    public static final String PROP_PARCEL_NUMBER = "parcelNumber";
    public static final String PROP_PARCEL_NUMERATOR = "parcelNumerator";
    public static final String PROP_PARCEL_DENOMINATOR = "parcelDenominator";
    public static final String PROP_VALID_PARCEL_NUMBER = "validParcelNr";
    private String currentParcel;
    private String parcelNumber;
    private String parcelNumerator;
    private String parcelDenominator;
    private boolean validParcelNr = false;
    private final ParcelInputFieldConfig config;
    private JLabel lblDelimitier1;
    private JLabel lblDelimitier2;
    private JLabel lblDelimitier3;
    private JTextField txtDistrict;
    private JTextField txtLandParcelDenominator;
    private JTextField txtLandParcelNumerator;
    private JTextField txtParcel;

    public ParcelInputField() {
        this(ParcelInputFieldConfig.FallbackConfig);
    }

    public ParcelInputField(final ParcelInputFieldConfig config) {
        super(config);
        this.config = config;
        this.initComponents();
        this.setTxtDistrict(this.txtDistrict);
        this.txtDistrict.setDocument(new AbstractInputField.DistrictPlainDocument(this, this.txtDistrict, this.txtParcel));
        this.txtParcel.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String newStr = str = str.replaceAll("[^-0-9_%]", "");
                if (str.length() > 0 && (str.length() > config.getMaxLenParcelNumberField() - offs || str.substring(0, Math.min(config.getMaxLenParcelNumberField() + 1 - offs, str.length())).contains(config.getDelimiter1AsString()))) {
                    String writeOverStr;
                    int pos = str.indexOf(config.getDelimiter1());
                    if (pos < 0 || pos > config.getMaxLenParcelNumberField() - offs) {
                        pos = config.getMaxLenParcelNumberField() - offs;
                    }
                    if (ParcelInputField.this.changeFocus) {
                        ParcelInputField.this.txtLandParcelNumerator.requestFocusInWindow();
                    }
                    newStr = str.substring(0, pos);
                    if (ParcelInputField.this.writeOver && !(writeOverStr = str.indexOf(config.getDelimiter1AsString()) == pos ? str.substring(pos + 1) : str.substring(pos)).isEmpty()) {
                        ParcelInputField.this.setOverwritten(true);
                        ParcelInputField.this.txtLandParcelNumerator.setText(writeOverStr);
                    }
                }
                super.insertString(offs, newStr, a);
                ParcelInputField.this.updateParcel();
            }
        });
        this.txtLandParcelNumerator.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String newStr = str = str.replaceAll("[^-0-9_%]", "");
                if (str.length() > 0 && (str.length() > config.getMaxLenParcelNumeratorField() - offs || str.substring(0, Math.min(config.getMaxLenParcelNumeratorField() + 1 - offs, str.length())).contains(config.getDelimiter1AsString()) || str.substring(0, Math.min(config.getMaxLenParcelNumeratorField() + 1 - offs, str.length())).contains(config.getDelimiter2AsString()))) {
                    String writeOverStr;
                    ParcelInputField.this.setOverwritten(true);
                    int pos = str.indexOf(config.getDelimiter1());
                    if (pos < 0 || pos > str.indexOf(config.getDelimiter2()) && str.indexOf(config.getDelimiter2()) >= 0) {
                        pos = str.indexOf(config.getDelimiter2());
                    }
                    if (pos < 0 || pos > config.getMaxLenParcelNumeratorField() - offs && config.getMaxLenParcelNumeratorField() - offs >= 0) {
                        pos = config.getMaxLenParcelNumeratorField() - offs;
                    }
                    if (ParcelInputField.this.changeFocus) {
                        ParcelInputField.this.txtLandParcelDenominator.requestFocusInWindow();
                    }
                    newStr = str.substring(0, pos);
                    if (ParcelInputField.this.writeOver && !(writeOverStr = str.indexOf(config.getDelimiter1AsString()) == pos || str.indexOf(config.getDelimiter2AsString()) == pos ? str.substring(pos + 1) : str.substring(pos)).isEmpty()) {
                        ParcelInputField.this.setOverwritten(true);
                        ParcelInputField.this.txtLandParcelDenominator.setText(writeOverStr);
                    }
                }
                super.insertString(offs, newStr, a);
                ParcelInputField.this.updateParcel();
            }
        });
        this.txtLandParcelDenominator.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null || str.isEmpty()) {
                    return;
                }
                if (offs + (str = str.replaceAll("[^0-9_%]", "")).length() > config.getMaxLenParcelDenominatorField()) {
                    str = str.substring(0, config.getMaxLenParcelDenominatorField() - offs);
                }
                super.insertString(offs, str, a);
                ParcelInputField.this.updateParcel();
            }
        });
    }

    @Override
    void updateResult() {
        this.updateParcel();
    }

    private void checkValidParcelNr() {
        String[] parts = this.currentParcel.split("[-/]");
        if (parts.length < 3 || parts.length > 4) {
            this.validParcelNr = false;
            return;
        }
        if (parts[0].matches("^05")) {
            if (!parts[0].matches("^05[0-9]{" + this.config.getMaxLenDistrictNumberField() + "}$")) {
                this.validParcelNr = false;
                return;
            }
        } else if (!parts[0].matches("^[0-9]{" + this.config.getMaxLenDistrictNumberField() + "}$")) {
            this.validParcelNr = false;
            return;
        }
        if (parts[1].contains("%")) {
            if (!parts[1].matches("^[0-9_%]{1," + this.config.getMaxLenParcelNumberField() + "}$")) {
                this.validParcelNr = false;
                return;
            }
        } else if (!parts[1].matches("^[0-9_]{" + this.config.getMaxLenParcelNumberField() + "}$")) {
            this.validParcelNr = false;
            return;
        }
        if (parts[2].contains("%")) {
            if (!parts[2].matches("^[0-9_%]{1," + this.config.getMaxLenParcelNumeratorField() + "}$")) {
                this.validParcelNr = false;
                return;
            }
        } else if (!parts[2].matches("^[0-9_]{" + this.config.getMaxLenParcelNumeratorField() + "}$")) {
            this.validParcelNr = false;
            return;
        }
        if (parts.length == 4) {
            if (parts[3].contains("%")) {
                if (!parts[3].matches("^[0-9_%]{1," + this.config.getMaxLenParcelDenominatorField() + "}$")) {
                    this.validParcelNr = false;
                    return;
                }
            } else if (!parts[3].matches("^[0-9_]{" + this.config.getMaxLenParcelDenominatorField() + "}$")) {
                this.validParcelNr = false;
                return;
            }
        }
        this.validParcelNr = true;
    }

    public String getCurrentParcel() {
        return this.currentParcel;
    }

    public void setCurrentParcel(String currentParcel) {
        this.changeFocus = false;
        this.txtDistrict.setText(currentParcel);
        this.finishDistrict();
        this.finishParcel();
        this.finishParcelNumerator();
        this.finishParcelDenominator();
        this.changeFocus = true;
    }

    public String getParcelDenominator() {
        return this.parcelDenominator;
    }

    public void setParcelDenominator(String parcelDenominator) {
        this.changeFocus = false;
        this.writeOver = false;
        this.txtLandParcelDenominator.setText(parcelDenominator);
        this.finishParcelDenominator();
        this.changeFocus = true;
        this.writeOver = true;
    }

    public String getParcelNumber() {
        return this.parcelNumber;
    }

    public void setParcelNumber(String parcelNumber) {
        this.changeFocus = false;
        this.writeOver = false;
        this.txtParcel.setText(parcelNumber);
        this.finishParcel();
        this.changeFocus = true;
        this.writeOver = true;
    }

    public String getParcelNumerator() {
        return this.parcelNumerator;
    }

    public void setParcelNumerator(String parcelNumerator) {
        this.changeFocus = false;
        this.writeOver = false;
        this.txtLandParcelNumerator.setText(parcelNumerator);
        this.finishParcelNumerator();
        this.changeFocus = true;
        this.writeOver = true;
    }

    private void updateParcel() {
        String oldParcel = this.currentParcel;
        StringBuilder sb = new StringBuilder();
        if (this.txtDistrict.getText() != null && !this.txtDistrict.getText().isEmpty()) {
            sb.append(this.txtDistrict.getText());
        }
        if (this.txtParcel.getText() != null && !this.txtParcel.getText().isEmpty()) {
            sb.append(this.config.getDelimiter1AsString()).append(this.txtParcel.getText());
        }
        if (this.txtLandParcelNumerator.getText() != null && !this.txtLandParcelNumerator.getText().isEmpty()) {
            sb.append(this.config.getDelimiter1AsString()).append(this.txtLandParcelNumerator.getText());
        }
        if (this.txtLandParcelDenominator.getText() != null && !this.txtLandParcelDenominator.getText().isEmpty() && !this.txtLandParcelDenominator.getText().matches("^0+$")) {
            sb.append(this.config.getDelimiter2AsString()).append(this.txtLandParcelDenominator.getText());
        }
        this.currentParcel = sb.toString();
        super.firePropertyChange(PROP_CURRENT_PARCEL, oldParcel, this.currentParcel);
        boolean oldValid = this.validParcelNr;
        this.checkValidParcelNr();
        if (oldValid != this.validParcelNr) {
            super.firePropertyChange(PROP_VALID_PARCEL_NUMBER, oldValid, this.validParcelNr);
        }
    }

    @Override
    void fireAreaBlockFinished(AbstractInputField.BlockType blockNr) {
        switch (blockNr) {
            case DISTRICT: {
                String oldValue = this.getDistrictNumber();
                this.setDistrictNumber(this.txtDistrict.getText());
                super.firePropertyChange("districtNumber", oldValue, this.getDistrictNumber());
                break;
            }
            case PARCEL: {
                String oldValue = this.parcelNumber;
                this.parcelNumber = this.txtParcel.getText();
                super.firePropertyChange(PROP_PARCEL_NUMBER, oldValue, this.parcelNumber);
                break;
            }
            case PARCEL_NUMERATOR: {
                String oldValue = this.parcelNumerator;
                this.parcelNumerator = this.txtLandParcelNumerator.getText();
                super.firePropertyChange(PROP_PARCEL_NUMERATOR, oldValue, this.parcelNumerator);
                break;
            }
            case PARCEL_DENOMINATOR: {
                String oldValue = this.parcelDenominator;
                this.parcelDenominator = this.txtLandParcelDenominator.getText();
                super.firePropertyChange(PROP_PARCEL_DENOMINATOR, oldValue, this.parcelDenominator);
            }
        }
    }

    private void finishParcel() {
        if (!this.txtParcel.getText().contains("%")) {
            this.addLeadingZeroes(this.txtParcel.getDocument(), this.config.getMaxLenParcelNumberField());
        }
        this.fireAreaBlockFinished(AbstractInputField.BlockType.PARCEL);
    }

    private void finishParcelNumerator() {
        if (!this.txtLandParcelNumerator.getText().contains("%")) {
            this.addLeadingZeroes(this.txtLandParcelNumerator.getDocument(), this.config.getMaxLenParcelNumeratorField());
        }
        this.fireAreaBlockFinished(AbstractInputField.BlockType.PARCEL_NUMERATOR);
    }

    private void finishParcelDenominator() {
        String text = this.txtLandParcelDenominator.getText();
        if (text != null && !text.isEmpty() && !this.txtLandParcelDenominator.getText().contains("%")) {
            this.addLeadingZeroes(this.txtLandParcelDenominator.getDocument(), this.config.getMaxLenParcelDenominatorField());
        }
        this.fireAreaBlockFinished(AbstractInputField.BlockType.PARCEL_DENOMINATOR);
    }

    private void initComponents() {
        this.txtDistrict = new JTextField();
        this.lblDelimitier1 = new JLabel(this.config.getDelimiter1AsString());
        this.txtParcel = new JTextField();
        this.lblDelimitier2 = new JLabel(this.config.getDelimiter1AsString());
        this.txtLandParcelNumerator = new JTextField();
        this.lblDelimitier3 = new JLabel(this.config.getDelimiter2AsString());
        this.txtLandParcelDenominator = new JTextField();
        this.setLayout(new GridBagLayout());
        this.txtDistrict.setHorizontalAlignment(0);
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.txtDistrict.getFont());
        Dimension dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxLenDistrictNumberField() + 4), this.txtDistrict.getPreferredSize().height);
        this.txtDistrict.setMinimumSize(dim);
        this.txtDistrict.setPreferredSize(dim);
        this.txtDistrict.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ParcelInputField.this.txtDistrictFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelInputField.this.txtDistrictFocusLost(evt);
            }
        });
        this.add((Component)this.txtDistrict, new GridBagConstraints());
        this.lblDelimitier1.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.lblDelimitier1, gridBagConstraints);
        this.txtParcel.setHorizontalAlignment(0);
        dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxLenParcelNumberField() + 2), this.txtParcel.getPreferredSize().height);
        this.txtParcel.setMinimumSize(dim);
        this.txtParcel.setPreferredSize(dim);
        this.txtParcel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ParcelInputField.this.txtParcelFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelInputField.this.txtParcelFocusLost(evt);
            }
        });
        this.add((Component)this.txtParcel, new GridBagConstraints());
        this.lblDelimitier2.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.lblDelimitier2, gridBagConstraints);
        this.txtLandParcelNumerator.setHorizontalAlignment(0);
        dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxLenParcelNumeratorField() + 2), this.txtLandParcelNumerator.getPreferredSize().height);
        this.txtLandParcelNumerator.setMinimumSize(dim);
        this.txtLandParcelNumerator.setPreferredSize(dim);
        this.txtLandParcelNumerator.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ParcelInputField.this.txtLandParcelNumeratorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelInputField.this.txtLandParcelNumeratorFocusLost(evt);
            }
        });
        this.add((Component)this.txtLandParcelNumerator, new GridBagConstraints());
        this.lblDelimitier3.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.lblDelimitier3, gridBagConstraints);
        this.txtLandParcelDenominator.setHorizontalAlignment(0);
        dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxLenParcelDenominatorField() + 2), this.txtLandParcelDenominator.getPreferredSize().height);
        this.txtLandParcelDenominator.setMinimumSize(dim);
        this.txtLandParcelDenominator.setPreferredSize(dim);
        this.txtLandParcelDenominator.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ParcelInputField.this.txtLandParcelDenominatorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelInputField.this.txtLandParcelDenominatorFocusLost(evt);
            }
        });
        this.add((Component)this.txtLandParcelDenominator, new GridBagConstraints());
    }

    private void txtDistrictFocusLost(FocusEvent evt) {
        this.finishDistrict();
        this.txtDistrict.setCaretPosition(0);
    }

    private void txtParcelFocusLost(FocusEvent evt) {
        this.finishParcel();
        this.txtParcel.setCaretPosition(0);
    }

    private void txtLandParcelNumeratorFocusLost(FocusEvent evt) {
        this.finishParcelNumerator();
        this.txtLandParcelNumerator.setCaretPosition(0);
    }

    private void txtLandParcelDenominatorFocusLost(FocusEvent evt) {
        this.finishParcelDenominator();
        this.txtLandParcelDenominator.setCaretPosition(0);
    }

    private void txtLandParcelDenominatorFocusGained(FocusEvent evt) {
        int textLenght = this.txtLandParcelDenominator.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtLandParcelDenominator.getHighlighter().removeAllHighlights();
            this.txtLandParcelDenominator.setCaretPosition(textLenght);
        } else {
            this.txtLandParcelDenominator.setCaretPosition(0);
            this.txtLandParcelDenominator.moveCaretPosition(textLenght);
        }
    }

    private void txtLandParcelNumeratorFocusGained(FocusEvent evt) {
        int textLength = this.txtLandParcelNumerator.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtLandParcelNumerator.getHighlighter().removeAllHighlights();
            this.txtLandParcelNumerator.setCaretPosition(textLength);
        } else {
            this.txtLandParcelNumerator.setCaretPosition(0);
            this.txtLandParcelNumerator.moveCaretPosition(textLength);
        }
    }

    private void txtParcelFocusGained(FocusEvent evt) {
        int textLength = this.txtParcel.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtParcel.getHighlighter().removeAllHighlights();
            this.txtParcel.setCaretPosition(textLength);
        } else {
            this.txtParcel.setCaretPosition(0);
            this.txtParcel.moveCaretPosition(textLength);
        }
    }

    private void txtDistrictFocusGained(FocusEvent evt) {
        int textLength = this.txtDistrict.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtDistrict.getHighlighter().removeAllHighlights();
            this.txtDistrict.setCaretPosition(textLength);
        } else {
            this.txtDistrict.setCaretPosition(0);
            this.txtDistrict.moveCaretPosition(textLength);
        }
    }
}

