/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.butler;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;

import com.fasterxml.jackson.databind.ObjectMapper;

import com.vividsolutions.jts.geom.Geometry;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Property;

import org.openide.util.Exceptions;

import java.io.IOException;

import java.util.ArrayList;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.cismet.cids.custom.nas.NasFeeCalculator;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerResolution;
import de.cismet.cids.custom.wunda_blau.search.actions.NasZaehlObjekteServerAction;

import de.cismet.cids.server.actions.ServerActionParameter;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.StaticDecimalTools;

/**
 * DOCUMENT ME!
 *
 * @author   daniel
 * @version  $Revision$, $Date$
 */
public class Butler1ProductPanel extends javax.swing.JPanel implements ListSelectionListener, ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(Butler1ProductPanel.class);

    //~ Instance fields --------------------------------------------------------

    ArrayList<ButlerProductGroup> productGroups;
    ArrayList<ButlerProduct> products;
    ArrayList<ButlerResolution> resolutions;
    ArrayList<ButlerResolution> defaultGroupResolutions;
    ArrayList<ButlerFormat> formats;
    private Geometry geom;

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup btGroupFormat;
    private javax.swing.JComboBox cbProduktGruppe;
    private javax.swing.JComboBox cbResolution;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel lblAuflösung;
    private javax.swing.JLabel lblFiller;
    private javax.swing.JLabel lblFormat;
    private javax.swing.JLabel lblProdukt;
    private javax.swing.JLabel lblProduktGruppe;
    private javax.swing.JLabel lblVolumeParam;
    private javax.swing.JLabel lblVolumeParamKey;
    private javax.swing.JLabel lblVolumeParamTitle;
    private javax.swing.JList lstProdukt;
    private javax.swing.JPanel pnlFeeParrameter;
    private javax.swing.JPanel pnlFormat;
    private javax.swing.JRadioButton rbDxf;
    private javax.swing.JRadioButton rbGeoTif;
    private javax.swing.JRadioButton rbShp;
    private javax.swing.JRadioButton rbTif;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new Butler1ProductPanel object.
     */
    public Butler1ProductPanel() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        loadPrductDescriptions();
        initComponents();
        lstProdukt.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        lstProdukt.addListSelectionListener(this);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        btGroupFormat = new javax.swing.ButtonGroup();
        lblProduktGruppe = new javax.swing.JLabel();
        cbProduktGruppe = new javax.swing.JComboBox();
        lblProdukt = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lstProdukt = new javax.swing.JList();
        lblFormat = new javax.swing.JLabel();
        pnlFormat = new javax.swing.JPanel();
        rbDxf = new javax.swing.JRadioButton();
        rbShp = new javax.swing.JRadioButton();
        rbTif = new javax.swing.JRadioButton();
        rbGeoTif = new javax.swing.JRadioButton();
        lblFiller = new javax.swing.JLabel();
        lblAuflösung = new javax.swing.JLabel();
        cbResolution = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        pnlFeeParrameter = new javax.swing.JPanel();
        lblVolumeParamTitle = new javax.swing.JLabel();
        lblVolumeParamKey = new javax.swing.JLabel();
        lblVolumeParam = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        setBorder(null);
        setMinimumSize(new java.awt.Dimension(400, 291));
        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            lblProduktGruppe,
            org.openide.util.NbBundle.getMessage(
                Butler1ProductPanel.class,
                "Butler1ProductPanel.lblProduktGruppe.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 40);
        add(lblProduktGruppe, gridBagConstraints);

        org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${productGroups}");
        org.jdesktop.swingbinding.JComboBoxBinding jComboBoxBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJComboBoxBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        cbProduktGruppe);
        bindingGroup.addBinding(jComboBoxBinding);

        cbProduktGruppe.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbProduktGruppeActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 10);
        add(cbProduktGruppe, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblProdukt,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.lblProdukt.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 40);
        add(lblProdukt, gridBagConstraints);

        jScrollPane1.setMinimumSize(new java.awt.Dimension(250, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(258, 150));

        eLProperty = org.jdesktop.beansbinding.ELProperty.create("${products}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        lstProdukt,
                        "productBinding");
        bindingGroup.addBinding(jListBinding);

        jScrollPane1.setViewportView(lstProdukt);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 10);
        add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFormat,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.lblFormat.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 40);
        add(lblFormat, gridBagConstraints);

        pnlFormat.setLayout(new java.awt.GridBagLayout());

        btGroupFormat.add(rbDxf);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbDxf,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.rbDxf.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbDxf, gridBagConstraints);

        btGroupFormat.add(rbShp);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbShp,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.rbShp.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbShp, gridBagConstraints);

        btGroupFormat.add(rbTif);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbTif,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.rbTif.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbTif, gridBagConstraints);

        btGroupFormat.add(rbGeoTif);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbGeoTif,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.rbGeoTif.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbGeoTif, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFiller,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.lblFiller.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlFormat.add(lblFiller, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 10);
        add(pnlFormat, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblAuflösung,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.lblAuflösung.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 40);
        add(lblAuflösung, gridBagConstraints);

        eLProperty = org.jdesktop.beansbinding.ELProperty.create("${resolutions}");
        jComboBoxBinding = org.jdesktop.swingbinding.SwingBindings.createJComboBoxBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                eLProperty,
                cbResolution,
                "resolutionBinding");
        bindingGroup.addBinding(jComboBoxBinding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        add(cbResolution, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(jSeparator1, gridBagConstraints);

        pnlFeeParrameter.setBackground(new java.awt.Color(255, 255, 255));
        pnlFeeParrameter.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        pnlFeeParrameter.setLayout(new java.awt.GridBagLayout());

        lblVolumeParamTitle.setFont(new java.awt.Font("DejaVu Sans", 1, 14)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            lblVolumeParamTitle,
            org.openide.util.NbBundle.getMessage(
                Butler1ProductPanel.class,
                "Butler1ProductPanel.lblVolumeParamTitle.text"));             // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 20, 10);
        pnlFeeParrameter.add(lblVolumeParamTitle, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblVolumeParamKey,
            org.openide.util.NbBundle.getMessage(
                Butler1ProductPanel.class,
                "Butler1ProductPanel.lblVolumeParamKey.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        pnlFeeParrameter.add(lblVolumeParamKey, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblVolumeParam,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.lblVolumeParam.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        pnlFeeParrameter.add(lblVolumeParam, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(Butler1ProductPanel.class, "Butler1ProductPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        pnlFeeParrameter.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        add(pnlFeeParrameter, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbProduktGruppeActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbProduktGruppeActionPerformed
        final ButlerProductGroup productGroup = ((ButlerProductGroup)cbProduktGruppe.getSelectedItem());
        if (productGroup != null) {
            final Binding productBinding = bindingGroup.getBinding("productBinding");
            final Property productProp = productBinding.getSourceProperty();
            productProp.setValue(this, productGroup.getButlerProducts());
            final Binding resolutionBinding = bindingGroup.getBinding("resolutionBinding");
            final Property resolutionProp = resolutionBinding.getSourceProperty();
            resolutionProp.setValue(this, productGroup.getButlerResolutions());
            defaultGroupResolutions = productGroup.getButlerResolutions();
            productGroup.getButlerFormats();
            updateFormatButtons(productGroup.getButlerFormats());
        }
    }                                                                                   //GEN-LAST:event_cbProduktGruppeActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void loadPrductDescriptions() {
        try {
            final ObjectMapper mapper = new ObjectMapper();
            final ButlerProductInfo tester = mapper.readValue(ButlerProductInfo.class.getResourceAsStream(
                        "/de/cismet/cids/custom/butler/productDescription.json"),
                    ButlerProductInfo.class);
            productGroups = tester.getButler1ProductGroups();
            products = productGroups.get(0).getButlerProducts();
            resolutions = productGroups.get(0).getButlerResolutions();
        } catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<ButlerProductGroup> getProductGroups() {
        return productGroups;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  productGroups  DOCUMENT ME!
     */
    public void setProductGroups(final ArrayList<ButlerProductGroup> productGroups) {
        this.productGroups = productGroups;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<ButlerProduct> getProducts() {
        return products;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ButlerProduct getSelectedProduct() {
        final ButlerProduct bp = (ButlerProduct)lstProdukt.getSelectedValue();
        if (bp != null) {
            if (rbDxf.isSelected()) {
                bp.setFormat(new ButlerFormat("dxf"));
            } else if (rbGeoTif.isSelected()) {
                bp.setFormat(new ButlerFormat("geotif"));
            } else if (rbShp.isSelected()) {
                bp.setFormat(new ButlerFormat("shp"));
            } else if (rbTif.isSelected()) {
                bp.setFormat(new ButlerFormat("tif"));
            }
            final ButlerResolution res = (ButlerResolution)cbResolution.getSelectedItem();
            bp.setResolution(res);
        }
        return bp;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  products  args products DOCUMENT ME!
     */
    public void setProducts(final ArrayList<ButlerProduct> products) {
        this.products = products;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<ButlerResolution> getResolutions() {
        return resolutions;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  resolution  args resolution DOCUMENT ME!
     */
    public void setResolutions(final ArrayList<ButlerResolution> resolution) {
        this.resolutions = resolution;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  allowedButlerFormats  DOCUMENT ME!
     */
    private void updateFormatButtons(final ArrayList<ButlerFormat> allowedButlerFormats) {
        // remove selection for all
        btGroupFormat.clearSelection();

        // set them all disabled
        rbDxf.setEnabled(false);
        rbGeoTif.setEnabled(false);
        rbShp.setEnabled(false);
        rbTif.setEnabled(false);

//        enable the ones that are currentyl allowed
        for (final ButlerFormat f : allowedButlerFormats) {
            if (f.getKey().equals("TIF")) {
                rbTif.setEnabled(true);
            } else if (f.getKey().equals("GEOTIF")) {
                rbGeoTif.setEnabled(true);
            } else if (f.getKey().equals("DXF")) {
                rbDxf.setEnabled(true);
            } else if (f.getKey().equals("SHAPE")) {
                rbShp.setEnabled(true);
            }
        }
    }

    @Override
    public void valueChanged(final ListSelectionEvent e) {
        final ButlerProduct selectedProduct = (ButlerProduct)lstProdukt.getSelectedValue();
        if (selectedProduct != null) {
            final String text = (selectedProduct.getVolumeParamText() == null) ? ""
                                                                               : selectedProduct.getVolumeParamText();
            lblVolumeParamKey.setText(text);
            calculateVolumePram();
            // the product can ovverride the resolutions...
            if ((selectedProduct.getButlerResolutions() != null) && !selectedProduct.getButlerResolutions().isEmpty()) {
                final Binding resolutionBinding = bindingGroup.getBinding("resolutionBinding");
                final Property resolutionProp = resolutionBinding.getSourceProperty();
                resolutionProp.setValue(this, selectedProduct.getButlerResolutions());
            } else {
                final Binding resolutionBinding = bindingGroup.getBinding("resolutionBinding");
                final Property resolutionProp = resolutionBinding.getSourceProperty();
                resolutionProp.setValue(this, defaultGroupResolutions);
            }
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void calculateVolumePram() {
        final ButlerProduct product = (ButlerProduct)lstProdukt.getSelectedValue();
        if ((product == null) || (geom == null)) {
            lblVolumeParam.setText("0");
            return;
        }
        final String productKey = product.getKey();
        if (productKey != null) {
            String volumeParamText = "";
            if (productKey.equals("0108")) {
                volumeParamText = getDachPunkteCount();
            } else if (productKey.equals("0109")) {
                volumeParamText = getBodenPuntkeCount();
            } else if (productKey.equals("0501")) {
                volumeParamText = getGebauedeCount();
            } else if (productKey.equals("0502")) {
                volumeParamText = getFlurstueckeCount();
            } else if (productKey.equals("0503")) {
                volumeParamText = getAdressCount();
            } else {
                volumeParamText = getFlaeche();
            }
            lblVolumeParam.setText(volumeParamText);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  g  DOCUMENT ME!
     */
    public void setGeometry(final Geometry g) {
        geom = g;
        calculateVolumePram();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getDachPunkteCount() {
        if (geom != null) {
            final int dachPunkteCount;
            try {
                dachPunkteCount = NasFeeCalculator.getDachPunkteAmount(geom, getConnectionContext());
                return "" + dachPunkteCount;
            } catch (ConnectionException ex) {
                LOG.error("Error during Dachpunkte search in butler 1 prduct panel", ex);
            }
        }
        return "0";
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getBodenPuntkeCount() {
        if (geom != null) {
            final int bodenPuntkeCount;
            try {
                bodenPuntkeCount = NasFeeCalculator.getBodenPunkteAmount(geom, getConnectionContext());
                return "" + bodenPuntkeCount;
            } catch (ConnectionException ex) {
                LOG.error("Error during Dachpunkte search in butler 1 prduct panel", ex);
            }
        }
        return "0";
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getGebauedeCount() {
        if (geom != null) {
            final int gebaeudeCount;
            try {
                gebaeudeCount = NasFeeCalculator.getGebaeudeAmount(geom, getConnectionContext());
                return "" + gebaeudeCount;
            } catch (ConnectionException ex) {
                LOG.error("Error during Gebaeude search in butler 1 prduct panel", ex);
            }
        }
        return "0";
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getFlurstueckeCount() {
        if (geom != null) {
            final int flurstueckCount;
            try {
                flurstueckCount = NasFeeCalculator.getFlurstueckAmount(geom, getConnectionContext());
                return "" + flurstueckCount;
            } catch (ConnectionException ex) {
                LOG.error("Error during Flurstuecksearch in butler 1 prduct panel");
            }
        }
        return "0";
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getAdressCount() {
        if (geom != null) {
            final ArrayList<Integer> c;
            try {
                final ServerActionParameter sapType =
                    new ServerActionParameter<NasZaehlObjekteServerAction.NasSearchType>(
                        NasZaehlObjekteServerAction.Parameter.SEARCH_TYPE.toString(),
                        NasZaehlObjekteServerAction.NasSearchType.ADRESSE);
                final ServerActionParameter sapGeom = new ServerActionParameter<Geometry>(
                        NasZaehlObjekteServerAction.Parameter.GEOMETRY.toString(),
                        geom);
                c = (ArrayList<Integer>)SessionManager.getProxy()
                            .executeTask(
                                    NasZaehlObjekteServerAction.TASK_NAME,
                                    "WUNDA_BLAU",
                                    (Object)null,
                                    getConnectionContext(),
                                    sapType,
                                    sapGeom);
                return "" + c.get(0);
            } catch (ConnectionException ex) {
                Exceptions.printStackTrace(ex);
            }
            return "0";
        }
        return "0";
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getFlaeche() {
        if (geom == null) {
            return null;
        }
        final double areaInKm = geom.getArea() / (1000 * 1000);
        return StaticDecimalTools.round("0.0##", areaInKm);
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
