/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * LSAFeatureRenderer.java
 *
 * Created on 1. Juni 2007, 10:15
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;

import java.util.Properties;

import javax.swing.JComponent;

import de.cismet.cids.featurerenderer.*;

import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;

/**
 * DOCUMENT ME!
 *
 * @author   hell
 * @version  $Revision$, $Date$
 */
public class Bplan_planFeatureRenderer extends CustomCidsFeatureRenderer {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            Bplan_planFeatureRenderer.class);

    //~ Instance fields --------------------------------------------------------

    private Properties properties = new Properties();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel lblImagePreview;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new BebauungsplanPlanfeatureRenderer object.
     */
    public Bplan_planFeatureRenderer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bplan_planFeatureRenderer init()");
        }
        initComponents();
        setOpaque(false);
        setPreferredSize(new Dimension(150, 150));
        try {
            properties.load(getClass().getResourceAsStream("/renderer.properties"));
        } catch (Exception e) {
            LOG.warn("Fehler beim Laden der Properties", e);
        }
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void assign() {
        this.cidsBean = metaObject.getBean();
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    @Override
    public Paint getFillingStyle() {
        return new Color(255, 255, 255, 0);
    }

    @Override
    public Stroke getLineStyle() {
        final String qualitaet = (String)cidsBean.getProperty("qualitaet");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bplan_planFeatureRenderer GetLineStyle " + qualitaet);
        }
        if (qualitaet == null) {
            return new BasicStroke(20.0f);
        } else {
            if (qualitaet.equals("geprüft")) {
                return new CustomFixedWidthStroke(5.0f);
            }
            return new CustomFixedWidthStroke(10.0f);
        }
    }

    @Override
    public Paint getLinePaint() {
        final String status = (String)cidsBean.getProperty("status");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bplan_planFeatureRenderer GetLinePaint " + status);
        }
        if (status == null) {
            return new Color(0, 0, 0, 255);
        } else {
            if ("rechtskräftig".equals(status)) {
                return new Color(0, 255, 0, 50);
            }
            return new Color(255, 0, 0, 50);
        }
    }

    @Override
    public JComponent getInfoComponent(final Refreshable arg0) {
        super.getInfoComponent(arg0);
        return null;
    }

    @Override
    public String getAlternativeName() {
        return (String)cidsBean.getProperty("nummer");
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        lblImagePreview = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        setPreferredSize(new java.awt.Dimension(100, 100));
        setLayout(new java.awt.BorderLayout());

        lblImagePreview.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblImagePreview.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png"))); // NOI18N
        lblImagePreview.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseExited(final java.awt.event.MouseEvent evt) {
                    lblImagePreviewMouseExited(evt);
                }
                @Override
                public void mouseEntered(final java.awt.event.MouseEvent evt) {
                    lblImagePreviewMouseEntered(evt);
                }
            });
        add(lblImagePreview, java.awt.BorderLayout.CENTER);

        jLabel12.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel12.setText("Höhere Auflösung durch Mausklick.");
        add(jLabel12, java.awt.BorderLayout.PAGE_END);
    } // </editor-fold>//GEN-END:initComponents
    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblImagePreviewMouseExited(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblImagePreviewMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }                                                                              //GEN-LAST:event_lblImagePreviewMouseExited

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblImagePreviewMouseEntered(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblImagePreviewMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }                                                                               //GEN-LAST:event_lblImagePreviewMouseEntered
}
