/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.MetaObject;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.error.ErrorInfo;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;

import java.net.URL;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

import javax.imageio.ImageIO;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.cismet.cids.custom.objecteditors.utils.KlimaConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.security.WebAccessManager;

import de.cismet.tools.BrowserLauncher;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   sandra
 * @version  $Revision$, $Date$
 */
public class KlimaAngebotPanel extends javax.swing.JPanel implements Disposable,
    CidsBeanStore,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    public static final int FOTO_WIDTH = 150;

    private static final Logger LOG = Logger.getLogger(KlimaAngebotPanel.class);

    public static final String FIELD__KATEGORIE = "arr_kategorie"; // klima_kategorie
    public static final String LABEL__NAME_HP = "lblUrlHpCheck";

    public static final String BUNDLE_KAT_QUESTION = "KlimaAngebotPanel.btnRemoveKategorieActionPerformed().question";
    public static final String BUNDLE_KAT_TITLE = "KlimaAngebotPanel.btnRemoveKategorieActionPerformed().title";
    public static final String BUNDLE_KAT_ERRORTITLE =
        "KlimaAngebotPanel.btnRemoveKategorieActionPerformed().errortitle";
    public static final String BUNDLE_KAT_ERRORTEXT = "KlimaAngebotPanel.btnRemoveKategorieActionPerformed().errortext";
    public static final String BUNDLE_NOLOAD = "KlimaAngebotPanel.loadPictureWithUrl().noLoad";
    public static final String BUNDLE_NOFOTO = "KlimaAngebotPanel.doWithFotoUrl().noFoto";

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        dlgAddKategorie = new JDialog();
        panAddKategorie = new JPanel();
        lblAuswaehlenKategorie = new JLabel();
        final MetaObject[] kategorie = ObjectRendererUtils.getLightweightMetaObjectsForTable(
                "klima_kategorie",
                new String[] { "name" },
                getConnectionContext());
        if (kategorie != null) {
            Arrays.sort(kategorie);
            cbKategorie = new JComboBox(kategorie);
        }
        panMenButtonsKategorie = new JPanel();
        btnMenAbortKategorie = new JButton();
        btnMenOkKategorie = new JButton();
        panAngebot = new JPanel();
        lblKategorie = new JLabel();
        final JPanel panKategorie = new JPanel();
        final JScrollPane scpKategorie = new JScrollPane();
        lstKategorie = new JList();
        panButtonsKategorie = new JPanel();
        btnAddKategorie = new JButton();
        btnRemoveKategorie = new JButton();
        final Box.Filler filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        lblBeschreibungA = new JLabel();
        final JPanel panBeschreibungA = new JPanel();
        final JScrollPane scpBeschreibungA = new JScrollPane();
        taBeschreibungA = new JTextArea();
        lblBemerkung = new JLabel();
        final JPanel panBemerkung = new JPanel();
        final JScrollPane scpBemerkung = new JScrollPane();
        taBemerkung = new JTextArea();
        lblKommentar = new JLabel();
        final JPanel panKommentar = new JPanel();
        final JScrollPane scpKommentar = new JScrollPane();
        taKommentar = new JTextArea();
        lblOnline = new JLabel();
        chOnline = new JCheckBox();
        lblFoto = new JLabel();
        txtFoto = new JTextField();
        panUrl = new JPanel();
        lblUrlCheck = new JLabel();
        lblFotoAnzeigen = new JLabel();
        lblHomepage = new JLabel();
        final JPanel panHomepage = new JPanel();
        hlHomepage = new JXHyperlink();
        tfHomepage = new JTextField();
        final JPanel panUrlHp = new JPanel();
        lblUrlHpCheck = new JLabel();
        final Box.Filler filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(32767, 0));

        final FormListener formListener = new FormListener();

        dlgAddKategorie.setTitle("Kategorie auswählen");
        dlgAddKategorie.setModal(true);
        dlgAddKategorie.setName("dlgAddKategorie"); // NOI18N

        panAddKategorie.setName("panAddKategorie"); // NOI18N
        panAddKategorie.setLayout(new GridBagLayout());

        lblAuswaehlenKategorie.setText("Bitte eine Kategorie auswählen:");
        lblAuswaehlenKategorie.setName("lblAuswaehlenKategorie"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        panAddKategorie.add(lblAuswaehlenKategorie, gridBagConstraints);

        cbKategorie.setName("cbKategorie"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panAddKategorie.add(cbKategorie, gridBagConstraints);

        panMenButtonsKategorie.setName("panMenButtonsKategorie"); // NOI18N
        panMenButtonsKategorie.setLayout(new GridBagLayout());

        btnMenAbortKategorie.setText("Abbrechen");
        btnMenAbortKategorie.setName("btnMenAbortKategorie"); // NOI18N
        btnMenAbortKategorie.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panMenButtonsKategorie.add(btnMenAbortKategorie, gridBagConstraints);

        btnMenOkKategorie.setText("OK");
        btnMenOkKategorie.setName("btnMenOkKategorie"); // NOI18N
        btnMenOkKategorie.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panMenButtonsKategorie.add(btnMenOkKategorie, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panAddKategorie.add(panMenButtonsKategorie, gridBagConstraints);

        dlgAddKategorie.getContentPane().add(panAddKategorie, BorderLayout.CENTER);

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        panAngebot.setName("panAngebot"); // NOI18N
        panAngebot.setOpaque(false);
        panAngebot.setLayout(new GridBagLayout());

        lblKategorie.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblKategorie, "Kategorie:");
        lblKategorie.setName("lblKategorie");            // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblKategorie, gridBagConstraints);

        panKategorie.setName("panKategorie"); // NOI18N
        panKategorie.setOpaque(false);
        panKategorie.setLayout(new GridBagLayout());

        scpKategorie.setMinimumSize(new Dimension(258, 66));
        scpKategorie.setName("scpKategorie"); // NOI18N

        lstKategorie.setFont(new Font("Dialog", 0, 12)); // NOI18N
        lstKategorie.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        lstKategorie.setName("lstKategorie");            // NOI18N
        lstKategorie.setVisibleRowCount(3);

        final ELProperty eLProperty = ELProperty.create("${cidsBean.arr_kategorie}");
        final JListBinding jListBinding = SwingBindings.createJListBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                eLProperty,
                lstKategorie);
        bindingGroup.addBinding(jListBinding);

        scpKategorie.setViewportView(lstKategorie);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panKategorie.add(scpKategorie, gridBagConstraints);

        panButtonsKategorie.setName("panButtonsKategorie"); // NOI18N
        panButtonsKategorie.setOpaque(false);
        panButtonsKategorie.setLayout(new GridBagLayout());

        btnAddKategorie.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png"))); // NOI18N
        btnAddKategorie.setName("btnAddKategorie");                                                            // NOI18N
        btnAddKategorie.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        panButtonsKategorie.add(btnAddKategorie, gridBagConstraints);

        btnRemoveKategorie.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png"))); // NOI18N
        btnRemoveKategorie.setName("btnRemoveKategorie");                                                         // NOI18N
        btnRemoveKategorie.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        panButtonsKategorie.add(btnRemoveKategorie, gridBagConstraints);

        filler1.setName("filler1"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        panButtonsKategorie.add(filler1, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        panKategorie.add(panButtonsKategorie, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        panAngebot.add(panKategorie, gridBagConstraints);

        lblBeschreibungA.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblBeschreibungA, "Beschreibung:");
        lblBeschreibungA.setName("lblBeschreibungA");        // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblBeschreibungA, gridBagConstraints);

        panBeschreibungA.setName("panBeschreibungA"); // NOI18N
        panBeschreibungA.setOpaque(false);
        panBeschreibungA.setLayout(new GridBagLayout());

        scpBeschreibungA.setName("scpBeschreibungA"); // NOI18N

        taBeschreibungA.setColumns(20);
        taBeschreibungA.setLineWrap(true);
        taBeschreibungA.setRows(2);
        taBeschreibungA.setWrapStyleWord(true);
        taBeschreibungA.setName("taBeschreibungA"); // NOI18N

        Binding binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.beschreibung}"),
                taBeschreibungA,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scpBeschreibungA.setViewportView(taBeschreibungA);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panBeschreibungA.add(scpBeschreibungA, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panBeschreibungA, gridBagConstraints);

        lblBemerkung.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblBemerkung, "Bemerkung:");
        lblBemerkung.setName("lblBemerkung");            // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblBemerkung, gridBagConstraints);

        panBemerkung.setName("panBemerkung"); // NOI18N
        panBemerkung.setOpaque(false);
        panBemerkung.setLayout(new GridBagLayout());

        scpBemerkung.setName("scpBemerkung"); // NOI18N

        taBemerkung.setColumns(20);
        taBemerkung.setLineWrap(true);
        taBemerkung.setRows(2);
        taBemerkung.setWrapStyleWord(true);
        taBemerkung.setName("taBemerkung"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.bemerkung}"),
                taBemerkung,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scpBemerkung.setViewportView(taBemerkung);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panBemerkung.add(scpBemerkung, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panBemerkung, gridBagConstraints);

        lblKommentar.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblKommentar, "Kommentar:");
        lblKommentar.setName("lblKommentar");            // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblKommentar, gridBagConstraints);

        panKommentar.setName("panKommentar"); // NOI18N
        panKommentar.setOpaque(false);
        panKommentar.setLayout(new GridBagLayout());

        scpKommentar.setName("scpKommentar"); // NOI18N

        taKommentar.setColumns(20);
        taKommentar.setLineWrap(true);
        taKommentar.setRows(2);
        taKommentar.setWrapStyleWord(true);
        taKommentar.setName("taKommentar"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.kommentar}"),
                taKommentar,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scpKommentar.setViewportView(taKommentar);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panKommentar.add(scpKommentar, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panKommentar, gridBagConstraints);

        lblOnline.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblOnline, "Online:");
        lblOnline.setName("lblOnline");               // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblOnline, gridBagConstraints);

        chOnline.setContentAreaFilled(false);
        chOnline.setName("chOnline"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.online}"),
                chOnline,
                BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(chOnline, gridBagConstraints);

        lblFoto.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblFoto, "Foto:");
        lblFoto.setName("lblFoto");                 // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblFoto, gridBagConstraints);

        txtFoto.setName("txtFoto"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.bild}"),
                txtFoto,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(txtFoto, gridBagConstraints);

        panUrl.setName("panUrl"); // NOI18N
        panUrl.setOpaque(false);
        panUrl.setLayout(new GridBagLayout());

        lblUrlCheck.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"))); // NOI18N
        lblUrlCheck.setName("lblUrlCheck");                                                                  // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        panUrl.add(lblUrlCheck, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panUrl, gridBagConstraints);

        lblFotoAnzeigen.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblFotoAnzeigen, "Foto anzeigen");
        lblFotoAnzeigen.setName("lblFotoAnzeigen");         // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        panAngebot.add(lblFotoAnzeigen, gridBagConstraints);

        lblHomepage.setFont(new Font("Tahoma", 1, 11)); // NOI18N
        Mnemonics.setLocalizedText(lblHomepage, "Homepage:");
        lblHomepage.setName("lblHomepage");             // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panAngebot.add(lblHomepage, gridBagConstraints);

        panHomepage.setMaximumSize(new Dimension(500, 2147483647));
        panHomepage.setName("panHomepage"); // NOI18N
        panHomepage.setOpaque(false);
        panHomepage.setPreferredSize(new Dimension(500, 32));
        panHomepage.setLayout(new GridBagLayout());

        hlHomepage.setName("hlHomepage"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.website}"),
                hlHomepage,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.website}"),
                hlHomepage,
                BeanProperty.create("toolTipText"));
        bindingGroup.addBinding(binding);

        hlHomepage.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        panHomepage.add(hlHomepage, gridBagConstraints);

        tfHomepage.setName("tfHomepage"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.website}"),
                tfHomepage,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        panHomepage.add(tfHomepage, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panHomepage, gridBagConstraints);

        panUrlHp.setName("panUrlHp"); // NOI18N
        panUrlHp.setOpaque(false);
        panUrlHp.setLayout(new GridBagLayout());

        lblUrlHpCheck.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"))); // NOI18N
        lblUrlHpCheck.setName("lblUrlHpCheck");                                                              // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        panUrlHp.add(lblUrlHpCheck, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panAngebot.add(panUrlHp, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        add(panAngebot, gridBagConstraints);

        filler3.setName("filler3"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        add(filler3, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements ActionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent evt) {
            if (evt.getSource() == btnAddKategorie) {
                KlimaAngebotPanel.this.btnAddKategorieActionPerformed(evt);
            } else if (evt.getSource() == btnRemoveKategorie) {
                KlimaAngebotPanel.this.btnRemoveKategorieActionPerformed(evt);
            } else if (evt.getSource() == btnMenAbortKategorie) {
                KlimaAngebotPanel.this.btnMenAbortKategorieActionPerformed(evt);
            } else if (evt.getSource() == btnMenOkKategorie) {
                KlimaAngebotPanel.this.btnMenOkKategorieActionPerformed(evt);
            } else if (evt.getSource() == hlHomepage) {
                KlimaAngebotPanel.this.hlHomepageActionPerformed(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    private final boolean isEditor;
    private final KlimaStandortEditor parentEditor;
    private final ConnectionContext connectionContext;
    private CidsBean cidsBean;
    private SwingWorker worker_loadFoto;
    private SwingWorker worker_hp;
    private SwingWorker worker_foto;

    private final ImageIcon statusFalsch = new ImageIcon(
            getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"));
    private final ImageIcon statusOk = new ImageIcon(
            getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status.png"));
    // Variables declaration - do not modify//GEN-BEGIN:variables
    JButton btnAddKategorie;
    JButton btnMenAbortKategorie;
    JButton btnMenOkKategorie;
    JButton btnRemoveKategorie;
    JComboBox cbKategorie;
    JCheckBox chOnline;
    JDialog dlgAddKategorie;
    JXHyperlink hlHomepage;
    JLabel lblAuswaehlenKategorie;
    JLabel lblBemerkung;
    JLabel lblBeschreibungA;
    JLabel lblFoto;
    JLabel lblFotoAnzeigen;
    JLabel lblHomepage;
    JLabel lblKategorie;
    JLabel lblKommentar;
    JLabel lblOnline;
    JLabel lblUrlCheck;
    JLabel lblUrlHpCheck;
    JList lstKategorie;
    JPanel panAddKategorie;
    JPanel panAngebot;
    JPanel panButtonsKategorie;
    JPanel panMenButtonsKategorie;
    JPanel panUrl;
    JTextArea taBemerkung;
    JTextArea taBeschreibungA;
    JTextArea taKommentar;
    JTextField tfHomepage;
    JTextField txtFoto;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new KlimaAngebotPanel object.
     */
    public KlimaAngebotPanel() {
        this(null, true);
    }

    /**
     * Creates new form KlimaAngebotPanel.
     *
     * @param  parentEditor  DOCUMENT ME!
     * @param  editable      DOCUMENT ME!
     */
    public KlimaAngebotPanel(final KlimaStandortEditor parentEditor, final boolean editable) {
        this.isEditor = editable;
        initComponents();
        this.connectionContext = null;
        this.parentEditor = parentEditor;
    }

    /**
     * Creates new form KlimaAngebotPanel.
     *
     * @param  parentEditor       DOCUMENT ME!
     * @param  editable           DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public KlimaAngebotPanel(final KlimaStandortEditor parentEditor,
            final boolean editable,
            final ConnectionContext connectionContext) {
        this.isEditor = editable;
        this.connectionContext = connectionContext;
        initComponents();
        this.parentEditor = parentEditor;
        dlgAddKategorie.pack();
        dlgAddKategorie.getRootPane().setDefaultButton(btnMenOkKategorie);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddKategorieActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnAddKategorieActionPerformed
        StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(KlimaAngebotPanel.this), dlgAddKategorie, true);
    }                                                                    //GEN-LAST:event_btnAddKategorieActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenAbortKategorieActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnMenAbortKategorieActionPerformed
        dlgAddKategorie.setVisible(false);
    }                                                                         //GEN-LAST:event_btnMenAbortKategorieActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenOkKategorieActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnMenOkKategorieActionPerformed
        try {
            final Object selItem = cbKategorie.getSelectedItem();
            if (selItem instanceof MetaObject) {
                cidsBean = TableUtils.addBeanToCollectionWithMessage(StaticSwingTools.getParentFrame(this),
                        cidsBean,
                        FIELD__KATEGORIE,
                        ((MetaObject)selItem).getBean());
                // sortListNew(FIELD__KATEGORIE);
            }
        } catch (Exception ex) {
            LOG.error(ex, ex);
        } finally {
            dlgAddKategorie.setVisible(false);
        }
    }                                                                      //GEN-LAST:event_btnMenOkKategorieActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveKategorieActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnRemoveKategorieActionPerformed
        final Object selection = lstKategorie.getSelectedValue();
        if (selection != null) {
            final int answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame(this),
                    NbBundle.getMessage(KlimaAngebotPanel.class, BUNDLE_KAT_QUESTION),
                    NbBundle.getMessage(KlimaAngebotPanel.class, BUNDLE_KAT_TITLE),
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    cidsBean = TableUtils.deleteItemFromList(cidsBean, FIELD__KATEGORIE, selection, false);
                } catch (Exception ex) {
                    final ErrorInfo ei = new ErrorInfo(
                            BUNDLE_KAT_ERRORTITLE,
                            BUNDLE_KAT_ERRORTEXT,
                            null,
                            null,
                            ex,
                            Level.SEVERE,
                            null);
                    JXErrorPane.showDialog(this, ei);
                }
            }
        }
    }                                                                       //GEN-LAST:event_btnRemoveKategorieActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void hlHomepageActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_hlHomepageActionPerformed
        if (!isEditor) {
            try {
                BrowserLauncher.openURL(hlHomepage.getText());
            } catch (final Exception e) {
                LOG.fatal("Problem during opening url", e);
                final ErrorInfo ei = new ErrorInfo(
                        "Fehler beim Aufrufen der Url",
                        "Beim Aufrufen der Url ist ein Fehler aufgetreten",
                        null,
                        null,
                        e,
                        Level.SEVERE,
                        null);
                JXErrorPane.showDialog(this, ei);
            }
        }
    }                                                               //GEN-LAST:event_hlHomepageActionPerformed

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        cidsBean = null;
        dlgAddKategorie.dispose();
    }

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        bindingGroup.bind();
        changeOnlineColor();
        dlgAddKategorie.pack();
        dlgAddKategorie.getRootPane().setDefaultButton(btnMenOkKategorie);
        txtFoto.getDocument().addDocumentListener(new DocumentListener() {

                // Immer, wenn das Foto geändert wird, wird dieses überprüft und neu geladen.
                @Override
                public void insertUpdate(final DocumentEvent e) {
                    doWithFotoUrl();
                }

                @Override
                public void removeUpdate(final DocumentEvent e) {
                    doWithFotoUrl();
                }

                @Override
                public void changedUpdate(final DocumentEvent e) {
                    doWithFotoUrl();
                }
            });
        tfHomepage.getDocument().addDocumentListener(new DocumentListener() {

                // Immer, wenn die Homepage geändert wird, wird diese überprüft.
                @Override
                public void insertUpdate(final DocumentEvent e) {
                    doWithHpUrl();
                }

                @Override
                public void removeUpdate(final DocumentEvent e) {
                    doWithHpUrl();
                }

                @Override
                public void changedUpdate(final DocumentEvent e) {
                    doWithHpUrl();
                }
            });
        chOnline.addItemListener(new ItemListener() {

                @Override
                public void itemStateChanged(final ItemEvent e) {
                    changeOnlineColor();
                }
            });
        setReadOnly();
    }

    /**
     * DOCUMENT ME!
     */
    private void setReadOnly() {
        hlHomepage.setVisible(!isEditor);
        tfHomepage.setVisible(isEditor);
        panButtonsKategorie.setVisible(isEditor);

        if (!(isEditor)) {
            RendererTools.makeReadOnly(txtFoto);
            RendererTools.makeReadOnly(taBeschreibungA);
            RendererTools.makeReadOnly(taBemerkung);
            RendererTools.makeReadOnly(taKommentar);
            RendererTools.makeReadOnly(chOnline);
            RendererTools.makeReadOnly(lstKategorie);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void changeOnlineColor() {
        if (chOnline.isSelected()) {
            lblOnline.setForeground(Color.black);
        } else {
            lblOnline.setForeground(Color.red);
        }
    }
    /**
     * DOCUMENT ME!
     *
     * @param   url  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ImageIcon loadPicture(final URL url) {
        try {
            final int bildZielBreite = FOTO_WIDTH;
            final BufferedImage originalBild = ImageIO.read(WebAccessManager.getInstance().doRequest(url));
            final Image skaliertesBild = originalBild.getScaledInstance(bildZielBreite, -1, Image.SCALE_SMOOTH);
            return new ImageIcon(skaliertesBild);
        } catch (final Exception ex) {
            LOG.error("Could not load picture.", ex);
            return null;
        }
    }
    /**
     * DOCUMENT ME!
     */
    private void doWithFotoUrl() {
        if (txtFoto.getText().trim().isEmpty()) {
            lblFotoAnzeigen.setIcon(null);
            lblFotoAnzeigen.setText(NbBundle.getMessage(KlimaAngebotPanel.class, BUNDLE_NOFOTO));
            lblFotoAnzeigen.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        } else {
            final String foto = KlimaConfProperties.getInstance().getFotoUrl().concat(txtFoto.getText());
            // Worker Aufruf, grün/rot
            checkUrl(foto, lblUrlCheck);
            // Worker Aufruf, Foto laden
            loadPictureWithUrl(foto, lblFotoAnzeigen);
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void doWithHpUrl() {
        final String url = tfHomepage.getText();
        // Worker Aufruf, grün/rot
        checkUrl(url, lblUrlHpCheck);
    }
    /**
     * DOCUMENT ME!
     *
     * @param  url        DOCUMENT ME!
     * @param  showLabel  DOCUMENT ME!
     */
    private void checkUrl(final String url, final JLabel showLabel) {
        showLabel.setIcon(statusFalsch);
        showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        final SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>() {

                @Override
                protected Boolean doInBackground() throws Exception {
                    return WebAccessManager.getInstance().checkIfURLaccessible(new URL(url));
                }

                @Override
                protected void done() {
                    final Boolean check;
                    try {
                        if (!isCancelled()) {
                            check = get();
                            if (check) {
                                showLabel.setIcon(statusOk);
                                showLabel.setCursor(new Cursor(Cursor.HAND_CURSOR));
                            } else {
                                showLabel.setIcon(statusFalsch);
                                showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                            }
                        }
                    } catch (InterruptedException | ExecutionException e) {
                        showLabel.setIcon(statusFalsch);
                        showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                        LOG.warn("URL Check Problem in Worker.", e);
                    }
                }
            };
        if (showLabel.getName().equals(LABEL__NAME_HP)) {
            if (worker_hp != null) {
                worker_hp.cancel(true);
            }
            worker_hp = worker;
            worker_hp.execute();
        } else {
            if (worker_foto != null) {
                worker_foto.cancel(true);
            }
            worker_foto = worker;
            worker_foto.execute();
        }
    }
    /**
     * DOCUMENT ME!
     *
     * @param  url        DOCUMENT ME!
     * @param  showLabel  DOCUMENT ME!
     */
    private void loadPictureWithUrl(final String url, final JLabel showLabel) {
        showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        final SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>() {

                @Override
                protected ImageIcon doInBackground() throws Exception {
                    return loadPicture(new URL(url));
                }

                @Override
                protected void done() {
                    final ImageIcon check;
                    try {
                        if (!isCancelled()) {
                            check = get();
                            if (check != null) {
                                showLabel.setIcon(check);
                                showLabel.setText("");
                                showLabel.setCursor(new Cursor(Cursor.HAND_CURSOR));
                            } else {
                                showLabel.setIcon(null);
                                showLabel.setText(NbBundle.getMessage(KlimaAngebotPanel.class, BUNDLE_NOLOAD));
                                showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                            }
                        }
                    } catch (InterruptedException | ExecutionException e) {
                        showLabel.setText(NbBundle.getMessage(KlimaAngebotPanel.class, BUNDLE_NOLOAD));
                        showLabel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                        LOG.warn("load picture Problem in Worker.", e);
                    }
                }
            };
        if (worker_loadFoto != null) {
            worker_loadFoto.cancel(true);
        }
        worker_loadFoto = worker;
        worker_loadFoto.execute();
    }
}
