/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

import java.net.URLDecoder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

import javax.imageio.ImageIO;

import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.cismet.cids.client.tools.WebDavTunnelHelper;

import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.actions.UaWebDavTunnelAction;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.AfterClosingHook;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.commons.concurrency.CismetConcurrency;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;

/**
 * DOCUMENT ME!
 *
 * @author   sandra
 * @version  $Revision$, $Date$
 */
public class SimpleDocumentWebDavPanel extends javax.swing.JPanel implements CidsBeanStore,
    SaveVetoable,
    AfterClosingHook,
    Disposable,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(SimpleDocumentWebDavPanel.class);
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static File lastFolder = null;

    public static final String FIELD__NAME = "name";
    public static final String FIELD__DATEINAME = "dateiname";
    public static final String BUNDLE_LIMIT_MESSAGE =
        "SimpleDocumentWebDavPanel.ImageUploadWorker.doInBackground.fileLimitMessage";
    public static final String BUNDLE_LIMIT_TITLE =
        "SimpleDocumentWebDavPanel.ImageUploadWorker.doInBackground.fileLimitTitle";

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        final RoundedPanel pnlDateien = new RoundedPanel();
        final SemiRoundedPanel pnlHeaderDateien = new SemiRoundedPanel();
        final JLabel lblHeaderDateien = new JLabel();
        final JPanel jPanel2 = new JPanel();
        final JPanel jPanel1 = new JPanel();
        final JScrollPane jspDateiList = new JScrollPane();
        lstDateien = new JList();
        final JPanel pnlCtrlButtons = new JPanel();
        btnAddDatei = new JButton();
        btnRemoveDateien = new JButton();

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        pnlDateien.setName("pnlDateien"); // NOI18N
        pnlDateien.setLayout(new GridBagLayout());

        pnlHeaderDateien.setBackground(new Color(51, 51, 51));
        pnlHeaderDateien.setForeground(new Color(51, 51, 51));
        pnlHeaderDateien.setName("pnlHeaderDateien"); // NOI18N
        pnlHeaderDateien.setLayout(new FlowLayout());

        lblHeaderDateien.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText(
            lblHeaderDateien,
            NbBundle.getMessage(SimpleDocumentWebDavPanel.class, "SimpleDocumentWebDavPanel.lblHeaderDateien.text")); // NOI18N
        lblHeaderDateien.setName("lblHeaderDateien");                                                                 // NOI18N
        pnlHeaderDateien.add(lblHeaderDateien);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        pnlDateien.add(pnlHeaderDateien, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());

        jspDateiList.setMinimumSize(new Dimension(250, 130));
        jspDateiList.setName("jspDateiList"); // NOI18N

        lstDateien.setMinimumSize(new Dimension(250, 130));
        lstDateien.setName("lstDateien"); // NOI18N
        lstDateien.setPreferredSize(new Dimension(250, 130));

        final ELProperty eLProperty = ELProperty.create("${cidsBean." + beanCollProp + "}");
        final JListBinding jListBinding = SwingBindings.createJListBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                eLProperty,
                lstDateien);
        bindingGroup.addBinding(jListBinding);

        lstDateien.addMouseListener(formListener);
        lstDateien.addListSelectionListener(formListener);
        jspDateiList.setViewportView(lstDateien);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jspDateiList, gridBagConstraints);

        pnlCtrlButtons.setName("pnlCtrlButtons"); // NOI18N
        pnlCtrlButtons.setOpaque(false);
        pnlCtrlButtons.setLayout(new GridBagLayout());

        btnAddDatei.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));   // NOI18N
        Mnemonics.setLocalizedText(
            btnAddDatei,
            NbBundle.getMessage(SimpleDocumentWebDavPanel.class, "SimpleDocumentWebDavPanel.btnAddDatei.text")); // NOI18N
        btnAddDatei.setBorderPainted(false);
        btnAddDatei.setContentAreaFilled(false);
        btnAddDatei.setName("btnAddDatei");                                                                      // NOI18N
        btnAddDatei.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        pnlCtrlButtons.add(btnAddDatei, gridBagConstraints);

        btnRemoveDateien.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));     // NOI18N
        Mnemonics.setLocalizedText(
            btnRemoveDateien,
            NbBundle.getMessage(SimpleDocumentWebDavPanel.class, "SimpleDocumentWebDavPanel.btnRemoveDateien.text")); // NOI18N
        btnRemoveDateien.setBorderPainted(false);
        btnRemoveDateien.setContentAreaFilled(false);
        btnRemoveDateien.setName("btnRemoveDateien");                                                                 // NOI18N
        btnRemoveDateien.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pnlCtrlButtons.add(btnRemoveDateien, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel1.add(pnlCtrlButtons, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        jPanel2.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlDateien.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(pnlDateien, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements ActionListener, MouseListener, ListSelectionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent evt) {
            if (evt.getSource() == btnAddDatei) {
                SimpleDocumentWebDavPanel.this.btnAddDateiActionPerformed(evt);
            } else if (evt.getSource() == btnRemoveDateien) {
                SimpleDocumentWebDavPanel.this.btnRemoveDateienActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(final MouseEvent evt) {
            if (evt.getSource() == lstDateien) {
                SimpleDocumentWebDavPanel.this.lstDateienMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(final MouseEvent evt) {
        }

        @Override
        public void mouseExited(final MouseEvent evt) {
        }

        @Override
        public void mousePressed(final MouseEvent evt) {
        }

        @Override
        public void mouseReleased(final MouseEvent evt) {
        }

        @Override
        public void valueChanged(final ListSelectionEvent evt) {
            if (evt.getSource() == lstDateien) {
                SimpleDocumentWebDavPanel.this.lstDateienValueChanged(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    protected final String beanCollProp;
    protected final String nameProp;
    protected final String bildClassName;

    protected final JFileChooser fileChooser;
    protected final List<CidsBean> removeNewAddedDateiBean = new ArrayList<>();
    protected final List<CidsBean> removedDateiBeans = new ArrayList<>();
    protected boolean listListenerEnabled = true;
    protected CidsBean cidsBean;
    final boolean editor;

    private final String[] imageEndings;
    private final int fileLimit;

    private final WebDavTunnelHelper webdavHelper;
    private List<ListSelectionListener> listSelectionListeners = new ArrayList<>();

    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    JButton btnAddDatei;
    JButton btnRemoveDateien;
    JList lstDateien;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new WebDavPicturePanel object. Nicht nutzen!! nur für gui
     */
    public SimpleDocumentWebDavPanel() {
        this(
            false,
            "dokumente",
            "albo_flaeche_document",
            "dateiname",
            UaWebDavTunnelAction.TASK_NAME,
            ConnectionContext.createDummy(),
            new JFileChooser(),
            new String[] { "jpg", "jpeg", "png", "gif", "svg" },
            2
                    * 1024
                    * 1024);
    }

    /**
     * Creates new form WebDavPicturePanel.
     *
     * @param  editable           DOCUMENT ME!
     * @param  beanCollProp       DOCUMENT ME!
     * @param  bildClassName      DOCUMENT ME!
     * @param  nameProp           DOCUMENT ME!
     * @param  tunnelAction       webdavDirectory urlProp DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     * @param  file_chooser       DOCUMENT ME!
     * @param  endings            DOCUMENT ME!
     * @param  limit              DOCUMENT ME!
     */
    public SimpleDocumentWebDavPanel(final boolean editable,
            final String beanCollProp,
            final String bildClassName,
            final String nameProp,
            final String tunnelAction,
            final ConnectionContext connectionContext,
            final JFileChooser file_chooser,
            final String[] endings,
            final int limit) {
        this.editor = editable;
        this.beanCollProp = beanCollProp;
        this.bildClassName = bildClassName;
        this.nameProp = nameProp;
        this.connectionContext = connectionContext;
        this.fileChooser = file_chooser;
        this.imageEndings = endings;
        Arrays.sort(imageEndings);
        this.fileLimit = limit;

        WebDavTunnelHelper webdavHelp = null;
        try {
            webdavHelp = new WebDavTunnelHelper("WUNDA_BLAU", tunnelAction);
        } catch (final Exception ex) {
            final String message = "Fehler beim Initialisieren des WebdavHelpers.";
            LOG.error(message, ex);
            ObjectRendererUtils.showExceptionWindowToUser(message, ex, null);
        }
        this.webdavHelper = webdavHelp;

        initComponents();
        lstDateien.setCellRenderer(new DefaultListCellRenderer() {

                @Override
                public Component getListCellRendererComponent(final JList list,
                        final Object value,
                        final int index,
                        final boolean isSelected,
                        final boolean cellHasFocus) {
                    final Component component = super.getListCellRendererComponent(
                            list,
                            value,
                            index,
                            isSelected,
                            cellHasFocus);
                    if ((component instanceof JLabel) && (value instanceof CidsBean)) {
                        final CidsBean dokumentBean = (CidsBean)value;
                        final String name = (String)dokumentBean.getProperty(FIELD__DATEINAME); // name
                        ((JLabel)component).setText(name);
                    }
                    return component;
                }
            });

        fileChooser.setMultiSelectionEnabled(true);

        lstDateien.getModel().addListDataListener(new ListDataListener() {

                @Override
                public void intervalAdded(final ListDataEvent e) {
                    defineButtonStatus();
                }

                @Override
                public void intervalRemoved(final ListDataEvent e) {
                    defineButtonStatus();
                }

                @Override
                public void contentsChanged(final ListDataEvent e) {
                    defineButtonStatus();
                }
            });

        if (editable) {
            new DropTarget(lstDateien, new DropTargetAdapter() {

                    @Override
                    public void drop(final DropTargetDropEvent dtde) {
                        boolean a = false;
                        try {
                            final Transferable tr = dtde.getTransferable();
                            final DataFlavor[] flavors = tr.getTransferDataFlavors();

                            for (int i = 0; i < flavors.length; i++) {
                                if (flavors[i].isFlavorJavaFileListType()) {
                                    // zunaechst annehmen
                                    dtde.acceptDrop(dtde.getDropAction());
                                    final List<File> files = (List<File>)tr.getTransferData(flavors[i]);
                                    if ((files != null) && (files.size() > 0)) {
                                        CismetConcurrency.getInstance("WebDavPanel")
                                                .getDefaultExecutor()
                                                .execute(new DateiUploadWorker(files));
                                    }
                                    dtde.dropComplete(true);
                                    return;
                                } else if (flavors[i].isRepresentationClassInputStream()) {
                                    // this is used under linux
                                    if (!a) {
                                        dtde.acceptDrop(dtde.getDropAction());
                                        a = true;
                                    }
                                    final BufferedReader br = new BufferedReader(
                                            new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                                    String tmp = null;
                                    final List<File> fileList = new ArrayList<>();
                                    while ((tmp = br.readLine()) != null) {
                                        if (tmp.trim().startsWith(FILE_PROTOCOL_PREFIX)) {
                                            File f = new File(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()));
                                            if (f.exists()) {
                                                fileList.add(f);
                                            } else {
                                                f = new File(
                                                        URLDecoder.decode(
                                                            tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()),
                                                            "UTF-8"));

                                                if (f.exists()) {
                                                    fileList.add(f);
                                                } else {
                                                    LOG.warn("File " + f.toString() + " does not exist.");
                                                }
                                            }
                                        }
                                    }
                                    br.close();

                                    if ((fileList != null) && (fileList.size() > 0)) {
                                        CismetConcurrency.getInstance("WebDavPanel")
                                                .getDefaultExecutor()
                                                .execute(new DateiUploadWorker(fileList));
                                        dtde.dropComplete(true);
                                        return;
                                    }
                                }
                            }
                        } catch (UnsupportedFlavorException | IOException ex) {
                            LOG.warn(ex, ex);
                        }
                        // Problem ist aufgetreten
                        dtde.rejectDrop();
                    }
                });
        }

        btnAddDatei.setVisible(editable);
        btnRemoveDateien.setVisible(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     */
    private void defineButtonStatus() {
        final boolean hasSelection = lstDateien.getSelectedValue() != null;

        btnRemoveDateien.setEnabled(hasSelection && isEditor());
    }

    /**
     * DOCUMENT ME!
     *
     * @return  the webdavHelper
     */
    public WebDavTunnelHelper getWebdavHelper() {
        return webdavHelper;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isEditor() {
        return this.editor;
    }
    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lstDateienValueChanged(final ListSelectionEvent evt) { //GEN-FIRST:event_lstDateienValueChanged
        if (!evt.getValueIsAdjusting() && listListenerEnabled) {
            for (final ListSelectionListener listener : listSelectionListeners) {
                listener.valueChanged(evt);
            }
        }
    }                                                                   //GEN-LAST:event_lstDateienValueChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddDateiActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnAddDateiActionPerformed
        if (lastFolder != null) {
            fileChooser.setCurrentDirectory(lastFolder);
        }
        if (JFileChooser.APPROVE_OPTION == fileChooser.showOpenDialog(this)) {
            final File[] selFiles = fileChooser.getSelectedFiles();

            if ((selFiles != null) && (selFiles.length > 0)) {
                lastFolder = selFiles[0].getParentFile();
                CismetConcurrency.getInstance("WebDavPanel")
                        .getDefaultExecutor()
                        .execute(new DateiUploadWorker(Arrays.asList(selFiles)));
            }
        }
    } //GEN-LAST:event_btnAddDateiActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveDateienActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnRemoveDateienActionPerformed
        final Object[] selection = lstDateien.getSelectedValuesList().toArray();
        if ((selection != null) && (selection.length > 0)) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Sollen die Dokumente wirklich gelöscht werden?",
                    "Dokumente entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    listListenerEnabled = false;
                    final List<Object> removeList = Arrays.asList(selection);
                    final List<CidsBean> dateien = cidsBean.getBeanCollectionProperty(beanCollProp);
                    if (dateien != null) {
                        dateien.removeAll(removeList);
                    }
                    // TODO set the laufende_nr
                    for (int i = 0; i < lstDateien.getModel().getSize(); i++) {
                        final CidsBean datei = (CidsBean)lstDateien.getModel().getElementAt(i);
                        datei.setProperty("laufende_nummer", i + 1);
                    }

                    for (final Object toDeleteObj : removeList) {
                        if (toDeleteObj instanceof CidsBean) {
                            final CidsBean dateiToDelete = (CidsBean)toDeleteObj;
                            removedDateiBeans.add(dateiToDelete);
                        }
                    }
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                } finally {
                    // TODO check the laufende_nummer attribute
                    listListenerEnabled = true;
                    final int modelSize = lstDateien.getModel().getSize();
                    if (modelSize > 0) {
                        lstDateien.setSelectedIndex(0);
                    }
                }
            }
        }
    } //GEN-LAST:event_btnRemoveDateienActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lstDateienMouseClicked(final MouseEvent evt) { //GEN-FIRST:event_lstDateienMouseClicked
        if (evt.getClickCount() == 2) {
            final CidsBean dokumentBean = (CidsBean)lstDateien.getSelectedValue();
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(getParent())) {
                final String jobname = DownloadManagerDialog.getInstance().getJobName();

                final Download download = new AbstractDownload() {

                        {
                            status = State.WAITING;
                            this.directory = jobname;
                            final String dateiname = (String)dokumentBean.getProperty(FIELD__DATEINAME);
                            final int extIndex = dateiname.lastIndexOf(".");
                            final String extension = (extIndex >= 0) ? dateiname.substring(extIndex) : "";
                            final String filename = (extIndex >= 0) ? dateiname.substring(0, extIndex) : dateiname;
                            determineDestinationFile(filename, extension);
                        }

                        @Override
                        public void run() {
                            try {
                                status = State.RUNNING;
                                stateChanged();

                                final InputStream is = getWebdavHelper().getFileFromWebDAV((String)
                                        dokumentBean.getProperty(
                                            nameProp),
                                        getConnectionContext());
                                try(final OutputStream os = new FileOutputStream(fileToSaveTo)) {
                                    IOUtils.copy(is, os);
                                }

                                if (status == State.RUNNING) {
                                    status = State.COMPLETED;
                                    stateChanged();
                                }
                            } catch (final Exception ex) {
                                LOG.error(ex, ex);
                                status = State.ABORTED;
                                stateChanged();
                            }
                        }
                    };
                DownloadManager.instance().add(download);
            }
        }
    } //GEN-LAST:event_lstDateienMouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  l  DOCUMENT ME!
     */
    public void addListSelectionListener(final ListSelectionListener l) {
        this.listSelectionListeners.add(l);
    }

    /**
     * DOCUMENT ME!
     *
     * @param   l  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean removeListSelectionListener(final ListSelectionListener l) {
        return this.listSelectionListeners.remove(l);
    }

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        bindingGroup.bind();

        if (cidsBean != null) {
            if (lstDateien.getModel().getSize() > 0) {
                lstDateien.setSelectedIndex(0);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   bi         DOCUMENT ME!
     * @param   component  DOCUMENT ME!
     * @param   insetX     DOCUMENT ME!
     * @param   insetY     DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static Image adjustScale(final BufferedImage bi,
            final JComponent component,
            final int insetX,
            final int insetY) {
        final double scalex = (double)component.getWidth() / bi.getWidth();
        final double scaley = (double)component.getHeight() / bi.getHeight();
        final double scale = Math.min(scalex, scaley);
        if (scale <= 1d) {
            return bi.getScaledInstance((int)(bi.getWidth() * scale) - insetX,
                    (int)(bi.getHeight() * scale)
                            - insetY,
                    Image.SCALE_SMOOTH);
        } else {
            return bi;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   tempFile  DOCUMENT ME!
     * @param   ending    DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    private static byte[] resizeImage(final File tempFile, final String ending) throws Exception {
        final Image img = ImageIO.read(tempFile);
        final int height = img.getHeight(null);
        final int width = img.getWidth(null);
        final int longestSide = Math.max(width, height);
        double scale = 1;

        // set longest side to 1600 if it is longer
        if (longestSide > 800) {
            scale = 800.0 / longestSide;
        }

        final BufferedImage imgThumb = new BufferedImage((int)(width * scale),
                (int)(height * scale),
                BufferedImage.TYPE_INT_RGB);

        imgThumb.createGraphics()
                .drawImage(img.getScaledInstance((int)(width * scale), (int)(height * scale), Image.SCALE_SMOOTH),
                    0,
                    0,
                    null);
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write(imgThumb, ending, os);

        return os.toByteArray();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  ex      DOCUMENT ME!
     * @param  parent  DOCUMENT ME!
     */
    private static void showExceptionToUser(final Exception ex, final JComponent parent) {
        final ErrorInfo ei = new ErrorInfo(
                "Fehler",
                "Beim Vorgang ist ein Fehler aufgetreten",
                null,
                null,
                ex,
                Level.SEVERE,
                null);
        JXErrorPane.showDialog(parent, ei);
    }

    @Override
    public void afterClosing(final AfterClosingHook.Event event) {
        if (AfterClosingHook.Status.SAVED == event.getStatus()) {
            for (final CidsBean deleteBean : removedDateiBeans) {
                final String fileName = (String)deleteBean.getProperty(nameProp);

                try {
                    webdavHelper.deleteFileFromWebDAV(fileName, getConnectionContext());
                    deleteBean.delete();
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                }
            }
        } else {
            for (final CidsBean deleteBean : removeNewAddedDateiBean) {
                final String fileName = (String)deleteBean.getProperty(nameProp);
                try {
                    webdavHelper.deleteFileFromWebDAV(fileName, getConnectionContext());
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                }
            }
        }
    }

    @Override
    public boolean isOkForSaving() {
        return true;
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        cidsBean = null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   filename  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private synchronized String createUniqueFilename(final String filename) {
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf(".")) + new Long(System.currentTimeMillis()).hashCode()
                        + filename.substring(filename.lastIndexOf("."));
        } else {
            return filename + new Long(System.currentTimeMillis()).hashCode();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   filename  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String cutEnding(final String filename) {
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf("."));
        } else {
            return filename;
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    protected class DateiUploadWorker extends SwingWorker<Collection<CidsBean>, Void> {

        //~ Instance fields ----------------------------------------------------

        private final Collection<File> dokumente;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new DateiUploadWorker object.
         *
         * @param  dokumente  DOCUMENT ME!
         */
        public DateiUploadWorker(final Collection<File> dokumente) {
            this.dokumente = dokumente;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            final Collection<CidsBean> newBeans = new ArrayList<>();
            for (final File dokument : dokumente) {
                final String filename = createUniqueFilename(dokument.getName());
                String fileEnding = null;

                if (dokument.getName().toLowerCase().contains(".")) {
                    fileEnding = dokument.getName().toLowerCase()
                                .substring(dokument.getName().toLowerCase().lastIndexOf(".") + 1);
                }

                if ((fileEnding != null) && (Arrays.binarySearch(imageEndings, fileEnding) >= 0)) {
                    final InputStream is = new ByteArrayInputStream(resizeImage(dokument, fileEnding));

                    getWebdavHelper().uploadFileToWebDAV(
                        filename,
                        is,
                        SimpleDocumentWebDavPanel.this,
                        getConnectionContext());
                } else {
                    if (dokument.length() > fileLimit) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame(
                                CismapBroker.getInstance().getMappingComponent()),
                            NbBundle.getMessage(SimpleDocumentWebDavPanel.class,
                                BUNDLE_LIMIT_MESSAGE),
                            NbBundle.getMessage(SimpleDocumentWebDavPanel.class,
                                BUNDLE_LIMIT_TITLE),
                            JOptionPane.ERROR_MESSAGE);
                        continue;
                    } else {
                        getWebdavHelper().uploadFileToWebDAV(
                            filename,
                            dokument,
                            SimpleDocumentWebDavPanel.this,
                            getConnectionContext());
                    }
                }

                final CidsBean newDokument = CidsBean.createNewCidsBeanFromTableName(
                        "WUNDA_BLAU",
                        bildClassName,
                        getConnectionContext());
                newDokument.setProperty(nameProp, filename);
                // newDokument.setProperty(FIELD__NAME, dokument.getName());
                newBeans.add(newDokument);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                final Collection<CidsBean> newBeans = get();
                if (!newBeans.isEmpty()) {
                    final List<CidsBean> oldBeans = cidsBean.getBeanCollectionProperty(beanCollProp);
                    oldBeans.addAll(newBeans);
                    removeNewAddedDateiBean.addAll(newBeans);
                    lstDateien.setSelectedValue(newBeans.iterator().next(), true);
                }
            } catch (final InterruptedException ex) {
                LOG.warn(ex, ex);
            } catch (final ExecutionException ex) {
                LOG.error(ex, ex);
            }
        }
    }
}
