/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.tools.MetaObjectCache;
import Sirius.navigator.ui.DescriptionPaneFS;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;

import lombok.Getter;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.DefaultBindableLabelsPanel;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   sandra
 * @version  $Revision$, $Date$
 */
public class UaFirmaLeistungenPanel extends javax.swing.JPanel implements ConnectionContextStore,
    CidsBeanStore,
    Disposable {

    //~ Static fields/initializers ---------------------------------------------

    private static DefaultBindableReferenceCombo.Option SORTING_OPTION =
        new DefaultBindableReferenceCombo.SortingColumnOption("name");
    private static DefaultBindableReferenceCombo.Option NULLABLE_OPTION =
        new DefaultBindableReferenceCombo.NullableOption(null, "-");
    private static final Logger LOG = Logger.getLogger(UaFirmaLeistungenPanel.class);
    public static final String FIELD__FIRMA = "fk_firma";
    public static final String BUNDLE_PANE_PREFIX_SELECTION =
        "UaFirmaLeistungenPanel.btnFirmaActionPerformed().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX_SELECTION =
        "UaFirmaLeistungenPanel.btnFirmaActionPerformed().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE_SELECTION =
        "UaFirmaLeistungenPanel.btnFirmaActionPerformed().JOptionPane.title";
    public static final String BUNDLE_PANE_SELECTION =
        "UaFirmaLeistungenPanel.btnFirmaActionPerformed().JOptionPane.message";

    static {
        final ConnectionContext connectionContext = ConnectionContext.create(
                ConnectionContext.Category.STATIC,
                BaumErsatzPanel.class.getSimpleName());
        MC__FIRMA = ClassCacheMultiple.getMetaClass(
                "WUNDA_BLAU",
                "UA_FIRMA",
                connectionContext);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        final JPanel panFL = new JPanel();
        final JLabel lblFirma = new JLabel();
        final JLabel lblLeistungen = new JLabel();
        blpLeistungen = new DefaultBindableLabelsPanel(isEditor(), "Leistungen:", SORTING_OPTION);
        btnFirma = new JButton();
        cbFirma = new DefaultBindableScrollableComboBox(MC__FIRMA);
        final JPanel jPanel3 = new JPanel();
        final Box.Filler filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        if (isEditor()) {
            btnRemoveFirma = new JButton();
        }
        final JSeparator jSeparator1 = new JSeparator();
        final Box.Filler filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        panFL.setName("panFL"); // NOI18N
        panFL.setOpaque(false);
        panFL.setLayout(new GridBagLayout());

        lblFirma.setFont(new Font("Tahoma", 1, 11));                                                    // NOI18N
        Mnemonics.setLocalizedText(
            lblFirma,
            NbBundle.getMessage(UaFirmaLeistungenPanel.class, "UaFirmaLeistungenPanel.lblFirma.text")); // NOI18N
        lblFirma.setName("lblFirma");                                                                   // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        panFL.add(lblFirma, gridBagConstraints);

        lblLeistungen.setFont(new Font("Tahoma", 1, 11));                                                    // NOI18N
        Mnemonics.setLocalizedText(
            lblLeistungen,
            NbBundle.getMessage(UaFirmaLeistungenPanel.class, "UaFirmaLeistungenPanel.lblLeistungen.text")); // NOI18N
        lblLeistungen.setName("lblLeistungen");                                                              // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        panFL.add(lblLeistungen, gridBagConstraints);

        blpLeistungen.setName("blpLeistungen"); // NOI18N
        blpLeistungen.setOpaque(false);

        Binding binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.arr_leistungen}"),
                blpLeistungen,
                BeanProperty.create("selectedElements"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panFL.add(blpLeistungen, gridBagConstraints);

        btnFirma.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/icon-explorerwindow.png"))); // NOI18N
        btnFirma.setBorderPainted(false);
        btnFirma.setContentAreaFilled(false);
        btnFirma.setFocusPainted(false);
        btnFirma.setName("btnFirma");                                                                                // NOI18N
        btnFirma.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.LAST_LINE_END;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        panFL.add(btnFirma, gridBagConstraints);

        cbFirma.setFont(new Font("Dialog", 0, 12)); // NOI18N
        cbFirma.setMaximumRowCount(15);
        cbFirma.setAutoscrolls(true);
        cbFirma.setName("cbFirma");                 // NOI18N
        cbFirma.setPreferredSize(new Dimension(150, 25));

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.fk_firma}"),
                cbFirma,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        panFL.add(cbFirma, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        add(panFL, gridBagConstraints);

        jPanel3.setName("jPanel3"); // NOI18N
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());

        filler4.setName("filler4"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(filler4, gridBagConstraints);

        if (isEditor()) {
            btnRemoveFirma.setIcon(new ImageIcon(
                    getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png"))); // NOI18N
            btnRemoveFirma.setBorderPainted(false);
            btnRemoveFirma.setContentAreaFilled(false);
            btnRemoveFirma.setName("btnRemoveFirma");                                                                 // NOI18N
            btnRemoveFirma.addActionListener(formListener);
        }
        if (isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = GridBagConstraints.SOUTHEAST;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            jPanel3.add(btnRemoveFirma, gridBagConstraints);
        }

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        add(jPanel3, gridBagConstraints);

        jSeparator1.setName("jSeparator1"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        add(jSeparator1, gridBagConstraints);

        filler3.setName("filler3"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(filler3, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements ActionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent evt) {
            if (evt.getSource() == btnFirma) {
                UaFirmaLeistungenPanel.this.btnFirmaActionPerformed(evt);
            } else if (evt.getSource() == btnRemoveFirma) {
                UaFirmaLeistungenPanel.this.btnRemoveFirmaActionPerformed(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    private static final MetaClass MC__FIRMA;

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private ConnectionContext connectionContext;
    // private CidsBean firmaBean;
    private final UaEinsatzEditor parentEditor;
    @Getter private final boolean editor;
    private final Collection<DefaultBindableLabelsPanel> labelsPanels = new ArrayList<>();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    DefaultBindableLabelsPanel blpLeistungen;
    JButton btnFirma;
    JButton btnRemoveFirma;
    JComboBox<String> cbFirma;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new UaFirmaLeistungenPanel object.
     */
    public UaFirmaLeistungenPanel() {
        this(true);
    }

    /**
     * Creates new form UaFirmaLeistungenPanel.
     *
     * @param  editable  DOCUMENT ME!
     */
    public UaFirmaLeistungenPanel(final boolean editable) {
        this(null, editable);
    }

    /**
     * Creates new form UaFirmaLeistungenPanel.
     *
     * @param  editor    DOCUMENT ME!
     * @param  editable  DOCUMENT ME!
     */
    public UaFirmaLeistungenPanel(final UaEinsatzEditor editor, final boolean editable) {
        this.parentEditor = editor;
        this.editor = editable;

        // btnRemoveFirma.setVisible(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveFirmaActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnRemoveFirmaActionPerformed
        // parentEditor.getFirmaBeans().remove(cidsBean);
        // parentEditor.remove(this);
        parentEditor.removeFirmaPanel(this);
    } //GEN-LAST:event_btnRemoveFirmaActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnFirmaActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnFirmaActionPerformed
        final JDialog dialog = new JDialog((Frame)null,
                "Firma",
                true);
        final Collection<MetaObjectNode> mons = new ArrayList<>();

        if (getCidsBean() != null) {
            final MetaObjectNode metaObjectNode = new MetaObjectNode((CidsBean)getCidsBean().getProperty(FIELD__FIRMA));
            mons.add(metaObjectNode);
            dialog.setContentPane(new DescriptionPaneDialogWrapperPanel(mons));
            dialog.setSize(1200, 800);
            StaticSwingTools.showDialog(this, dialog, true);
        } else {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame(this),
                NbBundle.getMessage(UaFirmaLeistungenPanel.class, BUNDLE_PANE_PREFIX_SELECTION)
                        + NbBundle.getMessage(UaFirmaLeistungenPanel.class, BUNDLE_PANE_SELECTION)
                        + NbBundle.getMessage(UaFirmaLeistungenPanel.class, BUNDLE_PANE_SUFFIX_SELECTION),
                NbBundle.getMessage(UaFirmaLeistungenPanel.class, BUNDLE_PANE_TITLE_SELECTION),
                JOptionPane.WARNING_MESSAGE);
        }
    } //GEN-LAST:event_btnFirmaActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    /**
     * DOCUMENT ME!
     */
    private void setReadOnly() {
        if (!(isEditor())) {
            RendererTools.makeReadOnly(cbFirma);
            RendererTools.makeReadOnly(blpLeistungen);
        }
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        MetaObjectCache.getInstance().clearCache(MC__FIRMA);
        for (final DefaultBindableLabelsPanel labelsPanel : Arrays.asList(blpLeistungen)) {
            labelsPanel.initWithConnectionContext(parentEditor.getConnectionContext());
        }
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        // 8.5.17 s.Simmert: Methodenaufruf, weil sonst die Comboboxen nicht gefüllt werden
        // evtl. kann dies verbessert werden.
        DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
            bindingGroup,
            cidsBean,
            getConnectionContext());
        bindingGroup.bind();
        if (getCidsBean() != null) {
            labelsPanels.addAll(Arrays.asList(blpLeistungen));
        }
        for (final DefaultBindableLabelsPanel labelsPanel : labelsPanels) {
            if (labelsPanel != null) {
                MetaObjectCache.getInstance().clearCache(labelsPanel.getMetaClass());
            }
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        if (labelsPanels != null) {
            for (final DefaultBindableLabelsPanel panel : labelsPanels) {
                panel.dispose();
            }
        }
        labelsPanels.clear();
        // this.parentEditor = null;
        this.cidsBean = null;
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext cc) {
        this.connectionContext = cc;

        initComponents();
        setReadOnly();
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    public final class DescriptionPaneDialogWrapperPanel extends JPanel {

        //~ Instance fields ----------------------------------------------------

        private final DescriptionPaneFS pane = new DescriptionPaneFS();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new TestBlubbPanel object.
         *
         * @param  mons  DOCUMENT ME!
         */
        private DescriptionPaneDialogWrapperPanel(final Collection<MetaObjectNode> mons) {
            setLayout(new BorderLayout());
            add(pane, BorderLayout.CENTER);
            pane.gotoMetaObjectNodes(mons.toArray(new MetaObjectNode[0]));
        }
    }
}
