/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import Sirius.navigator.connection.SessionManager;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;

import org.jdesktop.beansbinding.BindingGroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.swing.SwingWorker;

import de.cismet.cids.custom.featurerenderer.wunda_blau.AlboFlaecheFeatureRenderer;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.wunda_blau.search.server.BufferingGeosearch;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;

import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;

import static de.cismet.cids.custom.objecteditors.wunda_blau.albo.AbstractAlboFlaechePanel.LOG;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AlboFlaecheMainOrtPanel extends AbstractAlboFlaechePanel {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler filler41;
    private javax.swing.JComboBox<String> jComboBox31;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JLabel labGrundwassermessstelle;
    private de.cismet.cismap.commons.gui.MappingComponent mappingComponent1;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainOrtPanel object.
     */
    public AlboFlaecheMainOrtPanel() {
        initComponents();
    }

    /**
     * Creates a new AlboFlaecheXXXPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboFlaecheMainOrtPanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    protected void initGui() {
        initComponents();

        if (isEditable()) {
            ((DefaultCismapGeometryComboBoxEditor)jComboBox31).setAllowedGeometryTypes(
                new Class[] { Polygon.class, MultiPolygon.class });
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jPanel9 = new javax.swing.JPanel();
        if (isEditable()) {
            jLabel38 = new javax.swing.JLabel();
        }
        if (isEditable()) {
            jComboBox31 = new DefaultCismapGeometryComboBoxEditor(isEditable());
        }
        filler41 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        mappingComponent1 = new de.cismet.cismap.commons.gui.MappingComponent();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        labGrundwassermessstelle = new javax.swing.JLabel();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel9.setName("jPanel9"); // NOI18N
        jPanel9.setOpaque(false);
        jPanel9.setLayout(new java.awt.GridBagLayout());

        if (isEditable()) {
            org.openide.awt.Mnemonics.setLocalizedText(jLabel38, "Geometrie:");
        }
        if (isEditable()) {
            jLabel38.setName("jLabel38"); // NOI18N
        }
        if (isEditable()) {
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
            jPanel9.add(jLabel38, gridBagConstraints);
        }

        if (isEditable()) {
            jComboBox31.setName("jComboBox31"); // NOI18N
        }

        final org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_geom}"),
                jComboBox31,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        binding.setConverter(isEditable() ? ((DefaultCismapGeometryComboBoxEditor)jComboBox31).getConverter() : null);
        bindingGroup.addBinding(binding);

        if (isEditable()) {
        }
        if (isEditable()) {
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
            jPanel9.add(jComboBox31, gridBagConstraints);
        }

        filler41.setName("filler41"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel9.add(filler41, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel9, gridBagConstraints);

        mappingComponent1.setName("mappingComponent1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(mappingComponent1, gridBagConstraints);

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "Gemarkung:");
        jLabel1.setName("jLabel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, "-");
        jLabel2.setName("jLabel2"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, "Fläche");
        jLabel3.setName("jLabel3"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel3, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, "-");
        jLabel4.setName("jLabel4"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(labGrundwassermessstelle, "suche Messstellen");
        labGrundwassermessstelle.setName("labGrundwassermessstelle"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(labGrundwassermessstelle, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     */
    private void initMap() {
        if (getCidsBean() != null) {
            final Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
            try {
                final XBoundingBox box = new XBoundingBox(geom.getEnvelope().buffer(
                            ClientAlkisConf.getInstance().getGeoBuffer()
                                    * 2));

                final ActiveLayerModel mappingModel = new ActiveLayerModel();
                mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                mappingModel.addHome(new XBoundingBox(
                        box.getX1(),
                        box.getY1(),
                        box.getX2(),
                        box.getY2(),
                        ClientAlkisConf.getInstance().getSrsService(),
                        true));
                final SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(
                            ClientAlkisConf.getInstance().getMapCallString()));
                swms.setName("Altlasten-Flächen");

                // add the raster layer to the model
                mappingModel.addLayer(swms);
                // set the model
                mappingComponent1.setMappingModel(mappingModel);
                // interaction mode
                mappingComponent1.gotoInitialBoundingBox();
                mappingComponent1.setInteractionMode(MappingComponent.ZOOM);
                // finally when all configurations are done ...
                mappingComponent1.unlock();
            } catch (final Exception ex) {
                LOG.warn("could not init Map !", ex);
            }
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void refreshGeomFeatures() {
        mappingComponent1.getFeatureCollection().removeAllFeatures();
        if (getCidsBean() != null) {
            final Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
            if (geom != null) {
                final BufferingGeosearch search = new BufferingGeosearch();
                search.setValidClasses(Arrays.asList(
                        ClassCacheMultiple.getMetaClass(
                            CidsBeanSupport.DOMAIN_NAME,
                            "alkis_landparcel",
                            getConnectionContext())));
                search.setGeometry(geom);

                jLabel4.setText(Math.round(geom.getArea()) + " m²");
                jLabel2.setText("<html><i>wird gesucht...");
                new SwingWorker<CidsBean, Void>() {

                        @Override
                        protected CidsBean doInBackground() throws Exception {
                            // Suche ausführen
                            final Collection<MetaObjectNode> mons = SessionManager.getProxy()
                                        .customServerSearch(
                                            SessionManager.getSession().getUser(),
                                            search,
                                            getConnectionContext());
                            if ((mons != null) && !mons.isEmpty()) {
                                final MetaObjectNode mon = mons.toArray(new MetaObjectNode[0])[0];

                                final MetaObject mo = SessionManager.getProxy()
                                            .getMetaObject(mon.getObjectId(),
                                                mon.getClassId(),
                                                mon.getDomain(),
                                                getConnectionContext());
                                final CidsBean gemarkungBean = mo.getBean();
                                return gemarkungBean;
                            } else {
                                return null;
                            }
                        }

                        @Override
                        protected void done() {
                            try {
                                final CidsBean gemarkungBean = get();
                                if (gemarkungBean != null) {
                                    jLabel2.setText((String)gemarkungBean.getProperty("gemarkung"));
                                } else {
                                    jLabel2.setText("-");
                                }
                            } catch (final Exception ex) {
                                LOG.warn("Geom Search Error.", ex);
                            }
                        }
                    }.execute();

                new SwingWorker<List<CidsBean>, Void>() {

                        @Override
                        protected List<CidsBean> doInBackground() throws Exception {
                            // Suche ausführen
                            final BufferingGeosearch mstSearch = new BufferingGeosearch();
                            mstSearch.setValidClasses(Arrays.asList(
                                    ClassCacheMultiple.getMetaClass(
                                        CidsBeanSupport.DOMAIN_NAME,
                                        "grundwassermessstelle",
                                        getConnectionContext())));
                            mstSearch.setGeometry(geom);
                            mstSearch.setBuffer(100.0);

                            final Collection<MetaObjectNode> mons = SessionManager.getProxy()
                                        .customServerSearch(
                                            SessionManager.getSession().getUser(),
                                            mstSearch,
                                            getConnectionContext());

                            if ((mons != null) && !mons.isEmpty()) {
                                final List<CidsBean> messstellen = new ArrayList<>();

                                for (final MetaObjectNode mon : mons) {
                                    final MetaObject mo = SessionManager.getProxy()
                                                .getMetaObject(mon.getObjectId(),
                                                    mon.getClassId(),
                                                    mon.getDomain(),
                                                    getConnectionContext());

                                    messstellen.add(mo.getBean());
                                }

                                return messstellen;
                            } else {
                                return null;
                            }
                        }

                        @Override
                        protected void done() {
                            try {
                                final List<CidsBean> messstellen = get();

                                if ((messstellen != null) && !messstellen.isEmpty()) {
                                    labGrundwassermessstelle.setText("Grundwassermessstellen vorhanden");

                                    for (final CidsBean mst : messstellen) {
                                        final StyledFeature dsf = new DefaultStyledFeature();
                                        dsf.setGeometry((Geometry)mst.getProperty("geometrie.geo_field"));

                                        try {
                                            final FeatureAnnotationSymbol fas = new FeatureAnnotationSymbol(
                                                    new javax.swing.ImageIcon(
                                                        getClass().getResource(
                                                            "/de/cismet/cids/custom/objecteditors/wunda_blau/blue_cross.png"))
                                                                .getImage());
                                            dsf.setPointAnnotationSymbol(fas);
                                        } catch (final Exception ex) {
                                            LOG.error(ex, ex);
                                        }
                                        mappingComponent1.getFeatureCollection().addFeature(dsf);
                                    }
                                } else {
                                    labGrundwassermessstelle.setText("<html><b>---</b></html>");
                                }
                            } catch (final Exception ex) {
                                LOG.warn("Geom Search Error.", ex);
                            }
                        }
                    }.execute();

                final StyledFeature dsf = new DefaultStyledFeature();
                dsf.setGeometry(geom);
                try {
                    final AlboFlaecheFeatureRenderer renderer = new AlboFlaecheFeatureRenderer();
                    renderer.setMetaObject(getCidsBean().getMetaObject());
                    renderer.assign();
                    dsf.setFillingPaint(renderer.getFillingStyle());
                    dsf.setTransparency(renderer.getTransparency());
                    dsf.setLinePaint(renderer.getLinePaint());
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                }
                mappingComponent1.getFeatureCollection().addFeature(dsf);
            } else {
                jLabel2.setText("-");
                jLabel4.setText("-");
            }
        } else {
            jLabel2.setText("-");
        }
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        initMap();
        refreshGeomFeatures();
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }

    @Override
    public void dispose() {
        if (isEditable()) {
            ((DefaultCismapGeometryComboBoxEditor)jComboBox31).dispose();
        }
        mappingComponent1.dispose();
        super.dispose();
    }
}
