/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import org.apache.log4j.Logger;

import java.awt.image.BufferedImage;

import java.io.InputStream;

import javax.imageio.ImageIO;

import javax.swing.ImageIcon;
import javax.swing.SwingWorker;

import de.cismet.cids.client.tools.WebDavTunnelHelper;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.gui.ImageUtil;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class AlboPicturePanel extends javax.swing.JPanel implements CidsBeanStore, ConnectionContextStore, Disposable {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(AlboPicturePanel.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private ConnectionContext cc;
    private boolean editable;
    private WebDavTunnelHelper webDavHelper;
    private SwingWorker<ImageIcon, Void> imageLoader;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> cbType;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel labBeschreibung;
    private javax.swing.JLabel labName;
    private javax.swing.JLabel labPreview;
    private javax.swing.JLabel labTyp;
    private javax.swing.JLabel labVorschau;
    private javax.swing.JPanel panPreview;
    private javax.swing.JTextArea txtBeschrei;
    private javax.swing.JTextField txtName;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainRclPanel object.
     */
    public AlboPicturePanel() {
        initComponents();
    }

    /**
     * Creates a new AlboFlaecheXXXPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboPicturePanel(final boolean editable) {
        this.editable = editable;

        initComponents();

        if (!editable) {
            RendererTools.makeReadOnly(cbType);
            cbType.setEditable(false);
            RendererTools.makeReadOnly(txtName);
            RendererTools.makeReadOnly(txtBeschrei);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  webDavHelper  the webDavHelper to set
     */
    public void setWebDavHelper(final WebDavTunnelHelper webDavHelper) {
        this.webDavHelper = webDavHelper;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panPreview = new javax.swing.JPanel();
        labTyp = new javax.swing.JLabel();
        cbType = new DefaultBindableScrollableComboBox();
        txtName = new javax.swing.JTextField();
        labName = new javax.swing.JLabel();
        labBeschreibung = new javax.swing.JLabel();
        labPreview = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtBeschrei = new javax.swing.JTextArea();
        labVorschau = new javax.swing.JLabel();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        panPreview.setBorder(javax.swing.BorderFactory.createTitledBorder("Dokument"));
        panPreview.setName("panPreview"); // NOI18N
        panPreview.setOpaque(false);
        panPreview.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(labTyp, "Typ:");
        labTyp.setName("labTyp"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(labTyp, gridBagConstraints);

        ((DefaultBindableScrollableComboBox)cbType).setNullable(true);
        cbType.setName("cbType"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.dokumentart}"),
                cbType,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(cbType, gridBagConstraints);

        txtName.setName("txtName"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                txtName,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(txtName, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(labName, "Name:");
        labName.setName("labName"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(labName, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(labBeschreibung, "Beschreibung:");
        labBeschreibung.setName("labBeschreibung"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(labBeschreibung, gridBagConstraints);

        labPreview.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(labPreview, "nicht verfügbar");
        labPreview.setName("labPreview"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(labPreview, gridBagConstraints);

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        txtBeschrei.setColumns(20);
        txtBeschrei.setRows(5);
        txtBeschrei.setName("txtBeschrei"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.beschreibung}"),
                txtBeschrei,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        jScrollPane1.setViewportView(txtBeschrei);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(labVorschau, "Vorschau:");
        labVorschau.setName("labVorschau"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panPreview.add(labVorschau, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(panPreview, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        try {
            bindingGroup.unbind();
        } catch (final Exception ex) {
        }

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean,
                getConnectionContext());
            this.cidsBean = cidsBean;
            bindingGroup.bind();

            if ((cidsBean.getProperty("dateiname") instanceof String) && (webDavHelper != null)) {
                final String filename = (String)cidsBean.getProperty("dateiname");
                labPreview.setPreferredSize(labPreview.getPreferredSize());
                labPreview.setIcon(null);
                labPreview.setText("wird geladen");

                if (filename.toLowerCase().endsWith("png") || filename.toLowerCase().endsWith("jpg")) {
                    final SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>() {

                            @Override
                            protected ImageIcon doInBackground() throws Exception {
                                final InputStream is = webDavHelper.getFileFromWebDAV((String)cidsBean.getProperty(
                                            "dateiname"),
                                        getConnectionContext());
                                final BufferedImage image = ImageIO.read(is);

                                if (isCancelled()) {
                                    return null;
                                }

                                ImageIcon ic;

                                if ((labPreview.getWidth() > 40) && (labPreview.getHeight() > 40)) {
                                    ic = new ImageIcon(ImageUtil.adjustScale(
                                                image,
                                                labPreview.getWidth()
                                                        - 10,
                                                labPreview.getHeight()
                                                        - 10,
                                                20,
                                                20));
                                } else {
                                    ic = new ImageIcon(image);
                                }

                                if (isCancelled()) {
                                    return null;
                                }
                                return ic;
                            }

                            @Override
                            protected void done() {
                                try {
                                    final ImageIcon ii = get();

                                    if (ii != null) {
                                        labPreview.setText("");
                                        labPreview.setIcon(ii);
                                    }
                                } catch (Exception ex) {
                                    LOG.error(ex);
                                }
                            }
                        };

                    if (imageLoader != null) {
                        imageLoader.cancel(true);
                    }

                    imageLoader = worker;
                    imageLoader.execute();
                } else {
                    labPreview.setIcon(null);
                    labPreview.setText("Für diesen Datentyp ist keine Vorschau verfügbar");
                }
            } else {
                labPreview.setIcon(null);
                labPreview.setText("Vorschau kann nicht geladen werden");
            }
        }
    }

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext cc) {
        this.cc = cc;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return cc;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isEditable() {
        return editable;
    }

    @Override
    public void dispose() {
        setCidsBean(null);
    }
}
