/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.treppe;

import Sirius.server.middleware.types.MetaClass;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.AbstractConnectionContext.Category;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class TreppeEntwaesserungPanel extends javax.swing.JPanel implements CidsBeanStore,
    Disposable,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(TreppeEntwaesserungPanel.class);
    private static final MetaClass MC__ENTWAESSERUNG_ART;
    private static final MetaClass MC__ENTWAESSERUNG_ABLEITUNG;

    static {
        final ConnectionContext connectionContext = ConnectionContext.create(
                Category.STATIC,
                TreppeEntwaesserungPanel.class.getSimpleName());
        MC__ENTWAESSERUNG_ART = ClassCacheMultiple.getMetaClass(
                "WUNDA_BLAU",
                "TREPPE_ENTWAESSERUNG_ART",
                connectionContext);
        MC__ENTWAESSERUNG_ABLEITUNG = ClassCacheMultiple.getMetaClass(
                "WUNDA_BLAU",
                "TREPPE_ENTWAESSERUNG_ABLEITUNG",
                connectionContext);
    }

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private final boolean editable;
    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    DefaultBindableReferenceCombo defaultBindableReferenceCombo4;
    DefaultBindableReferenceCombo defaultBindableReferenceCombo5;
    JTextArea jTextArea6;
    TreppeBauteilZustandKostenPanel treppeBauteilZustandKostenPanel1;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new TreppeEntwaesserungPanel object.
     */
    public TreppeEntwaesserungPanel() {
        this(ConnectionContext.createDeprecated());
    }

    /**
     * Creates a new TreppeLaufPanel object.
     *
     * @param  connectionContext  DOCUMENT ME!
     */
    public TreppeEntwaesserungPanel(final ConnectionContext connectionContext) {
        this(true, connectionContext);
    }

    /**
     * Creates new form TreppePodestPanel.
     *
     * @param  editable           DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public TreppeEntwaesserungPanel(final boolean editable, final ConnectionContext connectionContext) {
        this.editable = editable;
        this.connectionContext = connectionContext;

        initComponents();
        jTextArea6.addKeyListener(new RendererTools.NoTabTextAreaKeyAdapter());
        if (!editable) {
            RendererTools.makeReadOnly(jTextArea6);
            RendererTools.makeReadOnly(defaultBindableReferenceCombo4);
            RendererTools.makeReadOnly(defaultBindableReferenceCombo5);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        final JPanel jPanel28 = new JPanel();
        final RoundedPanel panAllgemein6 = new RoundedPanel();
        final SemiRoundedPanel panBeschreibungTitle6 = new SemiRoundedPanel();
        final JLabel lblHeaderAllgemein7 = new JLabel();
        final JPanel panBeschreibungContent6 = new JPanel();
        final JPanel jPanel29 = new JPanel();
        final JLabel jLabel79 = new JLabel();
        defaultBindableReferenceCombo4 = new DefaultBindableReferenceCombo(MC__ENTWAESSERUNG_ART, true, false);
        final JLabel jLabel80 = new JLabel();
        defaultBindableReferenceCombo5 = new DefaultBindableReferenceCombo(MC__ENTWAESSERUNG_ABLEITUNG, true, false);
        final JLabel jLabel78 = new JLabel();
        final JPanel jPanel2 = new JPanel();
        final JScrollPane jScrollPane7 = new JScrollPane();
        jTextArea6 = new JTextArea();
        final Box.Filler filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        final Box.Filler filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        final JPanel jPanel1 = new JPanel();
        treppeBauteilZustandKostenPanel1 = new TreppeBauteilZustandKostenPanel(editable);
        final Box.Filler filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        final Box.Filler filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        jPanel28.setName("jPanel28"); // NOI18N
        jPanel28.setOpaque(false);
        jPanel28.setLayout(new GridBagLayout());

        panAllgemein6.setName("panAllgemein6"); // NOI18N
        panAllgemein6.setLayout(new GridBagLayout());

        panBeschreibungTitle6.setBackground(new Color(51, 51, 51));
        panBeschreibungTitle6.setName("panBeschreibungTitle6"); // NOI18N
        panBeschreibungTitle6.setLayout(new FlowLayout());

        lblHeaderAllgemein7.setForeground(new Color(255, 255, 255));
        lblHeaderAllgemein7.setHorizontalAlignment(SwingConstants.CENTER);
        Mnemonics.setLocalizedText(
            lblHeaderAllgemein7,
            NbBundle.getMessage(TreppeEntwaesserungPanel.class, "TreppeEntwaesserungPanel.lblHeaderAllgemein7.text")); // NOI18N
        lblHeaderAllgemein7.setName("lblHeaderAllgemein7");                                                            // NOI18N
        panBeschreibungTitle6.add(lblHeaderAllgemein7);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        panAllgemein6.add(panBeschreibungTitle6, gridBagConstraints);

        panBeschreibungContent6.setName("panBeschreibungContent6"); // NOI18N
        panBeschreibungContent6.setOpaque(false);
        panBeschreibungContent6.setLayout(new GridBagLayout());

        jPanel29.setName("jPanel29"); // NOI18N
        jPanel29.setOpaque(false);
        jPanel29.setLayout(new GridBagLayout());

        Mnemonics.setLocalizedText(
            jLabel79,
            NbBundle.getMessage(TreppeEntwaesserungPanel.class, "TreppeEntwaesserungPanel.jLabel79.text")); // NOI18N
        jLabel79.setName("jLabel79");                                                                       // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel29.add(jLabel79, gridBagConstraints);

        defaultBindableReferenceCombo4.setName("defaultBindableReferenceCombo4"); // NOI18N

        Binding binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.art}"),
                defaultBindableReferenceCombo4,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel29.add(defaultBindableReferenceCombo4, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel80,
            NbBundle.getMessage(TreppeEntwaesserungPanel.class, "TreppeEntwaesserungPanel.jLabel80.text")); // NOI18N
        jLabel80.setName("jLabel80");                                                                       // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel29.add(jLabel80, gridBagConstraints);

        defaultBindableReferenceCombo5.setName("defaultBindableReferenceCombo5"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.ableitung}"),
                defaultBindableReferenceCombo5,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel29.add(defaultBindableReferenceCombo5, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel78,
            NbBundle.getMessage(TreppeEntwaesserungPanel.class, "TreppeEntwaesserungPanel.jLabel78.text")); // NOI18N
        jLabel78.setVerticalAlignment(SwingConstants.TOP);
        jLabel78.setName("jLabel78");                                                                       // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel29.add(jLabel78, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setLayout(new BorderLayout());

        jScrollPane7.setName("jScrollPane7"); // NOI18N

        jTextArea6.setColumns(20);
        jTextArea6.setLineWrap(true);
        jTextArea6.setWrapStyleWord(true);
        jTextArea6.setName("jTextArea6"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.bemerkung}"),
                jTextArea6,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        jScrollPane7.setViewportView(jTextArea6);

        jPanel2.add(jScrollPane7, BorderLayout.CENTER);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel29.add(jPanel2, gridBagConstraints);

        filler4.setName("filler4"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(19, 0, 19, 0);
        jPanel29.add(filler4, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panBeschreibungContent6.add(jPanel29, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panAllgemein6.add(panBeschreibungContent6, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        jPanel28.add(panAllgemein6, gridBagConstraints);

        filler2.setName("filler2"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel28.add(filler2, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        add(jPanel28, gridBagConstraints);

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());

        treppeBauteilZustandKostenPanel1.setName("treppeBauteilZustandKostenPanel1"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.zustand}"),
                treppeBauteilZustandKostenPanel1,
                BeanProperty.create("cidsBean"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(treppeBauteilZustandKostenPanel1, gridBagConstraints);

        filler3.setName("filler3"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(filler3, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        add(jPanel1, gridBagConstraints);

        filler1.setName("filler1"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(filler1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        bindingGroup.bind();
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        treppeBauteilZustandKostenPanel1.dispose();
        cidsBean = null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
