/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.treppe;

import Sirius.server.middleware.types.MetaClass;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingWorker;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.server.TreppeMaterialArtLightweightSearch;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.FastBindableReferenceCombo;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class TreppePodestPanel extends javax.swing.JPanel implements CidsBeanStore,
    Disposable,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(TreppePodestPanel.class);

    private static final MetaClass MC__PODEST_MATERIAL;
    private static final MetaClass MC__PODEST_FUGEN;
    private static final MetaClass MC__ENTWAESSERUNG_ART;

    static {
        final ConnectionContext connectionContext = ConnectionContext.create(
                ConnectionContext.Category.STATIC,
                TreppePodestPanel.class.getSimpleName());
        MC__PODEST_MATERIAL = ClassCacheMultiple.getMetaClass(
                "WUNDA_BLAU",
                "TREPPE_PODEST_MATERIAL",
                connectionContext);
        MC__PODEST_FUGEN = ClassCacheMultiple.getMetaClass("WUNDA_BLAU", "TREPPE_PODEST_FUGEN", connectionContext);
        MC__ENTWAESSERUNG_ART = ClassCacheMultiple.getMetaClass(
                "WUNDA_BLAU",
                "TREPPE_ENTWAESSERUNG_ART",
                connectionContext);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        final JPanel jPanel41 = new JPanel();
        final RoundedPanel panAllgemein2 = new RoundedPanel();
        final SemiRoundedPanel panBeschreibungTitle2 = new SemiRoundedPanel();
        final JLabel lblHeaderAllgemein3 = new JLabel();
        final JPanel panBeschreibungContent2 = new JPanel();
        final JPanel jPanel42 = new JPanel();
        final JLabel jLabel57 = new JLabel();
        final JPanel jPanel3 = new JPanel();
        jCheckBox2 = new JCheckBox();
        jCheckBox1 = new JCheckBox();
        jTextField19 = new JTextField();
        final JLabel jLabel71 = new JLabel();
        final JSeparator jSeparator2 = new JSeparator();
        final JLabel jLabel56 = new JLabel();
        final JLabel jLabel1 = new JLabel();
        final JPanel jPanel2 = new JPanel();
        defaultBindableReferenceCombo1 = new DefaultBindableReferenceCombo(MC__PODEST_MATERIAL, true, false);
        fastBindableReferenceCombo1 = new FastBindableReferenceCombo(
                materialArtSearch1,
                materialArtSearch1.getRepresentationPattern(),
                materialArtSearch1.getRepresentationFields());
        fastBindableReferenceCombo2 = new FastBindableReferenceCombo(
                materialArtSearch2,
                materialArtSearch2.getRepresentationPattern(),
                materialArtSearch2.getRepresentationFields());
        final JSeparator jSeparator3 = new JSeparator();
        final JLabel jLabel2 = new JLabel();
        defaultBindableReferenceCombo4 = new DefaultBindableReferenceCombo(MC__ENTWAESSERUNG_ART, true, false);
        final JLabel jLabel3 = new JLabel();
        defaultBindableReferenceCombo5 = new DefaultBindableReferenceCombo(MC__PODEST_FUGEN, true, false);
        final JLabel jLabel55 = new JLabel();
        final JScrollPane jScrollPane2 = new JScrollPane();
        jTextArea2 = new JTextArea();
        final Box.Filler filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        final Box.Filler filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        final JPanel jPanel4 = new JPanel();
        treppeBauteilZustandKostenPanel7 = new TreppeBauteilZustandKostenPanel(editable);
        final Box.Filler filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));
        btnRemoveArt1 = new JButton();
        final JSeparator jSeparator1 = new JSeparator();
        final Box.Filler filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 32767));

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        jPanel41.setName("jPanel41"); // NOI18N
        jPanel41.setOpaque(false);
        jPanel41.setLayout(new GridBagLayout());

        panAllgemein2.setName("panAllgemein2"); // NOI18N
        panAllgemein2.setLayout(new GridBagLayout());

        panBeschreibungTitle2.setBackground(new Color(51, 51, 51));
        panBeschreibungTitle2.setName("panBeschreibungTitle2"); // NOI18N
        panBeschreibungTitle2.setLayout(new FlowLayout());

        lblHeaderAllgemein3.setForeground(new Color(255, 255, 255));
        lblHeaderAllgemein3.setHorizontalAlignment(SwingConstants.CENTER);
        Mnemonics.setLocalizedText(
            lblHeaderAllgemein3,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.lblHeaderAllgemein3.text")); // NOI18N
        lblHeaderAllgemein3.setName("lblHeaderAllgemein3");                                              // NOI18N
        panBeschreibungTitle2.add(lblHeaderAllgemein3);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        panAllgemein2.add(panBeschreibungTitle2, gridBagConstraints);

        panBeschreibungContent2.setName("panBeschreibungContent2"); // NOI18N
        panBeschreibungContent2.setOpaque(false);
        panBeschreibungContent2.setLayout(new GridBagLayout());

        jPanel42.setName("jPanel42"); // NOI18N
        jPanel42.setOpaque(false);
        jPanel42.setLayout(new GridBagLayout());

        Mnemonics.setLocalizedText(
            jLabel57,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel57.text")); // NOI18N
        jLabel57.setName("jLabel57");                                                         // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel57, gridBagConstraints);

        jPanel3.setName("jPanel3"); // NOI18N
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());

        Mnemonics.setLocalizedText(
            jCheckBox2,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jCheckBox2.text")); // NOI18N
        jCheckBox2.setContentAreaFilled(false);
        jCheckBox2.setName("jCheckBox2");                                                       // NOI18N

        Binding binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.antrittspodest_oben}"),
                jCheckBox2,
                BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel3.add(jCheckBox2, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jCheckBox1,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jCheckBox1.text")); // NOI18N
        jCheckBox1.setContentAreaFilled(false);
        jCheckBox1.setName("jCheckBox1");                                                       // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.austrittspodest_unten}"),
                jCheckBox1,
                BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(1, 0, 1, 10);
        jPanel3.add(jCheckBox1, gridBagConstraints);

        jTextField19.setName("jTextField19"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.nummer}"),
                jTextField19,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel3.add(jTextField19, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel71,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel71.text")); // NOI18N
        jLabel71.setName("jLabel71");                                                         // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 10, 1, 10);
        jPanel3.add(jLabel71, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel42.add(jPanel3, gridBagConstraints);

        jSeparator2.setName("jSeparator2"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel42.add(jSeparator2, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel56,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel56.text")); // NOI18N
        jLabel56.setName("jLabel56");                                                         // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel56, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel1,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1");                                                          // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel1, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());

        defaultBindableReferenceCombo1.setName("defaultBindableReferenceCombo1"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.material}"),
                defaultBindableReferenceCombo1,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        defaultBindableReferenceCombo1.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel2.add(defaultBindableReferenceCombo1, gridBagConstraints);

        fastBindableReferenceCombo1.setName("fastBindableReferenceCombo1"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.material_art_1}"),
                fastBindableReferenceCombo1,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 0);
        jPanel2.add(fastBindableReferenceCombo1, gridBagConstraints);

        fastBindableReferenceCombo2.setName("fastBindableReferenceCombo2"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.material_art_2}"),
                fastBindableReferenceCombo2,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 10, 1, 0);
        jPanel2.add(fastBindableReferenceCombo2, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel42.add(jPanel2, gridBagConstraints);

        jSeparator3.setName("jSeparator3"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel42.add(jSeparator3, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel2,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2");                                                          // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel2, gridBagConstraints);

        defaultBindableReferenceCombo4.setName("defaultBindableReferenceCombo4"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.entwaesserung_art}"),
                defaultBindableReferenceCombo4,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel42.add(defaultBindableReferenceCombo4, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel3,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3");                                                          // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel3, gridBagConstraints);

        defaultBindableReferenceCombo5.setName("defaultBindableReferenceCombo5"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.fugen}"),
                defaultBindableReferenceCombo5,
                BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel42.add(defaultBindableReferenceCombo5, gridBagConstraints);

        Mnemonics.setLocalizedText(
            jLabel55,
            NbBundle.getMessage(TreppePodestPanel.class, "TreppePodestPanel.jLabel55.text")); // NOI18N
        jLabel55.setVerticalAlignment(SwingConstants.TOP);
        jLabel55.setName("jLabel55");                                                         // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 5);
        jPanel42.add(jLabel55, gridBagConstraints);

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        jTextArea2.setColumns(20);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setName("jTextArea2"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.bemerkung}"),
                jTextArea2,
                BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        jScrollPane2.setViewportView(jTextArea2);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel42.add(jScrollPane2, gridBagConstraints);

        filler4.setName("filler4"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(19, 0, 19, 0);
        jPanel42.add(filler4, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panBeschreibungContent2.add(jPanel42, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panAllgemein2.add(panBeschreibungContent2, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        jPanel41.add(panAllgemein2, gridBagConstraints);

        filler1.setName("filler1"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel41.add(filler1, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        add(jPanel41, gridBagConstraints);

        jPanel4.setName("jPanel4"); // NOI18N
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new GridBagLayout());

        treppeBauteilZustandKostenPanel7.setName("treppeBauteilZustandKostenPanel7"); // NOI18N

        binding = Bindings.createAutoBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                ELProperty.create("${cidsBean.zustand}"),
                treppeBauteilZustandKostenPanel7,
                BeanProperty.create("cidsBean"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(treppeBauteilZustandKostenPanel7, gridBagConstraints);

        filler3.setName("filler3"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(filler3, gridBagConstraints);

        btnRemoveArt1.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png"))); // NOI18N
        btnRemoveArt1.setBorderPainted(false);
        btnRemoveArt1.setContentAreaFilled(false);
        btnRemoveArt1.setName("btnRemoveArt1");                                                                   // NOI18N
        btnRemoveArt1.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel4.add(btnRemoveArt1, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        add(jPanel4, gridBagConstraints);

        jSeparator1.setName("jSeparator1"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        add(jSeparator1, gridBagConstraints);

        filler2.setName("filler2"); // NOI18N
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(filler2, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements ActionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent evt) {
            if (evt.getSource() == defaultBindableReferenceCombo1) {
                TreppePodestPanel.this.defaultBindableReferenceCombo1ActionPerformed(evt);
            } else if (evt.getSource() == btnRemoveArt1) {
                TreppePodestPanel.this.btnRemoveArt1ActionPerformed(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private TreppePodestePanel parent;
    private final boolean editable;
    private final TreppeMaterialArtLightweightSearch materialArtSearch1;
    private final TreppeMaterialArtLightweightSearch materialArtSearch2;
    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    JButton btnRemoveArt1;
    DefaultBindableReferenceCombo defaultBindableReferenceCombo1;
    DefaultBindableReferenceCombo defaultBindableReferenceCombo4;
    DefaultBindableReferenceCombo defaultBindableReferenceCombo5;
    FastBindableReferenceCombo fastBindableReferenceCombo1;
    FastBindableReferenceCombo fastBindableReferenceCombo2;
    JCheckBox jCheckBox1;
    JCheckBox jCheckBox2;
    JTextArea jTextArea2;
    JTextField jTextField19;
    TreppeBauteilZustandKostenPanel treppeBauteilZustandKostenPanel7;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new TreppePodestPanel object.
     *
     * @param  connectionContext  DOCUMENT ME!
     */
    public TreppePodestPanel(final ConnectionContext connectionContext) {
        this(true, connectionContext);
    }

    /**
     * Creates new form TreppePodestPanel.
     *
     * @param  editable           DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public TreppePodestPanel(final boolean editable, final ConnectionContext connectionContext) {
        this.editable = editable;
        this.connectionContext = connectionContext;
        this.materialArtSearch1 = new TreppeMaterialArtLightweightSearch(
                TreppeMaterialArtLightweightSearch.SearchFor.PODEST,
                "%1$2s",
                new String[] { "NAME" });
        this.materialArtSearch2 = new TreppeMaterialArtLightweightSearch(
                TreppeMaterialArtLightweightSearch.SearchFor.PODEST,
                "%1$2s",
                new String[] { "NAME" });

        materialArtSearch1.setTypId(1);
        materialArtSearch2.setTypId(2);

        initComponents();
        jTextArea2.addKeyListener(new RendererTools.NoTabTextAreaKeyAdapter());
        if (!editable) {
            RendererTools.makeReadOnly(jCheckBox1);
            RendererTools.makeReadOnly(jCheckBox2);
            RendererTools.makeReadOnly(defaultBindableReferenceCombo1);
            RendererTools.makeReadOnly(defaultBindableReferenceCombo4);
            RendererTools.makeReadOnly(defaultBindableReferenceCombo5);
            RendererTools.makeReadOnly(fastBindableReferenceCombo1);
            RendererTools.makeReadOnly(fastBindableReferenceCombo2);
            RendererTools.makeReadOnly(jTextArea2);
            RendererTools.makeReadOnly(jTextField19);
        }
        btnRemoveArt1.setVisible(editable);

        fastBindableReferenceCombo1.setMetaClassFromTableName("WUNDA_BLAU", "treppe_podest_material_art");
        fastBindableReferenceCombo2.setMetaClassFromTableName("WUNDA_BLAU", "treppe_podest_material_art");
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveArt1ActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnRemoveArt1ActionPerformed
        parent.getCidsBeans().remove(cidsBean);
        parent.removePodestPanel(this);
    }                                                                  //GEN-LAST:event_btnRemoveArt1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void defaultBindableReferenceCombo1ActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_defaultBindableReferenceCombo1ActionPerformed
        refreshMaterialTyp();
        fastBindableReferenceCombo1.setSelectedItem(null);
        fastBindableReferenceCombo2.setSelectedItem(null);
    }                                                                                   //GEN-LAST:event_defaultBindableReferenceCombo1ActionPerformed
    /**
     * DOCUMENT ME!
     */
    private void refreshMaterialTyp() {
        materialArtSearch1.setMaterialId((Integer)cidsBean.getProperty("material.id"));
        materialArtSearch2.setMaterialId((Integer)cidsBean.getProperty("material.id"));

        new SwingWorker<Void, Void>() {

                @Override
                protected Void doInBackground() throws Exception {
                    fastBindableReferenceCombo1.refreshModel();
                    fastBindableReferenceCombo2.refreshModel();
                    return null;
                }
            }.execute();
    }

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        bindingGroup.bind();

        if (cidsBean != null) {
            refreshMaterialTyp();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  parent  DOCUMENT ME!
     */
    public void setParent(final TreppePodestePanel parent) {
        this.parent = parent;
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        treppeBauteilZustandKostenPanel7.dispose();
        cidsBean = null;
        parent = null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
