/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objectrenderer.utils.billing;

import org.apache.log4j.Logger;

import java.awt.CardLayout;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.Calendar;
import java.util.Date;

import javax.swing.Action;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class TimeFilterPanel extends javax.swing.JPanel implements FilterSettingChangedTrigger {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(TimeFilterPanel.class);
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");

    //~ Instance fields --------------------------------------------------------

    private Action filterAction;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup btngTimeFilters;
    private javax.swing.JComboBox cboMonth;
    private javax.swing.JComboBox cboQuarter;
    private javax.swing.JComboBox cboYear_Month;
    private javax.swing.JComboBox cboYear_Quarter;
    private org.jdesktop.swingx.JXDatePicker dpFrom;
    private org.jdesktop.swingx.JXDatePicker dpTill;
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler2;
    private javax.swing.Box.Filler filler3;
    private javax.swing.Box.Filler filler4;
    private javax.swing.Box.Filler filler5;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel pnlDateRange;
    private javax.swing.JPanel pnlIgnore;
    private javax.swing.JPanel pnlMonth;
    private javax.swing.JPanel pnlQuarter;
    private javax.swing.JPanel pnlTimeFilterCards;
    private javax.swing.JPanel pnlTimeFilters;
    private javax.swing.JPanel pnlToday;
    private javax.swing.JToggleButton tbtnDateRange;
    private javax.swing.JToggleButton tbtnIgnore;
    private javax.swing.JToggleButton tbtnMonth;
    private javax.swing.JToggleButton tbtnQuarter;
    private javax.swing.JToggleButton tbtnToday;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form TimeFilterPanel.
     */
    public TimeFilterPanel() {
        initComponents();
        setTimeRelatedModels();
        selectCurrentDates();

        // set Zoomable has to be set to activate the SpinningCalendarHeaderHandler. for more information see
        // JXDatePickerHeaderTakeoff or http://stackoverflow.com/questions/16111943/java-swing-jxdatepicker
        dpFrom.getMonthView().setZoomable(true);
        dpTill.getMonthView().setZoomable(true);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        btngTimeFilters = new javax.swing.ButtonGroup();
        pnlTimeFilters = new javax.swing.JPanel();
        pnlTimeFilterCards = new javax.swing.JPanel();
        pnlIgnore = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        filler5 = new javax.swing.Box.Filler(new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 32767));
        pnlToday = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 32767));
        pnlMonth = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        cboMonth = new javax.swing.JComboBox();
        cboYear_Month = new javax.swing.JComboBox();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 32767));
        pnlQuarter = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        cboQuarter = new javax.swing.JComboBox();
        cboYear_Quarter = new javax.swing.JComboBox();
        filler4 = new javax.swing.Box.Filler(new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 0),
                new java.awt.Dimension(1, 32767));
        pnlDateRange = new javax.swing.JPanel();
        dpTill = new org.jdesktop.swingx.JXDatePicker();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        dpFrom = new org.jdesktop.swingx.JXDatePicker();
        filler3 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        tbtnToday = new javax.swing.JToggleButton();
        tbtnIgnore = new javax.swing.JToggleButton();
        tbtnMonth = new javax.swing.JToggleButton();
        tbtnDateRange = new javax.swing.JToggleButton();
        tbtnQuarter = new javax.swing.JToggleButton();

        setLayout(new java.awt.GridBagLayout());

        pnlTimeFilters.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 2, 0, 2));
        pnlTimeFilters.setLayout(new java.awt.GridBagLayout());

        pnlTimeFilterCards.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        pnlTimeFilterCards.setLayout(new java.awt.CardLayout());

        pnlIgnore.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel13,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel13.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        pnlIgnore.add(jLabel13, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlIgnore.add(filler5, gridBagConstraints);

        pnlTimeFilterCards.add(pnlIgnore, "pnlIgnore");

        pnlToday.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel9,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel9.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        pnlToday.add(jLabel9, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlToday.add(filler2, gridBagConstraints);

        pnlTimeFilterCards.add(pnlToday, "pnlToday");

        pnlMonth.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel3,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel3.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(10, 6, 3, 3);
        pnlMonth.add(jLabel3, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel10,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel10.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 10, 3);
        pnlMonth.add(jLabel10, gridBagConstraints);

        cboMonth.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Januar", "Februar", "März" }));
        cboMonth.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboMonthActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(10, 2, 3, 0);
        pnlMonth.add(cboMonth, gridBagConstraints);

        cboYear_Month.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "2013" }));
        cboYear_Month.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboYear_MonthActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 10, 0);
        pnlMonth.add(cboYear_Month, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlMonth.add(filler1, gridBagConstraints);

        pnlTimeFilterCards.add(pnlMonth, "pnlMonth");

        pnlQuarter.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel11,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel11.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(10, 6, 4, 3);
        pnlQuarter.add(jLabel11, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel12,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel12.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 10, 3);
        pnlQuarter.add(jLabel12, gridBagConstraints);

        cboQuarter.setModel(new javax.swing.DefaultComboBoxModel(
                new String[] { "Januar - März", "April - Juni", "Juli - September", "Oktober - Dezember" }));
        cboQuarter.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboQuarterActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(10, 3, 4, 0);
        pnlQuarter.add(cboQuarter, gridBagConstraints);

        cboYear_Quarter.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "2013" }));
        cboYear_Quarter.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboYear_QuarterActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 10, 0);
        pnlQuarter.add(cboYear_Quarter, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlQuarter.add(filler4, gridBagConstraints);

        pnlTimeFilterCards.add(pnlQuarter, "pnlQuarter");

        pnlDateRange.setLayout(new java.awt.GridBagLayout());

        dpTill.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    dpTillActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 10, 0);
        pnlDateRange.add(dpTill, gridBagConstraints);
        dpTill.setFormats(DATE_FORMAT);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel7,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel7.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 6, 4, 3);
        pnlDateRange.add(jLabel7, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel8,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.jLabel8.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 10, 3);
        pnlDateRange.add(jLabel8, gridBagConstraints);

        dpFrom.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    dpFromActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(10, 3, 4, 0);
        pnlDateRange.add(dpFrom, gridBagConstraints);
        dpFrom.setFormats(DATE_FORMAT);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        pnlDateRange.add(filler3, gridBagConstraints);

        pnlTimeFilterCards.add(pnlDateRange, "pnlDateRange");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        pnlTimeFilters.add(pnlTimeFilterCards, gridBagConstraints);

        btngTimeFilters.add(tbtnToday);
        org.openide.awt.Mnemonics.setLocalizedText(
            tbtnToday,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.tbtnToday.text")); // NOI18N
        tbtnToday.setMaximumSize(new java.awt.Dimension(500, 25));
        tbtnToday.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    tbtnTodayActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        pnlTimeFilters.add(tbtnToday, gridBagConstraints);

        btngTimeFilters.add(tbtnIgnore);
        tbtnIgnore.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(
            tbtnIgnore,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.tbtnIgnore.text")); // NOI18N
        tbtnIgnore.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    tbtnIgnoreActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        pnlTimeFilters.add(tbtnIgnore, gridBagConstraints);

        btngTimeFilters.add(tbtnMonth);
        org.openide.awt.Mnemonics.setLocalizedText(
            tbtnMonth,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.tbtnMonth.text")); // NOI18N
        tbtnMonth.setMaximumSize(new java.awt.Dimension(500, 25));
        tbtnMonth.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    tbtnMonthActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        pnlTimeFilters.add(tbtnMonth, gridBagConstraints);

        btngTimeFilters.add(tbtnDateRange);
        org.openide.awt.Mnemonics.setLocalizedText(
            tbtnDateRange,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.tbtnDateRange.text")); // NOI18N
        tbtnDateRange.setMaximumSize(new java.awt.Dimension(500, 25));
        tbtnDateRange.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    tbtnDateRangeActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.weightx = 1.0;
        pnlTimeFilters.add(tbtnDateRange, gridBagConstraints);

        btngTimeFilters.add(tbtnQuarter);
        org.openide.awt.Mnemonics.setLocalizedText(
            tbtnQuarter,
            org.openide.util.NbBundle.getMessage(TimeFilterPanel.class, "TimeFilterPanel.tbtnQuarter.text")); // NOI18N
        tbtnQuarter.setMaximumSize(new java.awt.Dimension(500, 25));
        tbtnQuarter.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    tbtnQuarterActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        pnlTimeFilters.add(tbtnQuarter, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(pnlTimeFilters, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboMonthActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboMonthActionPerformed
        filterSettingChanged();
    }                                                                            //GEN-LAST:event_cboMonthActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboYear_MonthActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboYear_MonthActionPerformed
        filterSettingChanged();
    }                                                                                 //GEN-LAST:event_cboYear_MonthActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboQuarterActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboQuarterActionPerformed
        filterSettingChanged();
    }                                                                              //GEN-LAST:event_cboQuarterActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboYear_QuarterActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboYear_QuarterActionPerformed
        filterSettingChanged();
    }                                                                                   //GEN-LAST:event_cboYear_QuarterActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void dpTillActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_dpTillActionPerformed
        checkDateRange();
    }                                                                          //GEN-LAST:event_dpTillActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void dpFromActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_dpFromActionPerformed
        checkDateRange();
    }                                                                          //GEN-LAST:event_dpFromActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tbtnTodayActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_tbtnTodayActionPerformed
        changeVisibleTimeFilterPanel();
        filterSettingChanged();
    }                                                                             //GEN-LAST:event_tbtnTodayActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tbtnMonthActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_tbtnMonthActionPerformed
        changeVisibleTimeFilterPanel();
        filterSettingChanged();
    }                                                                             //GEN-LAST:event_tbtnMonthActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tbtnDateRangeActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_tbtnDateRangeActionPerformed
        changeVisibleTimeFilterPanel();
    }                                                                                 //GEN-LAST:event_tbtnDateRangeActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tbtnQuarterActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_tbtnQuarterActionPerformed
        changeVisibleTimeFilterPanel();
        filterSettingChanged();
    }                                                                               //GEN-LAST:event_tbtnQuarterActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tbtnIgnoreActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_tbtnIgnoreActionPerformed
        changeVisibleTimeFilterPanel();
        filterSettingChanged();
    }                                                                              //GEN-LAST:event_tbtnIgnoreActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void changeVisibleTimeFilterPanel() {
        final CardLayout cardLayout = (CardLayout)pnlTimeFilterCards.getLayout();
        if (tbtnIgnore.isSelected()) {
            cardLayout.show(pnlTimeFilterCards, "pnlIgnore");
        } else if (tbtnToday.isSelected()) {
            cardLayout.show(pnlTimeFilterCards, "pnlToday");
        } else if (tbtnMonth.isSelected()) {
            cardLayout.show(pnlTimeFilterCards, "pnlMonth");
        } else if (tbtnQuarter.isSelected()) {
            cardLayout.show(pnlTimeFilterCards, "pnlQuarter");
        } else if (tbtnDateRange.isSelected()) {
            cardLayout.show(pnlTimeFilterCards, "pnlDateRange");
        } else {
            LOG.warn("No toggle button, to show a time filter, is selected. This should never happen.");
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void checkDateRange() {
        final Date from = dpFrom.getDate();
        final Date till = dpTill.getDate();
        if (((from != null) && (till != null) && from.before(till)) || from.equals(till)) {
            filterAction.actionPerformed(null);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public Action getFilterSettingChangedAction() {
        return filterAction;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  filterAction  DOCUMENT ME!
     */
    @Override
    public void setFilterSettingChangedAction(final Action filterAction) {
        this.filterAction = filterAction;
    }

    /**
     * DOCUMENT ME!
     */
    private void setTimeRelatedModels() {
        // set localised month January - December to ComboBox
        final String[] months = getMonthStrings();
        cboMonth.setModel(new javax.swing.DefaultComboBoxModel(months));

        // put the last 100 year numbers into the comboboxes
        final int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        final Integer[] years = new Integer[100];
        for (int i = 0; i < 100; i++) {
            years[i] = new Integer(currentYear - i);
        }
        cboYear_Month.setModel(new javax.swing.DefaultComboBoxModel<Integer>(years));
        cboYear_Quarter.setModel(new javax.swing.DefaultComboBoxModel<Integer>(years));
    }

    /**
     * DOCUMENT ME!
     */
    private void selectCurrentDates() {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        final int month = cal.get(Calendar.MONTH);
        cboMonth.setSelectedIndex(month);

        final int quarter = month / 3;
        cboQuarter.setSelectedIndex(quarter);
    }

    /**
     * DateFormatSymbols returns an extra, empty value at the end of the array of months. Remove it.
     *
     * @return  DOCUMENT ME!
     */
    private static String[] getMonthStrings() {
        final String[] months = new java.text.DateFormatSymbols().getMonths();
        final int lastIndex = months.length - 1;

        if ((months[lastIndex] == null)
                    || (months[lastIndex].length() <= 0)) { // last item empty
            final String[] monthStrings = new String[lastIndex];
            System.arraycopy(months, 0,
                monthStrings, 0, lastIndex);
            return monthStrings;
        } else {                                            // last item not empty
            return months;
        }
    }

    /**
     * a Date array with two elements representing a time span (the two dates are not null), a single day (the second
     * date is null) or nothing (both dates are null). date[0] = from Date date[1] = till Date
     *
     * @return  DOCUMENT ME!
     */
    public Date[] chooseDates() {
        // default value is today
        final Date[] fromDate_tillDate = new Date[] { null, null };
        if (tbtnToday.isSelected()) {
            fromDate_tillDate[0] = new Date();
        } else if (tbtnMonth.isSelected()) {
            final Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(Calendar.MONTH, cboMonth.getSelectedIndex());
            calendar.set(Calendar.YEAR, (Integer)cboYear_Month.getSelectedItem());
            fromDate_tillDate[0] = calendar.getTime();
            calendar.add(Calendar.MONTH, 1);
            calendar.add(Calendar.DAY_OF_MONTH, -1);
            fromDate_tillDate[1] = calendar.getTime();
        } else if (tbtnQuarter.isSelected()) {
            final Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(Calendar.MONTH, cboQuarter.getSelectedIndex() * 3);
            calendar.set(Calendar.YEAR, (Integer)cboYear_Quarter.getSelectedItem());
            fromDate_tillDate[0] = calendar.getTime();
            calendar.add(Calendar.MONTH, 3);
            calendar.add(Calendar.DAY_OF_MONTH, -1);
            fromDate_tillDate[1] = calendar.getTime();
        } else if (tbtnDateRange.isSelected()) {
            final Date from = dpFrom.getDate();
            if (from != null) {
                fromDate_tillDate[0] = from;
                fromDate_tillDate[1] = dpTill.getDate();
            }
        }
        return fromDate_tillDate;
    }

    /**
     * DOCUMENT ME!
     */
    public void filterSettingChanged() {
        if (filterAction != null) {
            filterAction.actionPerformed(null);
        }
    }
}
