/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 *  Copyright (C) 2010 srichter
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Alkis_gebaeudeRendererPanel.java
 *
 * Created on 06.01.2010, 16:32:30
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.wunda_blau.search.server.AdresseGebaeudeLightweightSearch;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.collections.TypeSafeCollections;

/**
 * DOCUMENT ME!
 *
 * @author   srichter
 * @version  $Revision$, $Date$
 */
public class AlkisGebaeudeRendererPanel extends javax.swing.JPanel implements DisposableCidsBeanStore,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            AlkisGebaeudeRendererPanel.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblBauweise;
    private javax.swing.JLabel lblDescBauweise;
    private javax.swing.JLabel lblDescFlurstuecke;
    private javax.swing.JLabel lblDescFunktion;
    private javax.swing.JLabel lblDescLage;
    private javax.swing.JLabel lblDescStockwerkeOber;
    private javax.swing.JLabel lblDescStockwerkeUnter;
    private javax.swing.JLabel lblFunktion;
    private javax.swing.JLabel lblLage;
    private javax.swing.JLabel lblStockwerkeOber;
    private javax.swing.JLabel lblStockwerkeUnter;
    private javax.swing.JList lstLandparcels;
    private javax.swing.JPanel panGebaeudeContent;
    private javax.swing.JScrollPane scpLandparcels;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlkisGebaeudeRendererPanel object.
     *
     * @param  connectionContext  DOCUMENT ME!
     */
    public AlkisGebaeudeRendererPanel(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panGebaeudeContent = new javax.swing.JPanel();
        lblDescFunktion = new javax.swing.JLabel();
        lblDescStockwerkeOber = new javax.swing.JLabel();
        lblFunktion = new javax.swing.JLabel();
        lblStockwerkeOber = new javax.swing.JLabel();
        lblDescBauweise = new javax.swing.JLabel();
        lblBauweise = new javax.swing.JLabel();
        lblDescStockwerkeUnter = new javax.swing.JLabel();
        lblStockwerkeUnter = new javax.swing.JLabel();
        scpLandparcels = new javax.swing.JScrollPane();
        lstLandparcels = new javax.swing.JList();
        lblDescFlurstuecke = new javax.swing.JLabel();
        lblDescLage = new javax.swing.JLabel();
        lblLage = new javax.swing.JLabel();

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        panGebaeudeContent.setOpaque(false);
        panGebaeudeContent.setLayout(new java.awt.GridBagLayout());

        lblDescFunktion.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescFunktion.setText("Funktion:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescFunktion, gridBagConstraints);

        lblDescStockwerkeOber.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescStockwerkeOber.setText("Oberirdische Geschosse:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescStockwerkeOber, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.funktion}"),
                lblFunktion,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("keine Angabe");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panGebaeudeContent.add(lblFunktion, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geschosse_oberirdisch}"),
                lblStockwerkeOber,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("keine Angabe");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panGebaeudeContent.add(lblStockwerkeOber, gridBagConstraints);

        lblDescBauweise.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescBauweise.setText("Bauweise:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescBauweise, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.bauweise}"),
                lblBauweise,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("keine Angabe");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panGebaeudeContent.add(lblBauweise, gridBagConstraints);

        lblDescStockwerkeUnter.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescStockwerkeUnter.setText("Unterirdische Geschosse:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescStockwerkeUnter, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geschosse_unterirdisch}"),
                lblStockwerkeUnter,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("keine Angabe");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panGebaeudeContent.add(lblStockwerkeUnter, gridBagConstraints);

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.landparcels}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                        this,
                        eLProperty,
                        lstLandparcels);
        jListBinding.setSourceNullValue(null);
        jListBinding.setSourceUnreadableValue(null);
        bindingGroup.addBinding(jListBinding);

        lstLandparcels.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lstLandparcelsMouseClicked(evt);
                }
            });
        scpLandparcels.setViewportView(lstLandparcels);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(scpLandparcels, gridBagConstraints);

        lblDescFlurstuecke.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescFlurstuecke.setText("Das Gebäude ist auf folgendem Flurstück errichtet:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescFlurstuecke, gridBagConstraints);

        lblDescLage.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblDescLage.setText("Lage:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panGebaeudeContent.add(lblDescLage, gridBagConstraints);

        lblLage.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panGebaeudeContent.add(lblLage, gridBagConstraints);

        add(panGebaeudeContent, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cb  DOCUMENT ME!
     */
    @Override
    public void setCidsBean(final CidsBean cb) {
        bindingGroup.unbind();
        if (cb != null) {
            cidsBean = cb;
            initLageLabel(getAllAdressesForSameBuilding());
            bindingGroup.bind();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  sameBuildingAdresses  DOCUMENT ME!
     */
    private void initLageLabel(final MetaObject[] sameBuildingAdresses) {
        final Map<String, List<String>> multiMap = TypeSafeCollections.newLinkedHashMap();
        for (final MetaObject adressMO : sameBuildingAdresses) {
            if (adressMO instanceof LightweightMetaObject) {
                final LightweightMetaObject lwmo = (LightweightMetaObject)adressMO;
                final Object strasse = lwmo.getLWAttribute("strasse");
                final Object nummer = lwmo.getLWAttribute("nummer");
                if (strasse != null) {
                    List<String> bucket = multiMap.get(strasse.toString());
                    if (bucket == null) {
                        bucket = TypeSafeCollections.newArrayList();
                        multiMap.put(strasse.toString(), bucket);
                    }
                    if (nummer != null) {
                        bucket.add(nummer.toString());
                    }
                }
            }
        }
        final StringBuilder lageTxt = new StringBuilder("<html>");
        int size = multiMap.size();
        for (final Entry<String, List<String>> entry : multiMap.entrySet()) {
            final String strasse = entry.getKey();
            final List<String> nummern = entry.getValue();
            lageTxt.append(strasse);
            if (nummern.size() > 0) {
                lageTxt.append(" ");
                for (int i = 0; i < nummern.size(); ++i) {
                    lageTxt.append(nummern.get(i));
                    if (i < (nummern.size() - 1)) {
                        lageTxt.append(", ");
                    }
                }
            }
            if (--size > 0) {
                lageTxt.append("<br>");
            }
        }
        lageTxt.append("</html>");
        lblLage.setText(lageTxt.toString());
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private MetaObject[] getAllAdressesForSameBuilding() {
        if (cidsBean != null) {
            final Object idObj = cidsBean.getProperty("id");
            if (idObj instanceof Integer) {
                final Integer gebaeudeId = (Integer)idObj;
                try {
                    final AdresseGebaeudeLightweightSearch search = new AdresseGebaeudeLightweightSearch();
                    search.setRepresentationFields(new String[] { "id", "strasse", "nummer" });
                    search.setGebaudeId(gebaeudeId);
                    final Collection<LightweightMetaObject> lwmos = SessionManager.getProxy()
                                .customServerSearch(search, getConnectionContext());
                    for (final LightweightMetaObject lwmo : lwmos) {
                        lwmo.setFormater(new AbstractAttributeRepresentationFormater() {

                                @Override
                                public String getRepresentation() {
                                    final StringBuilder result = new StringBuilder();
                                    result.append(getAttribute("strasse")).append(" ").append(getAttribute("nummer"));
                                    return result.toString();
                                }
                            });
                    }
                    return lwmos.toArray(new MetaObject[0]);
                } catch (final ConnectionException ex) {
                    LOG.error(ex, ex);
                    return null;
                }
            }
        }
        return new MetaObject[0];
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lstLandparcelsMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lstLandparcelsMouseClicked
        if (evt.getClickCount() > 1) {
            final Object selection = lstLandparcels.getSelectedValue();
            if (selection instanceof CidsBean) {
                final CidsBean selBean = (CidsBean)selection;
                final Object jumpID = selBean.getProperty("fullobjectid");
                if (jumpID instanceof Integer) {
                    final String tabname = "alkis_landparcel";
                    final MetaClass mc = ClassCacheMultiple.getMetaClass(
                            CidsBeanSupport.DOMAIN_NAME,
                            tabname,
                            getConnectionContext());
                    if (mc != null) {
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(mc, (Integer)jumpID, "");
                    } else {
                        LOG.error("Could not find MetaClass for " + tabname);
                    }
                }
            }
        }
    }                                                                              //GEN-LAST:event_lstLandparcelsMouseClicked

    /**
     * DOCUMENT ME!
     */
    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
