/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import org.apache.log4j.Logger;

import java.util.Date;

import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.cismet.cids.custom.deprecated.CoolTabPanel;
import de.cismet.cids.custom.deprecated.JBreakLabel;
import de.cismet.cids.custom.deprecated.TabbedPaneUITransparent;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
public class Bplan_verfahrenRenderer extends JPanel implements CidsBeanRenderer,
    ChangeListener,
    RequestsFullSizeComponent {

    //~ Static fields/initializers ---------------------------------------------

    private static final String TITLE = "Bebauungsplanverfahren";
    private static final int HISTORIE_INDEX = 1;
    private static int lastSelected = 0;
    private static Date timer = new Date();

    private static final Logger LOG = Logger.getLogger(Bplan_verfahrenRenderer.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

// Historie

    private Object historie = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel lblAlkRelevant;
    private javax.swing.JLabel lblNummer;
    private javax.swing.JLabel lblStatus;
    private javax.swing.JPanel panAlkis;
    private javax.swing.JPanel panAllgemein;
    private javax.swing.JPanel panContent;
    private de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel panPreviewMap;
    private javax.swing.JPanel panTabAlkis;
    private javax.swing.JPanel panTabAllgemein;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JTextArea txtBezeichnung;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form CoolTIMRenderer.
     */
    public Bplan_verfahrenRenderer() {
        initComponents();
        tabbedPane.addChangeListener(this);
        if ((new Date().getTime() - timer.getTime()) < (60 * 1000L)) {
            tabbedPane.setSelectedIndex(lastSelected);
        }
        assignSingle();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     */
    public void assignSingle() {
        // ALKIS-Assign
        if (historie != null) {
        } else {
            tabbedPane.removeTabAt(HISTORIE_INDEX);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panContent = new javax.swing.JPanel();
        panPreviewMap = new de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel();
        tabbedPane = new javax.swing.JTabbedPane();
        tabbedPane.setUI(new TabbedPaneUITransparent());
        panTabAllgemein = new CoolTabPanel();
        panAllgemein = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        lblNummer = new JBreakLabel();
        lblStatus = new javax.swing.JLabel();
        txtBezeichnung = new javax.swing.JTextArea();
        panTabAlkis = new CoolTabPanel();
        panAlkis = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        lblAlkRelevant = new javax.swing.JLabel();

        setMinimumSize(new java.awt.Dimension(400, 300));
        setLayout(new java.awt.BorderLayout());

        panContent.setOpaque(false);
        panContent.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        panContent.add(panPreviewMap, gridBagConstraints);

        tabbedPane.setTabPlacement(javax.swing.JTabbedPane.LEFT);
        tabbedPane.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N

        panTabAllgemein.setOpaque(false);
        panTabAllgemein.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 10, 5));

        panAllgemein.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panAllgemein.setOpaque(false);
        panAllgemein.setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel1.setText("Nummer:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 30);
        panAllgemein.add(jLabel1, gridBagConstraints);

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel2.setText("Bezeichnung:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 30);
        panAllgemein.add(jLabel2, gridBagConstraints);
        jLabel2.getAccessibleContext().setAccessibleName("Bezeichnung");

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel3.setText("Status:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 30);
        panAllgemein.add(jLabel3, gridBagConstraints);
        jLabel3.getAccessibleContext().setAccessibleName("Status");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.nummer}"),
                lblNummer,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        panAllgemein.add(lblNummer, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.status}"),
                lblStatus,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        panAllgemein.add(lblStatus, gridBagConstraints);

        txtBezeichnung.setEditable(false);
        txtBezeichnung.setColumns(30);
        txtBezeichnung.setLineWrap(true);
        txtBezeichnung.setRows(1);
        txtBezeichnung.setToolTipText("");
        txtBezeichnung.setWrapStyleWord(true);
        txtBezeichnung.setBorder(null);
        txtBezeichnung.setOpaque(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                txtBezeichnung,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        panAllgemein.add(txtBezeichnung, gridBagConstraints);

        panTabAllgemein.add(panAllgemein);

        tabbedPane.addTab("Allgemein", panTabAllgemein);

        panTabAlkis.setOpaque(false);
        panTabAlkis.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 10, 5));

        panAlkis.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panAlkis.setOpaque(false);
        panAlkis.setLayout(new java.awt.GridBagLayout());

        jLabel9.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel9.setText("ALKIS relevant");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 30);
        panAlkis.add(jLabel9, gridBagConstraints);

        lblAlkRelevant.setText("ja/nein");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        panAlkis.add(lblAlkRelevant, gridBagConstraints);

        panTabAlkis.add(panAlkis);

        tabbedPane.addTab("Historie", panTabAlkis);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 10);
        panContent.add(tabbedPane, gridBagConstraints);

        add(panContent, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void stateChanged(final ChangeEvent e) {
        lastSelected = tabbedPane.getSelectedIndex();
        timer = new Date();
    }

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            panPreviewMap.initMap(cidsBean, "geometrie.geo_field");
            bindingGroup.bind();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        String title = cidsBean.toString();
        if (title != null) {
            if (title.length() > 50) {
                title = title.substring(0, 50);
                title = title + "...";
            }
            title = TITLE + " - " + title;
        } else {
            title = TITLE;
        }

        return title;
    }

    @Override
    public void setTitle(final String title) {
    }
}
