/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.swing.JPanel;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
public class KehrbezirkRenderer extends JPanel implements CidsBeanRenderer, RequestsFullSizeComponent {

    //~ Static fields/initializers ---------------------------------------------

    private static final String TITLE = "Kehrbezirk";

    private static final Logger LOG = Logger.getLogger(KehrbezirkRenderer.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel panPreviewMap;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form CoolKehrbezirkRenderer.
     */
    public KehrbezirkRenderer() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            panPreviewMap.initMap(cidsBean, "ausdehnung.geo_field");
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getTitle() {
        final String name = (String)cidsBean.getProperty("k_bezirk");
        if (StringUtils.isBlank(name)) {
            return TITLE;
        } else {
            return TITLE + " - " + name;
        }
    }

    @Override
    public void setTitle(final String title) {
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        panPreviewMap = new de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel();

        setMinimumSize(new java.awt.Dimension(420, 250));
        setPreferredSize(new java.awt.Dimension(420, 300));
        setLayout(new java.awt.BorderLayout());
        add(panPreviewMap, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents
}
