/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wunda_blau.search;

import com.fasterxml.jackson.databind.ObjectMapper;

import lombok.Getter;

import org.openide.util.lookup.ServiceProvider;

import java.awt.Component;

import java.util.ArrayList;
import java.util.Collection;

import de.cismet.cids.custom.wunda_blau.search.abfrage.AbfragePanel;
import de.cismet.cids.custom.wunda_blau.search.abfrage.AbstractAbfragePanel;
import de.cismet.cids.custom.wunda_blau.search.server.PotenzialflaecheSearch;

import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = AbfragePanel.class)
public class PotenzialflaechenWindowSearchPanel extends AbstractAbfragePanel<PotenzialflaecheSearch.Configuration> {

    //~ Instance fields --------------------------------------------------------

    @Getter private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbMapSearch;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblFiller5;
    private javax.swing.JLabel lblFiller6;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlMessung;
    private javax.swing.JPanel pnlScrollPane;
    private javax.swing.JPanel pnlSearchMode;
    private javax.swing.JRadioButton rbAll;
    private javax.swing.JRadioButton rbOne;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form PotenzialflaechenWindowSearchPanel.
     */
    public PotenzialflaechenWindowSearchPanel() {
        this(true);
    }

    /**
     * Creates a new PotenzialflaechenWindowSearchPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public PotenzialflaechenWindowSearchPanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public PotenzialflaecheSearch.Configuration createConfiguration() {
        final PotenzialflaecheSearch.SearchMode searchMode = rbAll.isSelected() ? PotenzialflaecheSearch.SearchMode.AND
                                                                                : PotenzialflaecheSearch.SearchMode.OR;

        final PotenzialflaecheSearch.Configuration searchConfiguration = new PotenzialflaecheSearch.Configuration();
        searchConfiguration.setSearchMode(searchMode);
        searchConfiguration.getFilters().addAll(getFilters());

        return searchConfiguration;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  configuration  DOCUMENT ME!
     */
    @Override
    public void initFromConfiguration(final PotenzialflaecheSearch.Configuration configuration) {
        if (configuration != null) {
            rbAll.setSelected(!PotenzialflaecheSearch.SearchMode.OR.equals(configuration.getSearchMode()));
            setFilters(configuration.getFilters());
        } else {
            rbAll.setSelected(true);
            setFilters(null);
        }
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        pnlScrollPane = new javax.swing.JPanel();
        pnlSearchMode = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        rbAll = new javax.swing.JRadioButton();
        rbOne = new javax.swing.JRadioButton();
        lblFiller5 = new javax.swing.JLabel();
        pnlMessung = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        pnlButtons = new javax.swing.JPanel();
        cbMapSearch = new javax.swing.JCheckBox();
        lblFiller6 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jScrollPane1.setViewportBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));

        pnlScrollPane.setBorder(javax.swing.BorderFactory.createTitledBorder(
                org.openide.util.NbBundle.getMessage(
                    PotenzialflaechenWindowSearchPanel.class,
                    "PotenzialflaechenWindowSearchPanel.pnlScrollPane.border.title"))); // NOI18N
        pnlScrollPane.setLayout(new java.awt.GridBagLayout());

        pnlSearchMode.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlSearchMode.add(jLabel1, gridBagConstraints);

        buttonGroup1.add(rbAll);
        rbAll.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbAll,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.rbAll.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 20);
        pnlSearchMode.add(rbAll, gridBagConstraints);

        buttonGroup1.add(rbOne);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbOne,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.rbOne.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        pnlSearchMode.add(rbOne, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFiller5,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.lblFiller5.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlSearchMode.add(lblFiller5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 25, 0, 25);
        pnlScrollPane.add(pnlSearchMode, gridBagConstraints);

        pnlMessung.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        pnlMessung.setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridLayout(0, 1, 0, 5));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel2.add(jPanel1, gridBagConstraints);

        jButton1.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            jButton1,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.jButton1.text"));                                // NOI18N
        jButton1.setBorderPainted(false);
        jButton1.setContentAreaFilled(false);
        jButton1.setFocusPainted(false);
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
        jPanel2.add(jButton1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        pnlMessung.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 20);
        pnlScrollPane.add(pnlMessung, gridBagConstraints);

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 20);
        pnlScrollPane.add(pnlButtons, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            cbMapSearch,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.cbMapSearch.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 25, 0, 25);
        pnlScrollPane.add(cbMapSearch, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFiller6,
            org.openide.util.NbBundle.getMessage(
                PotenzialflaechenWindowSearchPanel.class,
                "PotenzialflaechenWindowSearchPanel.lblFiller6.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        pnlScrollPane.add(lblFiller6, gridBagConstraints);

        jScrollPane1.setViewportView(pnlScrollPane);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        final PotenzialflaechenWindowSearchSubPanel sub = new PotenzialflaechenWindowSearchSubPanel(this);
        sub.initWithConnectionContext(getConnectionContext());
        jPanel1.add(sub);
        repaint();
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  filters  DOCUMENT ME!
     */
    public void setFilters(final Collection<PotenzialflaecheSearch.FilterInfo> filters) {
        jPanel1.removeAll();
        if (filters != null) {
            for (final PotenzialflaecheSearch.FilterInfo filter : filters) {
                final PotenzialflaechenWindowSearchSubPanel sub = new PotenzialflaechenWindowSearchSubPanel(this);
                sub.initWithConnectionContext(getConnectionContext());
                sub.setFilter(filter);
                jPanel1.add(sub);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  sub  DOCUMENT ME!
     */
    public void removeSub(final PotenzialflaechenWindowSearchSubPanel sub) {
        jPanel1.remove(sub);
        repaint();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Collection<PotenzialflaecheSearch.FilterInfo> getFilters() {
        final Collection<PotenzialflaecheSearch.FilterInfo> filters = new ArrayList<>();
        for (final Component sub : jPanel1.getComponents()) {
            filters.add(((PotenzialflaechenWindowSearchSubPanel)sub).getFilter());
        }
        return filters;
    }

    @Override
    public ObjectMapper getConfigurationMapper() {
        return new PotenzialflaecheSearch().getConfigurationMapper();
    }

    @Override
    public void initFromConfiguration(final Object configuration) {
        initFromConfiguration((PotenzialflaecheSearch.Configuration)configuration);
    }

    @Override
    public PotenzialflaecheSearch.Configuration readConfiguration(final String configuration) throws Exception {
        return getConfigurationMapper().readValue(configuration, PotenzialflaecheSearch.Configuration.class);
    }

    @Override
    public String getTableName() {
        return "pf_potenzialflaeche";
    }
}
