/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import de.cismet.cids.custom.wunda_blau.search.Sb_StadtbildWindowSearch;
import de.cismet.cids.custom.wunda_blau.search.server.MetaObjectNodesStadtbildSerieSearchStatement;
import java.util.ArrayList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openide.util.Exceptions;

public class Sb_StadtbildWindowSearchTest {
    Sb_StadtbildWindowSearch instance = new Sb_StadtbildWindowSearch();

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testFancyIntervall_normalInterval() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("004711", "004713");
            Assert.assertEquals((Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval("004711", "004713"), (Object)interval);
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_normalInterval_lastNumberHasSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("004711", "004713c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("004711");
            for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("004711" + ch);
            }
            expectedNumbers.add("004713");
            expectedNumbers.add("004713a");
            expectedNumbers.add("004713b");
            expectedNumbers.add("004713c");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("004712", "004712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_normalInterval_FirstNumberHasSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("004711y", "004713");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("004711y");
            expectedNumbers.add("004711z");
            expectedNumbers.add("004713");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("004712", "004712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_normalInterval_BothNumbersHaveSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("004711a", "004713c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("004711" + ch);
            }
            expectedNumbers.add("004713");
            expectedNumbers.add("004713a");
            expectedNumbers.add("004713b");
            expectedNumbers.add("004713c");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("004712", "004712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N04711", "N04713");
            Assert.assertEquals((Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval("N04711", "N04713"), (Object)interval);
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_lastNumberHasSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N04711", "N04713c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("N04711");
            for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("N04711" + ch);
            }
            expectedNumbers.add("N04713");
            expectedNumbers.add("N04713a");
            expectedNumbers.add("N04713b");
            expectedNumbers.add("N04713c");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("N04712", "N04712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_FirstNumberHasSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N04711y", "N04713");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("N04711y");
            expectedNumbers.add("N04711z");
            expectedNumbers.add("N04713");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("N04712", "N04712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_BothNumbersHaveSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N04711a", "N04713c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("N04711" + ch);
            }
            expectedNumbers.add("N04713");
            expectedNumbers.add("N04713a");
            expectedNumbers.add("N04713b");
            expectedNumbers.add("N04713c");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("N04712", "N04712", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_sameNumberBase_FirstNumberHasSuffixLetter() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval1 = this.instance.getIntervalForSearch("N04713y", "N04713");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval2 = this.instance.getIntervalForSearch("N04713", "N04713y");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("N04713");
            for (char ch = 'a'; ch <= 'y'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("N04713" + ch);
            }
            Assert.assertEquals((Object)interval1, (Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval(null, null, expectedNumbers));
            Assert.assertEquals((Object)interval1, (Object)interval2);
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_BothNumbersHaveSuffixLetter_sameNumberBase_firstBigger() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval1 = this.instance.getIntervalForSearch("N02308c", "N02308b");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval2 = this.instance.getIntervalForSearch("N02308b", "N02308c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("N02308b");
            expectedNumbers.add("N02308c");
            Assert.assertEquals((Object)interval1, (Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval(null, null, expectedNumbers));
            Assert.assertEquals((Object)interval1, (Object)interval2);
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_second_bigger_than_first_number() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval1 = this.instance.getIntervalForSearch("N04715", "N04713");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval2 = this.instance.getIntervalForSearch("N04713", "N04715");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("N04713");
            expectedNumbers.add("N04715");
            Assert.assertEquals((Object)interval1, (Object)interval2);
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test(expected=Sb_StadtbildWindowSearch.NotAValidIntervalException.class)
    public void testFancyIntervall_invalid_no_prefix() throws Sb_StadtbildWindowSearch.NotAValidIntervalException {
        MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("F04713", "N04714");
        Assert.fail((String)"Should throw an exception.");
    }

    @Test
    public void testFancyIntervall_valid_no_prefix() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("500000", "600000");
            Assert.assertEquals((Object)interval, (Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval("500000", "600000"));
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_valid_same_input_simple() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("500000", "500000");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("500000");
            Assert.assertEquals((Object)interval, (Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval(null, null, expectedNumbers));
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_valid_same_input_complex() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("500000a", "500000a");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("500000a");
            Assert.assertEquals((Object)interval, (Object)new MetaObjectNodesStadtbildSerieSearchStatement.Interval(null, null, expectedNumbers));
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test(expected=Sb_StadtbildWindowSearch.NotAValidIntervalException.class)
    public void testFancyIntervall_invalid_different_length() throws Sb_StadtbildWindowSearch.NotAValidIntervalException {
        MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("04713c", "047134");
        Assert.fail((String)"Should throw an exception.");
    }

    @Test(expected=Sb_StadtbildWindowSearch.NotAValidIntervalException.class)
    public void testFancyIntervall_invalid_wildcard_percent() throws Sb_StadtbildWindowSearch.NotAValidIntervalException {
        MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("%", "%");
        Assert.fail((String)"Should throw an exception.");
    }

    @Test(expected=Sb_StadtbildWindowSearch.NotAValidIntervalException.class)
    public void testFancyIntervall_invalid_wildcard_underscore() throws Sb_StadtbildWindowSearch.NotAValidIntervalException {
        MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("_", "_");
        Assert.fail((String)"Should throw an exception.");
    }

    @Test(expected=Sb_StadtbildWindowSearch.NotAValidIntervalException.class)
    public void testFancyIntervall_invalid_not_expected_input() throws Sb_StadtbildWindowSearch.NotAValidIntervalException {
        MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N02308af", "N02309af");
        Assert.fail((String)"Should throw an exception.");
    }

    @Test
    public void testFancyIntervall_normalInterval_FirstNumberHasSuffixLetter_biggerInterval() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("004711y", "005000");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            expectedNumbers.add("004711y");
            expectedNumbers.add("004711z");
            expectedNumbers.add("005000");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("004712", "004999", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    @Test
    public void testFancyIntervall_prefixLetter_BothNumbersHaveSuffixLetter_biggerInterval() {
        try {
            MetaObjectNodesStadtbildSerieSearchStatement.Interval interval = this.instance.getIntervalForSearch("N04711a", "N05000c");
            ArrayList<String> expectedNumbers = new ArrayList<String>();
            for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                expectedNumbers.add("N04711" + ch);
            }
            expectedNumbers.add("N05000");
            expectedNumbers.add("N05000a");
            expectedNumbers.add("N05000b");
            expectedNumbers.add("N05000c");
            MetaObjectNodesStadtbildSerieSearchStatement.Interval expectedInterval = new MetaObjectNodesStadtbildSerieSearchStatement.Interval("N04712", "N04999", expectedNumbers);
            Assert.assertEquals((Object)expectedInterval.getIntervalStart(), (Object)interval.getIntervalStart());
            Assert.assertEquals((Object)expectedInterval.getIntervalEnd(), (Object)interval.getIntervalEnd());
            Assert.assertArrayEquals((Object[])expectedInterval.getAdditionalExactMatches().toArray(), (Object[])interval.getAdditionalExactMatches().toArray());
        }
        catch (Sb_StadtbildWindowSearch.NotAValidIntervalException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Assert.fail((String)"Should not throw an exception.");
        }
    }
}

