/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.butler.Butler1ProductPanel;
import de.cismet.cids.custom.butler.ButlerDownload;
import de.cismet.cids.custom.butler.ButlerGeometryComboBox;
import de.cismet.cids.custom.butler.PredefinedBoxes;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Butler1Dialog
extends JDialog
implements DocumentListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Butler1Dialog.class);
    private static final double MIN_BUFFER = 100.0;
    private ArrayList<PredefinedBoxes> boxes;
    private final DocumentListener upperTfListeners;
    private boolean firstUpperTFChange = false;
    private final DecimalFormat coordFormatter = new DecimalFormat("#.###");
    private MappingComponent map;
    private PredefinedBoxes noSelectionBox = null;
    private PredefinedBoxes selectedRectBox = null;
    private DefaultStyledFeature rectangleFeature;
    private DefaultStyledFeature pointFeature;
    private boolean isPointCentered = false;
    private final GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)ClientAlkisConf.getInstance().getSrsService()));
    private boolean documentListenersRemoved = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnCancel;
    private JButton btnCreate;
    private Butler1ProductPanel butler1ProductPanel1;
    private JComboBox cbGeoms;
    private JComboBox cbSize;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblLowerPosition;
    private JLabel lblRequestNumber;
    private JLabel lblSRSInfo;
    private JLabel lblSize;
    private JLabel lblUpperPosition;
    private JPanel pnlControls;
    private JPanel pnlMap;
    private JPanel pnlMapSettings;
    private JPanel pnlProductSettings;
    private JPanel pnlRequestNumber;
    private JPanel pnlUpperBound;
    private JTabbedPane tbpProducts;
    private JTextField tfLowerE;
    private JTextField tfLowerN;
    private JTextField tfOrderId;
    private JTextField tfUpperE;
    private JTextField tfUpperN;
    private BindingGroup bindingGroup;

    public Butler1Dialog() {
        super(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), true);
        this.upperTfListeners = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                Butler1Dialog.this.handleUpperTFAction();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                Butler1Dialog.this.handleUpperTFAction();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                Butler1Dialog.this.handleUpperTFAction();
            }
        };
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.pointFeature = this.createPointFeature();
        this.rectangleFeature = this.createRectangleFeature();
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        this.coordFormatter.setDecimalFormatSymbols(formatSymbols);
        this.boxes = new ArrayList<PredefinedBoxes>(PredefinedBoxes.butler1Boxes);
        this.initComponents();
        this.butler1ProductPanel1.initWithConnectionContext(connectionContext);
        this.tfLowerE.getDocument().addDocumentListener(this);
        this.tfLowerN.getDocument().addDocumentListener(this);
        FocusAdapter upperTfFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Butler1Dialog.this.firstUpperTFChange = false;
            }
        };
        this.tfUpperE.addFocusListener(upperTfFocusListener);
        this.tfUpperN.addFocusListener(upperTfFocusListener);
        this.tfUpperE.getDocument().addDocumentListener(this.upperTfListeners);
        this.tfUpperN.getDocument().addDocumentListener(this.upperTfListeners);
        this.tbpProducts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int tabNr = Butler1Dialog.this.tbpProducts.getUI().tabForCoordinate(Butler1Dialog.this.tbpProducts, me.getX(), me.getY());
                if (tabNr == Butler1Dialog.this.tbpProducts.getTabCount() - 1) {
                    if (Butler1Dialog.this.tbpProducts.getTabCount() == 2) {
                        Butler1Dialog.this.tbpProducts.setTabComponentAt(0, Butler1Dialog.this.getTabComponent(true, 1));
                    }
                    Butler1Dialog.this.addCloseableTab();
                    Butler1Dialog.this.tbpProducts.setSelectedIndex(Butler1Dialog.this.tbpProducts.getTabCount() - 2);
                }
            }
        });
        this.tbpProducts.setBorder(null);
        this.tbpProducts.setTabComponentAt(0, this.getTabComponent(false));
        this.tbpProducts.setToolTipTextAt(0, "Produkt 1");
        JPanel addPan = new JPanel();
        addPan.setLayout(new FlowLayout(0, 0, 0));
        addPan.setOpaque(false);
        addPan.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        JLabel addLabel = new JLabel("+");
        addLabel.setOpaque(false);
        addLabel.setBorder(null);
        addLabel.setFocusable(false);
        addPan.add(addLabel);
        this.tbpProducts.addTab("+", null);
        this.tbpProducts.setTabComponentAt(this.tbpProducts.getTabCount() - 1, addPan);
        for (PredefinedBoxes box : this.boxes) {
            if (!box.getDisplayName().equals("keine Auswahl")) continue;
            this.noSelectionBox = box;
            this.cbSize.setSelectedItem(this.noSelectionBox);
            break;
        }
        this.map = new MappingComponent();
        this.initMap();
        this.pnlMap.setLayout(new BorderLayout());
        this.pnlMap.add((Component)this.map, "Center");
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pnlProductSettings = new JPanel();
        this.tbpProducts = new JTabbedPane();
        this.butler1ProductPanel1 = new Butler1ProductPanel();
        this.pnlMapSettings = new JPanel();
        this.lblLowerPosition = new JLabel();
        this.tfLowerE = new JTextField();
        this.tfLowerN = new JTextField();
        this.lblSize = new JLabel();
        this.cbSize = new JComboBox();
        this.pnlMap = new JPanel();
        this.pnlUpperBound = new JPanel();
        this.tfUpperE = new JTextField();
        this.tfUpperN = new JTextField();
        this.lblUpperPosition = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jLabel1 = new JLabel();
        this.cbGeoms = new ButlerGeometryComboBox(ButlerGeometryComboBox.GEOM_FILTER_TYPE.BOTH);
        this.jLabel2 = new JLabel();
        this.lblSRSInfo = new JLabel();
        this.pnlControls = new JPanel();
        this.btnCreate = new JButton();
        this.btnCancel = new JButton();
        this.pnlRequestNumber = new JPanel();
        this.lblRequestNumber = new JLabel();
        this.tfOrderId = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.title_1"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlProductSettings.setMinimumSize(new Dimension(450, 300));
        this.pnlProductSettings.setPreferredSize(new Dimension(450, 300));
        this.pnlProductSettings.setLayout(new GridBagLayout());
        this.tbpProducts.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tbpProducts.setMinimumSize(new Dimension(400, 400));
        this.tbpProducts.addTab(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.butler1ProductPanel1.TabConstraints.tabTitle"), this.butler1ProductPanel1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlProductSettings.add((Component)this.tbpProducts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlProductSettings, gridBagConstraints);
        this.pnlMapSettings.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblLowerPosition, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.lblLowerPosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMapSettings.add((Component)this.lblLowerPosition, gridBagConstraints);
        this.tfLowerE.setText(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.tfLowerE.text"));
        this.tfLowerE.setMinimumSize(new Dimension(70, 27));
        this.tfLowerE.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMapSettings.add((Component)this.tfLowerE, gridBagConstraints);
        this.tfLowerN.setText(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.tfLowerN.text"));
        this.tfLowerN.setMinimumSize(new Dimension(70, 27));
        this.tfLowerN.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.tfLowerN, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblSize, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.lblSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.lblSize, gridBagConstraints);
        this.cbSize.setPreferredSize(new Dimension(150, 27));
        ELProperty eLProperty = ELProperty.create((String)"${boxes}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JComboBox)this.cbSize);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        this.cbSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler1Dialog.this.cbSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.cbSize, gridBagConstraints);
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout pnlMapLayout = new GroupLayout(this.pnlMap);
        this.pnlMap.setLayout(pnlMapLayout);
        pnlMapLayout.setHorizontalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 479, Short.MAX_VALUE));
        pnlMapLayout.setVerticalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlMapSettings.add((Component)this.pnlMap, gridBagConstraints);
        this.pnlUpperBound.setLayout(new GridBagLayout());
        this.tfUpperE.setText(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.tfUpperE.text"));
        this.tfUpperE.setMinimumSize(new Dimension(70, 27));
        this.tfUpperE.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlUpperBound.add((Component)this.tfUpperE, gridBagConstraints);
        this.tfUpperN.setText(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.tfUpperN.text"));
        this.tfUpperN.setMinimumSize(new Dimension(70, 27));
        this.tfUpperN.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.pnlUpperBound.add((Component)this.tfUpperN, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblUpperPosition, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.lblUpperPosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlUpperBound.add((Component)this.lblUpperPosition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlUpperBound.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlMapSettings.add((Component)this.pnlUpperBound, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMapSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.jLabel1.AccessibleContext.accessibleName"));
        this.cbGeoms.setPreferredSize(new Dimension(150, 27));
        this.cbGeoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler1Dialog.this.cbGeomsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.cbGeoms, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 15, 0);
        this.pnlMapSettings.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblSRSInfo, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.lblSRSInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlMapSettings.add((Component)this.lblSRSInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlMapSettings, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreate, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.btnCreate.text"));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler1Dialog.this.btnCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlControls.add((Component)this.btnCreate, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler1Dialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.pnlControls.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.pnlRequestNumber.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblRequestNumber, (String)NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.lblRequestNumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 33);
        this.pnlRequestNumber.add((Component)this.lblRequestNumber, gridBagConstraints);
        this.tfOrderId.setText(NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.tfOrderId.text"));
        this.tfOrderId.setMinimumSize(new Dimension(70, 27));
        this.tfOrderId.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.pnlRequestNumber.add((Component)this.tfOrderId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.pnlRequestNumber, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder missConfiguredProducts = new StringBuilder();
                boolean showErrorPane = false;
                int missConfigPrdCount = 0;
                for (int i = 0; i < Butler1Dialog.this.tbpProducts.getTabCount() - 1; ++i) {
                    Butler1ProductPanel productPanel = (Butler1ProductPanel)Butler1Dialog.this.tbpProducts.getComponentAt(i);
                    ButlerProduct bp = productPanel.getSelectedProduct();
                    if (Butler1Dialog.this.isProductConfigurationValid(bp)) continue;
                    showErrorPane = true;
                    ++missConfigPrdCount;
                    missConfiguredProducts.append(i + 1);
                    missConfiguredProducts.append(", ");
                }
                if (showErrorPane) {
                    String productNumbers = missConfiguredProducts.toString().substring(0, missConfiguredProducts.toString().length() - 2);
                    String message = missConfigPrdCount == 1 ? NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.singularMessage") : NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.multiMessage");
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler1Dialog.this), String.format(message, productNumbers), NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.title"), 0);
                    return;
                }
                if (Butler1Dialog.this.rectangleFeature == null || Butler1Dialog.this.rectangleFeature.getGeometry() == null || Butler1Dialog.this.rectangleFeature.getGeometry().getArea() == 0.0) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler1Dialog.this), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.message"), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.title"), 0);
                    return;
                }
                Geometry g = Butler1Dialog.this.rectangleFeature.getGeometry();
                double minX = g.getEnvelopeInternal().getMinX();
                double minY = g.getEnvelopeInternal().getMinY();
                double maxX = g.getEnvelopeInternal().getMaxX();
                double maxY = g.getEnvelopeInternal().getMaxY();
                if (minX >= maxX || minY >= maxY) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler1Dialog.this), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.message"), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.title"), 0);
                    return;
                }
                String orderId = Butler1Dialog.this.tfOrderId.getText();
                if (!orderId.matches("[a-zA-Z0-9_-]*")) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler1Dialog.this), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.OrderIdCheck.JOptionPane.message"), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.OrderIdCheck.JOptionPane.title"), 0);
                    return;
                }
                StringBuilder jobnameBuilder = new StringBuilder();
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)CismapBroker.getInstance().getMappingComponent())) {
                    String jobname = DownloadManagerDialog.getInstance().getJobName();
                    if (jobname == null) {
                        jobnameBuilder.append("");
                    } else {
                        jobnameBuilder.append(jobname);
                    }
                }
                ArrayList<ButlerDownload> downloads = new ArrayList<ButlerDownload>();
                for (int i = 0; i < Butler1Dialog.this.tbpProducts.getTabCount() - 1; ++i) {
                    Butler1ProductPanel productPanel = (Butler1ProductPanel)Butler1Dialog.this.tbpProducts.getComponentAt(i);
                    ButlerProduct bp = productPanel.getSelectedProduct();
                    LOG.info((Object)("Create the following Butler product:\n\t orderId: " + Butler1Dialog.this.tfOrderId.getText() + "\n\t productId: " + bp.getKey() + "\n\t colorDepth: " + bp.getColorDepth() + "\n\t resolution: " + bp.getResolution() + "\n\t format: " + bp.getFormat()));
                    String title = Butler1Dialog.this.tfOrderId.getText() + "#" + (i + 1);
                    ButlerDownload download = new ButlerDownload(jobnameBuilder.toString(), Butler1Dialog.this.tfOrderId.getText() + "_" + (i + 1), bp, minX, minY, maxX, maxY, Butler1Dialog.this.getConnectionContext());
                    downloads.add(download);
                }
                DownloadManager.instance().add((Download)new MultipleDownload(downloads, "Butler Downloads " + Butler1Dialog.this.tfOrderId.getText()));
                Butler1Dialog.this.dispose();
            }
        });
    }

    private void cbSizeActionPerformed(ActionEvent evt) {
        PredefinedBoxes selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem();
        if (selectedBox != null && !selectedBox.getDisplayName().equals("keine Auswahl") && selectedBox != this.selectedRectBox) {
            Geometry g;
            this.removeDocumentListeners();
            if (this.cbSize.getSelectedIndex() != this.cbSize.getItemCount() - 1) {
                this.boxes.remove(this.selectedRectBox);
            }
            if (this.cbGeoms.getSelectedItem() instanceof Geometry && !((g = (Geometry)this.cbGeoms.getSelectedItem()) instanceof Point)) {
                this.cbGeoms.setSelectedIndex(0);
            }
            this.firstUpperTFChange = true;
            this.createGeomFromSize();
            this.changeMap();
            this.addDocumentListeners();
        } else {
            this.firstUpperTFChange = false;
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cbGeomsActionPerformed(ActionEvent evt) {
        Object obj = this.cbGeoms.getSelectedItem();
        if (obj != null && obj instanceof Geometry) {
            this.removeDocumentListeners();
            this.boxes.remove(this.selectedRectBox);
            Geometry g = (Geometry)obj;
            if (g.isRectangle()) {
                Envelope envelope = g.getEnvelopeInternal();
                Point p = g.getFactory().createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
                this.pointFeature.setGeometry((Geometry)p);
                this.tfLowerE.setText("" + this.coordFormatter.format(envelope.getMinX()));
                this.tfLowerN.setText("" + this.coordFormatter.format(envelope.getMinY()));
                this.tfUpperE.setText("" + this.coordFormatter.format(envelope.getMaxX()));
                this.tfUpperN.setText("" + this.coordFormatter.format(envelope.getMaxY()));
                double rectWidth = envelope.getMaxX() - envelope.getMinX();
                double rectHeight = envelope.getMaxY() - envelope.getMinY();
                this.selectedRectBox = new PredefinedBoxes(this.coordFormatter.format(rectWidth) + "m x " + this.coordFormatter.format(rectHeight) + "m", rectWidth, rectHeight);
                this.boxes.add(this.selectedRectBox);
                this.cbSize.setSelectedIndex(this.cbSize.getItemCount() - 1);
            } else if (g instanceof Point) {
                Point p = (Point)g;
                this.pointFeature.setGeometry(g);
                this.tfLowerE.setText("" + this.coordFormatter.format(p.getX()));
                this.tfLowerN.setText("" + this.coordFormatter.format(p.getY()));
                this.tfUpperE.setText("" + this.coordFormatter.format(p.getX()));
                this.tfUpperN.setText("" + this.coordFormatter.format(p.getY()));
                PredefinedBoxes selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem();
                if (selectedBox != null && !selectedBox.getDisplayName().equals("keine Auswahl") && selectedBox != this.selectedRectBox) {
                    this.createGeomFromSize();
                } else {
                    this.cbSize.setSelectedItem(this.noSelectionBox);
                }
            }
            this.changeMap();
            this.addDocumentListeners();
        }
    }

    private void createGeomFromSize() {
        PredefinedBoxes selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem();
        if (selectedBox != null && !selectedBox.getDisplayName().equals("keine Auswahl") && selectedBox != this.selectedRectBox) {
            if (selectedBox.getDisplayName().startsWith("M")) {
                this.isPointCentered = true;
                Point p = (!(this.cbGeoms.getSelectedItem() instanceof Geometry) || !(this.cbGeoms.getSelectedItem() instanceof Point)) && this.rectangleFeature != null ? this.rectangleFeature.getGeometry().getEnvelope().getCentroid() : (Point)this.pointFeature.getGeometry();
                double lowerE = p.getX() - selectedBox.getEastSize() / 2.0;
                double lowerN = p.getY() - selectedBox.getNorthSize() / 2.0;
                double upperE = p.getX() + selectedBox.getEastSize() / 2.0;
                double upperN = p.getY() + selectedBox.getNorthSize() / 2.0;
                this.tfLowerE.setText(this.coordFormatter.format(lowerE));
                this.tfLowerN.setText(this.coordFormatter.format(lowerN));
                this.tfUpperE.setText(this.coordFormatter.format(upperE));
                this.tfUpperN.setText(this.coordFormatter.format(upperN));
            } else if (this.isPointCentered) {
                double lowerE = ((Point)this.pointFeature.getGeometry()).getX();
                double lowerN = ((Point)this.pointFeature.getGeometry()).getY();
                double upperE = ((Point)this.pointFeature.getGeometry()).getX() + selectedBox.getEastSize();
                double upperN = ((Point)this.pointFeature.getGeometry()).getY() + selectedBox.getNorthSize();
                this.tfLowerE.setText(this.coordFormatter.format(lowerE));
                this.tfLowerN.setText(this.coordFormatter.format(lowerN));
                this.tfUpperE.setText(this.coordFormatter.format(upperE));
                this.tfUpperN.setText(this.coordFormatter.format(upperN));
                this.isPointCentered = false;
            } else {
                this.updatePositionFields();
            }
        }
    }

    private void addDocumentListeners() {
        if (!this.documentListenersRemoved) {
            this.removeDocumentListeners();
        }
        this.documentListenersRemoved = false;
        this.tfLowerE.getDocument().addDocumentListener(this);
        this.tfLowerN.getDocument().addDocumentListener(this);
        this.tfUpperE.getDocument().addDocumentListener(this.upperTfListeners);
        this.tfUpperN.getDocument().addDocumentListener(this.upperTfListeners);
    }

    private void removeDocumentListeners() {
        this.documentListenersRemoved = true;
        this.tfLowerE.getDocument().removeDocumentListener(this);
        this.tfLowerN.getDocument().removeDocumentListener(this);
        this.tfUpperE.getDocument().removeDocumentListener(this.upperTfListeners);
        this.tfUpperN.getDocument().removeDocumentListener(this.upperTfListeners);
    }

    private void updatePositionFields() {
        this.removeDocumentListeners();
        PredefinedBoxes selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem();
        if (selectedBox != null && !selectedBox.getDisplayName().equals("keine Auswahl")) {
            double eSize = selectedBox.getEastSize();
            double nSize = selectedBox.getNorthSize();
            if (this.tfLowerE.getText() != null && !this.tfLowerE.getText().equals("")) {
                double lowerE = Double.parseDouble(this.tfLowerE.getText().replaceAll(",", "."));
                this.tfUpperE.setText(this.coordFormatter.format(lowerE + eSize));
            }
            if (this.tfLowerN.getText() != null && !this.tfLowerN.getText().equals("")) {
                double lowerN = Double.parseDouble(this.tfLowerN.getText().replaceAll(",", "."));
                this.tfUpperN.setText(this.coordFormatter.format(lowerN + nSize));
            }
        }
        this.addDocumentListeners();
    }

    private void initMap() {
        Runnable mapRunnable = new Runnable(){

            @Override
            public void run() {
                ActiveLayerModel mappingModel = new ActiveLayerModel();
                mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                mappingModel.addHome(this.getBoundingBox());
                SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                swms.setName("butler-background");
                mappingModel.addLayer((RetrievalServiceLayer)swms);
                Butler1Dialog.this.map.setMappingModel((MappingModel)mappingModel);
                int duration = Butler1Dialog.this.map.getAnimationDuration();
                Butler1Dialog.this.map.setAnimationDuration(0);
                Butler1Dialog.this.map.gotoInitialBoundingBox();
                Butler1Dialog.this.map.setInteractionMode("ZOOM");
                Butler1Dialog.this.map.unlock();
                Butler1Dialog.this.map.setInteractionMode("MUTE");
                Butler1Dialog.this.map.setAnimationDuration(duration);
            }

            private XBoundingBox getBoundingBox() {
                XBoundingBox currBb = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox();
                Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)currBb.getGeometry(), (String)ClientAlkisConf.getInstance().getSrsService());
                XBoundingBox result = new XBoundingBox(transformedGeom.buffer(20.0));
                return result;
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapRunnable.run();
        } else {
            EventQueue.invokeLater(mapRunnable);
        }
    }

    private void changeMap() {
        Runnable mapChangeRunnable = new Runnable(){

            @Override
            public void run() {
                Envelope env;
                if (Butler1Dialog.this.cbGeoms.getSelectedItem() instanceof Point) {
                    if (!Butler1Dialog.this.map.getFeatureCollection().contains((Feature)Butler1Dialog.this.pointFeature)) {
                        Butler1Dialog.this.map.getFeatureCollection().addFeature((Feature)Butler1Dialog.this.pointFeature);
                    }
                    Butler1Dialog.this.map.reconsiderFeature((Feature)Butler1Dialog.this.pointFeature);
                } else {
                    Butler1Dialog.this.map.getFeatureCollection().removeFeature((Feature)Butler1Dialog.this.pointFeature);
                }
                Geometry g = Butler1Dialog.this.createGeometry();
                if (g != null) {
                    Butler1Dialog.this.updateGeomInAllProducts(g);
                    Butler1Dialog.this.rectangleFeature.setGeometry(g);
                    if (!Butler1Dialog.this.map.getFeatureCollection().contains((Feature)Butler1Dialog.this.rectangleFeature)) {
                        Butler1Dialog.this.map.getFeatureCollection().addFeature((Feature)Butler1Dialog.this.rectangleFeature);
                    }
                    Butler1Dialog.this.map.reconsiderFeature((Feature)Butler1Dialog.this.rectangleFeature);
                }
                XBoundingBox bb = null;
                if (g == null || g.getArea() == 0.0) {
                    if (Butler1Dialog.this.pointFeature.getGeometry() != null) {
                        env = Butler1Dialog.this.pointFeature.getGeometry().buffer(50.0).getEnvelopeInternal();
                        bb = new XBoundingBox(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), CrsTransformer.createCrsFromSrid((int)Butler1Dialog.this.pointFeature.getGeometry().getSRID()), true);
                    } else {
                        bb = (XBoundingBox)Butler1Dialog.this.map.getInitialBoundingBox();
                    }
                } else {
                    env = g.getEnvelopeInternal();
                    if (env.getHeight() > 100.0 || env.getWidth() > 100.0) {
                        bb = new XBoundingBox(g);
                    } else {
                        double buffer = (100.0 - Math.max(env.getHeight(), env.getWidth())) / 2.0;
                        Envelope e = g.buffer(buffer).getEnvelopeInternal();
                        bb = new XBoundingBox(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), CrsTransformer.createCrsFromSrid((int)g.getSRID()), true);
                    }
                }
                double width = bb.getX2() - bb.getX1();
                double height = bb.getY2() - bb.getY1();
                double buffer = Math.sqrt(height * height + width * width) * 0.1;
                bb = new XBoundingBox(bb.getGeometry().buffer(buffer).getEnvelope());
                Butler1Dialog.this.map.gotoBoundingBoxWithHistory((BoundingBox)bb);
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapChangeRunnable.run();
        } else {
            EventQueue.invokeLater(mapChangeRunnable);
        }
    }

    public ArrayList<PredefinedBoxes> getBoxes() {
        return this.boxes;
    }

    public void setBoxes(ArrayList<PredefinedBoxes> boxes) {
        this.boxes = boxes;
    }

    private void addCloseableTab() {
        Component tabComp = this.getTabComponent(true);
        int number = this.tbpProducts.getTabCount();
        String title = "Produkt " + number;
        int tabPos = this.tbpProducts.getTabCount() - 1;
        Butler1ProductPanel productPan = new Butler1ProductPanel();
        productPan.initWithConnectionContext(this.getConnectionContext());
        if (this.rectangleFeature != null && this.rectangleFeature.getGeometry() != null) {
            productPan.setGeometry(this.rectangleFeature.getGeometry());
        }
        this.tbpProducts.insertTab("", null, productPan, title, tabPos);
        int tabPosNew = this.tbpProducts.indexOfComponent(productPan);
        this.tbpProducts.setTabComponentAt(tabPosNew, tabComp);
        this.tbpProducts.setBorder(null);
    }

    private Geometry createGeometry() {
        double lowerE = 0.0;
        double lowerN = 0.0;
        double upperE = 0.0;
        double upperN = 0.0;
        try {
            lowerE = Double.parseDouble(this.tfLowerE.getText());
            lowerN = Double.parseDouble(this.tfLowerN.getText());
            upperE = Double.parseDouble(this.tfUpperE.getText());
            upperN = Double.parseDouble(this.tfUpperN.getText());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error during change map - very likely a double parsing error", (Throwable)ex);
            }
            return null;
        }
        Coordinate[] coords = new Coordinate[5];
        Coordinate startCoord = new Coordinate(lowerE, lowerN);
        coords[0] = new Coordinate(lowerE, lowerN);
        double c1 = lowerN + Math.abs(upperN - lowerN);
        coords[1] = new Coordinate(lowerE, c1);
        double c2 = lowerE + Math.abs(lowerE - upperE);
        coords[2] = new Coordinate(c2, c1);
        coords[3] = new Coordinate(c2, lowerN);
        coords[4] = startCoord;
        int currentSrid = CrsTransformer.extractSridFromCrs((String)this.map.getMappingModel().getSrs().getCode());
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
        Polygon p = new Polygon(geometryFactory.createLinearRing(coords), null, geometryFactory);
        return p;
    }

    private DefaultStyledFeature createRectangleFeature() {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        Geometry geom = this.createGeometry();
        dsf.setGeometry(geom);
        dsf.setTransparency(0.8f);
        dsf.setFillingPaint((Paint)new Color(192, 80, 77, 192));
        return dsf;
    }

    private Component getTabComponent(boolean isCloseableTab) {
        int number = this.tbpProducts.getTabCount();
        return this.getTabComponent(isCloseableTab, number);
    }

    private Component getTabComponent(boolean isCloseableTab, int tabNumber) {
        final JPanel tabComp = new JPanel();
        tabComp.setLayout(new GridBagLayout());
        tabComp.setOpaque(false);
        tabComp.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        tabComp.setPreferredSize(new Dimension(120, 22));
        String title = "Produkt " + tabNumber;
        JLabel label = new JLabel(title);
        label.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/butler/page_white.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        tabComp.add((Component)label, gridBagConstraints);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        if (isCloseableTab) {
            final JButton button = new JButton("x");
            button.setPreferredSize(new Dimension(10, 19));
            button.setToolTipText("close this tab");
            button.setUI(new BasicButtonUI());
            button.setContentAreaFilled(false);
            button.setFocusable(false);
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setRolloverEnabled(true);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int i = Butler1Dialog.this.tbpProducts.indexOfTabComponent(tabComp);
                    if (i != -1) {
                        Butler1Dialog.this.tbpProducts.remove(i);
                    }
                    if (i == Butler1Dialog.this.tbpProducts.getSelectedIndex()) {
                        if (i == 0) {
                            Butler1Dialog.this.tbpProducts.setSelectedIndex(0);
                        } else {
                            Butler1Dialog.this.tbpProducts.setSelectedIndex(i - 1);
                        }
                    }
                    Butler1Dialog.this.updateTabComponents();
                }
            });
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent me) {
                    button.setBorder(new LineBorder(Color.GRAY));
                    button.setBorderPainted(true);
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    button.setBorder(null);
                    button.setBorderPainted(false);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            tabComp.add((Component)button, gridBagConstraints);
        }
        return tabComp;
    }

    private void updateTabComponents() {
        if (this.tbpProducts.getTabCount() <= 2) {
            this.tbpProducts.setTabComponentAt(0, this.getTabComponent(false, 1));
        } else {
            for (int i = 0; i < this.tbpProducts.getTabCount() - 1; ++i) {
                this.tbpProducts.setTabComponentAt(i, this.getTabComponent(true, i + 1));
                this.tbpProducts.setToolTipTextAt(i, "Produkt " + (i + 1));
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.handleLowerTFAction();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.handleLowerTFAction();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.handleLowerTFAction();
    }

    private boolean isProductConfigurationValid(ButlerProduct bp) {
        if (bp == null) {
            return false;
        }
        if (bp.getKey() == null || bp.getKey().equals("")) {
            return false;
        }
        if (bp.getFormat() == null || bp.getFormat().getKey() == null || bp.getFormat().getKey().equals("")) {
            return false;
        }
        return bp.getResolution() != null && bp.getResolution().getKey() != null && !bp.getResolution().getKey().equals("");
    }

    private void handleUpperTFAction() {
        PredefinedBoxes selectedBox;
        Geometry g;
        if (this.cbGeoms.getSelectedItem() instanceof Geometry && (g = (Geometry)this.cbGeoms.getSelectedItem()).isRectangle()) {
            this.cbGeoms.setSelectedIndex(0);
        }
        if ((selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem()) != null && !selectedBox.getDisplayName().equals("keine Auswahl") && this.noSelectionBox != null && !this.firstUpperTFChange) {
            this.firstUpperTFChange = true;
            this.boxes.remove(selectedBox);
            this.cbSize.setSelectedItem(this.noSelectionBox);
        }
        this.changeMap();
    }

    private void handleLowerTFAction() {
        this.cbGeoms.setSelectedIndex(0);
        PredefinedBoxes selectedBox = (PredefinedBoxes)this.cbSize.getSelectedItem();
        double lowerE = 0.0;
        double lowerN = 0.0;
        try {
            lowerE = Double.parseDouble(this.tfLowerE.getText());
            lowerN = Double.parseDouble(this.tfLowerN.getText());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error during change map - very likely a double parsing error", (Throwable)ex);
            }
            return;
        }
        Point p = this.isPointCentered && selectedBox != null && !selectedBox.getDisplayName().equals("keine Auswahl") ? this.factory.createPoint(new Coordinate(lowerE + selectedBox.getEastSize() / 2.0, lowerN + selectedBox.getNorthSize() / 2.0)) : this.factory.createPoint(new Coordinate(lowerE, lowerN));
        this.pointFeature.setGeometry((Geometry)p);
        this.updatePositionFields();
        this.changeMap();
    }

    private void updateGeomInAllProducts(Geometry geom) {
        for (int i = 0; i < this.tbpProducts.getTabCount() - 1; ++i) {
            Butler1ProductPanel productPan = (Butler1ProductPanel)this.tbpProducts.getComponentAt(i);
            productPan.setGeometry(geom);
        }
    }

    private DefaultStyledFeature createPointFeature() {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        BufferedImage bi = new BufferedImage(9, 9, 6);
        Graphics2D g = (Graphics2D)bi.getGraphics().create();
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.drawOval(0, 0, 5, 5);
        FeatureAnnotationSymbol fas = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-circlerecordempty.png")).getImage());
        fas.setSweetSpotX(0.5);
        fas.setSweetSpotY(0.5);
        dsf.setPointAnnotationSymbol(fas);
        return dsf;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

