/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.butler.ButlerDownload;
import de.cismet.cids.custom.utils.butler.ButlerRequestInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.ButlerQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.configuration.StartupHook;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ButlerStartUpHook
implements StartupHook,
ConnectionContextStore {
    private static final String SERVER_ACTION = "butler1Query";
    private static final Logger LOG = Logger.getLogger(ButlerStartUpHook.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void applicationStarted() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ButlerStartUpHook.this.restartPendingButler1Requests();
            }
        }).start();
    }

    private void restartPendingButler1Requests() {
        boolean hasButlerAccess = false;
        try {
            hasButlerAccess = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://butler1Query", this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Butler!", (Throwable)ex);
        }
        if (hasButlerAccess) {
            ServerActionParameter paramMethod = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)ButlerQueryAction.METHOD_TYPE.GET_ALL);
            HashMap openRequestIds = null;
            try {
                openRequestIds = (HashMap)SessionManager.getProxy().executeTask(SERVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramMethod});
            }
            catch (ConnectionException ex) {
                LOG.error((Object)"error while getting the list of undelivered butler 1 requests from server", (Throwable)ex);
                return;
            }
            if (openRequestIds == null || openRequestIds.isEmpty()) {
                LOG.info((Object)"no pending butler orders found for the logged in user");
                return;
            }
            StringBuilder logMessageBuilder = new StringBuilder();
            for (String s : openRequestIds.keySet()) {
                logMessageBuilder.append(s);
                logMessageBuilder.append(",");
            }
            LOG.fatal((Object)("pending nas orders found: " + logMessageBuilder.toString()));
            ArrayList<ButlerDownload> downloads = new ArrayList<ButlerDownload>();
            for (String requestId : openRequestIds.keySet()) {
                ButlerRequestInfo info = (ButlerRequestInfo)openRequestIds.get(requestId);
                ButlerDownload download = new ButlerDownload(requestId, info.getUserOrderId(), info.getProduct(), this.getConnectionContext());
                downloads.add(download);
            }
            DownloadManager.instance().add((Download)new MultipleDownload(downloads, NbBundle.getMessage(ButlerStartUpHook.class, (String)"ButlerStartUpHook.downloadTitle")));
        }
    }

    public static void main(String[] args) {
        ButlerStartUpHook cptHook = new ButlerStartUpHook();
        cptHook.restartPendingButler1Requests();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

