/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.butler.Butler1Dialog;
import de.cismet.cids.custom.butler.Butler2Dialog;
import de.cismet.cids.custom.nas.NasDialog;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.JPopupMenuButton;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DigitalDataExportToolbarComponentProvider
implements ToolbarComponentsProvider,
ConnectionContextStore,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(DigitalDataExportToolbarComponentProvider.class);
    private List<ToolbarComponentDescription> toolbarComponents;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        LinkedList<ToolbarComponentDescription> preparationList = new LinkedList<ToolbarComponentDescription>();
        ToolbarComponentDescription description = new ToolbarComponentDescription("tlbMain", (JComponent)((Object)new DataExportButton()), ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdPrint");
        preparationList.add(description);
        this.toolbarComponents = Collections.unmodifiableList(preparationList);
    }

    public String getPluginName() {
        return "BUTLER";
    }

    public Collection<ToolbarComponentDescription> getToolbarComponents() {
        if (DigitalDataExportToolbarComponentProvider.validateUserHasButler1Access(this.getConnectionContext()) || DigitalDataExportToolbarComponentProvider.validateUserHasNasAccess(this.getConnectionContext())) {
            return this.toolbarComponents;
        }
        return Collections.emptyList();
    }

    public static boolean validateUserHasButler1Access(ConnectionContext connectionCon1text) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://butler1Query", connectionCon1text);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Butler!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasButler2Access(ConnectionContext connectionCon1text) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://butler2Query", connectionCon1text);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Butler 2!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasNasAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://nasDataQuery", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Butler!", (Throwable)ex);
            return false;
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "DigitalDataExportToolbar";
        }
        return null;
    }

    public Component getComponent() {
        if (DigitalDataExportToolbarComponentProvider.validateUserHasButler1Access(this.getConnectionContext()) || DigitalDataExportToolbarComponentProvider.validateUserHasNasAccess(this.getConnectionContext())) {
            return new DataExportButton();
        }
        return null;
    }

    final class DataExportPopupMenu
    extends JPopupMenu {
        public DataExportPopupMenu() {
            if (DigitalDataExportToolbarComponentProvider.validateUserHasNasAccess(DigitalDataExportToolbarComponentProvider.this.getConnectionContext())) {
                this.add(this.createNASMenuItem());
            }
            if (DigitalDataExportToolbarComponentProvider.validateUserHasButler2Access(DigitalDataExportToolbarComponentProvider.this.getConnectionContext())) {
                this.add(this.createButler2MenuItem());
            }
            if (DigitalDataExportToolbarComponentProvider.validateUserHasButler1Access(DigitalDataExportToolbarComponentProvider.this.getConnectionContext())) {
                this.add(this.createButler1MenuItem());
            }
        }

        private JMenuItem createNASMenuItem() {
            String title = NbBundle.getMessage(NasDialog.class, (String)"NasDialog.title");
            AbstractAction action = new AbstractAction(title){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StaticSwingTools.showDialog((JDialog)new NasDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), true, DigitalDataExportToolbarComponentProvider.this.getConnectionContext()));
                }
            };
            return new JMenuItem(action);
        }

        private JMenuItem createButler1MenuItem() {
            String title = NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.title_1");
            AbstractAction action = new AbstractAction(title){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Butler1Dialog dialog = new Butler1Dialog();
                    dialog.initWithConnectionContext(DigitalDataExportToolbarComponentProvider.this.getConnectionContext());
                    StaticSwingTools.showDialog((JDialog)dialog);
                }
            };
            return new JMenuItem(action);
        }

        private JMenuItem createButler2MenuItem() {
            String title = NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.title");
            AbstractAction action = new AbstractAction(title){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Butler2Dialog dialog = new Butler2Dialog();
                    dialog.initWithConnectionContext(DigitalDataExportToolbarComponentProvider.this.getConnectionContext());
                    StaticSwingTools.showDialog((JDialog)dialog);
                }
            };
            return new JMenuItem(action);
        }
    }

    final class DataExportButton
    extends JPopupMenuButton {
        Icon exportIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/icons/alkis_export.png"));
        private JPopupMenu popUpMenu = new DataExportPopupMenu();
        private boolean setsPopUpVisible = false;

        public DataExportButton() {
            super.setIcon(this.exportIcon);
            super.setToolTipText(NbBundle.getMessage(DigitalDataExportToolbarComponentProvider.class, (String)"DigitalDataExportToolbarComponentProvider.DataExportButton.tooltip"));
            super.setPopupMenu(this.popUpMenu);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!DataExportButton.this.popUpMenu.isVisible() && !DataExportButton.this.setsPopUpVisible) {
                                DataExportButton.this.setsPopUpVisible = true;
                                DataExportButton.this.popUpMenu.show((Component)((Object)DataExportButton.this), 0, DataExportButton.this.getHeight());
                                DataExportButton.this.popUpMenu.setVisible(true);
                            } else if (!DataExportButton.this.popUpMenu.isVisible()) {
                                DataExportButton.this.setsPopUpVisible = false;
                            }
                        }
                    });
                }
            });
        }
    }
}

