/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class CidsBeansTableModel
extends AbstractTableModel {
    private static final transient Logger LOG = Logger.getLogger(CidsBeansTableModel.class);
    protected final Set<Integer> selectedRowIndices;
    protected boolean loading = false;
    private final Class[] columnClasses;
    private final String[] columnNames;
    private final String[] columnProperties;
    private final Boolean[] columnEditables;
    private final PropertyRenderer[] propertyRenderer;
    private final Boolean allColumnsEditable;
    private final Boolean allRowsEditable;
    private List<CidsBean> cidsBeans;
    private final List<Integer> editableRowIndices = new ArrayList<Integer>();

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses) {
        this(columnProperties, columnNames, columnClasses, false, false);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, PropertyRenderer[] propertyRenderer) {
        this(columnProperties, columnNames, columnClasses, propertyRenderer, false, false);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, boolean rowsSelectable) {
        this(columnProperties, columnNames, columnClasses, false, rowsSelectable);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, Boolean[] columnEditable) {
        this(columnProperties, columnNames, columnClasses, columnEditable, true, false);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, Boolean[] columnEditable, boolean rowsSelectable) {
        this(columnProperties, columnNames, columnClasses, columnEditable, true, rowsSelectable);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, boolean allColumnsEditable, boolean rowsSelectable) {
        this(columnProperties, columnNames, columnClasses, allColumnsEditable, true, rowsSelectable);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, PropertyRenderer[] propertyRenderer, boolean allColumnsEditable, boolean rowsSelectable) {
        this(columnProperties, columnNames, columnClasses, propertyRenderer, allColumnsEditable, true, rowsSelectable);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, Boolean[] columnEditables, boolean allRowsEditable, boolean rowsSelectable) {
        this.columnProperties = columnProperties;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.propertyRenderer = null;
        this.columnEditables = columnEditables;
        this.allColumnsEditable = null;
        this.allRowsEditable = allRowsEditable;
        this.selectedRowIndices = rowsSelectable ? new HashSet() : null;
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, boolean allColumnsEditable, boolean allRowsEditable, boolean rowsSelectable) {
        this(columnProperties, columnNames, columnClasses, null, allColumnsEditable, allRowsEditable, rowsSelectable);
    }

    public CidsBeansTableModel(String[] columnProperties, String[] columnNames, Class[] columnClasses, PropertyRenderer[] propertyRenderer, boolean allColumnsEditable, boolean allRowsEditable, boolean rowsSelectable) {
        this.columnProperties = columnProperties;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.propertyRenderer = propertyRenderer;
        this.columnEditables = null;
        this.allColumnsEditable = allColumnsEditable;
        this.allRowsEditable = allRowsEditable;
        this.selectedRowIndices = rowsSelectable ? new HashSet() : null;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public void clear() {
        this.setCidsBeans(null);
    }

    public boolean isColumnWithinBounds(int columnIndex) {
        return this.columnProperties != null && columnIndex >= 0 && columnIndex < this.getColumnCount();
    }

    public boolean isRowWithinBounds(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.getRowCount();
    }

    public String getColumnProperty(int columnIndex) {
        if (columnIndex == 0 && this.isRowsSelectable()) {
            return null;
        }
        return this.isColumnWithinBounds(columnIndex) ? this.columnProperties[columnIndex - (this.isRowsSelectable() ? 1 : 0)] : null;
    }

    public void setCidsBeans(List<CidsBean> cidsBeans) {
        this.loading = false;
        this.cidsBeans = cidsBeans;
        this.fireTableDataChanged();
        this.editableRowIndices.clear();
    }

    public void setEditableRowIndices(List<Integer> editableRowIndices) {
        this.editableRowIndices.clear();
        this.editableRowIndices.addAll(editableRowIndices);
    }

    public void setEditableObjects(List<CidsBean> editableObjects) {
        this.editableRowIndices.clear();
        for (CidsBean cidsBean : this.cidsBeans) {
            int index = this.getRowIndex(cidsBean);
            if (index < 0) continue;
            this.editableRowIndices.add(index);
        }
    }

    public int getRowIndex(CidsBean cidsBean) {
        return this.cidsBeans.indexOf(cidsBean);
    }

    public boolean isRowsSelectable() {
        return this.selectedRowIndices != null;
    }

    public void add(CidsBean cidsBean) {
        this.cidsBeans.add(cidsBean);
        this.fireTableDataChanged();
    }

    public void remove(CidsBean cidsBean) {
        this.cidsBeans.remove(cidsBean);
        this.fireTableDataChanged();
    }

    public List<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0 && this.isRowsSelectable()) {
            return " ";
        }
        return this.isColumnWithinBounds(columnIndex) ? this.columnNames[columnIndex - (this.isRowsSelectable() ? 1 : 0)] : null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean rowCondition;
        if (!this.isColumnWithinBounds(columnIndex) || !this.isRowWithinBounds(rowIndex)) {
            return false;
        }
        if (Boolean.TRUE.equals(this.allColumnsEditable) && Boolean.TRUE.equals(this.allRowsEditable)) {
            return true;
        }
        if (Boolean.FALSE.equals(this.allRowsEditable) && !this.editableRowIndices.contains(rowIndex)) {
            return false;
        }
        if (columnIndex == 0 && this.isRowsSelectable()) {
            return true;
        }
        boolean columnCondition = Boolean.TRUE.equals(this.allColumnsEditable) || this.columnEditables != null && Boolean.TRUE.equals(this.columnEditables[columnIndex]);
        boolean bl = rowCondition = Boolean.TRUE.equals(this.allRowsEditable) || this.editableRowIndices.contains(rowIndex);
        if (columnCondition && rowCondition) {
            CidsBean cidsBean = this.getCidsBean(rowIndex);
            return cidsBean != null;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.loading) {
            return 1;
        }
        return this.cidsBeans != null ? this.cidsBeans.size() : 0;
    }

    @Override
    public int getColumnCount() {
        if (this.columnProperties == null) {
            return -1;
        }
        return this.columnProperties.length + (this.isRowsSelectable() ? 1 : 0);
    }

    public CidsBean getCidsBean(int rowIndex) {
        return this.isRowWithinBounds(rowIndex) ? this.cidsBeans.get(rowIndex) : null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.loading) {
            if (this.getColumnClass(columnIndex).equals(String.class)) {
                return "Wird geladen";
            }
            return null;
        }
        if (!this.isRowWithinBounds(rowIndex) || !this.isColumnWithinBounds(columnIndex)) {
            return null;
        }
        if (columnIndex == 0 && this.isRowsSelectable()) {
            return this.selectedRowIndices.contains(rowIndex);
        }
        CidsBean cidsBean = this.getCidsBean(rowIndex);
        String columnProperty = this.getColumnProperty(columnIndex);
        return this.getValue(cidsBean, columnProperty);
    }

    private Object getValue(CidsBean cidsBean, String columnProperty) {
        if (cidsBean != null && columnProperty != null) {
            if (columnProperty.startsWith("[") && columnProperty.endsWith("]")) {
                try {
                    String rendererValue = columnProperty.substring(1, columnProperty.length() - 1);
                    Integer index = Integer.parseInt(rendererValue);
                    if (this.propertyRenderer != null && index >= 0 && index < this.propertyRenderer.length) {
                        return this.propertyRenderer[index].getValue(cidsBean);
                    }
                    LOG.error((Object)("renderer with index " + index + " does not exist"));
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)"renderer index is not a number");
                }
            } else {
                if (columnProperty.startsWith("{") && columnProperty.endsWith("}") && columnProperty.contains("||")) {
                    String prop = columnProperty.substring(1, columnProperty.length() - 1);
                    StringTokenizer st = new StringTokenizer(prop, "||");
                    StringBuilder value = new StringBuilder();
                    Boolean result = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        Object property = cidsBean.getProperty(token.trim());
                        if (!(property instanceof Boolean)) continue;
                        if (result == null) {
                            result = (Boolean)property;
                            continue;
                        }
                        result = result != false || (Boolean)property != false;
                    }
                    return result;
                }
                if (columnProperty.contains("||")) {
                    StringTokenizer st = new StringTokenizer(columnProperty, "||");
                    StringBuilder value = new StringBuilder();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (Character.isLetter(token.charAt(0))) {
                            Object property = cidsBean.getProperty(token.trim());
                            if (property == null) continue;
                            value.append(String.valueOf(property));
                            continue;
                        }
                        if (token.startsWith("\"")) {
                            token = token.substring(1);
                        }
                        if (token.endsWith("\"")) {
                            token = token.substring(0, token.length() - 1);
                        }
                        value.append(token);
                    }
                    if (value.equals("")) {
                        return null;
                    }
                    return value.toString();
                }
                return cidsBean.getProperty(columnProperty);
            }
        }
        return null;
    }

    public Set<Integer> getSelectedRowIndices() {
        return this.selectedRowIndices;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!this.loading) {
            CidsBean cidsBean = this.getCidsBean(rowIndex);
            if (cidsBean == null) {
                return;
            }
            try {
                if (this.isColumnWithinBounds(columnIndex)) {
                    if (columnIndex == 0 && this.isRowsSelectable()) {
                        Boolean selected = (Boolean)value;
                        if (selected.booleanValue()) {
                            this.selectedRowIndices.add(rowIndex);
                        } else if (this.selectedRowIndices.contains(rowIndex)) {
                            this.selectedRowIndices.remove(rowIndex);
                        }
                    } else {
                        String columnProperty = this.getColumnProperty(columnIndex);
                        if (columnProperty != null) {
                            Class<?> columnClass = this.getColumnClass(columnIndex);
                            Object convertedValue = value instanceof Date && columnClass != null && java.sql.Date.class.equals(columnClass) ? new java.sql.Date(((Date)value).getTime()) : value;
                            cidsBean.setProperty(columnProperty, convertedValue);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.isRowsSelectable()) {
            return Boolean.class;
        }
        return this.isColumnWithinBounds(columnIndex) ? this.columnClasses[columnIndex - (this.isRowsSelectable() ? 1 : 0)] : null;
    }

    public static abstract class PropertyRenderer {
        public abstract Object getValue(CidsBean var1);
    }
}

