/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.wunda_blau.search.actions.RefreshDatasourceAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.JnlpSystemPropertyHelper;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DatasourceListAdminDialog
extends JDialog
implements ConnectionContextProvider,
Configurable {
    private static final Logger LOG = Logger.getLogger(DatasourceListAdminDialog.class);
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Element config;
    private Element masterConfig;
    private JButton btnChangePassword;
    private JButton btnClose;
    private JButton btnRefreshCapabilitiesList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public DatasourceListAdminDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.btnChangePassword = new JButton();
        this.btnRefreshCapabilitiesList = new JButton();
        this.jPanel3 = new JPanel();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(NbBundle.getMessage(DatasourceListAdminDialog.class, (String)"DatasourceListAdminDialog.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnChangePassword, (String)NbBundle.getMessage(DatasourceListAdminDialog.class, (String)"DatasourceListAdminDialog.btnChangePassword.text", (Object[])new Object[0]));
        this.btnChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasourceListAdminDialog.this.btnChangePasswordActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.btnChangePassword, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefreshCapabilitiesList, (String)NbBundle.getMessage(DatasourceListAdminDialog.class, (String)"DatasourceListAdminDialog.btnRefreshCapabilitiesList.text", (Object[])new Object[0]));
        this.btnRefreshCapabilitiesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasourceListAdminDialog.this.btnRefreshCapabilitiesListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.btnRefreshCapabilitiesList, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(DatasourceListAdminDialog.class, (String)"DatasourceListAdminDialog.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasourceListAdminDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.btnClose, new GridBagConstraints());
        this.jPanel1.add((Component)this.jPanel3, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnChangePasswordActionPerformed(ActionEvent evt) {
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                DatasourceListAdminDialog.this.createDatasourceList();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while executing swingworker", (Throwable)ex);
                    ErrorInfo errorInfo = new ErrorInfo("Fehler", "Fehler beim Erstellen der Datenquellenliste: " + ex.getCause().getMessage(), null, null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            }
        }.execute();
    }

    private void btnRefreshCapabilitiesListActionPerformed(ActionEvent evt) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        configurationManager.setDefaultFileName("defaultCismapProperties.xml");
        configurationManager.setFallBackFileName("defaultCismapProperties.xml");
        configurationManager.setFileName("configurationPlugin.xml");
        configurationManager.setClassPathFolder("/");
        String dirExtension = "";
        try {
            String ext = JnlpSystemPropertyHelper.getProperty((String)"directory.extension");
            System.out.println("SystemdirExtension=:" + ext);
            if (ext != null) {
                dirExtension = ext;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while adding DirectoryExtension");
        }
        configurationManager.setFolder(".cismap" + dirExtension);
        configurationManager.configure((Configurable)this);
        Document doc = new Document();
        Element rootElement = new Element("root");
        rootElement.addContent(this.masterConfig.getChild("cismapCapabilitiesPreferences").detach());
        doc.addContent((Content)rootElement);
        StringWriter writer = new StringWriter();
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xmlOutputter.output(doc, (Writer)writer);
            ServerActionParameter paramServerList = new ServerActionParameter(RefreshDatasourceAction.ParameterType.SERVER_DOCUMENT.toString(), (Object)writer.toString());
            Object object = SessionManager.getProxy().executeTask("refreshDatasourceServer", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramServerList});
        }
        catch (Exception ex) {
            LOG.error((Object)"error while write new Capabilities file", (Throwable)ex);
        }
    }

    public static void main(final String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean compressionEnabled;
                    String domain;
                    String callServerUrl;
                    DatasourceListAdminDialog dialog = new DatasourceListAdminDialog((Frame)new JFrame(), true);
                    if (args.length == 1) {
                        String cfgFile = args[0];
                        Properties properties = new Properties();
                        if (cfgFile.indexOf("http://") == 0 || cfgFile.indexOf("https://") == 0 || cfgFile.indexOf("file:/") == 0) {
                            properties.load(new URL(cfgFile).openStream());
                        } else {
                            properties.load(new BufferedInputStream(new FileInputStream(cfgFile)));
                        }
                        callServerUrl = properties.getProperty("callserverURL");
                        domain = properties.getProperty("userDomain");
                        compressionEnabled = Boolean.parseBoolean(properties.getProperty("compressionEnabled", "true"));
                    } else {
                        callServerUrl = args[0];
                        domain = args[1];
                        compressionEnabled = args.length > 2 && "compressionEnabled".equals(args[2]);
                    }
                    DevelopmentTools.showSimpleLoginDialog((String)callServerUrl, (String)domain, (boolean)compressionEnabled, (ConnectionContext)dialog.getConnectionContext());
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    StaticSwingTools.showDialog((JDialog)dialog);
                    System.exit(0);
                }
                catch (Exception ex) {
                    LOG.fatal((Object)"Fehler beim Starten des Datasource Admin Dialogs.", (Throwable)ex);
                    ErrorInfo errorInfo = new ErrorInfo("Fehler", "Fehler beim Starten des Datasource Admin Dialogs.", null, null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                    System.exit(1);
                }
            }
        });
    }

    private void createDatasourceList() throws Exception {
        Object ret = SessionManager.getProxy().executeTask("listDatasources", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[0]);
        if (ret instanceof Exception) {
            throw (Exception)ret;
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void configure(Element parent) {
        this.config = parent;
    }

    public void masterConfigure(Element parent) {
        this.masterConfig = parent;
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }
}

