/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import de.cismet.tools.configuration.Configurable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;

public class DmsUrlPathMapper
implements Configurable {
    private final HashMap<String, String> networkToLocalMap = new HashMap();
    private final HashMap<String, String> localToNetworkMap = new HashMap();

    private DmsUrlPathMapper() {
    }

    public static DmsUrlPathMapper getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void map(String networkPath, String localPath) {
        this.networkToLocalMap.put(networkPath, localPath);
        this.localToNetworkMap.put(localPath, networkPath);
    }

    public void unmapAll() {
        this.networkToLocalMap.clear();
        this.localToNetworkMap.clear();
    }

    public void unmapNetwork(String networkPath) {
        String localPath = this.networkToLocalMap.remove(networkPath);
        if (localPath != null) {
            this.localToNetworkMap.remove(localPath);
        }
    }

    public void unmapLocal(String localPath) {
        String networkPath = this.localToNetworkMap.remove(localPath);
        if (networkPath != null) {
            this.networkToLocalMap.remove(networkPath);
        }
    }

    public String getLocalPath(String networkPath) {
        return this.networkToLocalMap.get(networkPath);
    }

    public String getNetworkPath(String localPath) {
        return this.localToNetworkMap.get(localPath);
    }

    public Set<String> getAllNetworkPaths() {
        return this.networkToLocalMap.keySet();
    }

    public Set<String> getAllLocalPaths() {
        return this.localToNetworkMap.keySet();
    }

    public Element getConfiguration() {
        Element conf = new Element("dmsUrlPathMapperConfiguration");
        Element allMappingConf = new Element("Mappings");
        for (String networkPath : this.networkToLocalMap.keySet()) {
            String localPath = this.networkToLocalMap.get(networkPath);
            Element element = new Element("Mapping");
            element.setAttribute("networkPath", networkPath);
            element.setAttribute("localPath", localPath);
            allMappingConf.addContent((Content)element);
        }
        conf.addContent((Content)allMappingConf);
        return conf;
    }

    public void configure(Element parent) {
        Element mappingsElement;
        Element conf;
        this.unmapAll();
        if (parent != null && (conf = parent.getChild("dmsUrlPathMapperConfiguration")) != null && (mappingsElement = conf.getChild("Mappings")) != null) {
            List mappingElements = mappingsElement.getChildren();
            for (Element mappingElement : mappingElements) {
                String networkPath = mappingElement.getAttribute("networkPath").getValue();
                String localPath = mappingElement.getAttribute("localPath").getValue();
                this.map(networkPath, localPath);
            }
        }
    }

    public String replaceNetworkPath(String url) {
        for (String networkPath : this.getAllNetworkPaths()) {
            if (!url.startsWith(networkPath)) continue;
            return new File(url.replaceAll("^" + Pattern.quote(networkPath), Matcher.quoteReplacement(this.getLocalPath(networkPath))).replaceAll("[/\\\\]", Matcher.quoteReplacement(System.getProperty("file.separator")))).toString();
        }
        return url;
    }

    public String replaceLocalPath(String url) {
        for (String localPath : this.getAllLocalPaths()) {
            if (!url.startsWith(localPath)) continue;
            return url.replaceAll("^" + Pattern.quote(localPath), Matcher.quoteReplacement(this.getNetworkPath(localPath) + "/")).replaceAll("/", Matcher.quoteReplacement("\\"));
        }
        return url;
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    private static final class LazyInitialiser {
        private static final DmsUrlPathMapper INSTANCE = new DmsUrlPathMapper();

        private LazyInitialiser() {
        }
    }
}

