/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.wunda_blau.search.actions.NasDataQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openide.util.NbBundle;

public class NASDownload
extends AbstractCancellableDownload
implements ConnectionContextProvider {
    private static String SEVER_ACTION = "nasDataQuery";
    private static String XML_EXTENSION = ".xml";
    private static String ZIP_EXTENSION = ".zip";
    private static String DXF_EXTENSION = ".dxf";
    private static final String BASE_TITLE_NAS = NbBundle.getMessage(NASDownload.class, (String)"NASDownload.basetitle.nas.text");
    private static final String BASE_TITLE_DXF = NbBundle.getMessage(NASDownload.class, (String)"NASDownload.basetitle.dxf.text");
    protected String filename = null;
    private Future<ByteArrayWrapper> pollingFuture;
    private NasProduct product;
    private GeometryCollection geometries;
    private String orderId;
    private transient byte[] content;
    private boolean omitSendingRequest = false;
    private String requestId;
    private final ConnectionContext connectionContext;

    public NASDownload(String orderId, boolean isSplitted, boolean isDxf, String requestId, ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.omitSendingRequest = true;
        this.orderId = orderId;
        this.product = new NasProduct();
        this.product.setFormat(isDxf ? NasProduct.Format.DXF.toString() : NasProduct.Format.NAS.toString());
        this.geometries = null;
        this.title = isDxf ? BASE_TITLE_DXF : BASE_TITLE_NAS;
        this.status = Download.State.WAITING;
        this.requestId = requestId;
        this.directory = "";
        this.fileToSaveTo = requestId != null && !requestId.equals("") ? new File("" + requestId) : new File("" + orderId);
        String extension = XML_EXTENSION;
        if (this.product.getFormat().equals(NasProduct.Format.DXF.toString())) {
            extension = DXF_EXTENSION;
        } else if (isSplitted) {
            extension = ZIP_EXTENSION;
        }
        if (this.filename != null && !this.filename.equals("")) {
            this.determineDestinationFile(this.filename, extension);
        } else {
            this.determineDestinationFile(requestId, extension);
        }
    }

    public NASDownload(String title, String filename, String directory, String requestId, NasProduct product, GeometryCollection g, ConnectionContext connectionContext) {
        String extension;
        this.product = product;
        this.connectionContext = connectionContext;
        this.geometries = g;
        this.title = title;
        this.directory = directory;
        this.requestId = requestId;
        this.status = Download.State.WAITING;
        this.fileToSaveTo = requestId != null && !requestId.equals("") ? new File("" + requestId) : new File("" + System.currentTimeMillis());
        this.filename = filename;
        if (product.getFormat().equals(NasProduct.Format.DXF.toString())) {
            extension = DXF_EXTENSION;
        } else {
            String string = extension = this.isOrderSplitted(g) ? ZIP_EXTENSION : XML_EXTENSION;
        }
        if (filename != null && !filename.equals("")) {
            this.determineDestinationFile(filename, extension);
        } else {
            this.determineDestinationFile(requestId, extension);
        }
    }

    private NASDownload(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.fileToSaveTo = new File("" + System.currentTimeMillis());
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private boolean isOrderSplitted(GeometryCollection geoms) {
        Envelope env = geoms.getEnvelopeInternal();
        double xSize = env.getMaxX() - env.getMinX();
        double ySize = env.getMaxY() - env.getMinY();
        return xSize > 500.0 && ySize > 500.0;
    }

    private void setAbortedStatus() {
        this.status = Download.State.ABORTED;
        this.stateChanged();
    }

    public boolean cancel() {
        boolean cancelled = true;
        boolean isDone = false;
        if (this.downloadFuture != null) {
            isDone = this.downloadFuture.isDone();
            cancelled = this.downloadFuture.cancel(true);
        }
        if (this.pollingFuture != null) {
            this.pollingFuture.cancel(true);
        }
        if (cancelled || isDone) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return this.downloadFuture.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            block44: {
                block43: {
                    String format;
                    if (this.status != Download.State.WAITING) {
                        return;
                    }
                    this.setTitleForPhase(Phase.REQEUST_GEN);
                    this.titleChanged();
                    this.status = Download.State.RUNNING;
                    this.stateChanged();
                    String string = format = this.product.getFormat().equalsIgnoreCase(NasProduct.Format.DXF.toString()) ? "DXF" : "NAS";
                    if (!this.omitSendingRequest) {
                        if (!this.downloadFuture.isCancelled()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(format + " Download: sending request to server"));
                            }
                        } else {
                            this.doCancellationHandling(false, false);
                            return;
                        }
                        this.orderId = this.sendNasRequest();
                        if (this.orderId == null) {
                            log.error((Object)"nas server request returned no orderId, cannot continue with NAS download");
                            this.status = Download.State.COMPLETED_WITH_ERROR;
                            this.stateChanged();
                            return;
                        }
                        if (this.filename == null && this.requestId != null) {
                            this.filename = this.requestId;
                        }
                    }
                    if (!this.downloadFuture.isCancelled()) {
                        this.setTitleForPhase(Phase.RETRIEVAL);
                        this.titleChanged();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"NAS Download: Request correctly sended start polling the result from server (max 1 hour)");
                    }
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    if (this.downloadFuture.isCancelled()) {
                        this.doCancellationHandling(true, false);
                        return;
                    }
                    this.pollingFuture = executor.submit(new ServerPollingRunnable());
                    try {
                        if (!this.downloadFuture.isCancelled() && this.pollingFuture != null) {
                            this.content = this.pollingFuture.get().getByteArray();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"NAS Download: Polling is finished.");
                            }
                            break block43;
                        }
                        this.doCancellationHandling(true, true);
                        return;
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)"The polling thread was interrupted.", (Throwable)ex);
                        this.doCancellationHandling(true, true);
                        Thread.currentThread().interrupt();
                        this.error(ex);
                    }
                    catch (ExecutionException ex) {
                        log.warn((Object)"could not execute nas download", (Throwable)ex);
                        this.error(ex);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Exception during waiting / polling on NAS Result", (Throwable)ex);
                        this.error(ex);
                    }
                }
                if (!this.downloadFuture.isCancelled()) {
                    this.setTitleForPhase(Phase.DOWNLOAD);
                    this.titleChanged();
                }
                if (this.content == null || this.content.length <= 0) {
                    log.info((Object)"NAS Download: Downloaded content seems to be empty..");
                    if (this.status == Download.State.RUNNING && !Thread.interrupted()) {
                        this.status = Download.State.COMPLETED_WITH_ERROR;
                        this.stateChanged();
                    }
                    return;
                }
                FileOutputStream out = null;
                try {
                    if (!this.downloadFuture.isCancelled()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"NAS Download: Start writing the result to file");
                        }
                        out = new FileOutputStream(this.fileToSaveTo);
                        out.write(this.content);
                        break block44;
                    }
                    this.doCancellationHandling(false, false);
                    return;
                }
                catch (IOException ex) {
                    log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
                    this.error(ex);
                    return;
                }
                catch (Exception ex) {
                    log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
                    this.error(ex);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)e);
                            this.error(e);
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"NAS Download: done.");
            }
            if (!this.downloadFuture.isCancelled()) {
                this.setTitleForPhase(Phase.DONE);
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception during NASDownload " + this.filename), (Throwable)ex);
            this.error(ex);
        }
    }

    private void doCancellationHandling(boolean cancelServerRequest, boolean cancelPollingThread) {
        log.warn((Object)"NAS Download was interuppted");
        if (cancelServerRequest) {
            this.cancelNasRequest();
        }
        if (cancelPollingThread && this.pollingFuture != null) {
            this.pollingFuture.cancel(true);
        }
        this.deleteFile();
    }

    private void setTitleForPhase(Phase p) {
        String appendix = "";
        if (p == Phase.REQEUST_GEN) {
            appendix = NbBundle.getMessage(NASDownload.class, (String)"NASDownload.requestGenTitle.text");
        } else if (p == Phase.RETRIEVAL) {
            appendix = NbBundle.getMessage(NASDownload.class, (String)"NASDownload.resultRetrievalTitle.text");
        } else if (p == Phase.DOWNLOAD) {
            appendix = NbBundle.getMessage(NASDownload.class, (String)"NASDownload.downloadTitle.text");
        }
        String string = this.title = this.product.getFormat().equalsIgnoreCase(NasProduct.Format.DXF.toString()) ? BASE_TITLE_DXF : BASE_TITLE_NAS;
        if (appendix != null && !appendix.equals("")) {
            this.title = this.title + " - " + appendix;
        }
    }

    private String sendNasRequest() {
        ServerActionParameter paramTemplate = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.TEMPLATE.toString(), (Object)this.product);
        ServerActionParameter paramGeom = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.GEOMETRY_COLLECTION.toString(), (Object)this.geometries);
        ServerActionParameter paramMethod = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.ADD);
        ServerActionParameter paramRequest = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.REQUEST_ID.toString(), (Object)this.requestId);
        try {
            return (String)SessionManager.getProxy().executeTask(SEVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramTemplate, paramGeom, paramRequest, paramMethod});
        }
        catch (Exception ex) {
            log.error((Object)"error during enqueuing nas server request", (Throwable)ex);
            return null;
        }
    }

    private void cancelNasRequest() {
        ServerActionParameter paramOrderId = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.ORDER_ID.toString(), (Object)this.orderId);
        ServerActionParameter paramMethod = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.CANCEL);
        try {
            SessionManager.getProxy().executeTask(SEVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramOrderId, paramMethod});
        }
        catch (Exception ex) {
            log.error((Object)"error during enqueuing nas server request", (Throwable)ex);
        }
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    private class ByteArrayWrapper {
        private byte[] byteArray;

        private ByteArrayWrapper(byte[] ba) {
            this.byteArray = ba;
        }

        public byte[] getByteArray() {
            return this.byteArray;
        }

        public void setByteArray(byte[] b) {
            this.byteArray = b;
        }
    }

    private class ServerPollingRunnable
    implements Callable<ByteArrayWrapper> {
        private ServerPollingRunnable() {
        }

        @Override
        public ByteArrayWrapper call() {
            ServerActionParameter paramMethod = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.GET);
            ServerActionParameter paramOrderId = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.ORDER_ID.toString(), (Object)NASDownload.this.orderId);
            byte[] result = null;
            while (result == null || result.length == 0) {
                if (Thread.interrupted()) {
                    log.info((Object)"result fetching thread was interrupted");
                    return null;
                }
                try {
                    result = (byte[])SessionManager.getProxy().executeTask(SEVER_ACTION, "WUNDA_BLAU", null, NASDownload.this.getConnectionContext(), new ServerActionParameter[]{paramOrderId, paramMethod});
                }
                catch (ConnectionException ex) {
                    log.error((Object)"error during pulling nas result from server", (Throwable)ex);
                }
                if (result == null) {
                    return null;
                }
                if (result.length != 0) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    log.info((Object)"result fetching thread was interrupted", (Throwable)ex);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            ByteArrayWrapper baw = new ByteArrayWrapper(result);
            return baw;
        }
    }

    private static enum Phase {
        REQEUST_GEN,
        RETRIEVAL,
        DOWNLOAD,
        DONE;

    }
}

