/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.nas.CheckListItem;
import de.cismet.cids.custom.nas.PointNumberReservationPanel;
import de.cismet.cids.custom.nas.PointNumberTableModel;
import de.cismet.cids.custom.nas.PointNumberTxtDownload;
import de.cismet.cids.custom.nas.PointNumberWarnDialog;
import de.cismet.cids.custom.nas.PointNumberXmlDownload;
import de.cismet.cids.custom.nas.WideComboBox;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.cids.custom.utils.pointnumberreservation.VermessungsStellenSearchResult;
import de.cismet.cids.custom.wunda_blau.search.actions.PointNumberReservationServerAction;
import de.cismet.cids.custom.wunda_blau.search.server.VermessungsStellenNummerSearch;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.gui.progress.BusyLoggingTextPane;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PointNumberDialog
extends JDialog
implements ConnectionContextProvider {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(PointNumberDialog.class);
    private static final String SEVER_ACTION = "pointNumberReservation";
    private final Comparator<VermessungsStellenSearchResult> vnrComperator;
    private Timer loadAllAnrTimer = new Timer();
    private PointNumberReservationRequest result;
    private boolean hasFreigabeAccess = false;
    private boolean hasVerlaengernAccess = false;
    private AllAntragsnummernLoadWorker allAnrLoadWorker;
    private FreigebenWorker freigebenWorker;
    private VerlaengernWorker verlaengernWorker;
    private PointNumberLoadWorker pnrLoadWorker;
    private boolean useAutoCompleteDecorator = false;
    private List<String> priorityPrefixes = new ArrayList<String>();
    private List<CheckListItem> punktnummern = new ArrayList<CheckListItem>();
    private PointNumberTableModel releaseModel = new PointNumberTableModel(this.punktnummern, false);
    private PointNumberTableModel prolongModel = new PointNumberTableModel(this.punktnummern, true);
    private boolean hasBeenDownloadedOrIgnoredYet = true;
    private String dontReloadPnrsForThisAnr = null;
    private final List<String> antragsNummern = new ArrayList<String>();
    private String protokollAnrPrefix = null;
    private String protokollAnr = null;
    private final ConnectionContext connectionContext;
    private JButton btnDeSelectAll;
    private JButton btnDeSelectAll1;
    private JButton btnDone;
    private JButton btnDownload;
    private JButton btnFreigeben;
    private JButton btnSelectAll;
    private JButton btnSelectAll1;
    private JButton btnVerlaengern;
    private JComboBox cbAntragPrefix;
    private JComboBox cbAntragsNummer;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JXDatePicker jXDatePicker1;
    private JXBusyLabel jxFreigebenWaitLabel;
    private JXBusyLabel jxVerlaengernWaitLabel;
    private JLabel lblAnrSeperator;
    private JLabel lblAntragsnummer;
    private JLabel lblFreigebenError;
    private JLabel lblFreigebenError1;
    private JLabel lblProtokoll;
    private JLabel lblPunktNummern;
    private JLabel lblPunktNummern1;
    private JLabel lblTabErgaenzen;
    private JLabel lblTabFreigeben;
    private JLabel lblTabReservieren;
    private JLabel lblTabVerlaengern;
    private JLabel lblVnr;
    private JPanel pnlControls;
    private PointNumberReservationPanel pnlErgaenzen;
    private JPanel pnlFreigabeListControls;
    private JPanel pnlFreigabeListControls1;
    private JPanel pnlFreigeben;
    private JPanel pnlFreigebenCard;
    private JPanel pnlFreigebenError;
    private JPanel pnlLeft;
    private PointNumberReservationPanel pnlReservieren;
    private JPanel pnlRight;
    private JPanel pnlTabLabels;
    private JPanel pnlVerlaengern;
    private JPanel pnlVerlaengernCard;
    private JPanel pnlVerlaengernError;
    private JPanel pnlVerlaengernWait;
    private JPanel pnlWait;
    private BusyLoggingTextPane protokollPane;
    private JTable tblPunktnummernFreigeben;
    private JTable tblPunktnummernVerlaengern;
    private JTabbedPane tbpModus;

    public PointNumberDialog(Frame parent, boolean modal, ConnectionContext connectionContext) {
        super(parent, modal);
        TableColumn column;
        this.connectionContext = connectionContext;
        this.vnrComperator = new Comparator<VermessungsStellenSearchResult>(){

            @Override
            public int compare(VermessungsStellenSearchResult o1, VermessungsStellenSearchResult o2) {
                return o1.getZulassungsNummer().compareTo(o2.getZulassungsNummer());
            }
        };
        this.setTitle(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.title"));
        this.initComponents();
        Properties props = new Properties();
        try {
            props.load(PointNumberReservationPanel.class.getResourceAsStream("pointNumberSettings.properties"));
            this.useAutoCompleteDecorator = Boolean.parseBoolean(props.getProperty("autoCompletion"));
            String[] splittedPrioPrefixes = props.getProperty("priorityPrefixes").split(",");
            for (int i = 0; i < splittedPrioPrefixes.length; ++i) {
                String tmp = splittedPrioPrefixes[i];
                this.priorityPrefixes.add(tmp);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not read pointnumberSettings.properties", (Throwable)e);
        }
        this.tbpModus.setTabComponentAt(0, this.pnlTabLabels);
        this.tbpModus.setTabComponentAt(1, this.lblTabErgaenzen);
        this.tbpModus.setTabComponentAt(2, this.lblTabFreigeben);
        this.tbpModus.setTabComponentAt(3, this.lblTabVerlaengern);
        this.tbpModus.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PointNumberDialog.this.warnIfNeeded();
                if (PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlFreigeben) || PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlVerlaengern)) {
                    String fullAnr = PointNumberDialog.this.getAnrPrefix() + PointNumberDialog.this.getAnr();
                    if (!fullAnr.equals(PointNumberDialog.this.dontReloadPnrsForThisAnr)) {
                        PointNumberDialog.this.loadPointNumbers();
                    }
                } else {
                    PointNumberReservationPanel pnl = (PointNumberReservationPanel)PointNumberDialog.this.tbpModus.getSelectedComponent();
                    pnl.checkNummerierungsbezirke();
                }
                PointNumberDialog.this.cbAntragsNummer.setEditable(PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlReservieren));
                PointNumberDialog.this.cbAntragsNummer.setEnabled(PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlReservieren) || !PointNumberDialog.this.antragsNummern.isEmpty());
            }
        });
        DefaultCaret caret = (DefaultCaret)this.protokollPane.getCaret();
        caret.setUpdatePolicy(1);
        this.cbAntragPrefix.setRenderer(new AnrPrefixItemRenderer());
        JTextComponent tc = (JTextComponent)this.cbAntragPrefix.getEditor().getEditorComponent();
        tc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PointNumberDialog.this.delayedLoadAllAntragsNummern();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PointNumberDialog.this.delayedLoadAllAntragsNummern();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PointNumberDialog.this.loadAllAntragsNummern();
            }
        });
        try {
            this.configureFreigebenTab();
            this.configureVerlaengernTab();
            this.configurePrefixBox();
        }
        catch (Exception e) {
            LOG.error((Object)"Error during determination of vermessungstellennummer", (Throwable)e);
        }
        if (this.useAutoCompleteDecorator) {
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cbAntragsNummer);
        }
        ((DefaultComboBoxModel)this.cbAntragsNummer.getModel()).addElement("");
        if (this.tblPunktnummernFreigeben != null && this.tblPunktnummernFreigeben.getColumnModel() != null && (column = this.tblPunktnummernFreigeben.getColumnModel().getColumn(0)) != null) {
            column.setPreferredWidth(20);
            column.setMaxWidth(20);
        }
        if (this.tblPunktnummernVerlaengern != null && this.tblPunktnummernVerlaengern.getColumnModel() != null && (column = this.tblPunktnummernVerlaengern.getColumnModel().getColumn(0)) != null) {
            column.setPreferredWidth(20);
            column.setMaxWidth(20);
        }
        this.tblPunktnummernFreigeben.setTableHeader(null);
        this.tblPunktnummernFreigeben.setShowGrid(false);
        this.tblPunktnummernVerlaengern.setTableHeader(null);
        this.tblPunktnummernVerlaengern.setShowGrid(false);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, 18);
        this.jXDatePicker1.setDate(c.getTime());
    }

    private void delayedLoadAllAntragsNummern() {
        this.loadAllAnrTimer.cancel();
        this.loadAllAnrTimer = new Timer();
        this.loadAllAnrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PointNumberDialog.this.loadAllAntragsNummern();
            }
        }, 800L);
    }

    private void configureFreigebenTab() throws ConnectionException {
        this.hasFreigabeAccess = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "custom.nas.punktNummernFreigabe", this.getConnectionContext());
        if (!this.hasFreigabeAccess) {
            this.tbpModus.remove(this.pnlFreigeben);
        }
    }

    private void configureVerlaengernTab() throws ConnectionException {
        this.hasVerlaengernAccess = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "custom.nas.punktNummernVerlaengern", this.getConnectionContext());
        if (!this.hasVerlaengernAccess) {
            this.tbpModus.remove(this.pnlVerlaengern);
        }
    }

    private void configurePrefixBox() throws ConnectionException {
        User user = SessionManager.getSession().getUser();
        VermessungsnummerLoadWorker vnrLoadWorker = new VermessungsnummerLoadWorker(user.getName()){

            @Override
            protected void done() {
                try {
                    Collection res = (Collection)this.get();
                    if (res == null || res.isEmpty()) {
                        VermessungsnummerLoadWorker allVnrLoadWorker = new VermessungsnummerLoadWorker("%"){

                            @Override
                            protected void done() {
                                try {
                                    ArrayList<Object> tmp = new ArrayList<Object>();
                                    List resultAllVnr = (List)this.get();
                                    Collections.sort(resultAllVnr, PointNumberDialog.this.vnrComperator);
                                    for (String s : PointNumberDialog.this.priorityPrefixes) {
                                        int index = Collections.binarySearch(resultAllVnr, new VermessungsStellenSearchResult(s, s), PointNumberDialog.this.vnrComperator);
                                        if (index < 0) {
                                            if (s.equals("3290")) {
                                                tmp.add(new VermessungsStellenSearchResult(s, "Stadt Wuppertal"));
                                                continue;
                                            }
                                            tmp.add(new VermessungsStellenSearchResult(s, ""));
                                            continue;
                                        }
                                        tmp.add(resultAllVnr.get(index));
                                        resultAllVnr.remove(index);
                                    }
                                    tmp.addAll(resultAllVnr);
                                    PointNumberDialog.this.cbAntragPrefix.setModel(new DefaultComboBoxModel<Object>(tmp.toArray()));
                                    PointNumberDialog.this.loadAllAntragsNummern();
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)ex, (Throwable)ex);
                                }
                            }
                        };
                        allVnrLoadWorker.execute();
                    } else {
                        ArrayList tmp = (ArrayList)res;
                        VermessungsStellenSearchResult firstRes = (VermessungsStellenSearchResult)tmp.get(0);
                        if (firstRes != null && firstRes.getZulassungsNummer() != null) {
                            PointNumberDialog.this.cbAntragPrefix.setModel(new DefaultComboBoxModel<Object>(tmp.toArray()));
                            RendererTools.makeReadOnly(PointNumberDialog.this.cbAntragPrefix);
                            PointNumberDialog.this.cbAntragPrefix.setEditable(false);
                        }
                        PointNumberDialog.this.loadAllAntragsNummern();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };
        vnrLoadWorker.execute();
    }

    private void loadPointNumbers() {
        this.cancelWorker(this.pnrLoadWorker);
        this.pnrLoadWorker = new PointNumberLoadWorker();
        CardLayout cl = (CardLayout)this.pnlFreigeben.getLayout();
        cl.show(this.pnlFreigeben, "card1");
        this.jxFreigebenWaitLabel.setBusy(true);
        CardLayout cl1 = (CardLayout)this.pnlVerlaengern.getLayout();
        cl1.show(this.pnlVerlaengern, "card1");
        this.jxVerlaengernWaitLabel.setBusy(true);
        this.pnrLoadWorker.execute();
    }

    public String getAnr() {
        String tmp;
        String anr = this.cbAntragsNummer.isEditable() ? (((tmp = ((JTextComponent)this.cbAntragsNummer.getEditor().getEditorComponent()).getText()) == null || tmp.isEmpty()) && this.cbAntragsNummer.getSelectedItem() != null ? this.cbAntragsNummer.getSelectedItem().toString() : tmp) : this.cbAntragsNummer.getSelectedItem().toString();
        return anr;
    }

    public String getAnrPrefix() {
        String tmp;
        String anrPrefix = this.cbAntragPrefix.isEditable() ? ((tmp = ((JTextComponent)this.cbAntragPrefix.getEditor().getEditorComponent()).getText()) == null || tmp.isEmpty() ? this.cbAntragPrefix.getSelectedItem().toString() : tmp) : this.cbAntragPrefix.getSelectedItem().toString();
        return anrPrefix;
    }

    public boolean isErgaenzenMode() {
        return this.tbpModus.getSelectedComponent().equals(this.pnlErgaenzen);
    }

    private void showFreigabeError() {
        this.jxFreigebenWaitLabel.setBusy(false);
        CardLayout cl = (CardLayout)this.pnlFreigeben.getLayout();
        cl.show(this.pnlFreigeben, "card3");
        this.jxFreigebenWaitLabel.setBusy(true);
    }

    private void showVerlaengernError() {
        this.jxVerlaengernWaitLabel.setBusy(false);
        CardLayout cl1 = (CardLayout)this.pnlVerlaengern.getLayout();
        cl1.show(this.pnlVerlaengern, "card3");
        this.jxVerlaengernWaitLabel.setBusy(true);
    }

    private void initComponents() {
        this.pnlTabLabels = new JPanel();
        this.lblTabReservieren = new JLabel();
        this.lblTabErgaenzen = new JLabel();
        this.lblTabFreigeben = new JLabel();
        this.lblTabVerlaengern = new JLabel();
        this.pnlLeft = new JPanel();
        this.lblAntragsnummer = new JLabel();
        this.tbpModus = new JTabbedPane();
        this.pnlReservieren = new PointNumberReservationPanel(this, this.getConnectionContext());
        this.pnlErgaenzen = new PointNumberReservationPanel(this, this.getConnectionContext());
        this.pnlFreigeben = new JPanel();
        this.pnlWait = new JPanel();
        this.jxFreigebenWaitLabel = new JXBusyLabel();
        this.pnlFreigebenCard = new JPanel();
        this.lblPunktNummern = new JLabel();
        this.btnFreigeben = new JButton();
        this.pnlFreigabeListControls = new JPanel();
        this.btnSelectAll = new JButton();
        this.btnDeSelectAll = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jScrollPane2 = new JScrollPane();
        this.tblPunktnummernFreigeben = new JTable();
        this.pnlFreigebenError = new JPanel();
        this.lblFreigebenError = new JLabel();
        this.pnlVerlaengern = new JPanel();
        this.pnlVerlaengernWait = new JPanel();
        this.jxVerlaengernWaitLabel = new JXBusyLabel();
        this.pnlVerlaengernCard = new JPanel();
        this.lblPunktNummern1 = new JLabel();
        this.pnlFreigabeListControls1 = new JPanel();
        this.btnSelectAll1 = new JButton();
        this.btnDeSelectAll1 = new JButton();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel4 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.tblPunktnummernVerlaengern = new JTable();
        this.jPanel2 = new JPanel();
        this.jXDatePicker1 = new JXDatePicker();
        this.btnVerlaengern = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlVerlaengernError = new JPanel();
        this.lblFreigebenError1 = new JLabel();
        this.cbAntragPrefix = new WideComboBox();
        this.lblAnrSeperator = new JLabel();
        this.lblVnr = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.cbAntragsNummer = new JComboBox();
        this.pnlRight = new JPanel();
        this.lblProtokoll = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.protokollPane = new BusyLoggingTextPane(50, 50);
        this.btnDownload = new JButton();
        this.pnlControls = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.btnDone = new JButton();
        this.pnlTabLabels.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlTabLabels.setOpaque(false);
        this.lblTabReservieren.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/glyphicons_153_unchecked.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblTabReservieren, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblTabReservieren.text"));
        this.pnlTabLabels.add(this.lblTabReservieren);
        this.lblTabErgaenzen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/glyphicons_154_more_windows.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblTabErgaenzen, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblTabErgaenzen.text"));
        this.pnlTabLabels.add(this.lblTabErgaenzen);
        this.lblTabFreigeben.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/glyphicons_151_new_window.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblTabFreigeben, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblTabFreigeben.text"));
        this.pnlTabLabels.add(this.lblTabFreigeben);
        this.lblTabVerlaengern.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/glyphicons_153_unchecked_054_clock.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblTabVerlaengern, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblTabVerlaengern.text"));
        this.pnlTabLabels.add(this.lblTabVerlaengern);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlLeft.setMinimumSize(new Dimension(400, 27));
        this.pnlLeft.setPreferredSize(new Dimension(500, 378));
        this.pnlLeft.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblAntragsnummer, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblAntragsnummer.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlLeft.add((Component)this.lblAntragsnummer, gridBagConstraints);
        this.tbpModus.addTab(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlReservieren.TabConstraints.tabTitle"), null, this.pnlReservieren, NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlReservieren.TabConstraints.tabToolTip"));
        this.tbpModus.addTab(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlReservieren.TabConstraints.tabTitle"), this.pnlErgaenzen);
        this.pnlFreigeben.setLayout(new CardLayout());
        this.pnlWait.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jxFreigebenWaitLabel, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.jxFreigebenWaitLabel.text"));
        this.pnlWait.add((Component)this.jxFreigebenWaitLabel, new GridBagConstraints());
        this.pnlFreigeben.add((Component)this.pnlWait, "card1");
        this.pnlFreigebenCard.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblPunktNummern, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblPunktNummern.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlFreigebenCard.add((Component)this.lblPunktNummern, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFreigeben, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnFreigeben.text"));
        this.btnFreigeben.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnFreigebenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlFreigebenCard.add((Component)this.btnFreigeben, gridBagConstraints);
        this.pnlFreigabeListControls.setLayout(new GridBagLayout());
        this.btnSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-selectionadd.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAll, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnSelectAll.text"));
        this.btnSelectAll.setToolTipText(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnSelectAll.toolTipText"));
        this.btnSelectAll.setPreferredSize(new Dimension(30, 28));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pnlFreigabeListControls.add((Component)this.btnSelectAll, gridBagConstraints);
        this.btnDeSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-selectionremove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeSelectAll, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDeSelectAll.text"));
        this.btnDeSelectAll.setToolTipText(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDeSelectAll.toolTipText"));
        this.btnDeSelectAll.setPreferredSize(new Dimension(30, 28));
        this.btnDeSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnDeSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlFreigabeListControls.add((Component)this.btnDeSelectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlFreigabeListControls.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.pnlFreigebenCard.add((Component)this.pnlFreigabeListControls, gridBagConstraints);
        this.tblPunktnummernFreigeben.setModel(this.releaseModel);
        this.tblPunktnummernFreigeben.setFillsViewportHeight(true);
        this.tblPunktnummernFreigeben.setShowHorizontalLines(false);
        this.tblPunktnummernFreigeben.setShowVerticalLines(false);
        this.tblPunktnummernFreigeben.setTableHeader(null);
        this.jScrollPane2.setViewportView(this.tblPunktnummernFreigeben);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlFreigebenCard.add((Component)this.jScrollPane2, gridBagConstraints);
        this.pnlFreigeben.add((Component)this.pnlFreigebenCard, "card2");
        this.pnlFreigebenError.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblFreigebenError, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblFreigebenError.text"));
        this.pnlFreigebenError.add((Component)this.lblFreigebenError, new GridBagConstraints());
        this.pnlFreigeben.add((Component)this.pnlFreigebenError, "card3");
        this.pnlFreigebenError.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlFreigebenError.AccessibleContext.accessibleName"));
        this.tbpModus.addTab(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlReservieren.TabConstraints.tabTitle"), this.pnlFreigeben);
        this.pnlVerlaengern.setLayout(new CardLayout());
        this.pnlVerlaengernWait.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jxVerlaengernWaitLabel, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.jxVerlaengernWaitLabel.text"));
        this.pnlVerlaengernWait.add((Component)this.jxVerlaengernWaitLabel, new GridBagConstraints());
        this.pnlVerlaengern.add((Component)this.pnlVerlaengernWait, "card1");
        this.pnlVerlaengernCard.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblPunktNummern1, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblPunktNummern1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlVerlaengernCard.add((Component)this.lblPunktNummern1, gridBagConstraints);
        this.pnlFreigabeListControls1.setLayout(new GridBagLayout());
        this.btnSelectAll1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-selectionadd.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAll1, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnSelectAll1.text"));
        this.btnSelectAll1.setToolTipText(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnSelectAll1.toolTipText"));
        this.btnSelectAll1.setPreferredSize(new Dimension(30, 28));
        this.btnSelectAll1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnSelectAll1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pnlFreigabeListControls1.add((Component)this.btnSelectAll1, gridBagConstraints);
        this.btnDeSelectAll1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-selectionremove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeSelectAll1, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDeSelectAll1.text"));
        this.btnDeSelectAll1.setToolTipText(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDeSelectAll1.toolTipText"));
        this.btnDeSelectAll1.setPreferredSize(new Dimension(30, 28));
        this.btnDeSelectAll1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnDeSelectAll1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlFreigabeListControls1.add((Component)this.btnDeSelectAll1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlFreigabeListControls1.add((Component)this.filler3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.pnlFreigabeListControls1.add((Component)this.jPanel4, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.pnlVerlaengernCard.add((Component)this.pnlFreigabeListControls1, gridBagConstraints);
        this.tblPunktnummernVerlaengern.setModel(this.prolongModel);
        this.tblPunktnummernVerlaengern.setFillsViewportHeight(true);
        this.tblPunktnummernVerlaengern.setShowHorizontalLines(false);
        this.tblPunktnummernVerlaengern.setShowVerticalLines(false);
        this.tblPunktnummernVerlaengern.setTableHeader(null);
        this.jScrollPane4.setViewportView(this.tblPunktnummernVerlaengern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlVerlaengernCard.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jXDatePicker1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnVerlaengern, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnVerlaengern.text"));
        this.btnVerlaengern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnVerlaengernActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.btnVerlaengern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlVerlaengernCard.add((Component)this.jPanel2, gridBagConstraints);
        this.pnlVerlaengern.add((Component)this.pnlVerlaengernCard, "card2");
        this.pnlVerlaengernError.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblFreigebenError1, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblFreigebenError1.text"));
        this.pnlVerlaengernError.add((Component)this.lblFreigebenError1, new GridBagConstraints());
        this.pnlVerlaengern.add((Component)this.pnlVerlaengernError, "card3");
        this.tbpModus.addTab(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.pnlReservieren.TabConstraints.tabTitle"), this.pnlVerlaengern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlLeft.add((Component)this.tbpModus, gridBagConstraints);
        this.cbAntragPrefix.setEditable(true);
        this.cbAntragPrefix.setMinimumSize(new Dimension(70, 27));
        this.cbAntragPrefix.setPreferredSize(new Dimension(70, 27));
        this.cbAntragPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.cbAntragPrefixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlLeft.add((Component)this.cbAntragPrefix, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAnrSeperator, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblAnrSeperator.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlLeft.add((Component)this.lblAnrSeperator, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblVnr, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblVnr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.pnlLeft.add((Component)this.lblVnr, gridBagConstraints);
        this.jProgressBar1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jProgressBar1.setBorderPainted(false);
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setMaximumSize(new Dimension(Short.MAX_VALUE, 5));
        this.jProgressBar1.setMinimumSize(new Dimension(10, 5));
        this.jProgressBar1.setPreferredSize(new Dimension(150, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 35);
        this.pnlLeft.add((Component)this.jProgressBar1, gridBagConstraints);
        this.cbAntragsNummer.setEditable(true);
        this.cbAntragsNummer.setMinimumSize(new Dimension(209, 29));
        this.cbAntragsNummer.setPreferredSize(new Dimension(209, 29));
        this.cbAntragsNummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.cbAntragsNummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlLeft.add((Component)this.cbAntragsNummer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlLeft, gridBagConstraints);
        this.pnlRight.setBackground(new Color(254, 254, 254));
        this.pnlRight.setBorder(BorderFactory.createEtchedBorder());
        this.pnlRight.setMinimumSize(new Dimension(400, 0));
        this.pnlRight.setPreferredSize(new Dimension(400, 0));
        this.pnlRight.setLayout(new GridBagLayout());
        this.lblProtokoll.setFont(new Font("FreeMono", 1, 20));
        Mnemonics.setLocalizedText((JLabel)this.lblProtokoll, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.lblProtokoll.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.pnlRight.add((Component)this.lblProtokoll, gridBagConstraints);
        this.protokollPane.setEditable(false);
        this.jScrollPane1.setViewportView((Component)this.protokollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlRight.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnDownload.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-download-alt.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDownload, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDownload.text"));
        this.btnDownload.setToolTipText(NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDownload.toolTipText"));
        this.btnDownload.setBorderPainted(false);
        this.btnDownload.setContentAreaFilled(false);
        this.btnDownload.setFocusPainted(false);
        this.btnDownload.setPreferredSize(new Dimension(32, 32));
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnDownloadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlRight.add((Component)this.btnDownload, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlRight, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlControls.add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDone, (String)NbBundle.getMessage(PointNumberDialog.class, (String)"PointNumberDialog.btnDone.text"));
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberDialog.this.btnDoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.pnlControls.add((Component)this.btnDone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.pack();
    }

    private void btnDoneActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnFreigebenActionPerformed(ActionEvent evt) {
        this.cancelWorker(this.freigebenWorker);
        this.freigebenWorker = new FreigebenWorker();
        this.executeWorker(this.freigebenWorker, this.releaseModel, this.btnFreigeben, "Sende Freigabeauftrag.", "Es wurden keine Punktnummern zur Freigabe selektiert.");
    }

    private void executeWorker(SwingWorker worker, PointNumberTableModel model, JButton button, String executeString, String errorString) {
        try {
            this.protokollPane.getDocument().remove(0, this.protokollPane.getDocument().getLength());
        }
        catch (BadLocationException ex) {
            LOG.error((Object)"Could not clear Protokoll Pane", (Throwable)ex);
        }
        if (model.getSelectedValues() == 0) {
            this.protokollPane.addMessage(errorString, BusyLoggingTextPane.Styles.ERROR);
            return;
        }
        this.enableDoneButton(false);
        button.setEnabled(false);
        this.memorizeAnrPrefix();
        this.protokollPane.setBusy(true);
        this.protokollPane.addMessage(executeString, BusyLoggingTextPane.Styles.INFO);
        this.warnIfNeeded();
        worker.execute();
    }

    public void memorizeAnrPrefix() {
        this.protokollAnrPrefix = this.getAnrPrefix();
        this.protokollAnr = this.getAnr();
    }

    private void btnDownloadActionPerformed(ActionEvent evt) {
        if (this.result == null) {
            return;
        }
        String jobname = DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)CismapBroker.getInstance().getMappingComponent()) ? (!DownloadManagerDialog.getInstance().getJobName().equals("") ? DownloadManagerDialog.getInstance().getJobName() : null) : "";
        ArrayList<AbstractDownload> downloads = new ArrayList<AbstractDownload>();
        downloads.add(new PointNumberTxtDownload(this.result, "Punktnummer Download (TXT)", jobname, this.protokollAnrPrefix + "_" + this.protokollAnr));
        downloads.add(new PointNumberXmlDownload(this.result, "Punktnummer Download (XML)", jobname, this.protokollAnrPrefix + "_" + this.protokollAnr));
        MultipleDownload download = new MultipleDownload(downloads, "Punktnummer Download");
        DownloadManager.instance().add((Download)download);
        this.hasBeenDownloadedOrIgnoredYet = true;
    }

    private void cbAntragPrefixActionPerformed(ActionEvent evt) {
    }

    private void btnDeSelectAllActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.punktnummern.size(); ++i) {
            CheckListItem item = this.punktnummern.get(i);
            item.setSelected(true);
            this.releaseModel.setValueAt(item, i, 0);
        }
        this.tblPunktnummernFreigeben.repaint();
    }

    private void btnSelectAllActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.punktnummern.size(); ++i) {
            CheckListItem item = this.punktnummern.get(i);
            item.setSelected(false);
            this.releaseModel.setValueAt(item, i, 0);
        }
        this.tblPunktnummernFreigeben.repaint();
    }

    private void cbAntragsNummerActionPerformed(ActionEvent evt) {
        if (this.cbAntragsNummer.isEnabled() && (this.tbpModus.getSelectedComponent().equals(this.pnlFreigeben) || this.tbpModus.getSelectedComponent().equals(this.pnlVerlaengern))) {
            this.loadPointNumbers();
        }
    }

    private void btnVerlaengernActionPerformed(ActionEvent evt) {
        this.cancelWorker(this.verlaengernWorker);
        this.verlaengernWorker = new VerlaengernWorker();
        this.executeWorker(this.verlaengernWorker, this.prolongModel, this.btnVerlaengern, "Sende Verl\u00e4ngerungseauftrag.", "Es wurden keine Punktnummern zum Verl\u00e4ngern selektiert.");
    }

    private void btnSelectAll1ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.punktnummern.size(); ++i) {
            CheckListItem item = this.punktnummern.get(i);
            item.setSelected(false);
            this.prolongModel.setValueAt(item, i, 0);
        }
        this.tblPunktnummernVerlaengern.repaint();
    }

    private void btnDeSelectAll1ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.punktnummern.size(); ++i) {
            CheckListItem item = this.punktnummern.get(i);
            item.setSelected(true);
            this.prolongModel.setValueAt(item, i, 0);
        }
        this.tblPunktnummernVerlaengern.repaint();
    }

    private void showError() {
        this.enableDoneButton(true);
        this.btnFreigeben.setEnabled(true);
        if (this.protokollPane != null) {
            this.protokollPane.addMessage("W\u00e4hrend der Bearbeitung des Auftrags trat ein Fehler auf!", BusyLoggingTextPane.Styles.ERROR);
            this.protokollPane.setBusy(false);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PointNumberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PointNumberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PointNumberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PointNumberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PointNumberDialog dialog = new PointNumberDialog((Frame)new JFrame(), true, ConnectionContext.createDeprecated());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public BusyLoggingTextPane getProtokollPane() {
        return this.protokollPane;
    }

    public void setResult(PointNumberReservationRequest result) {
        this.result = result;
    }

    public void addAnr(String newAnr) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbAntragsNummer.getModel();
        ArrayList tmp = new ArrayList();
        for (int i = 0; i < model.getSize(); ++i) {
            tmp.add(model.getElementAt(i));
        }
        int pos = Collections.binarySearch(tmp, newAnr);
        model.insertElementAt(newAnr, Math.abs(pos) - 1);
    }

    private void cancelWorker(SwingWorker worker) {
        if (worker != null && worker.getState() != SwingWorker.StateValue.DONE) {
            worker.cancel(false);
        }
    }

    public void loadAllAntragsNummern() {
        this.cancelWorker(this.allAnrLoadWorker);
        this.allAnrLoadWorker = new AllAntragsnummernLoadWorker();
        this.jProgressBar1.setIndeterminate(true);
        this.cbAntragsNummer.setEnabled(false);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbAntragsNummer.getModel();
        String insertedText = ((JTextComponent)this.cbAntragsNummer.getEditor().getEditorComponent()).getText();
        model.removeAllElements();
        if (this.tbpModus.getSelectedComponent().equals(this.pnlReservieren)) {
            ((JTextComponent)this.cbAntragsNummer.getEditor().getEditorComponent()).setText(insertedText);
        } else {
            this.cbAntragsNummer.setEditable(false);
            String ladeString = "lade Antragsnummern...";
            model.addElement("lade Antragsnummern...");
            model.setSelectedItem("lade Antragsnummern...");
        }
        this.cbAntragsNummer.repaint();
        this.repaint();
        this.allAnrLoadWorker.execute();
    }

    public void enableDoneButton(boolean enable) {
        if (enable) {
            this.btnDone.setEnabled(true);
        } else {
            this.btnDone.setEnabled(false);
        }
    }

    public void setSuccess() {
        this.hasBeenDownloadedOrIgnoredYet = false;
    }

    @Override
    public void dispose() {
        this.warnIfNeeded();
        super.dispose();
    }

    public void warnIfNeeded() {
        if (!this.hasBeenDownloadedOrIgnoredYet) {
            PointNumberWarnDialog d = new PointNumberWarnDialog(StaticSwingTools.getFirstParentFrame((Component)this), true);
            StaticSwingTools.showDialog((JDialog)d);
            if (d.isDownloadRequested()) {
                this.btnDownloadActionPerformed(null);
            }
            this.hasBeenDownloadedOrIgnoredYet = true;
        }
    }

    private List<String> executeGetAllReservationsAction() throws ConnectionException {
        ServerActionParameter action = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.GET_ALL_RESERVATIONS);
        ServerActionParameter prefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)this.getAnrPrefix());
        return (List)SessionManager.getProxy().executeTask(SEVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{action, prefix});
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private final class AllAntragsnummernLoadWorker
    extends SwingWorker<Collection<String>, Void> {
        private AllAntragsnummernLoadWorker() {
        }

        @Override
        protected Collection<String> doInBackground() throws Exception {
            return PointNumberDialog.this.executeGetAllReservationsAction();
        }

        @Override
        protected void done() {
            try {
                List result = (List)this.get();
                PointNumberDialog.this.antragsNummern.clear();
                if (result != null && !result.isEmpty()) {
                    for (String antragsNummer : result) {
                        PointNumberDialog.this.antragsNummern.add(antragsNummer.substring(antragsNummer.indexOf("_") + 1));
                    }
                    Collections.sort(PointNumberDialog.this.antragsNummern);
                }
                DefaultComboBoxModel cbAntragsNummerModel = (DefaultComboBoxModel)PointNumberDialog.this.cbAntragsNummer.getModel();
                cbAntragsNummerModel.removeAllElements();
                if (PointNumberDialog.this.antragsNummern.isEmpty()) {
                    cbAntragsNummerModel.addElement("keine Auftr\u00e4ge gefunden");
                } else {
                    String insertedText = ((JTextComponent)PointNumberDialog.this.cbAntragsNummer.getEditor().getEditorComponent()).getText();
                    cbAntragsNummerModel.removeAllElements();
                    cbAntragsNummerModel.addElement(null);
                    for (String antragsNummer : PointNumberDialog.this.antragsNummern) {
                        cbAntragsNummerModel.addElement(antragsNummer);
                    }
                    PointNumberDialog.this.cbAntragsNummer.setEditable(PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlReservieren));
                    if (PointNumberDialog.this.tbpModus.getSelectedIndex() == 0) {
                        ((JTextComponent)PointNumberDialog.this.cbAntragsNummer.getEditor().getEditorComponent()).setText(insertedText);
                    }
                    PointNumberDialog.this.cbAntragsNummer.repaint();
                    PointNumberDialog.this.repaint();
                }
                PointNumberDialog.this.jProgressBar1.setIndeterminate(false);
                PointNumberDialog.this.cbAntragsNummer.setEnabled(PointNumberDialog.this.tbpModus.getSelectedComponent().equals(PointNumberDialog.this.pnlReservieren) || !PointNumberDialog.this.antragsNummern.isEmpty());
                if (PointNumberDialog.this.cbAntragsNummer.getModel().getSize() > 0) {
                    PointNumberDialog.this.cbAntragsNummer.setSelectedIndex(0);
                } else {
                    PointNumberDialog.this.cbAntragsNummer.setSelectedIndex(-1);
                }
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Worker Thread that loads all existing Antragsnummern was interrupted", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error during executing Worker Thread that loads all existing Antragsnummern", (Throwable)ex);
            }
            catch (CancellationException ex) {
                LOG.info((Object)"Worker Thread that loads all existing Antragsnummern was interrupted", (Throwable)ex);
            }
        }
    }

    private final class VerlaengernWorker
    extends SwingWorker<Object[], Void> {
        private VerlaengernWorker() {
        }

        @Override
        protected Object[] doInBackground() throws Exception {
            if (PointNumberDialog.this.prolongModel.getSelectedValues() == 0) {
                return null;
            }
            ArrayList<PointNumberReservation> selectedValues = new ArrayList<PointNumberReservation>();
            for (CheckListItem item : PointNumberDialog.this.punktnummern) {
                if (!item.isSelected()) continue;
                PointNumberReservation pnr = new PointNumberReservation();
                pnr.setAblaufDatum(item.getAblaufdatum());
                pnr.setPunktnummer(item.getPnr());
                selectedValues.add(pnr);
            }
            String anr = PointNumberDialog.this.getAnr();
            if (!anr.matches("[a-zA-Z0-9_-]*")) {
                return null;
            }
            ArrayList<ServerActionParameter> allSaps = new ArrayList<ServerActionParameter>();
            String anrPrefix = PointNumberDialog.this.getAnrPrefix() == null ? "3290" : PointNumberDialog.this.getAnrPrefix();
            ServerActionParameter prefixSap = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)anrPrefix);
            ServerActionParameter aNummerSap = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)anr);
            ServerActionParameter actionSap = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_PROLONGATION);
            ServerActionParameter dateSap = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PROLONG_DATE.toString(), (Object)PointNumberDialog.this.jXDatePicker1.getDate());
            allSaps.add(prefixSap);
            allSaps.add(aNummerSap);
            allSaps.add(actionSap);
            allSaps.add(dateSap);
            for (PointNumberReservation pnr : selectedValues) {
                ServerActionParameter pnrSap = new ServerActionParameter(PointNumberReservationServerAction.Parameter.POINT_NUMBER.toString(), (Object)Long.parseLong(pnr.getPunktnummer()));
                LOG.info((Object)("adding pnr SAP: " + pnrSap.getValue()));
                allSaps.add(pnrSap);
            }
            PointNumberReservationRequest res = new PointNumberReservationRequest();
            res.setSuccessful(true);
            PointNumberReservationRequest result = (PointNumberReservationRequest)SessionManager.getProxy().executeTask(PointNumberDialog.SEVER_ACTION, "WUNDA_BLAU", null, PointNumberDialog.this.getConnectionContext(), allSaps.toArray(new ServerActionParameter[0]));
            if (result != null) {
                res.setRawResult(result.getRawResult());
            }
            if (result != null && !result.isSuccessfull()) {
                res.setSuccessful(false);
                res.setProtokoll(result.getProtokoll());
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                for (PointNumberReservation pnr : selectedValues) {
                    pnr.setAblaufDatum(formatter.format(PointNumberDialog.this.jXDatePicker1.getDate()));
                }
                res.setPointNumbers(selectedValues);
            }
            if (result != null && result.getPointNumbers() != null && !selectedValues.isEmpty() && res.getAntragsnummer() == null) {
                res.setAntragsnummer(result.getAntragsnummer());
            }
            return new Object[]{PointNumberDialog.this.jXDatePicker1.getDate(), res};
        }

        @Override
        protected void done() {
            try {
                Object[] ret = (Object[])this.get();
                Date datum = (Date)ret[0];
                PointNumberReservationRequest result = (PointNumberReservationRequest)ret[1];
                for (PointNumberReservation pnr : result.getPointNumbers()) {
                    LOG.fatal((Object)pnr);
                }
                PointNumberDialog.this.setResult(result);
                if (result == null || !result.isSuccessfull()) {
                    PointNumberDialog.this.protokollPane.addMessage("Fehler beim Senden des Auftrags", BusyLoggingTextPane.Styles.ERROR);
                    PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                    if (result != null && result.getErrorMessages() != null) {
                        for (String s : result.getErrorMessages()) {
                            PointNumberDialog.this.protokollPane.addMessage(s, BusyLoggingTextPane.Styles.ERROR);
                            PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                        }
                        PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                        PointNumberDialog.this.protokollPane.addMessage("Die Protokolldatei mit Fehlerinformationen steht zum Download bereit.", BusyLoggingTextPane.Styles.ERROR);
                    }
                    PointNumberDialog.this.enableDoneButton(true);
                    PointNumberDialog.this.btnVerlaengern.setEnabled(true);
                    PointNumberDialog.this.protokollPane.setBusy(false);
                    return;
                }
                PointNumberDialog.this.enableDoneButton(true);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                PointNumberDialog.this.btnVerlaengern.setEnabled(true);
                PointNumberDialog.this.protokollPane.setBusy(false);
                PointNumberDialog.this.protokollPane.addMessage("Verl\u00e4ngerung f\u00fcr Antragsnummer: " + result.getAntragsnummer() + " erfolgreich. Die Reservierung folgender Punktnummern wurde auf den " + formatter.format(datum) + " verl\u00e4ngert:", BusyLoggingTextPane.Styles.SUCCESS);
                PointNumberDialog.this.setSuccess();
                PointNumberDialog.this.hasBeenDownloadedOrIgnoredYet = false;
                PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                for (PointNumberReservation pnr : result.getPointNumbers()) {
                    PointNumberDialog.this.protokollPane.addMessage("" + pnr.getPunktnummer(), BusyLoggingTextPane.Styles.INFO);
                }
                PointNumberDialog.this.loadPointNumbers();
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Swing worker that prolongs points was interrupted", (Throwable)ex);
                PointNumberDialog.this.showError();
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error in execution of Swing Worker that prolongs points", (Throwable)ex);
                PointNumberDialog.this.showError();
            }
            catch (CancellationException ex) {
                LOG.info((Object)"Worker was interrupted", (Throwable)ex);
            }
        }
    }

    private final class FreigebenWorker
    extends SwingWorker<PointNumberReservationRequest, Void> {
        private FreigebenWorker() {
        }

        @Override
        protected PointNumberReservationRequest doInBackground() throws Exception {
            if (PointNumberDialog.this.releaseModel.getSelectedValues() == 0) {
                return null;
            }
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (CheckListItem item : PointNumberDialog.this.punktnummern) {
                if (!item.isSelected()) continue;
                selectedValues.add(item.getPnr());
            }
            HashMap pnrIntervals = new HashMap();
            ArrayList<Long> pnrs = new ArrayList<Long>();
            int index = 0;
            for (String pnr : selectedValues) {
                int currIndex = selectedValues.indexOf(pnr);
                if (currIndex != selectedValues.size() - 1) {
                    long currPnr = Long.parseLong(pnr);
                    long nextPnr = Long.parseLong((String)selectedValues.get(currIndex + 1));
                    pnrs.add(currPnr);
                    if (currPnr + 1L == nextPnr) continue;
                    pnrIntervals.put(index, pnrs);
                    ++index;
                    pnrs = new ArrayList();
                    continue;
                }
                pnrs.add(Long.parseLong(pnr));
                pnrIntervals.put(index, pnrs);
            }
            String anr = PointNumberDialog.this.getAnr();
            if (!anr.matches("[a-zA-Z0-9_-]*")) {
                return null;
            }
            String anrPrefix = PointNumberDialog.this.getAnrPrefix() == null ? "3290" : PointNumberDialog.this.getAnrPrefix();
            ServerActionParameter prefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)anrPrefix);
            ServerActionParameter aNummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)anr);
            ServerActionParameter action = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_STORNO);
            ArrayList releasedPoints = new ArrayList();
            PointNumberReservationRequest res = new PointNumberReservationRequest();
            res.setSuccessful(true);
            for (ArrayList interval : pnrIntervals.values()) {
                Long s = (Long)interval.get(0) % 1000000L;
                Long e = (Long)interval.get(interval.size() - 1) % 1000000L;
                Integer start = s.intValue();
                Integer end = e.intValue();
                String nummerierungsbezirk = "" + (Long)interval.get(0) / 1000000L;
                ServerActionParameter on1 = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ON1.toString(), (Object)start);
                ServerActionParameter on2 = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ON2.toString(), (Object)end);
                ServerActionParameter nbz = new ServerActionParameter(PointNumberReservationServerAction.Parameter.NBZ.toString(), (Object)nummerierungsbezirk);
                PointNumberReservationRequest result = (PointNumberReservationRequest)SessionManager.getProxy().executeTask(PointNumberDialog.SEVER_ACTION, "WUNDA_BLAU", null, PointNumberDialog.this.getConnectionContext(), new ServerActionParameter[]{action, prefix, aNummer, nbz, on1, on2});
                if (result != null) {
                    res.setRawResult(result.getRawResult());
                }
                if (result != null && !result.isSuccessfull()) {
                    res.setSuccessful(false);
                    res.setProtokoll(result.getProtokoll());
                }
                if (result == null || result.getPointNumbers() == null || result.getPointNumbers().isEmpty()) continue;
                if (res.getAntragsnummer() == null) {
                    res.setAntragsnummer(result.getAntragsnummer());
                }
                releasedPoints.addAll(result.getPointNumbers());
            }
            res.setPointNumbers(releasedPoints);
            return res;
        }

        @Override
        protected void done() {
            try {
                PointNumberReservationRequest result = (PointNumberReservationRequest)this.get();
                PointNumberDialog.this.setResult(result);
                if (result == null || !result.isSuccessfull()) {
                    PointNumberDialog.this.protokollPane.addMessage("Fehler beim Senden des Auftrags", BusyLoggingTextPane.Styles.ERROR);
                    PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                    if (result != null && result.getErrorMessages() != null) {
                        for (String s : result.getErrorMessages()) {
                            PointNumberDialog.this.protokollPane.addMessage(s, BusyLoggingTextPane.Styles.ERROR);
                            PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                        }
                        PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                        PointNumberDialog.this.protokollPane.addMessage("Die Protokolldatei mit Fehlerinformationen steht zum Download bereit.", BusyLoggingTextPane.Styles.ERROR);
                    }
                    PointNumberDialog.this.enableDoneButton(true);
                    PointNumberDialog.this.btnFreigeben.setEnabled(true);
                    PointNumberDialog.this.protokollPane.setBusy(false);
                    return;
                }
                PointNumberDialog.this.enableDoneButton(true);
                PointNumberDialog.this.btnFreigeben.setEnabled(true);
                PointNumberDialog.this.protokollPane.setBusy(false);
                PointNumberDialog.this.protokollPane.addMessage("Freigabe f\u00fcr Antragsnummer: " + result.getAntragsnummer() + " erfolgreich. Folgende Punktnummern wurden freigegeben:", BusyLoggingTextPane.Styles.SUCCESS);
                PointNumberDialog.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                for (PointNumberReservation pnr : result.getPointNumbers()) {
                    PointNumberDialog.this.protokollPane.addMessage("" + pnr.getPunktnummer(), BusyLoggingTextPane.Styles.INFO);
                }
                int selectedValues = 0;
                for (CheckListItem item : PointNumberDialog.this.punktnummern) {
                    if (!item.isSelected()) continue;
                    ++selectedValues;
                }
                if (selectedValues == PointNumberDialog.this.punktnummern.size()) {
                    PointNumberDialog.this.cbAntragsNummer.removeItemAt(PointNumberDialog.this.cbAntragsNummer.getSelectedIndex());
                    PointNumberDialog.this.cbAntragsNummer.setSelectedItem(null);
                }
                PointNumberDialog.this.loadPointNumbers();
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Swing worker that releases points was interrupted", (Throwable)ex);
                PointNumberDialog.this.showError();
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error in execution of Swing Worker that releases points", (Throwable)ex);
                PointNumberDialog.this.showError();
            }
            catch (CancellationException ex) {
                LOG.info((Object)"Worker was interrupted", (Throwable)ex);
            }
        }
    }

    private class VermessungsnummerLoadWorker
    extends SwingWorker<Collection, Void> {
        private final String user;

        public VermessungsnummerLoadWorker(String user) {
            this.user = user;
        }

        @Override
        protected Collection doInBackground() throws Exception {
            VermessungsStellenNummerSearch search = new VermessungsStellenNummerSearch(this.user);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, PointNumberDialog.this.getConnectionContext());
            if (res == null || res.isEmpty()) {
                // empty if block
            }
            return res;
        }
    }

    private final class PointNumberLoadWorker
    extends SwingWorker<Collection<PointNumberReservation>, Void> {
        private PointNumberLoadWorker() {
        }

        @Override
        protected Collection<PointNumberReservation> doInBackground() throws Exception {
            try {
                String anr = PointNumberDialog.this.getAnr();
                if (anr == null || anr.equals("") || !anr.matches("[a-zA-Z0-9_-]*")) {
                    PointNumberDialog.this.showFreigabeError();
                    PointNumberDialog.this.showVerlaengernError();
                    return null;
                }
                String anrPrefix = PointNumberDialog.this.getAnrPrefix() == null ? "3290" : PointNumberDialog.this.getAnrPrefix();
                ServerActionParameter prefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)anrPrefix);
                ServerActionParameter aNummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)anr);
                ServerActionParameter action = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.GET_POINT_NUMBERS);
                Collection pointNumbers = (Collection)SessionManager.getProxy().executeTask(PointNumberDialog.SEVER_ACTION, "WUNDA_BLAU", null, PointNumberDialog.this.getConnectionContext(), new ServerActionParameter[]{action, prefix, aNummer});
                PointNumberDialog.this.dontReloadPnrsForThisAnr = anrPrefix + anr;
                return pointNumbers;
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                Collection result = (Collection)this.get();
                if (result == null || result.isEmpty()) {
                    PointNumberDialog.this.showFreigabeError();
                    PointNumberDialog.this.showVerlaengernError();
                    return;
                }
                ArrayList<CheckListItem> listModel = new ArrayList<CheckListItem>();
                SimpleDateFormat formatterFrom = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat formatterTo = new SimpleDateFormat("dd.MM.yyyy");
                for (PointNumberReservation pnr : result) {
                    try {
                        listModel.add(new CheckListItem(pnr.getPunktnummer(), formatterTo.format(formatterFrom.parse(pnr.getAblaufDatum()))));
                    }
                    catch (ParseException ex) {
                        listModel.add(new CheckListItem(pnr.getPunktnummer(), pnr.getAblaufDatum()));
                    }
                }
                Collections.sort(listModel, new Comparator<CheckListItem>(){

                    @Override
                    public int compare(CheckListItem o1, CheckListItem o2) {
                        return o1.getPnr().compareTo(o2.getPnr());
                    }
                });
                PointNumberDialog.this.punktnummern.clear();
                PointNumberDialog.this.punktnummern.addAll(listModel);
                PointNumberDialog.this.tblPunktnummernFreigeben.repaint();
                PointNumberDialog.this.tblPunktnummernVerlaengern.repaint();
                PointNumberDialog.this.jScrollPane2.invalidate();
                PointNumberDialog.this.jScrollPane2.validate();
                PointNumberDialog.this.jScrollPane2.repaint();
                PointNumberDialog.this.jScrollPane4.invalidate();
                PointNumberDialog.this.jScrollPane4.validate();
                PointNumberDialog.this.jScrollPane4.repaint();
                PointNumberDialog.this.jxFreigebenWaitLabel.setBusy(false);
                PointNumberDialog.this.jxVerlaengernWaitLabel.setBusy(false);
                CardLayout cl = (CardLayout)PointNumberDialog.this.pnlFreigeben.getLayout();
                cl.show(PointNumberDialog.this.pnlFreigeben, "card2");
                CardLayout cl1 = (CardLayout)PointNumberDialog.this.pnlVerlaengern.getLayout();
                cl1.show(PointNumberDialog.this.pnlVerlaengern, "card2");
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Swing worker that retrieves pointnumbers for antragsnummer was interrupted", (Throwable)ex);
                PointNumberDialog.this.showFreigabeError();
                PointNumberDialog.this.showVerlaengernError();
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error in executing worker thread that retrieves pointnumbers for antragsnummer", (Throwable)ex);
                PointNumberDialog.this.showFreigabeError();
                PointNumberDialog.this.showVerlaengernError();
            }
            catch (CancellationException ex) {
                LOG.info((Object)"Worker was interrupted", (Throwable)ex);
            }
        }
    }

    private final class AnrPrefixItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public AnrPrefixItemRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && list != null) {
                VermessungsStellenSearchResult item = (VermessungsStellenSearchResult)value;
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                if (index != -1) {
                    this.setText(item.getZulassungsNummer() + " " + item.getName());
                } else {
                    this.setText(item.getZulassungsNummer());
                }
            }
            return this;
        }
    }
}

