/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.nas.PointNumberDialog;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PointNumberReservationToolbarComponentProvider
implements ToolbarComponentsProvider,
ConnectionContextStore,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(PointNumberReservationToolbarComponentProvider.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public String getPluginName() {
        return "Punktnummernreservierung";
    }

    public Collection<ToolbarComponentDescription> getToolbarComponents() {
        if (this.validateUserHasAccess()) {
            JButton b = new JButton("Punktnummern");
            LinkedList<ToolbarComponentDescription> preparationList = new LinkedList<ToolbarComponentDescription>();
            ToolbarComponentDescription description = new ToolbarComponentDescription("tlbMain", (JComponent)new PunktNummernButton(this.getConnectionContext()), ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdPrint");
            preparationList.add(description);
            return Collections.unmodifiableList(preparationList);
        }
        return Collections.emptyList();
    }

    private boolean validateUserHasAccess() {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://pointNumberReservation", this.getConnectionContext());
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not validate action tag for PunktnummernReservierung!", (Throwable)ex);
            return false;
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "PointNumberReservationToolbar";
        }
        return null;
    }

    public Component getComponent() {
        if (this.validateUserHasAccess()) {
            return new PunktNummernButton(this.connectionContext);
        }
        return null;
    }

    private final class PunktNummernButton
    extends JButton {
        Icon icon;

        public PunktNummernButton(final ConnectionContext connectionContext) {
            super(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PointNumberDialog dialog = new PointNumberDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), true, connectionContext);
                            StaticSwingTools.showDialog((JDialog)dialog);
                        }
                    });
                }
            });
            this.icon = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/punktnummernreservierung.png"));
            super.setToolTipText(NbBundle.getMessage(PointNumberReservationToolbarComponentProvider.class, (String)"PointNumberReservationToolbarComponent.tooltip"));
            this.setIcon(this.icon);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }
    }
}

