/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.navigatorstartuphooks;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.servermessage.CidsServerMessageNotifier;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.configuration.StartupHook;
import org.apache.log4j.Logger;

public class TotdStartUpHook
implements StartupHook,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(TotdStartUpHook.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void applicationStarted() {
        if (ComponentRegistry.getRegistry().getNavigator() != null) {
            try {
                if (SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csm://totd", this.getConnectionContext())) {
                    CidsServerMessageNotifier.getInstance().subscribe(new CidsServerMessageNotifierListener(){

                        public void messageRetrieved(CidsServerMessageNotifierListenerEvent event) {
                            try {
                                String totd = (String)event.getMessage().getContent();
                                ComponentRegistry.getRegistry().getNavigator().setTotd(totd);
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)ex, (Throwable)ex);
                            }
                        }
                    }, "totd");
                }
            }
            catch (ConnectionException ex) {
                LOG.warn((Object)"Konnte Rechte an csm://totd nicht abfragen. Keine Titleleiste des Tages !", (Throwable)ex);
            }
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

