/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.measuring.MeasuringComponent;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.WebAccessMultiPagePictureReader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PictureLoaderPanel
extends JPanel
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(PictureLoaderPanel.class);
    private static final int NO_SELECTION = -1;
    private static final ListModel MODEL_LOAD = new DefaultListModel(){
        {
            this.add(0, "Wird geladen...");
        }
    };
    private static final ListModel FEHLER_MODEL = new DefaultListModel(){
        {
            this.add(0, "Lesefehler.");
        }
    };
    private final XBoundingBox initialBoundingbox;
    private final Crs crs;
    private PictureSelectWorker currentPictureSelectWorker = null;
    private PictureReaderWorker pictureReaderWorker = null;
    private WebAccessMultiPagePictureReader pictureReader;
    private int currentPage = -1;
    private final ConnectionContext connectionContext;
    private Listener listener;
    private JButton btnHome;
    private JList lstPages;
    private MeasuringComponent measuringComponent;
    private JScrollPane scpPages;
    private JToggleButton togPan;
    private JToggleButton togZoom;

    public PictureLoaderPanel() {
        this(null, ConnectionContext.createDummy());
    }

    public PictureLoaderPanel(Listener listener, ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.listener = listener;
        XBoundingBox initialBoundingbox = null;
        Crs crs = null;
        try {
            initialBoundingbox = new XBoundingBox(2583621.251964098, 5682507.032498134, 2584022.9413952776, 5682742.852810634, ClientAlkisConf.getInstance().getSrsService(), true);
            crs = new Crs(ClientAlkisConf.getInstance().getSrsService(), ClientAlkisConf.getInstance().getSrsService(), ClientAlkisConf.getInstance().getSrsService(), true, true);
            this.initComponents();
        }
        catch (Throwable ex) {
            LOG.error((Object)"could not initialize PictureLoaderPanel");
        }
        this.initialBoundingbox = initialBoundingbox;
        this.crs = crs;
    }

    public JToggleButton getTogPan() {
        return this.togPan;
    }

    public JToggleButton getTogZoom() {
        return this.togZoom;
    }

    public JButton getBtnHome() {
        return this.btnHome;
    }

    public MeasuringComponent getMeasuringComponent() {
        return this.measuringComponent;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void dispose() {
        this.measuringComponent.dispose();
    }

    private void initComponents() {
        this.scpPages = new JScrollPane();
        this.lstPages = new JList();
        this.togPan = new JToggleButton();
        this.togZoom = new JToggleButton();
        this.btnHome = new JButton();
        this.measuringComponent = new MeasuringComponent(this.initialBoundingbox, this.crs);
        this.scpPages.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scpPages.setMinimumSize(new Dimension(31, 75));
        this.scpPages.setOpaque(false);
        this.scpPages.setPreferredSize(new Dimension(85, 75));
        this.lstPages.setSelectionMode(0);
        this.lstPages.setFixedCellWidth(75);
        this.lstPages.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PictureLoaderPanel.this.lstPagesValueChanged(evt);
            }
        });
        this.scpPages.setViewportView(this.lstPages);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.togPan, (String)NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.togPan.text_1"));
        this.togPan.setToolTipText(NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.togPan.toolTipText_1"));
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureLoaderPanel.this.togPanActionPerformed(evt);
            }
        });
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.togZoom, (String)NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.togZoom.text_1"));
        this.togZoom.setToolTipText(NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.togZoom.toolTipText_1"));
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureLoaderPanel.this.togZoomActionPerformed(evt);
            }
        });
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnHome, (String)NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.btnHome.text_1"));
        this.btnHome.setToolTipText(NbBundle.getMessage(PictureLoaderPanel.class, (String)"PictureLoaderPanel.btnHome.toolTipText_1"));
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PictureLoaderPanel.this.btnHomeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void lstPagesValueChanged(ListSelectionEvent evt) {
        Object page;
        if (!evt.getValueIsAdjusting() && (page = this.lstPages.getSelectedValue()) instanceof Integer) {
            this.loadPage((Integer)page - 1);
        }
    }

    private void loadPage(int page) {
        PictureSelectWorker oldWorkerTest = this.currentPictureSelectWorker;
        if (oldWorkerTest != null) {
            oldWorkerTest.cancel(true);
        }
        this.currentPictureSelectWorker = new PictureSelectWorker(page);
        this.currentPictureSelectWorker.execute();
    }

    private void togPanActionPerformed(ActionEvent evt) {
        this.measuringComponent.actionPan();
    }

    private void togZoomActionPerformed(ActionEvent evt) {
        this.measuringComponent.actionZoom();
    }

    private void btnHomeActionPerformed(ActionEvent evt) {
        this.measuringComponent.actionOverview();
    }

    public void reloadPictureFromUrl(URL url) {
        this.cancelPictureWorkers();
        this.listener.showMeasureIsLoading();
        this.pictureReaderWorker = new PictureReaderWorker(url);
        this.pictureReaderWorker.execute();
    }

    private void closeReader() {
        if (this.pictureReader != null) {
            this.pictureReader.close();
            this.pictureReader = null;
        }
    }

    public JList getLstPages() {
        return this.lstPages;
    }

    public void cancelPictureWorkers() {
        this.lstPages.setModel(new DefaultListModel());
        if (this.pictureReaderWorker != null) {
            this.pictureReaderWorker.cancel(true);
        }
        if (this.currentPictureSelectWorker != null) {
            this.currentPictureSelectWorker.cancel(true);
        }
    }

    public void setUrl(URL url) {
        this.cancelPictureWorkers();
        this.listener.showMeasureIsLoading();
        this.lstPages.setEnabled(true);
        this.measuringComponent.removeAllFeatures();
        this.lstPages.setModel(new DefaultListModel());
        if (url == null) {
            this.listener.showMeasurePanel();
        } else {
            this.pictureReaderWorker = new PictureReaderWorker(url);
            this.pictureReaderWorker.execute();
        }
    }

    public void setCurrentPageNull() {
        this.currentPage = -1;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setLoading() {
        this.lstPages.setModel(MODEL_LOAD);
        this.listener.showMeasureIsLoading();
    }

    public static void main(String[] args) {
        new PictureLoaderPanel();
    }

    private final class PictureReaderWorker
    extends SwingWorker<ListModel, Void> {
        private final URL url;

        public PictureReaderWorker(URL url) {
            this.url = url;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preparing picture reader for file " + this.url.toExternalForm()));
            }
            PictureLoaderPanel.this.lstPages.setModel(MODEL_LOAD);
            PictureLoaderPanel.this.measuringComponent.removeAllFeatures();
            PictureLoaderPanel.this.listener.showMeasureIsLoading();
        }

        @Override
        protected ListModel doInBackground() throws Exception {
            DefaultListModel<Integer> model = new DefaultListModel<Integer>();
            PictureLoaderPanel.this.closeReader();
            try {
                PictureLoaderPanel.this.pictureReader = new WebAccessMultiPagePictureReader(this.url, false, true);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not create a MultiPagePictureReader for URL '" + this.url.toExternalForm() + "'."), (Throwable)e);
                return model;
            }
            int numberOfPages = PictureLoaderPanel.this.pictureReader.getNumberOfPages();
            for (int i = 0; i < numberOfPages; ++i) {
                model.addElement(i + 1);
            }
            return model;
        }

        @Override
        protected void done() {
            try {
                ListModel model = (ListModel)this.get();
                PictureLoaderPanel.this.lstPages.setModel(model);
                if (!this.isCancelled()) {
                    if (model.getSize() > 0) {
                        PictureLoaderPanel.this.lstPages.setSelectedIndex(0);
                    } else {
                        PictureLoaderPanel.this.lstPages.setModel(new DefaultListModel());
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Could not read found pictures.", (Throwable)ex);
                PictureLoaderPanel.this.lstPages.setModel(new DefaultListModel());
            }
        }
    }

    private final class PictureSelectWorker
    extends SwingWorker<BufferedImage, Void> {
        private final int pageNumber;

        public PictureSelectWorker(int pageNumber) {
            this.pageNumber = pageNumber;
            PictureLoaderPanel.this.setCurrentPageNull();
            PictureLoaderPanel.this.measuringComponent.reset();
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            if (PictureLoaderPanel.this.pictureReader != null) {
                return PictureLoaderPanel.this.pictureReader.loadPage(this.pageNumber);
            }
            throw new IllegalStateException("PictureReader is null!");
        }

        @Override
        protected void done() {
            try {
                if (!this.isCancelled()) {
                    PictureLoaderPanel.this.currentPage = this.pageNumber;
                    PictureLoaderPanel.this.measuringComponent.addImage((BufferedImage)this.get());
                    PictureLoaderPanel.this.togPan.setSelected(true);
                    PictureLoaderPanel.this.measuringComponent.zoomToFeatureCollection();
                }
            }
            catch (InterruptedException ex) {
                PictureLoaderPanel.this.setCurrentPageNull();
                PictureLoaderPanel.this.measuringComponent.reset();
                PictureLoaderPanel.this.lstPages.setModel(new DefaultListModel());
                LOG.warn((Object)"Was interrupted while setting new image.", (Throwable)ex);
            }
            catch (Exception ex) {
                PictureLoaderPanel.this.setCurrentPageNull();
                PictureLoaderPanel.this.measuringComponent.reset();
                PictureLoaderPanel.this.lstPages.setModel(FEHLER_MODEL);
                LOG.error((Object)"Could not set new image.", (Throwable)ex);
            }
            finally {
                if (this.isCancelled()) {
                    PictureLoaderPanel.this.measuringComponent.reset();
                }
                PictureLoaderPanel.this.listener.showMeasurePanel();
                PictureLoaderPanel.this.currentPictureSelectWorker = null;
            }
        }
    }

    public static interface Listener {
        public void showMeasureIsLoading();

        public void showMeasurePanel();
    }
}

