/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.clientutils.TifferDownload;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildserieProvider;
import de.cismet.cids.custom.objecteditors.wunda_blau.MauerEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.Sb_stadtbildserieEditor;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Sb_StadtbildPreviewImage
extends JPanel
implements ConnectionContextProvider {
    private static final ImageIcon FOLDER_ICON = new ImageIcon(Sb_stadtbildserieEditor.class.getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/inode-directory.png"));
    private static final Logger LOG = Logger.getLogger(Sb_StadtbildPreviewImage.class);
    private Sb_StadtbildserieProvider stadtbildserieProvider;
    private ImageResizeWorker currentResizeWorker;
    private boolean resizeListenerEnabled;
    private final Timer timer;
    private BufferedImage image;
    private CidsBean fotoCidsBean;
    private final ConnectionContext connectionContext;
    private final PropertyChangeListener listRepaintListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Sb_StadtbildPreviewImage.this.stadtbildserieProvider.previewImageChanged();
        }
    };
    private JButton btnDownloadHighResImage;
    private JButton btnNextImg;
    private JButton btnPrevImg;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel jPanel4;
    private JXBusyLabel lblBusy;
    private JLabel lblPicture;
    private JLabel lblVorschau;
    private JPanel pnlCtrlBtn;
    private JPanel pnlFoto;
    private RoundedPanel pnlVorschau;
    private SemiRoundedPanel semiRoundedPanel2;
    private JToggleButton tbtnIsPreviewImage;

    public Sb_StadtbildPreviewImage() {
        this(ConnectionContext.createDummy());
    }

    public Sb_StadtbildPreviewImage(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Sb_StadtbildPreviewImage.this.resizeListenerEnabled) {
                    if (Sb_StadtbildPreviewImage.this.currentResizeWorker != null) {
                        Sb_StadtbildPreviewImage.this.currentResizeWorker.cancel(true);
                    }
                    Sb_StadtbildPreviewImage.this.currentResizeWorker = new ImageResizeWorker();
                    Sb_StadtbildPreviewImage.this.currentResizeWorker.execute();
                }
            }
        });
        this.timer.setRepeats(false);
    }

    private void initComponents() {
        this.pnlVorschau = new RoundedPanel();
        this.semiRoundedPanel2 = new SemiRoundedPanel();
        this.lblVorschau = new JLabel();
        this.pnlFoto = new JPanel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        this.jPanel4 = new JPanel();
        this.lblPicture = new JLabel();
        this.pnlCtrlBtn = new JPanel();
        this.btnDownloadHighResImage = new EnableOnlyIfNotInternalUsageAndNotRendererJButton();
        this.btnPrevImg = new JButton();
        this.btnNextImg = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.tbtnIsPreviewImage = new JToggleButton();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.pnlVorschau.setPreferredSize(new Dimension(140, 300));
        this.pnlVorschau.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel2.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel2.setLayout((LayoutManager)new FlowLayout());
        this.lblVorschau.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblVorschau, (String)NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.lblVorschau.text"));
        this.semiRoundedPanel2.add((Component)this.lblVorschau);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.pnlVorschau.add((Component)this.semiRoundedPanel2, (Object)gridBagConstraints);
        this.pnlFoto.setOpaque(false);
        this.pnlFoto.setLayout(new CardLayout());
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 60));
        this.lblBusy.setPreferredSize(new Dimension(140, 60));
        this.pnlFoto.add((Component)this.lblBusy, "busy");
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblPicture, (String)NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.lblPicture.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPicture, gridBagConstraints);
        this.pnlFoto.add((Component)this.jPanel4, "image");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlVorschau.add((Component)this.pnlFoto, (Object)gridBagConstraints);
        this.pnlCtrlBtn.setMinimumSize(new Dimension(100, 50));
        this.pnlCtrlBtn.setOpaque(false);
        this.pnlCtrlBtn.setPreferredSize(new Dimension(100, 50));
        this.pnlCtrlBtn.setLayout(new GridBagLayout());
        this.btnDownloadHighResImage.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/einzelDownload.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDownloadHighResImage, (String)NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.btnDownloadHighResImage.text"));
        this.btnDownloadHighResImage.setToolTipText(NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.btnDownloadHighResImage.toolTipText"));
        this.btnDownloadHighResImage.setBorder(null);
        this.btnDownloadHighResImage.setBorderPainted(false);
        this.btnDownloadHighResImage.setContentAreaFilled(false);
        this.btnDownloadHighResImage.setEnabled(false);
        this.btnDownloadHighResImage.setFocusPainted(false);
        this.btnDownloadHighResImage.setMaximumSize(new Dimension(30, 30));
        this.btnDownloadHighResImage.setMinimumSize(new Dimension(30, 30));
        this.btnDownloadHighResImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_StadtbildPreviewImage.this.btnDownloadHighResImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlCtrlBtn.add((Component)this.btnDownloadHighResImage, gridBagConstraints);
        this.btnPrevImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrevImg, (String)NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.btnPrevImg.text"));
        this.btnPrevImg.setBorder(null);
        this.btnPrevImg.setBorderPainted(false);
        this.btnPrevImg.setContentAreaFilled(false);
        this.btnPrevImg.setFocusPainted(false);
        this.btnPrevImg.setMaximumSize(new Dimension(30, 30));
        this.btnPrevImg.setMinimumSize(new Dimension(30, 30));
        this.btnPrevImg.setPreferredSize(new Dimension(30, 30));
        this.btnPrevImg.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-pressed.png")));
        this.btnPrevImg.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-selected.png")));
        this.btnPrevImg.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-selected.png")));
        this.btnPrevImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_StadtbildPreviewImage.this.btnPrevImgActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlCtrlBtn.add((Component)this.btnPrevImg, gridBagConstraints);
        this.btnNextImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNextImg, (String)NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.btnNextImg.text"));
        this.btnNextImg.setBorder(null);
        this.btnNextImg.setBorderPainted(false);
        this.btnNextImg.setContentAreaFilled(false);
        this.btnNextImg.setFocusPainted(false);
        this.btnNextImg.setMaximumSize(new Dimension(30, 30));
        this.btnNextImg.setMinimumSize(new Dimension(30, 30));
        this.btnNextImg.setPreferredSize(new Dimension(30, 30));
        this.btnNextImg.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right-pressed.png")));
        this.btnNextImg.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right-selected.png")));
        this.btnNextImg.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right-selected.png")));
        this.btnNextImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_StadtbildPreviewImage.this.btnNextImgActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlCtrlBtn.add((Component)this.btnNextImg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlCtrlBtn.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlCtrlBtn.add((Component)this.filler2, gridBagConstraints);
        this.tbtnIsPreviewImage.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32bw.png")));
        this.tbtnIsPreviewImage.setToolTipText(NbBundle.getMessage(Sb_StadtbildPreviewImage.class, (String)"Sb_StadtbildPreviewImage.tbtnIsPreviewImage.toolTipText"));
        this.tbtnIsPreviewImage.setBorderPainted(false);
        this.tbtnIsPreviewImage.setContentAreaFilled(false);
        this.tbtnIsPreviewImage.setDisabledIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32bw.png")));
        this.tbtnIsPreviewImage.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32.png")));
        this.tbtnIsPreviewImage.setEnabled(false);
        this.tbtnIsPreviewImage.setMaximumSize(new Dimension(30, 30));
        this.tbtnIsPreviewImage.setMinimumSize(new Dimension(30, 30));
        this.tbtnIsPreviewImage.setPreferredSize(new Dimension(32, 32));
        this.tbtnIsPreviewImage.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32.png")));
        this.tbtnIsPreviewImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_StadtbildPreviewImage.this.tbtnIsPreviewImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlCtrlBtn.add((Component)this.tbtnIsPreviewImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlVorschau.add((Component)this.pnlCtrlBtn, (Object)gridBagConstraints);
        this.add((Component)this.pnlVorschau, "Center");
    }

    private void btnDownloadHighResImageActionPerformed(ActionEvent evt) {
        try {
            if (BillingPopup.doBilling("stb", "not.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1)) && DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                CidsBean stadtbildSerie = this.stadtbildserieProvider.getStadtbildserie();
                CidsBean stadtbild = this.stadtbildserieProvider.getSelectedStadtbild();
                String imageNumber = (String)stadtbild.getProperty("bildnummer");
                DownloadManager.instance().add((Download)new TifferDownload(jobname, "Stadtbild " + imageNumber, "stadtbild_" + imageNumber, new StadtbilderUtils.StadtbildInfo(stadtbildSerie, stadtbild), "1", this.getConnectionContext()));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error when trying to download an high res image", (Throwable)ex);
        }
    }

    private void btnPrevImgActionPerformed(ActionEvent evt) {
        this.stadtbildserieProvider.previousImageSelected();
    }

    private void btnNextImgActionPerformed(ActionEvent evt) {
        this.stadtbildserieProvider.nextImageSelected();
    }

    private void tbtnIsPreviewImageActionPerformed(ActionEvent evt) {
        if (this.tbtnIsPreviewImage.isSelected()) {
            this.stadtbildserieProvider.newPreviewImageSelected();
            this.tbtnIsPreviewImage.setEnabled(false);
        }
    }

    public void setStadtbildInfo(StadtbilderUtils.StadtbildInfo stadtbildInfo) {
        if (stadtbildInfo.getBildnummer() != null) {
            new CheckAccessibilityOfHighResImage(stadtbildInfo).execute();
            this.loadPhoto();
            String oldPreviewImage = (String)this.stadtbildserieProvider.getStadtbildserie().getProperty("vorschaubild.bildnummer");
            boolean isPreviewImage = oldPreviewImage != null && oldPreviewImage.equals(stadtbildInfo.getBildnummer());
            this.tbtnIsPreviewImage.setSelected(isPreviewImage);
            this.tbtnIsPreviewImage.setEnabled(this.stadtbildserieProvider.isEditable() && !isPreviewImage);
        } else {
            this.tbtnIsPreviewImage.setSelected(false);
            this.tbtnIsPreviewImage.setEnabled(false);
        }
    }

    public void setStadtbildserieProvider(Sb_StadtbildserieProvider stadtbildserieProvider) {
        this.stadtbildserieProvider = stadtbildserieProvider;
    }

    private void loadPhoto() {
        if (this.stadtbildserieProvider.getRestrictionLevel().isPreviewAllowed()) {
            CidsBean stadtbild = this.stadtbildserieProvider.getSelectedStadtbild();
            if (this.fotoCidsBean != null) {
                this.fotoCidsBean.removePropertyChangeListener(this.listRepaintListener);
            }
            if (stadtbild instanceof CidsBean) {
                this.fotoCidsBean = stadtbild;
                this.fotoCidsBean.addPropertyChangeListener(this.listRepaintListener);
                StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(this.stadtbildserieProvider.getStadtbildserie(), this.fotoCidsBean);
                new LoadSelectedImageWorker(stadtbildInfo).execute();
            } else {
                this.image = null;
                this.lblPicture.setIcon(FOLDER_ICON);
            }
        } else {
            this.indicateInternalUsage();
        }
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                ((CardLayout)this.pnlFoto.getLayout()).show(this.pnlFoto, "busy");
                this.lblBusy.setBusy(true);
                this.btnPrevImg.setEnabled(false);
                this.btnNextImg.setEnabled(false);
            }
        } else {
            ((CardLayout)this.pnlFoto.getLayout()).show(this.pnlFoto, "image");
            this.lblBusy.setBusy(false);
            this.defineButtonStatus();
        }
    }

    public void defineButtonStatus() {
        if (this.stadtbildserieProvider != null) {
            this.btnPrevImg.setEnabled(!this.stadtbildserieProvider.isFirstSelected());
            this.btnNextImg.setEnabled(!this.stadtbildserieProvider.isLastSelected());
        } else {
            this.btnPrevImg.setEnabled(false);
            this.btnNextImg.setEnabled(false);
        }
    }

    private void indicateError(String tooltip) {
        this.lblPicture.setIcon(new ImageIcon(StadtbilderUtils.ERROR_IMAGE));
        this.lblPicture.setText("<html>Fehler beim \u00dcbertragen des Bildes!</html>");
        this.lblPicture.setToolTipText(tooltip);
        this.showWait(false);
    }

    public void indicateNotAvailable(String tooltip) {
        this.indicateNotAvailable(tooltip, new ImageIcon(StadtbilderUtils.ERROR_IMAGE), "<html>Kein Vorschaubild vorhanden.</html>");
    }

    public void indicateNotAvailable(String tooltip, Icon icon, String text) {
        this.lblPicture.setIcon(icon);
        this.lblPicture.setText(text);
        this.lblPicture.setToolTipText(tooltip);
        this.showWait(false);
    }

    private void indicateInternalUsage() {
        this.lblPicture.setIcon(new ImageIcon(StadtbilderUtils.ERROR_IMAGE));
        this.lblPicture.setText("<html>Bild ist nicht zur Publikation freigegeben!</html>");
        this.lblPicture.setToolTipText("");
        this.showWait(false);
    }

    public void removeImage() {
        this.image = null;
    }

    public Icon getIcon() {
        return this.lblPicture.getIcon();
    }

    public void makeEditable() {
        if (!this.stadtbildserieProvider.isEditable()) {
            RendererTools.makeReadOnly(this.tbtnIsPreviewImage);
        } else {
            ObjectRendererUtils.decorateComponentWithMouseOverCursorChange(this.tbtnIsPreviewImage, 12, 0);
        }
    }

    public void setBtnDownloadHighResImageVisible(boolean visible) {
        this.btnDownloadHighResImage.setVisible(visible);
    }

    public void setTbtnIsPreviewImageVisible(boolean visible) {
        this.tbtnIsPreviewImage.setVisible(visible);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    final class CheckAccessibilityOfHighResImage
    extends SwingWorker<Boolean, Void> {
        private final StadtbilderUtils.StadtbildInfo stadtbildInfo;

        public CheckAccessibilityOfHighResImage(StadtbilderUtils.StadtbildInfo stadtbildInfo) {
            this.stadtbildInfo = stadtbildInfo;
            Sb_StadtbildPreviewImage.this.btnDownloadHighResImage.setEnabled(false);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            if (Sb_StadtbildPreviewImage.this.stadtbildserieProvider.getRestrictionLevel().isDownloadAllowed()) {
                return StadtbilderUtils.getFormatOfHighResPicture(this.stadtbildInfo) != null;
            }
            return false;
        }

        @Override
        protected void done() {
            try {
                boolean accessible = (Boolean)this.get();
                Sb_StadtbildPreviewImage.this.btnDownloadHighResImage.setEnabled(accessible);
                if (accessible) {
                    ObjectRendererUtils.decorateComponentWithMouseOverCursorChange(Sb_StadtbildPreviewImage.this.btnDownloadHighResImage, 12, 0);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
    }

    final class LoadSelectedImageWorker
    extends SwingWorker<BufferedImage, Void> {
        private final StadtbilderUtils.StadtbildInfo stadtbildInfo;

        public LoadSelectedImageWorker(StadtbilderUtils.StadtbildInfo stadtbildInfo) {
            this.stadtbildInfo = stadtbildInfo;
            Sb_StadtbildPreviewImage.this.lblPicture.setText("");
            Sb_StadtbildPreviewImage.this.lblPicture.setToolTipText(null);
            Sb_StadtbildPreviewImage.this.showWait(!StadtbilderUtils.isBildnummerInCacheOrFailed(stadtbildInfo));
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            if (this.stadtbildInfo != null) {
                return StadtbilderUtils.downloadImageForBildnummer(this.stadtbildInfo);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                Sb_StadtbildPreviewImage.this.image = (BufferedImage)this.get();
                if (Sb_StadtbildPreviewImage.this.image != null) {
                    Sb_StadtbildPreviewImage.this.resizeListenerEnabled = true;
                    Sb_StadtbildPreviewImage.this.timer.setInitialDelay(0);
                    Sb_StadtbildPreviewImage.this.timer.restart();
                } else {
                    Sb_StadtbildPreviewImage.this.indicateNotAvailable("");
                }
            }
            catch (InterruptedException ex) {
                Sb_StadtbildPreviewImage.this.image = null;
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                Sb_StadtbildPreviewImage.this.image = null;
                LOG.error((Object)ex, (Throwable)ex);
                if (ex.getCause() instanceof UniformInterfaceException) {
                    Sb_StadtbildPreviewImage.this.indicateNotAvailable("");
                } else {
                    Sb_StadtbildPreviewImage.this.indicateError(ex.getMessage());
                }
            }
            finally {
                Sb_StadtbildPreviewImage.this.showWait(false);
            }
        }
    }

    final class ImageResizeWorker
    extends SwingWorker<ImageIcon, Void> {
        ImageResizeWorker() {
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            if (Sb_StadtbildPreviewImage.this.image != null) {
                ImageIcon result = new ImageIcon(MauerEditor.adjustScale(Sb_StadtbildPreviewImage.this.image, Sb_StadtbildPreviewImage.this.pnlFoto, 20, 20));
                return result;
            }
            return null;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    Sb_StadtbildPreviewImage.this.resizeListenerEnabled = false;
                    ImageIcon result = (ImageIcon)this.get();
                    Sb_StadtbildPreviewImage.this.lblPicture.setIcon(result);
                    Sb_StadtbildPreviewImage.this.lblPicture.setText("");
                    Sb_StadtbildPreviewImage.this.lblPicture.setToolTipText(null);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    Sb_StadtbildPreviewImage.this.lblPicture.setIcon(null);
                    Sb_StadtbildPreviewImage.this.lblPicture.setText("<html>Fehler beim Skalieren!</html>");
                }
                finally {
                    if (Sb_StadtbildPreviewImage.this.currentResizeWorker == this) {
                        Sb_StadtbildPreviewImage.this.currentResizeWorker = null;
                    }
                    Sb_StadtbildPreviewImage.this.resizeListenerEnabled = true;
                }
            }
        }
    }

    private class EnableOnlyIfNotInternalUsageAndNotRendererJButton
    extends JButton {
        private EnableOnlyIfNotInternalUsageAndNotRendererJButton() {
        }

        @Override
        public void setEnabled(boolean enable) {
            boolean isDownloadAllowed = false;
            if (Sb_StadtbildPreviewImage.this.stadtbildserieProvider != null) {
                isDownloadAllowed = Sb_StadtbildPreviewImage.this.stadtbildserieProvider.getRestrictionLevel().isDownloadAllowed();
            }
            super.setEnabled(enable && isDownloadAllowed);
        }
    }
}

