/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class StrAdrConfProperties {
    private static final transient Logger LOG = Logger.getLogger(StrAdrConfProperties.class);
    private final Double bufferMeter;
    private final String stringBenenn;
    private final String stringEntnenn;
    private final String stringBenennGross;
    private final String stringForbiddenKeys;

    private StrAdrConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.stringBenenn = this.readProperty(properties, "LISTE_BENENN", null);
        this.stringEntnenn = this.readProperty(properties, "LISTE_ENTNENN", null);
        this.stringBenennGross = this.readProperty(properties, "LISTE_BENENN_GROSS", null);
        this.stringForbiddenKeys = this.readProperty(properties, "LISTE_FORBIDDEN_KEYS", null);
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.STRADR_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static StrAdrConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getStringBenenn() {
        return this.stringBenenn;
    }

    public String getStringEntnenn() {
        return this.stringEntnenn;
    }

    public String getStringBenennGross() {
        return this.stringBenennGross;
    }

    public String getStringForbiddenKeys() {
        return this.stringForbiddenKeys;
    }

    private static final class LazyInitialiser {
        private static final StrAdrConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            StrAdrConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.STRADR_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)StrAdrConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new StrAdrConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

