/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TwConfProperties {
    private static final transient Logger LOG = Logger.getLogger(TwConfProperties.class);
    private final Double bufferMeter;
    private final String url;
    private final String fotos;

    private TwConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.url = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING", null));
        this.fotos = String.valueOf(this.readProperty(properties, "FOTOS_PATH", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.TW_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static TwConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFotos() {
        return this.fotos;
    }

    private static final class LazyInitialiser {
        private static final TwConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            TwConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.TW_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)TwConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new TwConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Laden der Properties f\u00fcr TW-Client", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

