/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.objecteditors.wunda_blau.VkParentPanel;
import de.cismet.cids.custom.wunda_blau.search.server.VkDocumentLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VkDocumentLoader {
    private static final Logger LOG = Logger.getLogger(VkDocumentLoader.class);
    private static final String CHILD_TOSTRING_TEMPLATE = "%s";
    private static final String TABLE_VORHABEN = "vk_vorhaben";
    private static final String TABLE_BESCHLUSS = "vk_vorhaben_beschluesse";
    private static final String TABLE_LINKS = "vk_vorhaben_links";
    private static final String TABLE_DOKUMENTE = "vk_vorhaben_dokumente";
    private static final String TABLE_FOTOS = "vk_vorhaben_fotos";
    private static final String[] CHILD_TOSTRING_FIELDS = new String[]{"id"};
    private static final String FK_VORHABEN = "fk_vorhaben";
    public Boolean loadingCompletedWithoutError = false;
    public Map<Integer, List<CidsBean>> mapBeschluesse = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapLinks = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapDokumente = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapFotos = new HashMap<Integer, List<CidsBean>>();
    public Collection<Listener> listeners = new ArrayList<Listener>();
    private final VkDocumentLightweightSearch searchDocument = new VkDocumentLightweightSearch("%s", CHILD_TOSTRING_FIELDS, "vk_vorhaben", "fk_vorhaben");
    private final VkParentPanel parentOrganizer;

    public VkDocumentLoader(VkParentPanel vkOrganizer) {
        this.parentOrganizer = vkOrganizer;
    }

    public boolean loadChildrenBeschluesse(Integer idVorhaben, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchDocument.setParentId(idVorhaben);
            this.searchDocument.setFkField(FK_VORHABEN);
            this.searchDocument.setTable(TABLE_BESCHLUSS);
            this.searchDocument.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchDocument, connectionContext);
            ArrayList<CidsBean> beansBeschluesse = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansBeschluesse.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
            }
            if (!this.mapBeschluesse.containsKey(idVorhaben)) {
                this.mapBeschluesse.put(idVorhaben, beansBeschluesse);
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenLinks(Integer idVorhaben, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchDocument.setParentId(idVorhaben);
            this.searchDocument.setFkField(FK_VORHABEN);
            this.searchDocument.setTable(TABLE_LINKS);
            this.searchDocument.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchDocument, connectionContext);
            ArrayList<CidsBean> beansLinks = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansLinks.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
            }
            if (!this.mapLinks.containsKey(idVorhaben)) {
                this.mapLinks.put(idVorhaben, beansLinks);
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenFotos(Integer idVorhaben, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchDocument.setParentId(idVorhaben);
            this.searchDocument.setFkField(FK_VORHABEN);
            this.searchDocument.setTable(TABLE_FOTOS);
            this.searchDocument.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchDocument, connectionContext);
            ArrayList<CidsBean> beansFotos = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansFotos.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
            }
            if (!this.mapFotos.containsKey(idVorhaben)) {
                this.mapFotos.put(idVorhaben, beansFotos);
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenDokumente(Integer idVorhaben, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchDocument.setParentId(idVorhaben);
            this.searchDocument.setFkField(FK_VORHABEN);
            this.searchDocument.setTable(TABLE_DOKUMENTE);
            this.searchDocument.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchDocument, connectionContext);
            ArrayList<CidsBean> beansDokumente = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansDokumente.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
            }
            if (!this.mapDokumente.containsKey(idVorhaben)) {
                this.mapDokumente.put(idVorhaben, beansDokumente);
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildren(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        if (!this.loadChildrenBeschluesse(id, connectionContext)) {
            this.fireLoadingErrorBeschluesse(id);
            return false;
        }
        this.fireLoadingCompleteBeschluesse();
        if (!this.loadChildrenLinks(id, connectionContext)) {
            this.fireLoadingErrorLinks(id);
            return false;
        }
        this.fireLoadingCompleteLinks();
        if (!this.loadChildrenDokumente(id, connectionContext)) {
            this.fireLoadingErrorDokumente(id);
            return false;
        }
        this.fireLoadingCompleteDokumente();
        if (!this.loadChildrenFotos(id, connectionContext)) {
            this.fireLoadingErrorFotos(id);
            return false;
        }
        this.fireLoadingCompleteFotos();
        return true;
    }

    public List<CidsBean> getMapValueBeschluesse(Integer key) {
        return this.mapBeschluesse.get(key);
    }

    public List<CidsBean> getMapValueLinks(Integer key) {
        return this.mapLinks.get(key);
    }

    public List<CidsBean> getMapValueDokumente(Integer key) {
        return this.mapDokumente.get(key);
    }

    public List<CidsBean> getMapValueFotos(Integer key) {
        return this.mapFotos.get(key);
    }

    public void clearAllMaps() {
        this.mapBeschluesse.clear();
        this.mapLinks.clear();
        this.mapDokumente.clear();
        this.mapFotos.clear();
    }

    public void setLoadingCompletedWithoutError(Boolean status) {
        this.loadingCompletedWithoutError = status;
        if (status.booleanValue()) {
            this.fireLoadingCompleteBeschluesse();
            this.fireLoadingCompleteDokumente();
            this.fireLoadingCompleteFotos();
            this.fireLoadingCompleteLinks();
        }
    }

    public boolean removeBeschluesse(Integer idVorhaben, CidsBean beanBeschluesse) {
        return this.removeFromMap(idVorhaben, beanBeschluesse, this.mapBeschluesse);
    }

    public boolean removeLinks(Integer idVorhaben, CidsBean beanLinks) {
        return this.removeFromMap(idVorhaben, beanLinks, this.mapLinks);
    }

    public boolean removeDokumente(Integer idVorhaben, CidsBean beanDokumente) {
        return this.removeFromMap(idVorhaben, beanDokumente, this.mapDokumente);
    }

    public boolean removeFotos(Integer idVorhaben, CidsBean beanFotos) {
        return this.removeFromMap(idVorhaben, beanFotos, this.mapFotos);
    }

    public void addBeschluesse(Integer idVorhaben, CidsBean beanBeschluesse) {
        this.addToMap(idVorhaben, beanBeschluesse, this.mapBeschluesse);
    }

    public void addLinks(Integer idVorhaben, CidsBean beanLinks) {
        this.addToMap(idVorhaben, beanLinks, this.mapLinks);
    }

    public void addDokumente(Integer idVorhaben, CidsBean beanDokumente) {
        this.addToMap(idVorhaben, beanDokumente, this.mapDokumente);
    }

    public void addFotos(Integer idVorhaben, CidsBean beanFotos) {
        this.addToMap(idVorhaben, beanFotos, this.mapFotos);
    }

    public boolean removeFromMap(Integer id, CidsBean bean, Map<Integer, List<CidsBean>> map) {
        return map.get(id).remove(bean);
    }

    public void addToMap(Integer id, CidsBean bean, Map<Integer, List<CidsBean>> map) {
        List<Object> tempList = new ArrayList<CidsBean>();
        if (map.get(id) != null) {
            tempList = map.get(id);
            tempList.add(bean);
            map.replace(id, tempList);
        } else {
            tempList.add(bean);
            map.put(id, tempList);
        }
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    private void fireLoadingCompleteLinks() {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteLinks();
        }
    }

    private void fireLoadingErrorLinks(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorLinks(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteBeschluesse() {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteBeschluesse();
        }
    }

    private void fireLoadingErrorBeschluesse(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorBeschluesse(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteDokumente() {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteDokumente();
        }
    }

    private void fireLoadingErrorDokumente(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorDokumente(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteFotos() {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteFotos();
        }
    }

    private void fireLoadingErrorFotos(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorFotos(primaryKeyValue);
        }
    }

    public Boolean getLoadingCompletedWithoutError() {
        return this.loadingCompletedWithoutError;
    }

    public Map<Integer, List<CidsBean>> getMapBeschluesse() {
        return this.mapBeschluesse;
    }

    public Map<Integer, List<CidsBean>> getMapLinks() {
        return this.mapLinks;
    }

    public Map<Integer, List<CidsBean>> getMapDokumente() {
        return this.mapDokumente;
    }

    public Map<Integer, List<CidsBean>> getMapFotos() {
        return this.mapFotos;
    }

    public VkParentPanel getParentOrganizer() {
        return this.parentOrganizer;
    }

    public static interface Listener {
        public void loadingCompleteBeschluesse();

        public void loadingCompleteLinks();

        public void loadingErrorBeschluesse(Integer var1);

        public void loadingErrorLinks(Integer var1);

        public void loadingCompleteDokumente();

        public void loadingCompleteFotos();

        public void loadingErrorDokumente(Integer var1);

        public void loadingErrorFotos(Integer var1);
    }
}

